/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextHashBuiltins {

    @PythonCextBuiltins.CApiBuiltin(name="_Py_HashBytes", ret=ArgDescriptor.Py_hash_t, args={ArgDescriptor.CONST_VOID_PTR, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _Py_HashBytes
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _Py_HashBytes() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static long doI(Object value, long size, @Cached CStructAccess.ReadByteNode readNode, @Cached TruffleString.FromByteArrayNode toString, @Cached TruffleString.HashCodeNode hashNode) {
            byte[] array = readNode.readByteArray(value, (int)size);
            TruffleString string = toString.execute(array, TruffleString.Encoding.US_ASCII, false);
            return PyObjectHashNode.hash(string, hashNode);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_hash_t, args={ArgDescriptor.PyObject, ArgDescriptor.Double}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={Double.class})
    static abstract class _Py_HashDouble
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _Py_HashDouble() {
        }

        @Specialization(guards={"isFinite(value)"})
        long doFinite(Object inst, double value) {
            return PyObjectHashNode.hash(value);
        }

        @Specialization(guards={"!isFinite(value)"})
        long doNonFinite(Object inst, double value, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode) {
            return hashNode.execute(null, inliningTarget, inst);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Long, args={ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_HashConstant
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_HashConstant() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static long doI(int idx) {
            switch (idx) {
                case 0: {
                    return PyObjectHashNode.hash(Double.POSITIVE_INFINITY);
                }
                case 1: {
                    return PyObjectHashNode.hash(Double.NaN);
                }
                case 2: {
                    return 1000003L;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.INT8_T_PTR}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleHash_InitSecret
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleHash_InitSecret() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object get(Object secretPtr, @Cached CStructAccess.WriteByteNode writeNode) {
            writeNode.writeByteArray(secretPtr, this.getContext().getHashSecret());
            return PNone.NO_VALUE;
        }
    }
}

