/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ast.AstModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ast.AstState;
import com.oracle.graal.python.builtins.modules.ast.AstTypeFactory;
import com.oracle.graal.python.builtins.modules.ast.Obj2Sst;
import com.oracle.graal.python.builtins.modules.ast.Obj2SstBase;
import com.oracle.graal.python.builtins.modules.ast.Sst2ObjVisitor;
import com.oracle.graal.python.builtins.modules.ast.Validator;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_ast", isEager=true)
public final class AstModuleBuiltins
extends PythonBuiltins {
    private static final HiddenKey AST_STATE_KEY = new HiddenKey("ast_state");
    static final String J__AST = "_ast";
    static final TruffleString T__AST = PythonUtils.tsLiteral("_ast");
    static final TruffleString T_AST = PythonUtils.tsLiteral("ast");
    static final TruffleString T__FIELDS = PythonUtils.tsLiteral("_fields");
    static final TruffleString T__ATTRIBUTES = PythonUtils.tsLiteral("_attributes");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AstModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("PyCF_ONLY_AST", (Object)1024);
        this.addBuiltinConstant("PyCF_TYPE_COMMENTS", (Object)4096);
        this.addBuiltinConstant("PyCF_ALLOW_TOP_LEVEL_AWAIT", (Object)8192);
        PythonBuiltinClass clsAst = core.lookupType(PythonBuiltinClassType.AST);
        PTuple emptyTuple = core.factory().createTuple(PythonUtils.EMPTY_OBJECT_ARRAY);
        clsAst.setAttribute(T__FIELDS, emptyTuple);
        clsAst.setAttribute(T__ATTRIBUTES, emptyTuple);
        clsAst.setAttribute(SpecialAttributeNames.T___MATCH_ARGS__, emptyTuple);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule astModule = core.lookupBuiltinModule(T__AST);
        AstTypeFactory astTypeFactory = new AstTypeFactory(core.getLanguage(), core.factory(), astModule);
        AstState state = new AstState(astTypeFactory, core.lookupType(PythonBuiltinClassType.AST));
        astModule.setAttribute(AST_STATE_KEY, state);
    }

    private static AstState getAstState(PythonContext context) {
        return (AstState)ReadAttributeFromObjectNode.getUncached().execute((Object)context.lookupBuiltinModule(T__AST), AST_STATE_KEY);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object sst2Obj(PythonContext context, ModTy mod) {
        return mod.accept(new Sst2ObjVisitor(AstModuleBuiltins.getAstState(context)));
    }

    @CompilerDirectives.TruffleBoundary
    public static ModTy obj2sst(PythonContext context, Object obj, InputType type) {
        AstState state = AstModuleBuiltins.getAstState(context);
        PythonClass expectedClass = switch (type) {
            case InputType.FILE -> state.clsModule;
            case InputType.EVAL -> state.clsExpression;
            case InputType.SINGLE -> state.clsInteractive;
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        if (!Obj2SstBase.isInstanceOf(obj, expectedClass)) {
            throw Obj2SstBase.raiseTypeError(ErrorMessages.EXPECTED_S_NODE_GOT_P, expectedClass.getName(), obj);
        }
        ModTy mod = new Obj2Sst(state).obj2ModTy(obj);
        Validator.validateMod(mod);
        return mod;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isAst(PythonContext context, Object obj) {
        return Obj2SstBase.isInstanceOf(obj, context.lookupType(PythonBuiltinClassType.AST));
    }

    @Builtin(name="AST", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.AST)
    @GenerateNodeFactory
    public static abstract class AstNode
    extends PythonVarargsBuiltinNode {
        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (self == PNone.NO_VALUE && arguments.length > 0) {
                return this.factory().createPythonObject(arguments[0]);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
        }

        @Specialization
        PythonObject generic(Object cls, Object[] varargs, PKeyword[] kwargs) {
            return this.factory().createPythonObject(cls);
        }
    }
}

