/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.UnicodeDataModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.text.Normalizer;
import java.util.List;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

@CoreFunctions(defineModule="unicodedata")
public final class UnicodeDataModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnicodeDataModuleBuiltinsFactory.getFactories();
    }

    public static String getUnicodeVersion() {
        if (Character.getType('\u0560') != 0) {
            return "11.0.0";
        }
        if (Character.getType('\u0860') != 0) {
            return "10.0.0";
        }
        if (Character.getType('\u08b6') != 0) {
            return "9.0.0";
        }
        if (Character.getType('\u08b3') != 0) {
            return "8.0.0";
        }
        if (Character.getType('\u037f') != 0) {
            return "7.0.0";
        }
        if (Character.getType('\u061c') != 0) {
            return "6.3.0";
        }
        if (Character.getType('\u20ba') != 0) {
            return "6.2.0";
        }
        if (Character.getType('\u058f') != 0) {
            return "6.1.0";
        }
        if (Character.getType('\u0526') != 0) {
            return "6.0.0";
        }
        if (Character.getType('\u0524') != 0) {
            return "5.2.0";
        }
        if (Character.getType('\u0370') != 0) {
            return "5.1.0";
        }
        if (Character.getType('\u0242') != 0) {
            return "5.0.0";
        }
        if (Character.getType('\u0237') != 0) {
            return "4.1.0";
        }
        if (Character.getType('\u0221') != 0) {
            return "4.0.0";
        }
        if (Character.getType('\u0220') != 0) {
            return "3.2.0";
        }
        if (Character.getType('\u03f4') != 0) {
            return "3.1.0";
        }
        if (Character.getType('\u01f6') != 0) {
            return "3.0.0";
        }
        if (Character.getType('\u20ac') != 0) {
            return "2.1.0";
        }
        if (Character.getType('\u0591') != 0) {
            return "2.0.0";
        }
        if (Character.getType('\u0000') != 0) {
            return "1.1.0";
        }
        return "1.0.0";
    }

    public static String getUnicodeName(int cp) {
        if (57344 <= cp && cp <= 63743 || 983040 <= cp && cp <= 1048573 || 0x100000 <= cp && cp <= 1114109) {
            return null;
        }
        return UnicodeDataModuleBuiltins.getUnicodeNameTB(cp);
    }

    @CompilerDirectives.TruffleBoundary
    private static String getUnicodeNameTB(int cp) {
        return UCharacter.getName((int)cp);
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("unidata_version", (Object)UnicodeDataModuleBuiltins.getUnicodeVersion());
    }

    @Builtin(name="category", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"chr"})
    @ArgumentClinic(name="chr", conversion=ArgumentClinic.ClinicConversion.CodePoint)
    @GenerateNodeFactory
    public static abstract class CategoryNode
    extends PythonUnaryClinicBuiltinNode {
        @Specialization
        static TruffleString category(int chr, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(CategoryNode.getCategoryName(chr), PythonUtils.TS_ENCODING);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getCategoryName(int chr) {
            return UCharacter.getPropertyValueName((int)4101, (int)UCharacter.getType((int)chr), (int)0);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return UnicodeDataModuleBuiltinsClinicProviders.CategoryNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="bidirectional", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"chr"})
    @ArgumentClinic(name="chr", conversion=ArgumentClinic.ClinicConversion.CodePoint)
    @GenerateNodeFactory
    public static abstract class BidirectionalNode
    extends PythonUnaryClinicBuiltinNode {
        @Specialization
        static TruffleString bidirectional(int chr, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(BidirectionalNode.getBidiClassName(chr), PythonUtils.TS_ENCODING);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getBidiClassName(int chr) {
            return UCharacter.getPropertyValueName((int)4096, (int)UCharacter.getDirection((int)chr), (int)0);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return UnicodeDataModuleBuiltinsClinicProviders.BidirectionalNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, parameterNames={"chr", "default"})
    @ArgumentClinic(name="chr", conversion=ArgumentClinic.ClinicConversion.CodePoint)
    @GenerateNodeFactory
    public static abstract class NameNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static Object name(int cp, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            String result = UnicodeDataModuleBuiltins.getUnicodeName(cp);
            if (result == null) {
                if (defaultValue == PNone.NO_VALUE) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NO_SUCH_NAME);
                }
                return defaultValue;
            }
            return fromJavaStringNode.execute(result, PythonUtils.TS_ENCODING);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return UnicodeDataModuleBuiltinsClinicProviders.NameNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="is_normalized", minNumOfPositionalArgs=2, parameterNames={"form", "unistr"})
    @ArgumentsClinic(value={@ArgumentClinic(name="form", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="unistr", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    public static abstract class IsNormalizedNode
    extends PythonBinaryClinicBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        protected Normalizer.Form getForm(TruffleString form) {
            try {
                return Normalizer.Form.valueOf(form.toJavaStringUncached());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Specialization(guards={"stringEquals(form, cachedForm, equalNode)"}, limit="4")
        @CompilerDirectives.TruffleBoundary
        boolean isNormalized(TruffleString form, TruffleString unistr, @Cached(value="form") TruffleString cachedForm, @Cached(value="getForm(cachedForm)") Normalizer.Form cachedNormForm, @Cached TruffleString.EqualNode equalNode) {
            if (cachedNormForm == null) {
                throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.ValueError, ErrorMessages.INVALID_NORMALIZATION_FORM);
            }
            return Normalizer.isNormalized(unistr.toJavaStringUncached(), cachedNormForm);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return UnicodeDataModuleBuiltinsClinicProviders.IsNormalizedNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="normalize", minNumOfPositionalArgs=2, parameterNames={"form", "unistr"})
    @ArgumentsClinic(value={@ArgumentClinic(name="form", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="unistr", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    public static abstract class NormalizeNode
    extends PythonBinaryClinicBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        protected Normalizer.Form getForm(TruffleString form) {
            try {
                return Normalizer.Form.valueOf(form.toJavaStringUncached());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Specialization(guards={"stringEquals(form, cachedForm, equalNode)"}, limit="4")
        static TruffleString normalize(TruffleString form, TruffleString unistr, @Bind(value="this") Node inliningTarget, @Cached(value="form") TruffleString cachedForm, @Cached(value="getForm(cachedForm)") Normalizer.Form cachedNormForm, @Cached TruffleString.EqualNode equalNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (cachedNormForm == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.INVALID_NORMALIZATION_FORM);
            }
            return fromJavaStringNode.execute(NormalizeNode.normalize(toJavaStringNode.execute((AbstractTruffleString)unistr), cachedNormForm), PythonUtils.TS_ENCODING);
        }

        @CompilerDirectives.TruffleBoundary
        private static String normalize(String str, Normalizer.Form normForm) {
            return Normalizer.normalize(str, normForm);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return UnicodeDataModuleBuiltinsClinicProviders.NormalizeNodeClinicProviderGen.INSTANCE;
        }
    }
}

