/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TermiosModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.List;

@CoreFunctions(defineModule="termios", isEager=true)
public final class TermiosModuleBuiltins
extends PythonBuiltins {
    public TermiosModuleBuiltins() {
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"This module provides an interface to the Posix calls for tty I/O control.\nFor a complete description of these calls, see the Posix or Unix manual\npages. It is only available for those Unix versions that support Posix\ntermios style tty I/O control.\n\nAll functions in this module take a file descriptor fd as their first\nargument. This can be an integer file descriptor, such as returned by\nsys.stdin.fileno(), or a file object, such as sys.stdin itself.\n");
        this.addBuiltinConstant("B0", (Object)0);
        this.addBuiltinConstant("B1000000", (Object)4104);
        this.addBuiltinConstant("B110", (Object)3);
        this.addBuiltinConstant("B115200", (Object)4098);
        this.addBuiltinConstant("B1152000", (Object)4105);
        this.addBuiltinConstant("B1200", (Object)9);
        this.addBuiltinConstant("B134", (Object)4);
        this.addBuiltinConstant("B150", (Object)5);
        this.addBuiltinConstant("B1500000", (Object)4106);
        this.addBuiltinConstant("B1800", (Object)10);
        this.addBuiltinConstant("B19200", (Object)14);
        this.addBuiltinConstant("B200", (Object)6);
        this.addBuiltinConstant("B2000000", (Object)4107);
        this.addBuiltinConstant("B230400", (Object)4099);
        this.addBuiltinConstant("B2400", (Object)11);
        this.addBuiltinConstant("B2500000", (Object)4108);
        this.addBuiltinConstant("B300", (Object)7);
        this.addBuiltinConstant("B3000000", (Object)4109);
        this.addBuiltinConstant("B3500000", (Object)4110);
        this.addBuiltinConstant("B38400", (Object)15);
        this.addBuiltinConstant("B4000000", (Object)4111);
        this.addBuiltinConstant("B460800", (Object)4100);
        this.addBuiltinConstant("B4800", (Object)12);
        this.addBuiltinConstant("B50", (Object)1);
        this.addBuiltinConstant("B500000", (Object)4101);
        this.addBuiltinConstant("B57600", (Object)4097);
        this.addBuiltinConstant("B576000", (Object)4102);
        this.addBuiltinConstant("B600", (Object)8);
        this.addBuiltinConstant("B75", (Object)2);
        this.addBuiltinConstant("B921600", (Object)4103);
        this.addBuiltinConstant("B9600", (Object)13);
        this.addBuiltinConstant("BRKINT", (Object)2);
        this.addBuiltinConstant("BS0", (Object)0);
        this.addBuiltinConstant("BS1", (Object)8192);
        this.addBuiltinConstant("BSDLY", (Object)8192);
        this.addBuiltinConstant("CBAUD", (Object)4111);
        this.addBuiltinConstant("CBAUDEX", (Object)4096);
        this.addBuiltinConstant("CDSUSP", (Object)25);
        this.addBuiltinConstant("CEOF", (Object)4);
        this.addBuiltinConstant("CEOL", (Object)0);
        this.addBuiltinConstant("CEOT", (Object)4);
        this.addBuiltinConstant("CERASE", (Object)127);
        this.addBuiltinConstant("CFLUSH", (Object)15);
        this.addBuiltinConstant("CIBAUD", (Object)0x100F0000);
        this.addBuiltinConstant("CINTR", (Object)3);
        this.addBuiltinConstant("CKILL", (Object)21);
        this.addBuiltinConstant("CLNEXT", (Object)22);
        this.addBuiltinConstant("CLOCAL", (Object)2048);
        this.addBuiltinConstant("CQUIT", (Object)28);
        this.addBuiltinConstant("CR0", (Object)0);
        this.addBuiltinConstant("CR1", (Object)512);
        this.addBuiltinConstant("CR2", (Object)1024);
        this.addBuiltinConstant("CR3", (Object)1536);
        this.addBuiltinConstant("CRDLY", (Object)1536);
        this.addBuiltinConstant("CREAD", (Object)128);
        this.addBuiltinConstant("CRPRNT", (Object)18);
        this.addBuiltinConstant("CRTSCTS", (Object)0x80000000L);
        this.addBuiltinConstant("CS5", (Object)0);
        this.addBuiltinConstant("CS6", (Object)16);
        this.addBuiltinConstant("CS7", (Object)32);
        this.addBuiltinConstant("CS8", (Object)48);
        this.addBuiltinConstant("CSIZE", (Object)48);
        this.addBuiltinConstant("CSTART", (Object)17);
        this.addBuiltinConstant("CSTOP", (Object)19);
        this.addBuiltinConstant("CSTOPB", (Object)64);
        this.addBuiltinConstant("CSUSP", (Object)26);
        this.addBuiltinConstant("CWERASE", (Object)23);
        this.addBuiltinConstant("ECHO", (Object)8);
        this.addBuiltinConstant("ECHOCTL", (Object)512);
        this.addBuiltinConstant("ECHOE", (Object)16);
        this.addBuiltinConstant("ECHOK", (Object)32);
        this.addBuiltinConstant("ECHOKE", (Object)2048);
        this.addBuiltinConstant("ECHONL", (Object)64);
        this.addBuiltinConstant("ECHOPRT", (Object)1024);
        this.addBuiltinConstant("EXTA", (Object)14);
        this.addBuiltinConstant("EXTB", (Object)15);
        this.addBuiltinConstant("FF0", (Object)0);
        this.addBuiltinConstant("FF1", (Object)32768);
        this.addBuiltinConstant("FFDLY", (Object)32768);
        this.addBuiltinConstant("FIOASYNC", (Object)21586);
        this.addBuiltinConstant("FIOCLEX", (Object)21585);
        this.addBuiltinConstant("FIONBIO", (Object)21537);
        this.addBuiltinConstant("FIONCLEX", (Object)21584);
        this.addBuiltinConstant("FIONREAD", (Object)21531);
        this.addBuiltinConstant("FLUSHO", (Object)4096);
        this.addBuiltinConstant("HUPCL", (Object)1024);
        this.addBuiltinConstant("ICANON", (Object)2);
        this.addBuiltinConstant("ICRNL", (Object)256);
        this.addBuiltinConstant("IEXTEN", (Object)32768);
        this.addBuiltinConstant("IGNBRK", (Object)1);
        this.addBuiltinConstant("IGNCR", (Object)128);
        this.addBuiltinConstant("IGNPAR", (Object)4);
        this.addBuiltinConstant("IMAXBEL", (Object)8192);
        this.addBuiltinConstant("INLCR", (Object)64);
        this.addBuiltinConstant("INPCK", (Object)16);
        this.addBuiltinConstant("IOCSIZE_MASK", (Object)0x3FFF0000);
        this.addBuiltinConstant("IOCSIZE_SHIFT", (Object)16);
        this.addBuiltinConstant("ISIG", (Object)1);
        this.addBuiltinConstant("ISTRIP", (Object)32);
        this.addBuiltinConstant("IUCLC", (Object)512);
        this.addBuiltinConstant("IXANY", (Object)2048);
        this.addBuiltinConstant("IXOFF", (Object)4096);
        this.addBuiltinConstant("IXON", (Object)1024);
        this.addBuiltinConstant("NCC", (Object)8);
        this.addBuiltinConstant("NCCS", (Object)32);
        this.addBuiltinConstant("NL0", (Object)0);
        this.addBuiltinConstant("NL1", (Object)256);
        this.addBuiltinConstant("NLDLY", (Object)256);
        this.addBuiltinConstant("NOFLSH", (Object)128);
        this.addBuiltinConstant("N_MOUSE", (Object)2);
        this.addBuiltinConstant("N_PPP", (Object)3);
        this.addBuiltinConstant("N_SLIP", (Object)1);
        this.addBuiltinConstant("N_STRIP", (Object)4);
        this.addBuiltinConstant("N_TTY", (Object)0);
        this.addBuiltinConstant("OCRNL", (Object)8);
        this.addBuiltinConstant("OFDEL", (Object)128);
        this.addBuiltinConstant("OFILL", (Object)64);
        this.addBuiltinConstant("OLCUC", (Object)2);
        this.addBuiltinConstant("ONLCR", (Object)4);
        this.addBuiltinConstant("ONLRET", (Object)32);
        this.addBuiltinConstant("ONOCR", (Object)16);
        this.addBuiltinConstant("OPOST", (Object)1);
        this.addBuiltinConstant("PARENB", (Object)256);
        this.addBuiltinConstant("PARMRK", (Object)8);
        this.addBuiltinConstant("PARODD", (Object)512);
        this.addBuiltinConstant("PENDIN", (Object)16384);
        this.addBuiltinConstant("TAB0", (Object)0);
        this.addBuiltinConstant("TAB1", (Object)2048);
        this.addBuiltinConstant("TAB2", (Object)4096);
        this.addBuiltinConstant("TAB3", (Object)6144);
        this.addBuiltinConstant("TABDLY", (Object)6144);
        this.addBuiltinConstant("TCFLSH", (Object)21515);
        this.addBuiltinConstant("TCGETA", (Object)21509);
        this.addBuiltinConstant("TCGETS", (Object)21505);
        this.addBuiltinConstant("TCIFLUSH", (Object)0);
        this.addBuiltinConstant("TCIOFF", (Object)2);
        this.addBuiltinConstant("TCIOFLUSH", (Object)2);
        this.addBuiltinConstant("TCION", (Object)3);
        this.addBuiltinConstant("TCOFLUSH", (Object)1);
        this.addBuiltinConstant("TCOOFF", (Object)0);
        this.addBuiltinConstant("TCOON", (Object)1);
        this.addBuiltinConstant("TCSADRAIN", (Object)1);
        this.addBuiltinConstant("TCSAFLUSH", (Object)2);
        this.addBuiltinConstant("TCSANOW", (Object)0);
        this.addBuiltinConstant("TCSBRK", (Object)21513);
        this.addBuiltinConstant("TCSBRKP", (Object)21541);
        this.addBuiltinConstant("TCSETA", (Object)21510);
        this.addBuiltinConstant("TCSETAF", (Object)21512);
        this.addBuiltinConstant("TCSETAW", (Object)21511);
        this.addBuiltinConstant("TCSETS", (Object)21506);
        this.addBuiltinConstant("TCSETSF", (Object)21508);
        this.addBuiltinConstant("TCSETSW", (Object)21507);
        this.addBuiltinConstant("TCXONC", (Object)21514);
        this.addBuiltinConstant("TIOCCONS", (Object)21533);
        this.addBuiltinConstant("TIOCEXCL", (Object)21516);
        this.addBuiltinConstant("TIOCGETD", (Object)21540);
        this.addBuiltinConstant("TIOCGICOUNT", (Object)21597);
        this.addBuiltinConstant("TIOCGLCKTRMIOS", (Object)21590);
        this.addBuiltinConstant("TIOCGPGRP", (Object)21519);
        this.addBuiltinConstant("TIOCGSERIAL", (Object)21534);
        this.addBuiltinConstant("TIOCGSOFTCAR", (Object)21529);
        this.addBuiltinConstant("TIOCGWINSZ", (Object)21523);
        this.addBuiltinConstant("TIOCINQ", (Object)21531);
        this.addBuiltinConstant("TIOCLINUX", (Object)21532);
        this.addBuiltinConstant("TIOCMBIC", (Object)21527);
        this.addBuiltinConstant("TIOCMBIS", (Object)21526);
        this.addBuiltinConstant("TIOCMGET", (Object)21525);
        this.addBuiltinConstant("TIOCMIWAIT", (Object)21596);
        this.addBuiltinConstant("TIOCMSET", (Object)21528);
        this.addBuiltinConstant("TIOCM_CAR", (Object)64);
        this.addBuiltinConstant("TIOCM_CD", (Object)64);
        this.addBuiltinConstant("TIOCM_CTS", (Object)32);
        this.addBuiltinConstant("TIOCM_DSR", (Object)256);
        this.addBuiltinConstant("TIOCM_DTR", (Object)2);
        this.addBuiltinConstant("TIOCM_LE", (Object)1);
        this.addBuiltinConstant("TIOCM_RI", (Object)128);
        this.addBuiltinConstant("TIOCM_RNG", (Object)128);
        this.addBuiltinConstant("TIOCM_RTS", (Object)4);
        this.addBuiltinConstant("TIOCM_SR", (Object)16);
        this.addBuiltinConstant("TIOCM_ST", (Object)8);
        this.addBuiltinConstant("TIOCNOTTY", (Object)21538);
        this.addBuiltinConstant("TIOCNXCL", (Object)21517);
        this.addBuiltinConstant("TIOCOUTQ", (Object)21521);
        this.addBuiltinConstant("TIOCPKT", (Object)21536);
        this.addBuiltinConstant("TIOCPKT_DATA", (Object)0);
        this.addBuiltinConstant("TIOCPKT_DOSTOP", (Object)32);
        this.addBuiltinConstant("TIOCPKT_FLUSHREAD", (Object)1);
        this.addBuiltinConstant("TIOCPKT_FLUSHWRITE", (Object)2);
        this.addBuiltinConstant("TIOCPKT_NOSTOP", (Object)16);
        this.addBuiltinConstant("TIOCPKT_START", (Object)8);
        this.addBuiltinConstant("TIOCPKT_STOP", (Object)4);
        this.addBuiltinConstant("TIOCSCTTY", (Object)21518);
        this.addBuiltinConstant("TIOCSERCONFIG", (Object)21587);
        this.addBuiltinConstant("TIOCSERGETLSR", (Object)21593);
        this.addBuiltinConstant("TIOCSERGETMULTI", (Object)21594);
        this.addBuiltinConstant("TIOCSERGSTRUCT", (Object)21592);
        this.addBuiltinConstant("TIOCSERGWILD", (Object)21588);
        this.addBuiltinConstant("TIOCSERSETMULTI", (Object)21595);
        this.addBuiltinConstant("TIOCSERSWILD", (Object)21589);
        this.addBuiltinConstant("TIOCSER_TEMT", (Object)1);
        this.addBuiltinConstant("TIOCSETD", (Object)21539);
        this.addBuiltinConstant("TIOCSLCKTRMIOS", (Object)21591);
        this.addBuiltinConstant("TIOCSPGRP", (Object)21520);
        this.addBuiltinConstant("TIOCSSERIAL", (Object)21535);
        this.addBuiltinConstant("TIOCSSOFTCAR", (Object)21530);
        this.addBuiltinConstant("TIOCSTI", (Object)21522);
        this.addBuiltinConstant("TIOCSWINSZ", (Object)21524);
        this.addBuiltinConstant("TOSTOP", (Object)256);
        this.addBuiltinConstant("VDISCARD", (Object)13);
        this.addBuiltinConstant("VEOF", (Object)4);
        this.addBuiltinConstant("VEOL", (Object)11);
        this.addBuiltinConstant("VEOL2", (Object)16);
        this.addBuiltinConstant("VERASE", (Object)2);
        this.addBuiltinConstant("VINTR", (Object)0);
        this.addBuiltinConstant("VKILL", (Object)3);
        this.addBuiltinConstant("VLNEXT", (Object)15);
        this.addBuiltinConstant("VMIN", (Object)6);
        this.addBuiltinConstant("VQUIT", (Object)1);
        this.addBuiltinConstant("VREPRINT", (Object)12);
        this.addBuiltinConstant("VSTART", (Object)8);
        this.addBuiltinConstant("VSTOP", (Object)9);
        this.addBuiltinConstant("VSUSP", (Object)10);
        this.addBuiltinConstant("VSWTC", (Object)7);
        this.addBuiltinConstant("VSWTCH", (Object)7);
        this.addBuiltinConstant("VT0", (Object)0);
        this.addBuiltinConstant("VT1", (Object)16384);
        this.addBuiltinConstant("VTDLY", (Object)16384);
        this.addBuiltinConstant("VTIME", (Object)5);
        this.addBuiltinConstant("VWERASE", (Object)14);
        this.addBuiltinConstant("XCASE", (Object)4);
        this.addBuiltinConstant("XTABS", (Object)6144);
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TermiosModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="tcsetattr", minNumOfPositionalArgs=2, parameterNames={"fd", "when", "attributes"}, doc="tcsetattr(fd, when, attributes) -> None\n\n\tSet the tty attributes for file descriptor fd.\n\tThe attributes to be set are taken from the attributes argument, which\n\tis a list like the one returned by tcgetattr(). The when argument\n\tdetermines when the attributes are changed: termios.TCSANOW to\n\tchange immediately, termios.TCSADRAIN to change after transmitting all\n\tqueued output, or termios.TCSAFLUSH to change after transmitting all\n\tqueued output and discarding all queued input.")
    @GenerateNodeFactory
    static abstract class TCSetAttrNode
    extends PythonBuiltinNode {
        TCSetAttrNode() {
        }

        @Specialization
        static PNone flow(Object fd, Object when, Object attributes) {
            return PNone.NONE;
        }
    }

    @Builtin(name="tcsendbreak", minNumOfPositionalArgs=2, parameterNames={"fd", "duration"}, doc="tcsendbreak(fd, duration) -> None\n\n\tSend a break on file descriptor fd.\n\tA zero duration sends a break for 0.25-0.5 seconds; a nonzero duration\n\thas a system dependent meaning.")
    @GenerateNodeFactory
    static abstract class TCSendBreakNode
    extends PythonBuiltinNode {
        TCSendBreakNode() {
        }

        @Specialization
        static PNone flow(Object fd, Object duration) {
            return PNone.NONE;
        }
    }

    @Builtin(name="tcgetattr", minNumOfPositionalArgs=1, parameterNames={"fd"}, doc="tcgetattr(fd) -> list_of_attrs\n\n\tGet the tty attributes for file descriptor fd, as follows:\n\t[iflag, oflag, cflag, lflag, ispeed, ospeed, cc] where cc is a list\n\tof the tty special characters (each a string of length 1, except the items\n\twith indices VMIN and VTIME, which are integers when these fields are\n\tdefined).  The interpretation of the flags and the speeds as well as the\n\tindexing in the cc array must be done using the symbolic constants defined\n\tin this module.")
    @GenerateNodeFactory
    static abstract class TCGetAttrNode
    extends PythonBuiltinNode {
        TCGetAttrNode() {
        }

        @Specialization
        static PList flow(Object fd, @Cached PythonObjectFactory factory) {
            PList l = factory.createList(new Object[]{factory.createBytes(new byte[]{3}), factory.createBytes(new byte[]{28}), factory.createBytes(new byte[]{127}), factory.createBytes(new byte[]{21}), factory.createBytes(new byte[]{4}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{1}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{17}), factory.createBytes(new byte[]{19}), factory.createBytes(new byte[]{26}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{18}), factory.createBytes(new byte[]{15}), factory.createBytes(new byte[]{23}), factory.createBytes(new byte[]{22}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0}), factory.createBytes(new byte[]{0})});
            return factory.createList(new Object[]{17664, 5, 191, 35387, 15, 15, l});
        }
    }

    @Builtin(name="tcflush", minNumOfPositionalArgs=2, parameterNames={"fd", "queue"}, doc="tcflush(fd, queue) -> None\n\n\tDiscard queued data on file descriptor fd.\n\tThe queue selector specifies which queue: termios.TCIFLUSH for the input\n\tqueue, termios.TCOFLUSH for the output queue, or termios.TCIOFLUSH for\n\tboth queues.")
    @GenerateNodeFactory
    static abstract class TCFlushNode
    extends PythonBuiltinNode {
        TCFlushNode() {
        }

        @Specialization
        static PNone flow(Object fd, Object queue) {
            return PNone.NONE;
        }
    }

    @Builtin(name="tcflow", minNumOfPositionalArgs=2, parameterNames={"fd", "action"}, doc="tcflow(fd, action) -> None\n\n\tSuspend or resume input or output on file descriptor fd.\n\tThe action argument can be termios.TCOOFF to suspend output,\n\ttermios.TCOON to restart output, termios.TCIOFF to suspend input,\n\tor termios.TCION to restart input.")
    @GenerateNodeFactory
    static abstract class TCFlowNode
    extends PythonBuiltinNode {
        TCFlowNode() {
        }

        @Specialization
        static PNone flow(Object fd, Object action) {
            return PNone.NONE;
        }
    }

    @Builtin(name="tcdrain", minNumOfPositionalArgs=1, parameterNames={"fd"}, doc="tcdrain(fd) -> None\n\n\tWait until all output written to file descriptor fd has been transmitted.")
    @GenerateNodeFactory
    static abstract class TCDrainNode
    extends PythonBuiltinNode {
        TCDrainNode() {
        }

        @Specialization
        static PNone drain(Object fd) {
            return PNone.NONE;
        }
    }
}

