/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ContextvarsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_contextvars")
public final class ContextvarsModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ContextvarsModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="Token", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.ContextVarsToken)
    @GenerateNodeFactory
    public static abstract class TokenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object construct(Object cls, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.TOKEN_ONLY_BY_CONTEXTVAR);
        }
    }

    @Builtin(name="Context", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.ContextVarsContext)
    @GenerateNodeFactory
    public static abstract class ContextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object construct(Object cls, @Cached PythonObjectFactory factory) {
            return factory.createContextVarsContext();
        }
    }

    @Builtin(name="ContextVar", minNumOfPositionalArgs=2, parameterNames={"cls", "name", "default"}, constructsClass=PythonBuiltinClassType.ContextVar)
    @GenerateNodeFactory
    public static abstract class ContextVarNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        protected static Object constructDef(Object cls, TruffleString name, Object def, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile noValueProfile, @Cached PythonObjectFactory factory) {
            if (noValueProfile.profile(inliningTarget, PGuards.isNoValue(def))) {
                def = PContextVar.NO_DEFAULT;
            }
            return factory.createContextVar(name, def);
        }
    }

    @Builtin(name="copy_context", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetDefaultEncodingNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object copyCtx(@Cached PythonObjectFactory factory) {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            return factory.copyContextVarsContext(threadState.getContextVarsContext());
        }
    }
}

