/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsTruffleModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.SetAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(defineModule="_codecs_truffle")
public final class CodecsTruffleModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_CODEC_INFO_NAME = PythonUtils.tsLiteral("CodecInfo");
    private static final TruffleString T_CODEC = PythonUtils.tsLiteral("Codec");
    private static final TruffleString T_INCREMENTAL_ENCODER = PythonUtils.tsLiteral("IncrementalEncoder");
    private static final TruffleString T_BUFFERED_INCREMENTAL_DECODER = PythonUtils.tsLiteral("BufferedIncrementalDecoder");
    private static final TruffleString T_STREAM_READER = PythonUtils.tsLiteral("StreamReader");
    private static final TruffleString T_STREAM_WRITER = PythonUtils.tsLiteral("StreamWriter");
    private static final String J_BUFFER_DECODE = "_buffer_decode";
    private static final TruffleString T_TRUFFLE_CODEC = PythonUtils.tsLiteral("TruffleCodec");
    private static final TruffleString T_TRUFFLE_INCREMENTAL_ENCODER = PythonUtils.tsLiteral("TruffleIncrementalEncoder");
    private static final TruffleString T_TRUFFLE_INCREMENTAL_DECODER = PythonUtils.tsLiteral("TruffleIncrementalDecoder");
    private static final TruffleString T_TRUFFLE_STREAM_WRITER = PythonUtils.tsLiteral("TruffleStreamWriter");
    private static final TruffleString T_TRUFFLE_STREAM_READER = PythonUtils.tsLiteral("TruffleStreamReader");
    private static final TruffleString T_APPLY_ENCODING = PythonUtils.tsLiteral("ApplyEncoding");
    private static final TruffleString T_ATTR_ENCODING = PythonUtils.tsLiteral("encoding");
    private static final TruffleString T_ATTR_ERRORS = PythonUtils.tsLiteral("errors");
    private static final TruffleString T_ATTR_FN = PythonUtils.tsLiteral("fn");
    public static final TruffleString T_INCREMENTALENCODER = PythonUtils.tsLiteral("incrementalencoder");
    public static final TruffleString T_INCREMENTALDECODER = PythonUtils.tsLiteral("incrementaldecoder");
    private static final TruffleString T_STREAMREADER = PythonUtils.tsLiteral("streamreader");
    private static final TruffleString T_STREAMWRITER = PythonUtils.tsLiteral("streamwriter");
    private static final TruffleString T_CODECS = PythonUtils.tsLiteral("codecs");
    private PythonClass truffleCodecClass;
    private PythonClass truffleIncrementalEncoderClass;
    private PythonClass truffleIncrementalDecoderClass;
    private PythonClass truffleStreamReaderClass;
    private PythonClass truffleStreamWriterClass;
    private PythonClass applyEncodingClass;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return new ArrayList();
    }

    private static PythonClass initClass(TruffleString className, TruffleString superClassName, BuiltinDescr[] descrs, PythonModule codecsTruffleModule, PythonModule codecsModule, PythonLanguage language, PythonObjectFactory factory) {
        PythonAbstractClass superClass = (PythonAbstractClass)codecsModule.getAttribute(superClassName);
        return CodecsTruffleModuleBuiltins.initClass(className, superClass, descrs, codecsTruffleModule, language, factory);
    }

    private static PythonClass initClass(TruffleString className, PythonAbstractClass superClass, BuiltinDescr[] descrs, PythonModule codecsTruffleModule, PythonLanguage language, PythonObjectFactory factory) {
        PythonClass clazz = factory.createPythonClassAndFixupSlots(language, (Object)PythonBuiltinClassType.PythonClass, className, superClass, new PythonAbstractClass[]{superClass});
        for (BuiltinDescr d : descrs) {
            PythonUtils.createMethod(language, clazz, d.nodeClass, d.enclosingType ? clazz : null, 1, d.nodeSupplier, new Object[]{factory});
        }
        clazz.setAttribute(SpecialAttributeNames.T___MODULE__, BuiltinNames.T__CODECS_TRUFFLE);
        clazz.setAttribute(SpecialAttributeNames.T___QUALNAME__, BuiltinNames.T__CODECS_TRUFFLE);
        codecsTruffleModule.setAttribute(className, clazz);
        return clazz;
    }

    @CompilerDirectives.TruffleBoundary
    static PTuple codecsInfo(PythonModule self, TruffleString encoding, PythonContext context, PythonObjectFactory factory) {
        PythonModule codecsModule = (PythonModule)AbstractImportNode.importModule(T_CODECS);
        CodecsTruffleModuleBuiltins codecsTruffleBuiltins = (CodecsTruffleModuleBuiltins)self.getBuiltins();
        if (self.getAttribute(T_TRUFFLE_CODEC) instanceof PNone) {
            CodecsTruffleModuleBuiltins.initCodecClasses(self, codecsModule, context, factory);
        }
        PythonObject truffleCodec = factory.createPythonObject(codecsTruffleBuiltins.truffleCodecClass);
        truffleCodec.setAttribute(T_ATTR_ENCODING, encoding);
        Object encodeMethod = PyObjectGetAttr.executeUncached(truffleCodec, BuiltinNames.T_ENCODE);
        Object decodeMethod = PyObjectGetAttr.executeUncached(truffleCodec, SpecialMethodNames.T_DECODE);
        PythonObject tie = factory.createPythonObject(codecsTruffleBuiltins.applyEncodingClass);
        tie.setAttribute(T_ATTR_FN, codecsTruffleBuiltins.truffleIncrementalEncoderClass);
        tie.setAttribute(T_ATTR_ENCODING, encoding);
        PythonObject tid = factory.createPythonObject(codecsTruffleBuiltins.applyEncodingClass);
        tid.setAttribute(T_ATTR_FN, codecsTruffleBuiltins.truffleIncrementalDecoderClass);
        tid.setAttribute(T_ATTR_ENCODING, encoding);
        PythonObject sr = factory.createPythonObject(codecsTruffleBuiltins.applyEncodingClass);
        sr.setAttribute(T_ATTR_FN, codecsTruffleBuiltins.truffleStreamReaderClass);
        sr.setAttribute(T_ATTR_ENCODING, encoding);
        PythonObject sw = factory.createPythonObject(codecsTruffleBuiltins.applyEncodingClass);
        sw.setAttribute(T_ATTR_FN, codecsTruffleBuiltins.truffleStreamWriterClass);
        sw.setAttribute(T_ATTR_ENCODING, encoding);
        PythonAbstractClass codecInfoClass = (PythonAbstractClass)codecsModule.getAttribute(T_CODEC_INFO_NAME);
        return (PTuple)CallVarargsMethodNode.getUncached().execute(null, codecInfoClass, new Object[0], CodecsTruffleModuleBuiltins.createCodecInfoArgs(encoding, encodeMethod, decodeMethod, tie, tid, sr, sw));
    }

    private static PKeyword[] createCodecInfoArgs(TruffleString encoding, Object encodeMethod, Object decodeMethod, PythonObject tie, PythonObject tid, PythonObject sr, PythonObject sw) {
        return new PKeyword[]{new PKeyword(IONodes.T_NAME, encoding), new PKeyword(BuiltinNames.T_ENCODE, encodeMethod), new PKeyword(SpecialMethodNames.T_DECODE, decodeMethod), new PKeyword(T_INCREMENTALENCODER, tie), new PKeyword(T_INCREMENTALDECODER, tid), new PKeyword(T_STREAMREADER, sr), new PKeyword(T_STREAMWRITER, sw)};
    }

    private static void initCodecClasses(PythonModule codecsTruffleModule, PythonModule codecsModule, PythonContext context, PythonObjectFactory factory) {
        CodecsTruffleModuleBuiltins codecsTruffleBuiltins = (CodecsTruffleModuleBuiltins)codecsTruffleModule.getBuiltins();
        PythonLanguage language = PythonLanguage.get(null);
        codecsTruffleBuiltins.truffleCodecClass = CodecsTruffleModuleBuiltins.initClass(T_TRUFFLE_CODEC, (PythonClass)codecsModule.getAttribute(T_CODEC), new BuiltinDescr[]{new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.EncodeNodeGen::create, EncodeNode.class, false), new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.CodecDecodeNodeGen::create, CodecDecodeNode.class, true)}, codecsTruffleModule, language, factory);
        codecsTruffleBuiltins.truffleIncrementalEncoderClass = CodecsTruffleModuleBuiltins.initClass(T_TRUFFLE_INCREMENTAL_ENCODER, T_INCREMENTAL_ENCODER, new BuiltinDescr[]{new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.CodecInitNodeGen::create, CodecInitNode.class, false), new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.IncrementalEncodeNodeGen::create, IncrementalEncodeNode.class, true)}, codecsTruffleModule, codecsModule, language, factory);
        codecsTruffleBuiltins.truffleIncrementalDecoderClass = CodecsTruffleModuleBuiltins.initClass(T_TRUFFLE_INCREMENTAL_DECODER, T_BUFFERED_INCREMENTAL_DECODER, new BuiltinDescr[]{new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.CodecInitNodeGen::create, CodecInitNode.class, false), new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.IncrementalDecodeNodeGen::create, IncrementalDecodeNode.class, true)}, codecsTruffleModule, codecsModule, language, factory);
        codecsTruffleBuiltins.truffleStreamWriterClass = CodecsTruffleModuleBuiltins.initClass(T_TRUFFLE_STREAM_WRITER, T_STREAM_WRITER, new BuiltinDescr[]{new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.CodecInitNodeGen::create, CodecInitNode.class, false), new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.EncodeNodeGen::create, EncodeNode.class, true)}, codecsTruffleModule, codecsModule, language, factory);
        codecsTruffleBuiltins.truffleStreamReaderClass = CodecsTruffleModuleBuiltins.initClass(T_TRUFFLE_STREAM_READER, T_STREAM_READER, new BuiltinDescr[]{new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.CodecInitNodeGen::create, CodecInitNode.class, false), new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.StreamDecodeNodeGen::create, StreamDecodeNode.class, true)}, codecsTruffleModule, codecsModule, language, factory);
        codecsTruffleBuiltins.applyEncodingClass = CodecsTruffleModuleBuiltins.initClass(T_APPLY_ENCODING, context.lookupType(PythonBuiltinClassType.PythonObject), new BuiltinDescr[]{new BuiltinDescr(CodecsTruffleModuleBuiltinsFactory.CallApplyNodeGen::create, CallApplyNode.class, false)}, codecsTruffleModule, language, factory);
    }

    private static final class BuiltinDescr {
        final Supplier<PythonBuiltinBaseNode> nodeSupplier;
        final Class<?> nodeClass;
        final boolean enclosingType;

        public BuiltinDescr(Supplier<PythonBuiltinBaseNode> nodeSupplier, Class<?> nodeClass, boolean enclosingType) {
            this.nodeSupplier = nodeSupplier;
            this.nodeClass = nodeClass;
            this.enclosingType = enclosingType;
        }
    }

    @Builtin(name="encode", minNumOfPositionalArgs=2, parameterNames={"self", "input", "errors"})
    protected static abstract class EncodeNode
    extends PythonTernaryBuiltinNode {
        protected EncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, PythonObject self, Object input, Object errors, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CodecsModuleBuiltins.CodecsEncodeNode encode) {
            return encode.execute(frame, input, getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_ENCODING), errors);
        }
    }

    @Builtin(name="decode", minNumOfPositionalArgs=1, parameterNames={"self", "input", "errors"})
    protected static abstract class CodecDecodeNode
    extends PythonTernaryBuiltinNode {
        protected CodecDecodeNode() {
        }

        @Specialization
        Object decode(VirtualFrame frame, PythonObject self, Object input, Object errors, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode) {
            return decode.execute(frame, input, getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_ENCODING), errors, true);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    protected static abstract class CodecInitNode
    extends PythonVarargsBuiltinNode {
        protected CodecInitNode() {
        }

        @Specialization
        Object init(VirtualFrame frame, PythonObject self, Object[] args, PKeyword[] kw, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached(value="createSetAttr()") SetAttributeNode setAttrNode, @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached CallNode callNode) {
            assert (args.length > 0);
            Object base = getBaseClassNode.execute(inliningTarget, getClass.execute(inliningTarget, self));
            Object superInit = getAttrNode.execute((Frame)frame, inliningTarget, base, SpecialMethodNames.T___INIT__);
            Object[] callArgs = new Object[args.length];
            callArgs[0] = self;
            if (args.length > 1) {
                PythonUtils.arraycopy(args, 1, callArgs, 1, args.length - 1);
            }
            callNode.execute((Frame)frame, superInit, callArgs, kw);
            setAttrNode.execute(frame, self, args[0]);
            return PNone.NONE;
        }

        @NeverDefault
        protected SetAttributeNode createSetAttr() {
            return SetAttributeNode.create(T_ATTR_ENCODING);
        }
    }

    @Builtin(name="encode", minNumOfPositionalArgs=2, parameterNames={"self", "input", "final"})
    protected static abstract class IncrementalEncodeNode
    extends PythonTernaryBuiltinNode {
        protected IncrementalEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, PythonObject self, Object input, Object ffinal, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CodecsModuleBuiltins.CodecsEncodeNode encode, @Cached TupleBuiltins.GetItemNode getItemNode) {
            PTuple result = (PTuple)encode.execute(frame, input, getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_ENCODING), getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_ERRORS));
            return getItemNode.execute(frame, result, 0);
        }
    }

    @Builtin(name="_buffer_decode", minNumOfPositionalArgs=1, parameterNames={"self", "input", "errors", "final"})
    protected static abstract class IncrementalDecodeNode
    extends PythonQuaternaryBuiltinNode {
        protected IncrementalDecodeNode() {
        }

        @Specialization
        Object decode(VirtualFrame frame, PythonObject self, Object input, Object errors, Object ffinal, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode) {
            return decode.execute(frame, input, getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_ENCODING), errors, ffinal);
        }
    }

    @Builtin(name="decode", minNumOfPositionalArgs=1, parameterNames={"self", "input", "errors"})
    protected static abstract class StreamDecodeNode
    extends PythonTernaryBuiltinNode {
        protected StreamDecodeNode() {
        }

        @Specialization
        Object decode(VirtualFrame frame, PythonObject self, Object input, Object errors, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode) {
            return decode.execute(frame, input, getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_ENCODING), errors, false);
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    protected static abstract class CallApplyNode
    extends PythonVarargsBuiltinNode {
        protected CallApplyNode() {
        }

        @Specialization
        Object call(VirtualFrame frame, PythonObject self, Object[] args, PKeyword[] kw, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallVarargsMethodNode callNode) {
            Object[] callArgs = new Object[args.length + 1];
            callArgs[0] = getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_ENCODING);
            PythonUtils.arraycopy(args, 0, callArgs, 1, args.length);
            return callNode.execute((Frame)frame, getAttrNode.execute((Frame)frame, inliningTarget, self, T_ATTR_FN), callArgs, kw);
        }
    }

    @GenerateUncached
    @GenerateCached
    @GenerateInline(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class MakeIncrementalcodecNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3, TruffleString var4);

        @Specialization
        static Object getIncEncoder(VirtualFrame frame, Object codecInfo, PNone errors, TruffleString attrName, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, codecInfo, attrName, new Object[0]);
        }

        @Specialization(guards={"!isPNone(errors)"})
        static Object getIncEncoder(VirtualFrame frame, Object codecInfo, Object errors, TruffleString attrName, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, codecInfo, attrName, errors);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class GetPreferredEncoding
    extends PNodeWithContext {
        public static final TruffleString T_GETPREFERREDENCODING = PythonUtils.tsLiteral("getpreferredencoding");

        public abstract TruffleString execute(Frame var1);

        @Specialization
        TruffleString getpreferredencoding(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodNode, @Cached PyObjectStrAsTruffleStringNode strNode) {
            Object locale = AbstractImportNode.importModule(BuiltinNames.T_LOCALE);
            Object e = callMethodNode.execute((Frame)frame, inliningTarget, locale, T_GETPREFERREDENCODING, new Object[0]);
            return strNode.execute((Frame)frame, inliningTarget, e);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class LookupTextEncoding
    extends PNodeWithContext {
        public static final TruffleString T_IS_TEXT_ENCODING = PythonUtils.tsLiteral("_is_text_encoding");

        public abstract Object execute(Frame var1, TruffleString var2, TruffleString var3);

        @Specialization
        Object lookup(VirtualFrame frame, TruffleString encoding, TruffleString alternateCommand, @Bind(value="this") Node inliningTarget, @Cached CodecsModuleBuiltins.PyCodecLookupNode lookupNode, @Cached PyObjectGetAttr getAttributeNode, @Cached PRaiseNode raiseNode) {
            PTuple codecInfo = lookupNode.execute((Frame)frame, inliningTarget, encoding);
            Object isTextObj = getAttributeNode.execute((Frame)frame, inliningTarget, codecInfo, T_IS_TEXT_ENCODING);
            if (!(isTextObj instanceof Boolean) || !((Boolean)isTextObj).booleanValue()) {
                throw raiseNode.raise(PythonBuiltinClassType.LookupError, ErrorMessages.IS_NOT_TEXT_ENCODING, encoding, alternateCommand);
            }
            return codecInfo;
        }
    }
}

