/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.graal.python.runtime.sequence.storage.TypedSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import java.util.Arrays;

public final class DoubleSequenceStorage
extends TypedSequenceStorage {
    private double[] values;

    public DoubleSequenceStorage() {
        this.values = new double[0];
    }

    public DoubleSequenceStorage(double[] elements) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = elements.length;
    }

    public DoubleSequenceStorage(double[] elements, int length) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = length;
    }

    public DoubleSequenceStorage(int capacity) {
        this.values = new double[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    @Override
    protected void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    @Override
    protected void increaseCapacityExact(int newCapacity) {
        this.values = new double[newCapacity];
        this.capacity = this.values.length;
    }

    @Override
    public SequenceStorage copy() {
        return new DoubleSequenceStorage(PythonUtils.arrayCopyOf(this.values, this.length));
    }

    @Override
    public SequenceStorage createEmpty(int newCapacity) {
        return new DoubleSequenceStorage(newCapacity);
    }

    @Override
    public Object[] getInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    public double[] getInternalDoubleArray() {
        return this.values;
    }

    @Override
    public Object getItemNormalized(int idx) {
        return this.getDoubleItemNormalized(idx);
    }

    public double getDoubleItemNormalized(int idx) {
        return this.values[idx];
    }

    @Override
    public void setItemNormalized(int idx, Object value) throws SequenceStoreException {
        if (!(value instanceof Double)) {
            throw new SequenceStoreException(value);
        }
        this.setDoubleItemNormalized(idx, (Double)value);
    }

    public void setDoubleItemNormalized(int idx, double value) {
        this.values[idx] = value;
    }

    @Override
    public void insertItem(int idx, Object value) throws SequenceStoreException {
        if (!(value instanceof Double)) {
            throw new SequenceStoreException(value);
        }
        this.insertDoubleItem(idx, (Double)value);
    }

    public void insertDoubleItem(int idx, double value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        ++this.length;
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
        this.values[idxTo] = this.values[idxFrom];
    }

    @Override
    public DoubleSequenceStorage getSliceInBound(int start, int stop, int step, int sliceLength) {
        double[] newArray = new double[sliceLength];
        if (step == 1) {
            PythonUtils.arraycopy(this.values, start, newArray, 0, sliceLength);
            return new DoubleSequenceStorage(newArray);
        }
        int i = start;
        for (int j = 0; j < sliceLength; ++j) {
            newArray[j] = this.values[i];
            i += step;
        }
        return new DoubleSequenceStorage(newArray);
    }

    public int indexOfDouble(double value) {
        for (int i = 0; i < this.length; ++i) {
            if (Double.compare(this.values[i], value) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                double temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    @Override
    public Object getIndicativeValue() {
        return 0.0;
    }

    @Override
    public boolean equals(SequenceStorage other) {
        if (other.length() != this.length()) {
            return false;
        }
        double[] otherArray = ((DoubleSequenceStorage)other).getInternalDoubleArray();
        for (int i = 0; i < this.length(); ++i) {
            if (this.values[i] == otherArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return this.getInternalArray();
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (double[])arrayObject;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Double;
    }
}

