/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.exception.TopLevelExceptionHandler;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNodeGen;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;

public abstract class ExecutionContext {

    public static abstract class IndirectCalleeContext {
        public static Object enterIndirect(PythonLanguage language, PythonContext context, Object[] pArguments) {
            return IndirectCalleeContext.enter(context.getThreadState(language), pArguments, true);
        }

        public static Object enterIndirect(PythonContext.PythonThreadState threadState, Object[] pArguments) {
            return IndirectCalleeContext.enter(threadState, pArguments, true);
        }

        public static Object enter(PythonLanguage language, PythonContext context, Object[] pArguments, RootCallTarget callTarget) {
            PRootNode calleeRootNode = (PRootNode)callTarget.getRootNode();
            return IndirectCalleeContext.enter(context.getThreadState(language), pArguments, calleeRootNode.needsExceptionState());
        }

        public static Object enter(PythonContext.PythonThreadState threadState, Object[] pArguments, RootCallTarget callTarget) {
            PRootNode calleeRootNode = (PRootNode)callTarget.getRootNode();
            return IndirectCalleeContext.enter(threadState, pArguments, calleeRootNode.needsExceptionState());
        }

        private static Object enter(PythonContext.PythonThreadState threadState, Object[] pArguments, boolean needsExceptionState) {
            PFrame.Reference popTopFrameInfo = threadState.popTopFrameInfo();
            PArguments.setCallerFrameInfo(pArguments, popTopFrameInfo);
            if (needsExceptionState) {
                PException curExc = threadState.getCaughtException();
                if (curExc != null) {
                    threadState.setCaughtException(null);
                }
                PArguments.setException(pArguments, curExc);
                return new IndirectCallState(popTopFrameInfo, curExc);
            }
            return popTopFrameInfo;
        }

        public static void exit(PythonLanguage language, PythonContext context, Object state) {
            IndirectCalleeContext.exit(context.getThreadState(language), state);
        }

        public static void exit(PythonContext.PythonThreadState threadState, Object state) {
            if (state instanceof IndirectCallState) {
                IndirectCallState indirectCallState = (IndirectCallState)state;
                threadState.setTopFrameInfo(indirectCallState.info);
                threadState.setCaughtException(indirectCallState.curExc);
            } else {
                threadState.setTopFrameInfo((PFrame.Reference)state);
            }
        }
    }

    public static abstract class IndirectCallContext {
        public static Object enter(VirtualFrame frame, PythonLanguage language, PythonContext context, IndirectCallData indirectCallData) {
            if (frame == null || indirectCallData.isUncached()) {
                return null;
            }
            boolean needsCallerFrame = indirectCallData.calleeNeedsCallerFrame();
            boolean needsExceptionState = indirectCallData.calleeNeedsExceptionState();
            if (!needsCallerFrame && !needsExceptionState) {
                return null;
            }
            PythonContext.PythonThreadState pythonThreadState = context.getThreadState(language);
            return IndirectCallContext.enter(frame, pythonThreadState, needsCallerFrame, needsExceptionState, indirectCallData.getNode());
        }

        public static Object enter(VirtualFrame frame, IndirectCallData indirectCallData) {
            if (frame == null || indirectCallData.isUncached()) {
                return null;
            }
            boolean needsCallerFrame = indirectCallData.calleeNeedsCallerFrame();
            boolean needsExceptionState = indirectCallData.calleeNeedsExceptionState();
            if (!needsCallerFrame && !needsExceptionState) {
                return null;
            }
            Node indirectCallNode = indirectCallData.getNode();
            PythonContext.PythonThreadState pythonThreadState = PythonContext.get(indirectCallNode).getThreadState(PythonLanguage.get(indirectCallNode));
            return IndirectCallContext.enter(frame, pythonThreadState, needsCallerFrame, needsExceptionState, indirectCallNode);
        }

        public static Object enter(VirtualFrame frame, PythonContext.PythonThreadState pythonThreadState, IndirectCallData indirectCallData) {
            if (frame == null || indirectCallData.isUncached()) {
                return null;
            }
            return IndirectCallContext.enter(frame, pythonThreadState, indirectCallData.calleeNeedsCallerFrame(), indirectCallData.calleeNeedsExceptionState(), indirectCallData.getNode());
        }

        private static IndirectCallState enter(VirtualFrame frame, PythonContext.PythonThreadState pythonThreadState, boolean needsCallerFrame, boolean needsExceptionState, Node callNode) {
            PFrame.Reference info = null;
            if (needsCallerFrame) {
                PFrame.Reference prev = pythonThreadState.popTopFrameInfo();
                assert (prev == null) : "trying to call from Python to a foreign function, but we didn't clear the topframeref. This indicates that a call into Python code happened without a proper enter through ForeignToPythonCallContext";
                info = PArguments.getCurrentFrameInfo((Frame)frame);
                info.setCallNode(callNode);
                pythonThreadState.setTopFrameInfo(info);
            }
            PException curExc = pythonThreadState.getCaughtException();
            PException exceptionState = PArguments.getException((Frame)frame);
            if (needsExceptionState) {
                pythonThreadState.setCaughtException(exceptionState);
            } else if (exceptionState != curExc) {
                pythonThreadState.setCaughtException(null);
            }
            if (curExc == null && info == null) {
                return null;
            }
            return new IndirectCallState(info, curExc);
        }

        public static void exit(VirtualFrame frame, PythonLanguage language, PythonContext context, Object savedState) {
            if (savedState != null && frame != null && context != null) {
                IndirectCallContext.exit(frame, context.getThreadState(language), savedState);
                return;
            }
            assert (savedState == null) : "tried to exit an indirect call with state, but without frame/context";
        }

        public static void exit(VirtualFrame frame, IndirectCallData indirectCallData, Object savedState) {
            Node indirectCallNode;
            PythonContext context;
            if (savedState != null && frame != null && !indirectCallData.isUncached() && (context = PythonContext.get(indirectCallNode = indirectCallData.getNode())) != null) {
                PythonLanguage language = PythonLanguage.get(indirectCallNode);
                IndirectCallContext.exit(frame, context.getThreadState(language), savedState);
                return;
            }
            assert (savedState == null) : "tried to exit an indirect call with state, but without frame/context";
        }

        public static void exit(VirtualFrame frame, PythonContext.PythonThreadState pythonThreadState, Object savedState) {
            if (frame == null) {
                assert (savedState == null) : "tried to exit an indirect call with state, but without frame";
                return;
            }
            if (savedState == null) {
                return;
            }
            IndirectCallState state = (IndirectCallState)savedState;
            if (state.info != null) {
                pythonThreadState.popTopFrameInfo();
            }
            pythonThreadState.setCaughtException(state.curExc);
        }
    }

    @CompilerDirectives.ValueType
    private static final class IndirectCallState {
        private final PFrame.Reference info;
        private final PException curExc;

        private IndirectCallState(PFrame.Reference info, PException curExc) {
            this.info = info;
            this.curExc = curExc;
        }
    }

    public static final class CalleeContext
    extends Node {
        @Node.Child
        private MaterializeFrameNode materializeNode;
        @CompilerDirectives.CompilationFinal
        private boolean everEscaped = false;

        public Node copy() {
            return new CalleeContext();
        }

        public void enter(VirtualFrame frame) {
            PFrame.Reference thisFrameRef = new PFrame.Reference(PArguments.getCallerFrameInfo((Frame)frame));
            PArguments.setCurrentFrameInfo((Frame)frame, thisFrameRef);
        }

        public void exit(VirtualFrame frame, PRootNode node) {
            PFrame.Reference info = PArguments.getCurrentFrameInfo((Frame)frame);
            CompilerAsserts.partialEvaluationConstant((Object)((Object)node));
            if (node.getFrameEscapedProfile().profile(info.isEscaped())) {
                this.exitEscaped(frame, node, info);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private void exitEscaped(VirtualFrame frame, PRootNode node, PFrame.Reference info) {
            PFrame.Reference callerInfo;
            if (!this.everEscaped) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.everEscaped = true;
                this.reportPolymorphicSpecialize();
            }
            if ((callerInfo = PArguments.getCallerFrameInfo((Frame)frame)) == null) {
                CompilerDirectives.transferToInterpreter();
                Frame callerFrame = ReadCallerFrameNode.getCallerFrame(info, FrameInstance.FrameAccess.READ_ONLY, ReadCallerFrameNode.FrameSelector.ALL_PYTHON_FRAMES, 0);
                callerInfo = PArguments.isPythonFrame(callerFrame) ? PArguments.getCurrentFrameInfo(callerFrame) : PFrame.Reference.EMPTY;
                assert (node.needsCallerFrame()) : "stack walk did not invalidate caller frame assumption";
            }
            this.ensureMaterializeNode().execute((Frame)frame, (Node)node, false, true);
            callerInfo.markAsEscaped();
            info.setBackref(callerInfo);
        }

        private MaterializeFrameNode ensureMaterializeNode() {
            if (this.materializeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.materializeNode = (MaterializeFrameNode)this.insert(MaterializeFrameNodeGen.create());
            }
            return this.materializeNode;
        }

        public static CalleeContext create() {
            return new CalleeContext();
        }
    }

    public static final class CallContext
    extends Node {
        @CompilerDirectives.CompilationFinal
        boolean neededCallerFrame;
        @CompilerDirectives.CompilationFinal
        boolean neededExceptionState;
        private static final CallContext INSTANCE = new CallContext(false);
        @Node.Child
        private MaterializeFrameNode materializeNode;
        private final boolean adoptable;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile isPythonFrameProfile;

        private CallContext(boolean adoptable) {
            this.adoptable = adoptable;
            this.neededExceptionState = !adoptable;
            this.neededCallerFrame = !adoptable;
        }

        public void prepareIndirectCall(VirtualFrame frame, Object[] callArguments, Node callNode) {
            this.prepareCall(frame, callArguments, callNode, true, true);
        }

        public void prepareCall(VirtualFrame frame, Object[] callArguments, RootCallTarget callTarget, Node callNode) {
            PRootNode calleeRootNode = (PRootNode)callTarget.getRootNode();
            this.prepareCall(frame, callArguments, callNode, calleeRootNode.needsCallerFrame(), calleeRootNode.needsExceptionState());
        }

        private void prepareCall(VirtualFrame frame, Object[] callArguments, Node callNode, boolean needsCallerFrame, boolean needsExceptionState) {
            if (needsCallerFrame) {
                PFrame.Reference thisInfo;
                if (!this.neededCallerFrame) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.neededCallerFrame = true;
                }
                if (this.isPythonFrame(frame, callNode)) {
                    thisInfo = PArguments.getCurrentFrameInfo((Frame)frame);
                    PFrame pyFrame = this.materialize(frame, callNode, false, true);
                    assert (thisInfo.getPyFrame() == pyFrame);
                    assert (pyFrame.getRef() == thisInfo);
                } else {
                    thisInfo = PFrame.Reference.EMPTY;
                }
                thisInfo.setCallNode(callNode);
                PArguments.setCallerFrameInfo(callArguments, thisInfo);
            }
            if (needsExceptionState) {
                PException curExc;
                if (!this.neededExceptionState) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.neededExceptionState = true;
                }
                if (this.isPythonFrame(frame, callNode)) {
                    curExc = PArguments.getException((Frame)frame);
                    if (curExc == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        PException fromStackWalk = ExceptionStateNodes.GetCaughtExceptionNode.fullStackWalk();
                        curExc = fromStackWalk != null ? fromStackWalk : PException.NO_EXCEPTION;
                        PArguments.setException((Frame)frame, curExc);
                    }
                } else {
                    curExc = PException.NO_EXCEPTION;
                }
                PArguments.setException(callArguments, curExc);
            }
        }

        private PFrame materialize(VirtualFrame frame, Node callNode, boolean markAsEscaped, boolean forceSync) {
            if (this.adoptable) {
                return this.ensureMaterializeNode().execute((Frame)frame, callNode, markAsEscaped, forceSync);
            }
            return MaterializeFrameNode.getUncached().execute((Frame)frame, callNode, markAsEscaped, forceSync);
        }

        private boolean isPythonFrame(VirtualFrame frame, Node callNode) {
            if (this.isPythonFrameProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isPythonFrameProfile = ConditionProfile.create();
            }
            boolean result = this.isPythonFrameProfile.profile(PArguments.isPythonFrame((Frame)frame));
            assert (result || callNode.getRootNode() instanceof TopLevelExceptionHandler) : "calling from non-Python or non-top-level frame";
            return result;
        }

        private MaterializeFrameNode ensureMaterializeNode() {
            if (this.materializeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.materializeNode = (MaterializeFrameNode)this.insert(MaterializeFrameNodeGen.create());
            }
            return this.materializeNode;
        }

        public boolean isAdoptable() {
            return this.adoptable;
        }

        @NeverDefault
        public static CallContext create() {
            return new CallContext(true);
        }

        public static CallContext getUncached() {
            return INSTANCE;
        }
    }
}

