/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNodeFactory;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class CoerceToBooleanNode
extends UnaryOpNode {
    @NeverDefault
    public static CoerceToBooleanNode createIfTrueNode() {
        return CoerceToBooleanNodeFactory.YesNodeGen.create();
    }

    @NeverDefault
    public static CoerceToBooleanNode createIfFalseNode() {
        return CoerceToBooleanNodeFactory.NotNodeGen.create();
    }

    public abstract boolean executeBoolean(VirtualFrame var1, Node var2, Object var3);

    public final boolean executeBooleanCached(VirtualFrame frame, Object value) {
        return this.executeBoolean(frame, this, value);
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class YesNode
    extends CoerceToBooleanNode {
        @Specialization
        static boolean doBoolean(boolean operand) {
            return operand;
        }

        @Specialization
        static boolean doInteger(int operand) {
            return operand != 0;
        }

        @Specialization
        static boolean doLong(long operand) {
            return operand != 0L;
        }

        @Specialization
        static boolean doDouble(double operand) {
            return operand != 0.0;
        }

        @Specialization
        static boolean doString(TruffleString operand) {
            return !operand.isEmpty();
        }

        @Specialization
        @ReportPolymorphism.Megamorphic
        static boolean doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached PyObjectIsTrueNode isTrue) {
            return isTrue.execute((Frame)frame, inliningTarget, object);
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class NotNode
    extends CoerceToBooleanNode {
        @Specialization
        static boolean doBool(boolean operand) {
            return !operand;
        }

        @Specialization
        static boolean doInteger(int operand) {
            return operand == 0;
        }

        @Specialization
        static boolean doLong(long operand) {
            return operand == 0L;
        }

        @Specialization
        static boolean doDouble(double operand) {
            return operand == 0.0;
        }

        @Specialization
        static boolean doString(TruffleString operand) {
            return operand.isEmpty();
        }

        @Specialization
        @ReportPolymorphism.Megamorphic
        static boolean doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached PyObjectIsTrueNode isTrue) {
            return !isTrue.execute((Frame)frame, inliningTarget, object);
        }
    }
}

