/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupInheritedAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.expression.CastToListExpressionNodeGen;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class CastToListExpressionNode
extends UnaryOpNode {
    @Specialization
    static PList doObject(VirtualFrame frame, Object value, @Cached(inline=false) CastToListNode castToListNode) {
        return castToListNode.execute(frame, value);
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    public static abstract class CastToListNode
    extends Node {
        public abstract PList execute(VirtualFrame var1, Object var2);

        protected PythonLanguage getLanguage() {
            return PythonLanguage.get(this);
        }

        @Specialization(guards={"cannotBeOverridden(v, inliningTarget, getClassNode)", "cachedLength == getLength(v)", "cachedLength < 32"}, limit="2")
        @ExplodeLoop
        static PList starredTupleCachedLength(PTuple v, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Exclusive @Cached PythonObjectFactory factory, @Cached(value="getLength(v)") int cachedLength, @Cached SequenceStorageNodes.GetItemNode getItemNode) {
            SequenceStorage s = v.getSequenceStorage();
            Object[] array = new Object[cachedLength];
            for (int i = 0; i < cachedLength; ++i) {
                array[i] = getItemNode.execute(s, i);
            }
            return factory.createList(array);
        }

        @Specialization(replaces={"starredTupleCachedLength"}, guards={"cannotBeOverridden(v, inliningTarget, getClassNode)"}, limit="1")
        static PList starredTuple(PTuple v, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Exclusive @Cached PythonObjectFactory factory, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
            return factory.createList((Object[])getObjectArrayNode.execute(inliningTarget, v).clone());
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(v)"})
        protected static PList starredList(PList v) {
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(rewriteOn={PException.class})
        static PList starredIterable(VirtualFrame frame, PythonObject value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached.Shared @Cached ListNodes.ConstructListNode constructListNode) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                PList pList = constructListNode.execute((Frame)frame, value);
                return pList;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @Specialization
        static PList starredGeneric(VirtualFrame frame, Object v, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached.Shared @Cached ListNodes.ConstructListNode constructListNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrProfile, @Cached PRaiseNode raise) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, PythonContext.get(inliningTarget), indirectCallData);
            try {
                PList pList = constructListNode.execute((Frame)frame, v);
                return pList;
            }
            catch (PException e) {
                e.expectAttributeError(inliningTarget, attrProfile);
                throw raise.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, v);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, PythonContext.get(inliningTarget), state);
            }
        }

        protected int getLength(PTuple t) {
            return t.getSequenceStorage().length();
        }

        @NeverDefault
        public static CastToListNode create() {
            return CastToListExpressionNodeGen.CastToListNodeGen.create();
        }
    }

    private static final class CastToListUncachedNode
    extends CastToListInteropNode {
        private static final CastToListUncachedNode UNCACHED = new CastToListUncachedNode();

        private CastToListUncachedNode() {
        }

        @Override
        public PList executeWithGlobalState(Object list) {
            PythonModule builtins = PythonContext.get(this).getBuiltins();
            Object listType = ReadAttributeFromObjectNode.getUncached().execute((Object)builtins, (Object)BuiltinNames.T_LIST);
            return (PList)CallNode.getUncached().execute(null, LookupInheritedAttributeNode.Dynamic.executeUncached(listType, SpecialMethodNames.T___CALL__), listType, list);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    private static final class CastToListCachedNode
    extends CastToListInteropNode {
        @Node.Child
        private CastToListNode castToListNode = CastToListNode.create();

        private CastToListCachedNode() {
        }

        @Override
        public PList executeWithGlobalState(Object list) {
            return this.castToListNode.execute(null, list);
        }
    }

    public static abstract class CastToListInteropNode
    extends PNodeWithContext {
        public abstract PList executeWithGlobalState(Object var1);

        @NeverDefault
        public static CastToListInteropNode create() {
            return new CastToListCachedNode();
        }

        public static CastToListInteropNode getUncached() {
            return CastToListUncachedNode.UNCACHED;
        }
    }
}

