/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.traceback;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;

public final class PTraceback
extends PythonBuiltinObject {
    public static final int UNKNOWN_LINE_NUMBER = -2;
    private PFrame frame;
    private PFrame.Reference frameInfo;
    private int lineno = -2;
    private int lasti;
    private PTraceback next;
    private LazyTraceback lazyTraceback;
    static final String J_TB_FRAME = "tb_frame";
    static final String J_TB_NEXT = "tb_next";
    static final String J_TB_LASTI = "tb_lasti";
    static final String J_TB_LINENO = "tb_lineno";
    private static final TruffleString T_TB_FRAME = PythonUtils.tsLiteral("tb_frame");
    private static final TruffleString T_TB_NEXT = PythonUtils.tsLiteral("tb_next");
    private static final TruffleString T_TB_LASTI = PythonUtils.tsLiteral("tb_lasti");
    private static final TruffleString T_TB_LINENO = PythonUtils.tsLiteral("tb_lineno");
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final Object[] TB_DIR_FIELDS = new Object[]{T_TB_FRAME, T_TB_NEXT, T_TB_LASTI, T_TB_LINENO};

    public PTraceback(PythonLanguage lang, PFrame frame, int lineno, PTraceback next) {
        this(lang, frame, lineno, -1, next);
    }

    public PTraceback(PythonLanguage lang, PFrame frame, int lineno, int lasti, PTraceback next) {
        super((Object)PythonBuiltinClassType.PTraceback, PythonBuiltinClassType.PTraceback.getInstanceShape(lang));
        this.frame = frame;
        this.lineno = lineno;
        this.lasti = lasti;
        this.next = next;
    }

    public PTraceback(PythonLanguage lang, LazyTraceback lazyTraceback) {
        super((Object)PythonBuiltinClassType.PTraceback, PythonBuiltinClassType.PTraceback.getInstanceShape(lang));
        this.lazyTraceback = lazyTraceback;
        this.frameInfo = lazyTraceback.getFrameInfo();
        this.frame = lazyTraceback.getFrame();
    }

    public void copyFrom(PTraceback other) {
        this.frame = other.frame;
        this.frameInfo = other.frameInfo;
        this.lineno = other.lineno;
        this.next = other.next;
    }

    public PFrame getFrame() {
        return this.frame;
    }

    public void setFrame(PFrame frame) {
        this.frame = frame;
    }

    public PFrame.Reference getFrameInfo() {
        return this.frameInfo;
    }

    public int getLineno() {
        if (this.lineno == -2 && this.lazyTraceback != null) {
            this.lineno = this.lazyTraceback.getLineNo();
        }
        return this.lineno;
    }

    public int getLasti() {
        return this.lasti;
    }

    public LazyTraceback getLazyTraceback() {
        return this.lazyTraceback;
    }

    public PTraceback getNext() {
        return this.next;
    }

    public void setNext(PTraceback next) {
        this.next = next;
    }

    public void setLineno(int lineno) {
        this.lineno = lineno;
    }

    public void markMaterialized() {
        this.lazyTraceback = null;
    }

    public boolean isMaterialized() {
        return this.lazyTraceback == null;
    }

    static Object[] getTbFieldNames() {
        return (Object[])TB_DIR_FIELDS.clone();
    }
}

