/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.str;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.iterator.PStringIterator;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.range.RangeNodes;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.str.StringBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.str.TemplateFormatter;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.formatting.StringFormatProcessor;
import com.oracle.graal.python.runtime.formatting.TextFormatter;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.IntPredicate;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;
import org.graalvm.shadowed.com.ibm.icu.text.CaseMap;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PString})
public final class StringBuiltins
extends PythonBuiltins {
    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StringBuiltinsFactory.getFactories();
    }

    private static int indexOf(TruffleString self, TruffleString sub, int start, int end, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.IndexOfStringNode indexOfStringNode) {
        int cpEnd;
        int cpLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
        int cpStart = StringBuiltins.adjustStartIndex(start, cpLen);
        if (cpStart < (cpEnd = StringBuiltins.adjustEndIndex(end, cpLen))) {
            return indexOfStringNode.execute((AbstractTruffleString)self, (AbstractTruffleString)sub, cpStart, cpEnd, PythonUtils.TS_ENCODING);
        }
        if (sub.isEmpty() && cpStart == cpEnd && cpStart <= cpLen) {
            return cpStart;
        }
        return -1;
    }

    private static int lastIndexOf(TruffleString self, TruffleString sub, int start, int end, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.LastIndexOfStringNode lastIndexOfStringNode) {
        int cpEnd;
        int cpLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
        int cpStart = StringBuiltins.adjustStartIndex(start, cpLen);
        if (cpStart < (cpEnd = StringBuiltins.adjustEndIndex(end, cpLen))) {
            return lastIndexOfStringNode.execute((AbstractTruffleString)self, (AbstractTruffleString)sub, cpEnd, cpStart, PythonUtils.TS_ENCODING);
        }
        if (sub.isEmpty() && cpStart == cpEnd && cpStart <= cpLen) {
            return cpStart;
        }
        return -1;
    }

    static int adjustStartIndex(int startIn, int len) {
        if (startIn < 0) {
            int start = startIn + len;
            return start < 0 ? 0 : start;
        }
        return startIn;
    }

    static int adjustEndIndex(int endIn, int len) {
        if (endIn > len) {
            return len;
        }
        if (endIn < 0) {
            int end = endIn + len;
            return end < 0 ? 0 : end;
        }
        return endIn;
    }

    @Builtin(name="removesuffix", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"self", "suffix"})
    @ArgumentsClinic(value={@ArgumentClinic(name="self", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="suffix", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodNames.class})
    static abstract class RemoveSuffixNode
    extends PythonBinaryClinicBuiltinNode {
        RemoveSuffixNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.RemovePrefixNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString remove(TruffleString self, TruffleString suffix, @Bind(value="this") Node inliningTarget, @Cached PrefixSuffixNode prefixSuffixNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached InlinedConditionProfile profile) {
            int selfLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            if (profile.profile(inliningTarget, prefixSuffixNode.endsWith(self, suffix, 0, selfLen))) {
                int suffixLen = codePointLengthNode.execute((AbstractTruffleString)suffix, PythonUtils.TS_ENCODING);
                return substringNode.execute((AbstractTruffleString)self, 0, selfLen - suffixLen, PythonUtils.TS_ENCODING, false);
            }
            return self;
        }
    }

    @Builtin(name="removeprefix", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"self", "prefix"})
    @ArgumentsClinic(value={@ArgumentClinic(name="self", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="prefix", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodNames.class})
    static abstract class RemovePrefixNode
    extends PythonBinaryClinicBuiltinNode {
        RemovePrefixNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.RemovePrefixNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString remove(TruffleString self, TruffleString prefix, @Cached PrefixSuffixNode prefixSuffixNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode) {
            int prefixLen = codePointLengthNode.execute((AbstractTruffleString)prefix, PythonUtils.TS_ENCODING);
            if (prefixSuffixNode.startsWith(self, prefix, 0, prefixLen)) {
                int selfLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
                return substringNode.execute((AbstractTruffleString)self, prefixLen, selfLen - prefixLen, PythonUtils.TS_ENCODING, false);
            }
            return self;
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static long doString(TruffleString self, @Cached.Shared(value="hashCode") @Cached TruffleString.HashCodeNode hashCodeNode) {
            return PyObjectHashNode.hash(self, hashCodeNode);
        }

        @Specialization(replaces={"doString"})
        static long doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached.Shared(value="hashCode") @Cached TruffleString.HashCodeNode hashCodeNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return HashNode.doString(cast.execute(inliningTarget, self), hashCodeNode);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___HASH__, self);
            }
        }
    }

    @Builtin(name="expandtabs", minNumOfPositionalArgs=1, parameterNames={"$self", "tabsize"})
    @ArgumentsClinic(value={@ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="tabsize", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="8", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class ExpandTabsNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static TruffleString doString(TruffleString self, int tabsize, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)self.byteLength(PythonUtils.TS_ENCODING));
            int linePos = 0;
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int cp = nextNode.execute(it);
                if (cp == 9) {
                    int incr = tabsize - linePos % tabsize;
                    if (incr > 0) {
                        appendCodePointNode.execute(sb, 32, incr, true);
                    }
                    linePos += incr;
                    continue;
                }
                linePos = cp == 10 || cp == 13 ? 0 : ++linePos;
                appendCodePointNode.execute(sb, cp, 1, true);
            }
            return toStringNode.execute(sb);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.ExpandTabsNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="swapcase", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class SwapCaseNode
    extends PythonUnaryBuiltinNode {
        private static final int CAPITAL_SIGMA = 931;

        @CompilerDirectives.TruffleBoundary
        private static String doJavaString(String self) {
            int charCount;
            StringBuilder sb = new StringBuilder(self.length());
            for (int i = 0; i < self.length(); i += charCount) {
                int codePoint = self.codePointAt(i);
                charCount = Character.charCount(codePoint);
                String substr = self.substring(i, i + charCount);
                if (UCharacter.isUUppercase((int)codePoint)) {
                    if (codePoint == 931) {
                        SwapCaseNode.handleCapitalSigma(self, sb, i, codePoint);
                        continue;
                    }
                    sb.append(UCharacter.toLowerCase((Locale)Locale.ROOT, (String)substr));
                    continue;
                }
                if (UCharacter.isULowercase((int)codePoint)) {
                    sb.append(UCharacter.toUpperCase((Locale)Locale.ROOT, (String)substr));
                    continue;
                }
                sb.append(substr);
            }
            return sb.toString();
        }

        private static void handleCapitalSigma(String self, StringBuilder sb, int i, int codePoint) {
            boolean finalSigma;
            int ch;
            int j;
            for (j = i - 1; j >= 0 && (Character.isLowSurrogate(self.charAt(j)) || UCharacter.hasBinaryProperty((int)(ch = self.codePointAt(j)), (int)50)); --j) {
            }
            boolean bl = finalSigma = j >= 0 && UCharacter.hasBinaryProperty((int)codePoint, (int)49);
            if (finalSigma) {
                int ch2;
                for (j = i + 1; j < self.length() && UCharacter.hasBinaryProperty((int)(ch2 = self.codePointAt(j)), (int)50); j += Character.charCount(ch2)) {
                }
                finalSigma = j == self.length() || !UCharacter.hasBinaryProperty((int)codePoint, (int)49);
            }
            sb.appendCodePoint(finalSigma ? 962 : 963);
        }

        @Specialization
        static TruffleString doString(TruffleString self, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(SwapCaseNode.doJavaString(toJavaStringNode.execute((AbstractTruffleString)self)), PythonUtils.TS_ENCODING);
        }

        @Specialization(replaces={"doString"})
        static TruffleString doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToJavaStringCheckedNode castSelfNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(SwapCaseNode.doJavaString(castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "swapcase", self)), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="casefold", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CasefoldNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private static String doJavaString(String self) {
            return UCharacter.foldCase((String)self, (boolean)true);
        }

        @Specialization
        static TruffleString doString(TruffleString self, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(CasefoldNode.doJavaString(toJavaStringNode.execute((AbstractTruffleString)self)), PythonUtils.TS_ENCODING);
        }

        @Specialization(replaces={"doString"})
        static TruffleString doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToJavaStringCheckedNode castSelfNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(CasefoldNode.doJavaString(castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "casefold", self)), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PStringIterator doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached PythonObjectFactory factory) {
            TruffleString string = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___ITER__, self);
            return factory.createStringIterator(string);
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class StrGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static TruffleString doString(VirtualFrame frame, Object self, PSlice slice, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castToString, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached StrGetItemNodeWithSlice getItemNodeWithSlice, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            TruffleString str = castToString.cast(inliningTarget, self, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___GETITEM__, "str", self);
            PSlice.SliceInfo info = compute.execute((Frame)frame, sliceCast.execute(inliningTarget, slice), codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING));
            return getItemNodeWithSlice.execute(str, info);
        }

        @Specialization(guards={"!isPSlice(idx)"})
        static TruffleString doString(VirtualFrame frame, Object self, Object idx, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castToString, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString str = castToString.cast(inliningTarget, self, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___GETITEM__, "str", self);
            int len = codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
            int index = asSizeNode.executeExact((Frame)frame, inliningTarget, idx);
            if (index < 0) {
                index += len;
            }
            if (index < 0 || index >= len) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
            return substringNode.execute((AbstractTruffleString)str, index, 1, PythonUtils.TS_ENCODING, false);
        }
    }

    @GenerateUncached
    public static abstract class StrGetItemNodeWithSlice
    extends Node {
        public abstract TruffleString execute(TruffleString var1, PSlice.SliceInfo var2);

        static boolean isEmptySlice(PSlice.SliceInfo s) {
            int step = s.step;
            int start = s.start;
            int stop = s.stop;
            return step >= 0 && stop <= start || step <= 0 && stop >= start;
        }

        static boolean isSimpleSlice(PSlice.SliceInfo s) {
            return s.step == 1 && s.stop > s.start;
        }

        @Specialization(guards={"isSimpleSlice(slice)"})
        static TruffleString doStepOneStopGtStart(TruffleString value, PSlice.SliceInfo slice, @Cached TruffleString.SubstringNode substringNode) {
            return substringNode.execute((AbstractTruffleString)value, slice.start, slice.stop - slice.start, PythonUtils.TS_ENCODING, false);
        }

        @Specialization(guards={"isEmptySlice(slice)"})
        static TruffleString doEmptySlice(TruffleString value, PSlice.SliceInfo slice) {
            return StringLiterals.T_EMPTY_STRING;
        }

        @Specialization(guards={"step == slice.step", "!isSimpleSlice(slice)", "!isEmptySlice(slice)"}, limit="1")
        static TruffleString doGenericCachedStep(TruffleString value, PSlice.SliceInfo slice, @Bind(value="this") Node inliningTarget, @Cached(value="slice.step") int step, @Cached.Shared(value="loop") @Cached InlinedLoopConditionProfile loopProfile, @Cached.Shared(value="len") @Cached RangeNodes.LenOfRangeNode sliceLen, @Cached.Shared(value="appendCP") @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached.Shared(value="toStr") @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            int len = sliceLen.len(inliningTarget, slice);
            int start = slice.start;
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)PythonUtils.tsbCapacity(len));
            int j = 0;
            loopProfile.profileCounted(inliningTarget, (long)len);
            int i = start;
            while (loopProfile.inject(inliningTarget, j < len)) {
                appendCodePointNode.execute(sb, codePointAtIndexNode.execute((AbstractTruffleString)value, i, PythonUtils.TS_ENCODING), 1, true);
                ++j;
                i += step;
            }
            return toStringNode.execute(sb);
        }

        @Specialization(replaces={"doGenericCachedStep"}, guards={"!isSimpleSlice(slice)", "!isEmptySlice(slice)"})
        static TruffleString doGeneric(TruffleString value, PSlice.SliceInfo slice, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="loop") @Cached InlinedLoopConditionProfile loopProfile, @Cached.Shared(value="len") @Cached RangeNodes.LenOfRangeNode sliceLen, @Cached.Shared(value="appendCP") @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached.Shared(value="toStr") @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            return StrGetItemNodeWithSlice.doGenericCachedStep(value, slice, inliningTarget, slice.step, loopProfile, sliceLen, appendCodePointNode, toStringNode, codePointAtIndexNode);
        }
    }

    @Builtin(name="rjust", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class RJustNode
    extends CenterNode {
        RJustNode() {
        }

        @Override
        protected int getLeftPaddingWidth(int len, int width) {
            return width - len;
        }
    }

    @Builtin(name="ljust", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class LJustNode
    extends CenterNode {
        LJustNode() {
        }

        @Override
        protected int getLeftPaddingWidth(int len, int width) {
            return 0;
        }
    }

    @Builtin(name="center", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @ImportStatic(value={PString.class})
    static abstract class CenterNode
    extends PythonBuiltinNode {
        CenterNode() {
        }

        @Specialization
        TruffleString doIt(VirtualFrame frame, Object selfObj, Object width, Object fill, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached StringNodes.CastToTruffleStringCheckedNode castFillNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached InlinedConditionProfile errorProfile, @Cached PRaiseNode.Lazy raiseNode) {
            int fillChar;
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___ITER__, selfObj);
            if (PGuards.isNoValue(fill)) {
                fillChar = 32;
            } else {
                TruffleString fillStr = castFillNode.cast(inliningTarget, fill, ErrorMessages.FILL_CHAR_MUST_BE_UNICODE_CHAR_NOT_P, fill);
                if (errorProfile.profile(inliningTarget, codePointLengthNode.execute((AbstractTruffleString)fillStr, PythonUtils.TS_ENCODING) != 1)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.FILL_CHAR_MUST_BE_LENGTH_1);
                }
                fillChar = codePointAtIndexNode.execute((AbstractTruffleString)fillStr, 0, PythonUtils.TS_ENCODING);
            }
            return this.make(self, asSizeNode.executeExact((Frame)frame, inliningTarget, width), fillChar, codePointLengthNode, appendCodePointNode, appendStringNode, toStringNode);
        }

        private TruffleString make(TruffleString self, int width, int fillChar, TruffleString.CodePointLengthNode codePointLengthNode, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleStringBuilder.ToStringNode toStringNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            if (width <= len) {
                return self;
            }
            int left = this.getLeftPaddingWidth(len, width);
            int right = width - len - left;
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)PythonUtils.tsbCapacity(len + left + right));
            if (left > 0) {
                appendCodePointNode.execute(sb, fillChar, left, true);
            }
            appendStringNode.execute(sb, (AbstractTruffleString)self);
            if (right > 0) {
                appendCodePointNode.execute(sb, fillChar, right, true);
            }
            return toStringNode.execute(sb);
        }

        protected int getLeftPaddingWidth(int len, int width) {
            int pad = width - len;
            int half = pad / 2;
            if (pad % 2 > 0 && width % 2 > 0) {
                ++half;
            }
            return half;
        }
    }

    @Builtin(name="title", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class TitleNode
    extends PythonUnaryClinicBuiltinNode {
        TitleNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static TruffleString doString(TruffleString self, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)self.byteLength(PythonUtils.TS_ENCODING));
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            int start = 0;
            int end = 0;
            while (it.hasNext()) {
                int cp = nextNode.execute(it);
                if (!UCharacter.isLowerCase((int)cp) && !UCharacter.isUpperCase((int)cp)) {
                    if (start == end) {
                        appendCodePointNode.execute(sb, cp, 1, true);
                    } else {
                        TitleNode.appendSegment(self, appendStringNode, substringNode, toJavaStringNode, fromJavaStringNode, sb, start, end);
                    }
                    start = end + 1;
                }
                ++end;
            }
            if (start != end) {
                TitleNode.appendSegment(self, appendStringNode, substringNode, toJavaStringNode, fromJavaStringNode, sb, start, end - 1);
            }
            return toStringNode.execute(sb);
        }

        private static void appendSegment(TruffleString self, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleString.SubstringNode substringNode, TruffleString.ToJavaStringNode toJavaStringNode, TruffleString.FromJavaStringNode fromJavaStringNode, TruffleStringBuilder sb, int start, int end) {
            TruffleString segment = substringNode.execute((AbstractTruffleString)self, start, end - start + 1, PythonUtils.TS_ENCODING, true);
            String titleSegment = UCharacter.toTitleCase((Locale)Locale.ROOT, (String)toJavaStringNode.execute((AbstractTruffleString)segment), null);
            appendStringNode.execute(sb, (AbstractTruffleString)fromJavaStringNode.execute(titleSegment, PythonUtils.TS_ENCODING));
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.TitleNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="zfill", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ZFillNode
    extends PythonBinaryBuiltinNode {
        ZFillNode() {
        }

        @Specialization
        static TruffleString doGeneric(VirtualFrame frame, Object selfObj, Object widthObj, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "zfill", selfObj);
            int width = asSizeNode.executeExact((Frame)frame, inliningTarget, widthObj);
            int len = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            if (len >= width) {
                return self;
            }
            int nzeros = width - len;
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)PythonUtils.tsbCapacity(nzeros + len));
            if (len > 0) {
                int start = codePointAtIndexNode.execute((AbstractTruffleString)self, 0, PythonUtils.TS_ENCODING);
                if (start == 43 || start == 45) {
                    appendCodePointNode.execute(sb, start, 1, true);
                    if (nzeros > 0) {
                        appendCodePointNode.execute(sb, 48, nzeros, true);
                    }
                    TruffleString digits = substringNode.execute((AbstractTruffleString)self, 1, len - 1, PythonUtils.TS_ENCODING, true);
                    appendStringNode.execute(sb, (AbstractTruffleString)digits);
                } else {
                    if (nzeros > 0) {
                        appendCodePointNode.execute(sb, 48, nzeros, true);
                    }
                    appendStringNode.execute(sb, (AbstractTruffleString)self);
                }
            } else if (nzeros > 0) {
                appendCodePointNode.execute(sb, 48, nzeros, true);
            }
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="isupper", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsUpperNode
    extends PythonUnaryBuiltinNode {
        IsUpperNode() {
        }

        @Specialization
        static boolean doString(TruffleString self, @Cached.Shared(value="createCpIterator") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="next") @Cached TruffleStringIterator.NextNode nextNode) {
            boolean hasUpper = false;
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int codePoint = nextNode.execute(it);
                if (IsUpperNode.isLower(codePoint)) {
                    return false;
                }
                if (hasUpper || !IsUpperNode.isUpper(codePoint)) continue;
                hasUpper = true;
            }
            return hasUpper;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isLower(int codePoint) {
            return UCharacter.isULowercase((int)codePoint) || UCharacter.isTitleCase((int)codePoint);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isUpper(int codePoint) {
            return UCharacter.isUUppercase((int)codePoint);
        }

        @Specialization(replaces={"doString"})
        static boolean doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached.Shared(value="createCpIterator") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="next") @Cached TruffleStringIterator.NextNode nextNode) {
            return IsUpperNode.doString(castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "isupper", self), createCodePointIteratorNode, nextNode);
        }
    }

    @Builtin(name="istitle", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsTitleNode
    extends PythonUnaryBuiltinNode {
        IsTitleNode() {
        }

        @Specialization
        static boolean doString(TruffleString self, @Cached.Shared(value="createCpIterator") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="next") @Cached TruffleStringIterator.NextNode nextNode) {
            boolean cased = false;
            boolean previousIsCased = false;
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int codePoint = nextNode.execute(it);
                if (IsTitleNode.isUpper(codePoint)) {
                    if (previousIsCased) {
                        return false;
                    }
                    previousIsCased = true;
                    cased = true;
                    continue;
                }
                if (IsTitleNode.isLower(codePoint)) {
                    if (!previousIsCased) {
                        return false;
                    }
                    previousIsCased = true;
                    cased = true;
                    continue;
                }
                previousIsCased = false;
            }
            return cased;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isUpper(int codePoint) {
            return UCharacter.isUUppercase((int)codePoint) || UCharacter.isTitleCase((int)codePoint);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isLower(int codePoint) {
            return UCharacter.isULowercase((int)codePoint);
        }

        @Specialization(replaces={"doString"})
        static boolean doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached.Shared(value="createCpIterator") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="next") @Cached TruffleStringIterator.NextNode nextNode) {
            return IsTitleNode.doString(castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "istitle", self), createCodePointIteratorNode, nextNode);
        }
    }

    @Builtin(name="isspace", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsSpaceNode
    extends IsCategoryBaseNode {
        IsSpaceNode() {
        }

        @Override
        protected boolean isCategory(int codePoint) {
            return StringUtils.isSpace(codePoint);
        }

        @Override
        protected String getName() {
            return "isspace";
        }
    }

    @Builtin(name="isprintable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsPrintableNode
    extends IsCategoryBaseNode {
        IsPrintableNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected boolean isCategory(int codePoint) {
            return StringUtils.isPrintable(codePoint);
        }

        @Override
        protected boolean resultForEmpty() {
            return true;
        }

        @Override
        protected String getName() {
            return "isprintable";
        }
    }

    @Builtin(name="islower", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsLowerNode
    extends PythonUnaryBuiltinNode {
        IsLowerNode() {
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isUpper(int codePoint) {
            return UCharacter.isUUppercase((int)codePoint) || UCharacter.isTitleCase((int)codePoint);
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean isLower(int codePoint) {
            return UCharacter.isULowercase((int)codePoint);
        }

        @Specialization
        static boolean doIt(Object selfObj, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode) {
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "islower", selfObj);
            boolean hasLower = false;
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int codePoint = nextNode.execute(it);
                if (IsLowerNode.isUpper(codePoint)) {
                    return false;
                }
                if (hasLower || !IsLowerNode.isLower(codePoint)) continue;
                hasLower = true;
            }
            return hasLower;
        }
    }

    @Builtin(name="isidentifier", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsIdentifierNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        boolean doGeneric(Object selfObj, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached StringUtils.IsIdentifierNode isIdentifierNode) {
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "isidentifier", selfObj);
            return isIdentifierNode.execute(inliningTarget, self);
        }
    }

    @Builtin(name="isnumeric", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsNumericNode
    extends IsCategoryBaseNode {
        IsNumericNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected boolean isCategory(int codePoint) {
            int numericType = UCharacter.getIntPropertyValue((int)codePoint, (int)4105);
            return numericType == 1 || numericType == 2 || numericType == 3;
        }

        @Override
        protected String getName() {
            return "isnumeric";
        }
    }

    @Builtin(name="isdigit", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsDigitNode
    extends IsCategoryBaseNode {
        IsDigitNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected boolean isCategory(int codePoint) {
            int numericType = UCharacter.getIntPropertyValue((int)codePoint, (int)4105);
            return numericType == 1 || numericType == 2;
        }

        @Override
        protected String getName() {
            return "isdigit";
        }
    }

    @Builtin(name="isdecimal", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsDecimalNode
    extends IsCategoryBaseNode {
        IsDecimalNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected boolean isCategory(int codePoint) {
            return UCharacter.isDigit((int)codePoint);
        }

        @Override
        protected String getName() {
            return "isdecimal";
        }
    }

    @Builtin(name="isalpha", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAlphaNode
    extends IsCategoryBaseNode {
        IsAlphaNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected boolean isCategory(int codePoint) {
            return UCharacter.isLetter((int)codePoint);
        }

        @Override
        protected String getName() {
            return "isalpha";
        }
    }

    @Builtin(name="isalnum", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAlnumNode
    extends IsCategoryBaseNode {
        IsAlnumNode() {
        }

        @Override
        protected boolean isCategory(int codePoint) {
            return StringUtils.isAlnum(codePoint);
        }

        @Override
        protected String getName() {
            return "isalnum";
        }
    }

    static abstract class IsCategoryBaseNode
    extends PythonUnaryBuiltinNode {
        IsCategoryBaseNode() {
        }

        @Specialization
        boolean doGeneric(Object selfObj, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached InlinedConditionProfile isEmptyProfile, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode) {
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, this.getName(), selfObj);
            if (isEmptyProfile.profile(inliningTarget, self.isEmpty())) {
                return this.resultForEmpty();
            }
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int codePoint = nextNode.execute(it);
                if (this.isCategory(codePoint)) continue;
                return false;
            }
            return true;
        }

        protected boolean isCategory(int codePoint) {
            CompilerAsserts.neverPartOfCompilation();
            throw new IllegalStateException("should not be reached");
        }

        protected boolean resultForEmpty() {
            return false;
        }

        protected String getName() {
            CompilerAsserts.neverPartOfCompilation();
            throw new IllegalStateException("should not be reached");
        }
    }

    @Builtin(name="isascii", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsAsciiNode
    extends PythonUnaryBuiltinNode {
        IsAsciiNode() {
        }

        @Specialization
        boolean doString(TruffleString self, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            return getCodeRangeNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII;
        }

        @Specialization(replaces={"doString"})
        boolean doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            return this.doString(castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "isascii", self), getCodeRangeNode);
        }
    }

    @Builtin(name="__rmod__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RModNode
    extends PythonBinaryBuiltinNode {
        RModNode() {
        }

        @Specialization
        Object mod(Object self, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__mod__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ModNode
    extends PythonBinaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doGeneric(VirtualFrame frame, Object self, Object right, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached StringNodes.CastToJavaStringCheckedNode castSelfNode, @Cached TupleBuiltins.GetItemNode getTupleItemNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___MOD__, self);
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                TruffleString truffleString = fromJavaStringNode.execute((String)new StringFormatProcessor((Python3Core)context, getTupleItemNode, selfStr, inliningTarget).format(TruffleStringMigrationHelpers.assertNoJavaString(right)), PythonUtils.TS_ENCODING);
                return truffleString;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        MulNode() {
        }

        @Specialization(guards={"right <= 0"})
        static TruffleString doStringIntNonPositive(Object left, int right) {
            return StringLiterals.T_EMPTY_STRING;
        }

        @Specialization(guards={"right > 0"})
        static TruffleString doStringIntPositive(TruffleString left, int right, @Cached.Shared(value="repeat") @Cached TruffleString.RepeatNode repeatNode) {
            return repeatNode.execute((AbstractTruffleString)left, right, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doGeneric(VirtualFrame frame, Object self, Object rightObj, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedConditionProfile isNegativeProfile, @Cached.Shared(value="repeat") @Cached TruffleString.RepeatNode repeatNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "index", self);
            int right = asSizeNode.executeExact((Frame)frame, inliningTarget, rightObj);
            if (isNegativeProfile.profile(inliningTarget, right <= 0)) {
                return StringLiterals.T_EMPTY_STRING;
            }
            return MulNode.doStringIntPositive(selfStr, right, repeatNode);
        }
    }

    @Builtin(name="encode", minNumOfPositionalArgs=1, parameterNames={"self", "encoding", "errors"}, doc="Decode the bytes using the codec registered for encoding.\n\n    encoding\n      The encoding with which to decode the bytes.\n    errors\n      The error handling scheme to use for the handling of decoding errors.\n      The default is 'strict' meaning that decoding errors raise a\n      UnicodeDecodeError. Other possible values are 'ignore' and 'replace'\n      as well as any other name registered with codecs.register_error that\n      can handle UnicodeDecodeErrors.")
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_UTF8", useDefaultForNone=true), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class EncodeNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.EncodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object selfObj, TruffleString encoding, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached CodecsModuleBuiltins.EncodeNode encodeNode, @Cached SequenceStorageNodes.CopyNode copyNode, @Cached PythonObjectFactory.Lazy factory, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "index", selfObj);
            Object result = encodeNode.execute(frame, self, encoding, errors);
            if (!(result instanceof PBytes)) {
                if (result instanceof PByteArray) {
                    return factory.get(inliningTarget).createBytes(copyNode.execute(inliningTarget, ((PByteArray)result).getSequenceStorage()));
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_ENCODER_RETURNED_P_INSTEAD_OF_BYTES, encoding, result);
            }
            return result;
        }
    }

    @Builtin(name="rindex", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class RIndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.RIndexNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int rindex(Object selfObj, Object subObj, int start, int end, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.LastIndexOfStringNode lastIndexOfStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString self = castNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "rindex", selfObj);
            TruffleString sub = castNode.cast(inliningTarget, subObj, ErrorMessages.MUST_BE_STR_NOT_P, subObj);
            int idx = StringBuiltins.lastIndexOf(self, sub, start, end, codePointLengthNode, lastIndexOfStringNode);
            if (idx < 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SUBSTRING_NOT_FOUND);
            }
            return idx;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class IndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.IndexNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int index(Object selfObj, Object subObj, int start, int end, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString self = castNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "index", selfObj);
            TruffleString sub = castNode.cast(inliningTarget, subObj, ErrorMessages.MUST_BE_STR_NOT_P, subObj);
            int idx = StringBuiltins.indexOf(self, sub, start, end, codePointLengthNode, indexOfStringNode);
            if (idx < 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SUBSTRING_NOT_FOUND);
            }
            return idx;
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static int len(Object self, @Cached StringNodes.StringLenNode stringLenNode) {
            return stringLenNode.execute(self);
        }
    }

    @Builtin(name="lstrip", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LStripNode
    extends PythonBuiltinNode {
        @Specialization
        static TruffleString doStringString(TruffleString self, TruffleString chars, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            return StringUtils.strip(self, chars, StringUtils.StripKind.LEFT, codePointLengthNode, codePointAtIndexNode, indexOfCodePointNode, substringNode);
        }

        @Specialization
        static TruffleString doStringNone(TruffleString self, PNone chars, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            return StringUtils.strip(self, StringUtils.StripKind.LEFT, codePointLengthNode, codePointAtIndexNode, substringNode);
        }

        @Specialization(replaces={"doStringString", "doStringNone"})
        static TruffleString doGeneric(Object self, Object chars, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached StringNodes.CastToTruffleStringCheckedNode castCharsNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "lstrip", self);
            if (PGuards.isPNone(chars)) {
                return LStripNode.doStringNone(selfStr, PNone.NO_VALUE, codePointLengthNode, codePointAtIndexNode, substringNode);
            }
            TruffleString charsStr = castCharsNode.cast(inliningTarget, chars, ErrorMessages.S_ARG_1_MUST_BE_STR_NOT_P, "lstrip", chars);
            return LStripNode.doStringString(selfStr, charsStr, codePointLengthNode, codePointAtIndexNode, indexOfCodePointNode, substringNode);
        }
    }

    @Builtin(name="rstrip", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RStripNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static TruffleString doStringString(TruffleString self, TruffleString chars, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            return StringUtils.strip(self, chars, StringUtils.StripKind.RIGHT, codePointLengthNode, codePointAtIndexNode, indexOfCodePointNode, substringNode);
        }

        @Specialization
        static TruffleString doStringNone(TruffleString self, PNone chars, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            return StringUtils.strip(self, StringUtils.StripKind.RIGHT, codePointLengthNode, codePointAtIndexNode, substringNode);
        }

        @Specialization(replaces={"doStringString", "doStringNone"})
        static TruffleString doGeneric(Object self, Object chars, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached StringNodes.CastToTruffleStringCheckedNode castCharsNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "rstrip", self);
            if (PGuards.isPNone(chars)) {
                return RStripNode.doStringNone(selfStr, PNone.NO_VALUE, codePointLengthNode, codePointAtIndexNode, substringNode);
            }
            TruffleString charsStr = castCharsNode.cast(inliningTarget, chars, ErrorMessages.S_ARG_1_MUST_BE_STR_NOT_P, "rstrip", chars);
            return RStripNode.doStringString(selfStr, charsStr, codePointLengthNode, codePointAtIndexNode, indexOfCodePointNode, substringNode);
        }
    }

    @Builtin(name="strip", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class StripNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static TruffleString doStringString(TruffleString self, TruffleString chars, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            return StringUtils.strip(self, chars, StringUtils.StripKind.BOTH, codePointLengthNode, codePointAtIndexNode, indexOfCodePointNode, substringNode);
        }

        @Specialization
        static TruffleString doStringNone(TruffleString self, PNone chars, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            return StringUtils.strip(self, StringUtils.StripKind.BOTH, codePointLengthNode, codePointAtIndexNode, substringNode);
        }

        @Specialization(replaces={"doStringString", "doStringNone"})
        static TruffleString doGeneric(Object self, Object chars, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached StringNodes.CastToTruffleStringCheckedNode castCharsNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "strip", self);
            if (PGuards.isPNone(chars)) {
                return StripNode.doStringNone(selfStr, PNone.NO_VALUE, codePointLengthNode, codePointAtIndexNode, substringNode);
            }
            TruffleString charsStr = castCharsNode.cast(inliningTarget, chars, ErrorMessages.S_ARG_1_MUST_BE_STR_NOT_P, "strip", chars);
            return StripNode.doStringString(selfStr, charsStr, codePointLengthNode, codePointAtIndexNode, indexOfCodePointNode, substringNode);
        }
    }

    @Builtin(name="replace", minNumOfPositionalArgs=3, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    public static abstract class ReplaceNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization
        static TruffleString doReplace(TruffleString self, TruffleString old, TruffleString with, PNone maxCount, @Cached.Shared(value="replace") @Cached StringNodes.StringReplaceNode replaceNode) {
            return replaceNode.execute(self, old, with, -1);
        }

        @Specialization
        static TruffleString doReplace(TruffleString self, TruffleString old, TruffleString with, int maxCountArg, @Cached.Shared(value="replace") @Cached StringNodes.StringReplaceNode replaceNode) {
            return replaceNode.execute(self, old, with, maxCountArg);
        }

        @Specialization
        static TruffleString doGeneric(VirtualFrame frame, Object self, Object old, Object with, Object maxCount, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="replace") @Cached StringNodes.StringReplaceNode replaceNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "replace", self);
            TruffleString oldStr = castSelfNode.cast(inliningTarget, old, ErrorMessages.S_BRACKETS_ARG_S_MUST_BE_S_NOT_P, "replace", "1", "str", old);
            TruffleString withStr = castSelfNode.cast(inliningTarget, with, ErrorMessages.S_BRACKETS_ARG_S_MUST_BE_S_NOT_P, "replace", "2", "str", with);
            int iMaxCount = PGuards.isPNone(maxCount) ? -1 : asSizeNode.executeExact((Frame)frame, inliningTarget, maxCount);
            return replaceNode.execute(selfStr, oldStr, withStr, iMaxCount);
        }
    }

    @Builtin(name="splitlines", minNumOfPositionalArgs=1, parameterNames={"self", "keepends"})
    @GenerateNodeFactory
    public static abstract class SplitLinesNode
    extends PythonBinaryBuiltinNode {
        private static final Pattern LINEBREAK_PATTERN = Pattern.compile("\\R");

        @Specialization
        static PList doString(TruffleString self, PNone keepends, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared @Cached ListNodes.AppendNode appendNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return SplitLinesNode.doStringKeepends(self, false, toJavaStringNode, fromJavaStringNode, appendNode, factory);
        }

        @Specialization
        static PList doStringKeepends(TruffleString selfTs, boolean keepends, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared @Cached ListNodes.AppendNode appendNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            PList list = factory.createList();
            int lastEnd = 0;
            String self = toJavaStringNode.execute((AbstractTruffleString)selfTs);
            Matcher matcher = SplitLinesNode.getMatcher(self);
            while (SplitLinesNode.matcherFind(matcher)) {
                int end = SplitLinesNode.matcherEnd(matcher);
                String line = keepends ? SplitLinesNode.substring(self, lastEnd, end) : SplitLinesNode.substring(self, lastEnd, SplitLinesNode.matcherStart(matcher));
                appendNode.execute(list, fromJavaStringNode.execute(line, PythonUtils.TS_ENCODING));
                lastEnd = end;
            }
            String remainder = SplitLinesNode.substring(self, lastEnd);
            if (!remainder.isEmpty()) {
                appendNode.execute(list, fromJavaStringNode.execute(remainder, PythonUtils.TS_ENCODING));
            }
            return list;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String substring(String str, int start, int end) {
            return str.substring(start, end);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String substring(String str, int start) {
            return str.substring(start);
        }

        @CompilerDirectives.TruffleBoundary
        private static int matcherStart(Matcher matcher) {
            return matcher.start();
        }

        @CompilerDirectives.TruffleBoundary
        private static int matcherEnd(Matcher matcher) {
            return matcher.end();
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean matcherFind(Matcher matcher) {
            return matcher.find();
        }

        @CompilerDirectives.TruffleBoundary
        private static Matcher getMatcher(String self) {
            return LINEBREAK_PATTERN.matcher(self);
        }

        @Specialization(replaces={"doString", "doStringKeepends"})
        static PList doGeneric(Object self, Object keepends, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached CastToJavaIntExactNode castToJavaIntNode, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared @Cached ListNodes.AppendNode appendNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "splitlines", self);
            boolean bKeepends = !PGuards.isPNone(keepends) && castToJavaIntNode.execute(inliningTarget, keepends) != 0;
            return SplitLinesNode.doStringKeepends(selfStr, bKeepends, toJavaStringNode, fromJavaStringNode, appendNode, factory);
        }
    }

    @Builtin(name="rsplit", minNumOfPositionalArgs=1, parameterNames={"$self", "sep", "maxsplit"}, needsFrame=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="sep", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="maxsplit", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="-1")})
    @GenerateNodeFactory
    public static abstract class RSplitNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.RSplitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PList doStringSepMaxsplit(VirtualFrame frame, TruffleString self, TruffleString sep, int maxsplitInput, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode, @Cached.Shared(value="reverseNode") @Cached ListBuiltins.ListReverseNode reverseNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.LastIndexOfStringNode lastIndexOfStringNode, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            int idx;
            if (sep.isEmpty()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMPTY_SEPARATOR);
            }
            int maxsplit = maxsplitInput;
            if (maxsplitInput < 0) {
                maxsplit = Integer.MAX_VALUE;
            }
            PList list = factory.createList();
            int end = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            int sepLength = codePointLengthNode.execute((AbstractTruffleString)sep, PythonUtils.TS_ENCODING);
            for (int splits = 0; splits < maxsplit && end > 0 && (idx = lastIndexOfStringNode.execute((AbstractTruffleString)self, (AbstractTruffleString)sep, end, 0, PythonUtils.TS_ENCODING)) >= 0; ++splits) {
                appendNode.execute(list, substringNode.execute((AbstractTruffleString)self, idx + sepLength, end - (idx + sepLength), PythonUtils.TS_ENCODING, false));
                end = idx;
            }
            appendNode.execute(list, substringNode.execute((AbstractTruffleString)self, 0, end, PythonUtils.TS_ENCODING, true));
            reverseNode.execute(frame, list);
            return list;
        }

        @Specialization
        static PList doStringMaxsplit(VirtualFrame frame, TruffleString s, PNone sep, int maxsplit, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode, @Cached.Shared(value="reverseNode") @Cached ListBuiltins.ListReverseNode reverseNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            PList list = factory.createList();
            int length = codePointLengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING);
            int maxsplit2 = maxsplit;
            if (maxsplit2 < 0) {
                maxsplit2 = length;
            }
            boolean hasSegment = false;
            int start = 0;
            int end = length;
            int splits = 0;
            for (int i = length - 1; i >= 0; --i) {
                if (StringUtils.isSpace(codePointAtIndexNode.execute((AbstractTruffleString)s, i, PythonUtils.TS_ENCODING))) {
                    if (hasSegment) {
                        appendNode.execute(list, substringNode.execute((AbstractTruffleString)s, start, end - start, PythonUtils.TS_ENCODING, false));
                        hasSegment = false;
                        ++splits;
                    }
                    end = i;
                    continue;
                }
                hasSegment = true;
                if (splits >= maxsplit2) break;
                start = i;
            }
            if (hasSegment) {
                appendNode.execute(list, substringNode.execute((AbstractTruffleString)s, 0, end, PythonUtils.TS_ENCODING, false));
            }
            reverseNode.execute(frame, list);
            return list;
        }
    }

    @Builtin(name="split", minNumOfPositionalArgs=1, parameterNames={"$self", "sep", "maxsplit"}, needsFrame=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="$self", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="sep", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="maxsplit", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="-1")})
    @GenerateNodeFactory
    public static abstract class SplitNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.SplitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PList doStringNoSep(TruffleString self, PNone sep, int maxsplit, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return SplitNode.splitfields(self, maxsplit, appendNode, codePointLengthNode, codePointAtIndexNode, substringNode, factory);
        }

        @Specialization
        static PList doStringSep(TruffleString self, TruffleString sep, int maxsplit, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached.Shared(value="substring") @Cached TruffleString.SubstringNode substringNode, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            int nextIndex;
            if (sep.isEmpty()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMPTY_SEPARATOR);
            }
            PList list = factory.createList();
            int lastEnd = 0;
            int selfLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            int sepLen = codePointLengthNode.execute((AbstractTruffleString)sep, PythonUtils.TS_ENCODING);
            for (int splits = maxsplit == -1 ? Integer.MAX_VALUE : maxsplit; splits > 0 && lastEnd < selfLen && (nextIndex = indexOfStringNode.execute((AbstractTruffleString)self, (AbstractTruffleString)sep, lastEnd, selfLen, PythonUtils.TS_ENCODING)) >= 0; --splits) {
                appendNode.execute(list, substringNode.execute((AbstractTruffleString)self, lastEnd, nextIndex - lastEnd, PythonUtils.TS_ENCODING, false));
                lastEnd = nextIndex + sepLen;
            }
            appendNode.execute(list, substringNode.execute((AbstractTruffleString)self, lastEnd, selfLen - lastEnd, PythonUtils.TS_ENCODING, false));
            return list;
        }

        private static PList splitfields(TruffleString s, int maxsplit, ListNodes.AppendNode appendNode, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode, TruffleString.SubstringNode substringNode, PythonObjectFactory factory) {
            PList list = factory.createList();
            int length = codePointLengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING);
            int start = 0;
            int splits = 0;
            int maxsplit2 = maxsplit;
            if (maxsplit2 < 0) {
                maxsplit2 = length;
            }
            while (start < length) {
                int index;
                while (start < length && StringUtils.isSpace(codePointAtIndexNode.execute((AbstractTruffleString)s, start, PythonUtils.TS_ENCODING))) {
                    ++start;
                }
                if (start >= length) break;
                if (splits >= maxsplit2) {
                    index = length;
                } else {
                    for (index = start; index < length && !StringUtils.isSpace(codePointAtIndexNode.execute((AbstractTruffleString)s, index, PythonUtils.TS_ENCODING)); ++index) {
                    }
                }
                appendNode.execute(list, substringNode.execute((AbstractTruffleString)s, start, index - start, PythonUtils.TS_ENCODING, false));
                ++splits;
                start = index;
            }
            return list;
        }
    }

    @Builtin(name="rpartition", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RPartitionNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doGeneric(Object self, Object sep, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached StringNodes.CastToTruffleStringCheckedNode castSepNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.LastIndexOfStringNode lastIndexOfStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "rpartition", self);
            TruffleString sepStr = castSepNode.cast(inliningTarget, sep, ErrorMessages.MUST_BE_STR_NOT_P, sep);
            if (sepStr.isEmpty()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMPTY_SEPARATOR);
            }
            int selfLen = codePointLengthNode.execute((AbstractTruffleString)selfStr, PythonUtils.TS_ENCODING);
            int lastIndexOf = lastIndexOfStringNode.execute((AbstractTruffleString)selfStr, (AbstractTruffleString)sepStr, selfLen, 0, PythonUtils.TS_ENCODING);
            Object[] partitioned = new TruffleString[3];
            if (lastIndexOf < 0) {
                partitioned[0] = StringLiterals.T_EMPTY_STRING;
                partitioned[1] = StringLiterals.T_EMPTY_STRING;
                partitioned[2] = selfStr;
            } else {
                int o = lastIndexOf + codePointLengthNode.execute((AbstractTruffleString)sepStr, PythonUtils.TS_ENCODING);
                partitioned[0] = substringNode.execute((AbstractTruffleString)selfStr, 0, lastIndexOf, PythonUtils.TS_ENCODING, false);
                partitioned[1] = sepStr;
                partitioned[2] = substringNode.execute((AbstractTruffleString)selfStr, o, selfLen - o, PythonUtils.TS_ENCODING, false);
            }
            return factory.createTuple(partitioned);
        }
    }

    @Builtin(name="partition", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class PartitionNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static PTuple doGeneric(Object self, Object sep, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached StringNodes.CastToTruffleStringCheckedNode castSepNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "partition", self);
            TruffleString sepStr = castSepNode.cast(inliningTarget, sep, ErrorMessages.MUST_BE_STR_NOT_P, sep);
            if (sepStr.isEmpty()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMPTY_SEPARATOR);
            }
            int selfLen = codePointLengthNode.execute((AbstractTruffleString)selfStr, PythonUtils.TS_ENCODING);
            int indexOf = indexOfStringNode.execute((AbstractTruffleString)selfStr, (AbstractTruffleString)sepStr, 0, selfLen, PythonUtils.TS_ENCODING);
            Object[] partitioned = new TruffleString[3];
            if (indexOf < 0) {
                partitioned[0] = selfStr;
                partitioned[1] = StringLiterals.T_EMPTY_STRING;
                partitioned[2] = StringLiterals.T_EMPTY_STRING;
            } else {
                int o = indexOf + codePointLengthNode.execute((AbstractTruffleString)sepStr, PythonUtils.TS_ENCODING);
                partitioned[0] = substringNode.execute((AbstractTruffleString)selfStr, 0, indexOf, PythonUtils.TS_ENCODING, false);
                partitioned[1] = sepStr;
                partitioned[2] = substringNode.execute((AbstractTruffleString)selfStr, o, selfLen - o, PythonUtils.TS_ENCODING, false);
            }
            return factory.createTuple(partitioned);
        }
    }

    @Builtin(name="capitalize", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CapitalizeNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal
        private static CaseMap.Title titlecaser;

        @Specialization
        static TruffleString capitalize(TruffleString self, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            if (self.isEmpty()) {
                return StringLiterals.T_EMPTY_STRING;
            }
            return fromJavaStringNode.execute(CapitalizeNode.capitalizeImpl(toJavaStringNode.execute((AbstractTruffleString)self)), PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToJavaStringCheckedNode castToJavaStringNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String s = castToJavaStringNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "capitalize", self);
            if (s.isEmpty()) {
                return StringLiterals.T_EMPTY_STRING;
            }
            return fromJavaStringNode.execute(CapitalizeNode.capitalizeImpl(s), PythonUtils.TS_ENCODING);
        }

        private static String capitalizeImpl(String str) {
            if (titlecaser == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                titlecaser = CaseMap.toTitle().wholeString().noBreakAdjustment();
            }
            return CapitalizeNode.apply(str);
        }

        @CompilerDirectives.TruffleBoundary
        private static String apply(String str) {
            return titlecaser.apply(Locale.ROOT, null, (CharSequence)str);
        }
    }

    @Builtin(name="translate", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class TranslateNode
    extends PythonBuiltinNode {
        @Specialization
        static TruffleString doStringString(TruffleString self, TruffleString table, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Shared(value="createCpIterator") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="next") @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared(value="appendCp") @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached.Shared(value="toString") @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            int tableLen = codePointLengthNode.execute((AbstractTruffleString)table, PythonUtils.TS_ENCODING);
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)self.byteLength(PythonUtils.TS_ENCODING));
            while (it.hasNext()) {
                int cp = nextNode.execute(it);
                if (cp >= 0 && cp < tableLen) {
                    cp = codePointAtIndexNode.execute((AbstractTruffleString)table, cp, PythonUtils.TS_ENCODING);
                }
                appendCodePointNode.execute(sb, cp, 1, true);
            }
            return toStringNode.execute(sb);
        }

        @Specialization
        static TruffleString doGeneric(VirtualFrame frame, Object self, Object table, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached PyObjectGetItem getItemNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached StringNodes.SpliceNode spliceNode, @Cached.Shared(value="createCpIterator") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="next") @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared(value="appendCp") @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached.Shared(value="toString") @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "translate", self);
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)selfStr.byteLength(PythonUtils.TS_ENCODING));
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)selfStr, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                Object translated;
                int original;
                block4: {
                    original = nextNode.execute(it);
                    translated = null;
                    try {
                        translated = getItemNode.execute((Frame)frame, inliningTarget, table, original);
                    }
                    catch (PException e) {
                        if (isSubtypeNode.execute(null, getClassNode.execute(inliningTarget, e.getUnreifiedException()), (Object)PythonBuiltinClassType.LookupError)) break block4;
                        throw e;
                    }
                }
                if (translated != null) {
                    spliceNode.execute(sb, translated);
                    continue;
                }
                appendCodePointNode.execute(sb, original, 1, true);
            }
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="maketrans", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4, isStaticmethod=true)
    @GenerateNodeFactory
    public static abstract class MakeTransNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization(guards={"!isNoValue(to)"})
        static PDict doString(VirtualFrame frame, Object cls, Object from, Object to, Object z, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castFromNode, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castToNode, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castZNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached InlinedConditionProfile hasZProfile, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int fromLen;
            int toLen;
            TruffleString toStr = castToNode.cast(inliningTarget, to, ErrorMessages.ARG_S_MUST_BE_S_NOT_P, "2", "str", to);
            TruffleString fromStr = castFromNode.cast(inliningTarget, from, ErrorMessages.FIRST_MAKETRANS_ARGS_MUST_BE_A_STR, new Object[0]);
            boolean hasZ = hasZProfile.profile(inliningTarget, z != PNone.NO_VALUE);
            TruffleString zString = null;
            if (hasZ) {
                zString = castZNode.cast(inliningTarget, z, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "maketrans()", 3, "str", z);
            }
            if ((toLen = codePointLengthNode.execute((AbstractTruffleString)toStr, PythonUtils.TS_ENCODING)) != (fromLen = codePointLengthNode.execute((AbstractTruffleString)fromStr, PythonUtils.TS_ENCODING))) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.FIRST_TWO_MAKETRANS_ARGS_MUST_HAVE_EQ_LENGTH);
            }
            HashingStorage storage = PDict.createNewStorage(fromLen);
            TruffleStringIterator fromIt = createCodePointIteratorNode.execute((AbstractTruffleString)fromStr, PythonUtils.TS_ENCODING);
            TruffleStringIterator toIt = createCodePointIteratorNode.execute((AbstractTruffleString)toStr, PythonUtils.TS_ENCODING);
            while (fromIt.hasNext()) {
                assert (toIt.hasNext());
                int key = nextNode.execute(fromIt);
                int value = nextNode.execute(toIt);
                storage = setHashingStorageItem.execute((Frame)frame, inliningTarget, storage, key, value);
            }
            assert (!toIt.hasNext());
            if (hasZ) {
                TruffleStringIterator zIt = createCodePointIteratorNode.execute((AbstractTruffleString)zString, PythonUtils.TS_ENCODING);
                while (zIt.hasNext()) {
                    int key = nextNode.execute(zIt);
                    storage = setHashingStorageItem.execute((Frame)frame, inliningTarget, storage, key, PNone.NONE);
                }
            }
            return factory.createDict(storage);
        }

        @Specialization(guards={"isNoValue(to)", "isNoValue(z)"})
        static PDict doDict(VirtualFrame frame, Object cls, PDict from, Object to, Object z, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode cast, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterHasNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iterKey, @Cached HashingStorageNodes.HashingStorageIteratorValue iterValue, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            HashingStorage srcStorage = getHashingStorageNode.execute(frame, inliningTarget, from);
            HashingStorage destStorage = PDict.createNewStorage(lenNode.execute(inliningTarget, srcStorage));
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, srcStorage);
            while (iterHasNext.execute(inliningTarget, srcStorage, it)) {
                Object currentKey = iterKey.execute(inliningTarget, srcStorage, it);
                Object currentValue = iterValue.execute(inliningTarget, srcStorage, it);
                if (PGuards.isInteger(currentKey) || PGuards.isPInt(currentKey)) {
                    destStorage = setHashingStorageItem.execute((Frame)frame, inliningTarget, destStorage, currentKey, currentValue);
                    continue;
                }
                TruffleString strKey = cast.cast(inliningTarget, currentKey, ErrorMessages.KEYS_IN_TRANSLATE_TABLE_MUST_BE_STRINGS_OR_INTEGERS, new Object[0]);
                if (codePointLengthNode.execute((AbstractTruffleString)strKey, PythonUtils.TS_ENCODING) != 1) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.STRING_KEYS_MUST_BE_LENGTH_1);
                }
                int codePoint = codePointAtIndexNode.execute((AbstractTruffleString)strKey, 0, PythonUtils.TS_ENCODING);
                destStorage = setHashingStorageItem.execute((Frame)frame, inliningTarget, destStorage, codePoint, currentValue);
            }
            return factory.createDict(destStorage);
        }

        @Specialization(guards={"!isDict(from)", "isNoValue(to)"})
        static PDict doFail(Object cls, Object from, Object to, Object z, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.IF_YOU_GIVE_ONLY_ONE_ARG_TO_DICT);
        }
    }

    @Builtin(name="upper", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class UpperNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isAscii(self, getCodeRangeNode)"})
        static TruffleString upperAscii(TruffleString self, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            TruffleString ascii = switchEncodingNode.execute((AbstractTruffleString)self, TruffleString.Encoding.US_ASCII);
            int i = UpperNode.findFirstLowerCase(ascii, getInternalByteArrayNode);
            if (i < 0) {
                return self;
            }
            byte[] buf = new byte[ascii.byteLength(TruffleString.Encoding.US_ASCII)];
            copyToByteArrayNode.execute((AbstractTruffleString)ascii, 0, buf, 0, buf.length, TruffleString.Encoding.US_ASCII);
            while (i < buf.length) {
                if (buf[i] >= 97 && buf[i] <= 122) {
                    buf[i] = (byte)(buf[i] - 97 + 65);
                }
                ++i;
            }
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(buf, TruffleString.Encoding.US_ASCII, false), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isAscii(self, getCodeRangeNode)"})
        static TruffleString upper(TruffleString self, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(StringUtils.toUpperCase(toJavaStringNode.execute((AbstractTruffleString)self)), PythonUtils.TS_ENCODING);
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castToStringNode, @Cached UpperNode upperNode) {
            return upperNode.execute(frame, castToStringNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "upper", self));
        }

        private static int findFirstLowerCase(TruffleString s, TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
            InternalByteArray iba = getInternalByteArrayNode.execute((AbstractTruffleString)s, TruffleString.Encoding.US_ASCII);
            byte[] bytes = iba.getArray();
            int end = iba.getEnd();
            for (int i = iba.getOffset(); i < end; ++i) {
                if (bytes[i] < 97 || bytes[i] > 122) continue;
                return i;
            }
            return -1;
        }
    }

    @Builtin(name="lower", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LowerNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isAscii(self, getCodeRangeNode)"})
        static TruffleString lowerAscii(TruffleString self, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode) {
            TruffleString ascii = switchEncodingNode.execute((AbstractTruffleString)self, TruffleString.Encoding.US_ASCII);
            int i = LowerNode.findFirstUpperCase(ascii, getInternalByteArrayNode);
            if (i < 0) {
                return self;
            }
            byte[] buf = new byte[ascii.byteLength(TruffleString.Encoding.US_ASCII)];
            copyToByteArrayNode.execute((AbstractTruffleString)ascii, 0, buf, 0, buf.length, TruffleString.Encoding.US_ASCII);
            while (i < buf.length) {
                if (buf[i] >= 65 && buf[i] <= 90) {
                    buf[i] = (byte)(buf[i] - 65 + 97);
                }
                ++i;
            }
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(buf, TruffleString.Encoding.US_ASCII, false), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isAscii(self, getCodeRangeNode)"})
        static TruffleString lower(TruffleString self, @Cached.Shared(value="getCodeRange") @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(StringUtils.toLowerCase(toJavaStringNode.execute((AbstractTruffleString)self)), PythonUtils.TS_ENCODING);
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castToStringNode, @Cached LowerNode lowerNode) {
            return lowerNode.execute(frame, castToStringNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "lower", self));
        }

        private static int findFirstUpperCase(TruffleString s, TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
            InternalByteArray iba = getInternalByteArrayNode.execute((AbstractTruffleString)s, TruffleString.Encoding.US_ASCII);
            byte[] bytes = iba.getArray();
            int end = iba.getEnd();
            for (int i = iba.getOffset(); i < end; ++i) {
                if (bytes[i] < 65 || bytes[i] > 90) continue;
                return i;
            }
            return -1;
        }
    }

    @Builtin(name="join", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class JoinNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static TruffleString join(VirtualFrame frame, Object self, Object iterable, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castToStringNode, @Cached StringNodes.JoinInternalNode join) {
            return join.execute(frame, castToStringNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "join", self), iterable);
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class CountNode
    extends PythonQuaternaryClinicBuiltinNode {
        public abstract int execute(Object var1, Object var2, int var3, int var4);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.FindNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int count(TruffleString self, TruffleString sub, int start, int end, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfStringNode indexOfStringNode) {
            int i;
            int cpLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            int cpStart = StringBuiltins.adjustStartIndex(start, cpLen);
            int cpEnd = StringBuiltins.adjustEndIndex(end, cpLen);
            if (self.isEmpty()) {
                return sub.isEmpty() && cpStart <= 0 ? 1 : 0;
            }
            if (sub.isEmpty()) {
                return cpStart <= cpLen ? cpEnd - cpStart + 1 : 0;
            }
            if (cpStart >= cpLen) {
                return 0;
            }
            int subLen = codePointLengthNode.execute((AbstractTruffleString)sub, PythonUtils.TS_ENCODING);
            int pos = cpStart;
            int cnt = 0;
            while (pos <= cpEnd - subLen && (i = indexOfStringNode.execute((AbstractTruffleString)self, (AbstractTruffleString)sub, pos, cpEnd, PythonUtils.TS_ENCODING)) >= 0) {
                ++cnt;
                pos = i + subLen;
            }
            return cnt;
        }

        @Specialization
        static int count(Object self, Object sub, int start, int end, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfStringNode indexOfStringNode) {
            TruffleString selfStr = castNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "count", self);
            TruffleString subStr = castNode.cast(inliningTarget, sub, ErrorMessages.MUST_BE_STR_NOT_P, sub);
            return CountNode.count(selfStr, subStr, start, end, codePointLengthNode, indexOfStringNode);
        }
    }

    @Builtin(name="find", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class FindNode
    extends PythonQuaternaryClinicBuiltinNode {
        public abstract int execute(Object var1, Object var2, int var3, int var4);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.FindNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int find(TruffleString self, TruffleString sub, int start, int end, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfStringNode indexOfStringNode) {
            return StringBuiltins.indexOf(self, sub, start, end, codePointLengthNode, indexOfStringNode);
        }

        @Specialization
        static int find(Object self, Object sub, int start, int end, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="indexOf") @Cached TruffleString.IndexOfStringNode indexOfStringNode) {
            TruffleString selfStr = castNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "find", self);
            TruffleString subStr = castNode.cast(inliningTarget, sub, ErrorMessages.MUST_BE_STR_NOT_P, sub);
            return FindNode.find(selfStr, subStr, start, end, codePointLengthNode, indexOfStringNode);
        }
    }

    @Builtin(name="rfind", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class RFindNode
    extends PythonQuaternaryClinicBuiltinNode {
        public abstract int execute(Object var1, Object var2, int var3, int var4);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.RFindNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static int rfind(TruffleString self, TruffleString sub, int start, int end, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="lastIndexOf") @Cached TruffleString.LastIndexOfStringNode lastIndexOfStringNode) {
            return StringBuiltins.lastIndexOf(self, sub, start, end, codePointLengthNode, lastIndexOfStringNode);
        }

        @Specialization
        static int rfind(Object self, Object sub, int start, int end, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="lastIndexOf") @Cached TruffleString.LastIndexOfStringNode lastIndexOfStringNode) {
            TruffleString selfStr = castNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, "rfind", self);
            TruffleString subStr = castNode.cast(inliningTarget, sub, ErrorMessages.MUST_BE_STR_NOT_P, sub);
            return RFindNode.rfind(selfStr, subStr, start, end, codePointLengthNode, lastIndexOfStringNode);
        }
    }

    @Builtin(name="endswith", minNumOfPositionalArgs=2, parameterNames={"self", "suffix", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class EndsWithNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.EndsWithNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean doEndsWith(Object self, Object prefix, int start, int end, @Cached PrefixSuffixNode prefixSuffixNode) {
            return prefixSuffixNode.endsWith(self, prefix, start, end);
        }
    }

    @Builtin(name="startswith", minNumOfPositionalArgs=2, parameterNames={"self", "prefix", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class StartsWithNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.StartsWithNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static boolean doStartsWith(Object self, Object prefix, int start, int end, @Cached PrefixSuffixNode prefixSuffixNode) {
            return prefixSuffixNode.startsWith(self, prefix, start, end);
        }
    }

    @GenerateInline(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class PrefixSuffixNode
    extends Node {
        abstract boolean execute(Object var1, Object var2, int var3, int var4, Op var5);

        public final boolean startsWith(Object self, Object subStr, int start, int end) {
            return this.execute(self, subStr, start, end, Op.PREFIX);
        }

        public final boolean endsWith(Object self, Object subStr, int start, int end) {
            return this.execute(self, subStr, start, end, Op.SUFFIX);
        }

        @Specialization(guards={"!isPTuple(subStrObj)"})
        static boolean doString(Object selfObj, Object subStrObj, int start, int end, Op op, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castPrefixNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.RegionEqualNode regionEqualNode) {
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, op.methodName(), selfObj);
            TruffleString subStr = castPrefixNode.cast(inliningTarget, subStrObj, ErrorMessages.FIRST_ARG_MUST_BE_S_OR_TUPLE_NOT_P, op.methodName(), "str", subStrObj);
            int selfLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            int subStrLen = codePointLengthNode.execute((AbstractTruffleString)subStr, PythonUtils.TS_ENCODING);
            return PrefixSuffixNode.doIt(self, subStr, StringBuiltins.adjustStartIndex(start, selfLen), StringBuiltins.adjustEndIndex(end, selfLen), selfLen, subStrLen, regionEqualNode, op);
        }

        @Specialization
        static boolean doTuple(Object selfObj, PTuple subStrs, int start, int end, Op op, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached.Exclusive @Cached StringNodes.CastToTruffleStringCheckedNode castPrefixNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.RegionEqualNode regionEqualNode) {
            TruffleString self = castSelfNode.cast(inliningTarget, selfObj, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, op.methodName(), selfObj);
            int selfLen = codePointLengthNode.execute((AbstractTruffleString)self, PythonUtils.TS_ENCODING);
            int cpStart = StringBuiltins.adjustStartIndex(start, selfLen);
            int cpEnd = StringBuiltins.adjustEndIndex(end, selfLen);
            for (Object element : getObjectArrayNode.execute(inliningTarget, subStrs)) {
                int subStrLen;
                TruffleString subStr = castPrefixNode.cast(inliningTarget, element, ErrorMessages.INVALID_ELEMENT_TYPE, op.methodName(), element);
                if (!PrefixSuffixNode.doIt(self, subStr, cpStart, cpEnd, selfLen, subStrLen = codePointLengthNode.execute((AbstractTruffleString)subStr, PythonUtils.TS_ENCODING), regionEqualNode, op)) continue;
                return true;
            }
            return false;
        }

        private static boolean doIt(TruffleString text, TruffleString subStr, int start, int end, int textLen, int subStrLen, TruffleString.RegionEqualNode regionEqualNode, Op op) {
            assert (start >= 0);
            assert (end >= 0 && end <= textLen);
            if (end - start < subStrLen) {
                return false;
            }
            int fromIndex = op == Op.PREFIX ? start : end - subStrLen;
            return regionEqualNode.execute((AbstractTruffleString)text, fromIndex, (AbstractTruffleString)subStr, 0, subStrLen, PythonUtils.TS_ENCODING);
        }

        static enum Op {
            PREFIX,
            SUFFIX;


            TruffleString methodName() {
                return this == PREFIX ? BuiltinNames.T_STARTSWITH : BuiltinNames.T_ENDSWITH;
            }
        }
    }

    @Builtin(name="__add__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static TruffleString doIt(TruffleString self, TruffleString other, @Cached.Shared @Cached TruffleString.ConcatNode concatNode) {
            return concatNode.execute((AbstractTruffleString)self, (AbstractTruffleString)other, PythonUtils.TS_ENCODING, false);
        }

        @Specialization
        static TruffleString doSS(PString self, TruffleString other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.ConcatNode concatNode) {
            return AddNode.doIt(castToStringNode.execute(inliningTarget, self), other, concatNode);
        }

        @Specialization
        static TruffleString doSS(TruffleString self, PString other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.ConcatNode concatNode) {
            return AddNode.doIt(self, castToStringNode.execute(inliningTarget, other), concatNode);
        }

        @Specialization
        static TruffleString doSS(PString self, PString other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.ConcatNode concatNode) {
            return AddNode.doIt(castToStringNode.execute(inliningTarget, self), castToStringNode.execute(inliningTarget, other), concatNode);
        }

        @Specialization(guards={"isString(self)"})
        static Object doSNative(VirtualFrame frame, Object self, PythonAbstractNativeObject other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToTruffleStringNode cast, @Cached.Shared @Cached AddNode recurse, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return recurse.execute(frame, self, cast.execute(inliningTarget, other));
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_CONCAT_S_NOT_P_TO_S, "str", other, "str");
            }
        }

        @Specialization(guards={"isString(other)"})
        static Object doNativeS(VirtualFrame frame, PythonAbstractNativeObject self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToTruffleStringNode cast, @Cached.Shared @Cached AddNode recurse, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return recurse.execute(frame, cast.execute(inliningTarget, self), other);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_CONCAT_S_NOT_P_TO_S, "str", other, "str");
            }
        }

        @Specialization
        static Object doNative(VirtualFrame frame, PythonAbstractNativeObject self, PythonAbstractNativeObject other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToTruffleStringNode cast, @Cached.Shared @Cached AddNode recurse, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return recurse.execute(frame, cast.execute(inliningTarget, self), cast.execute(inliningTarget, other));
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___ADD__, "str", self);
            }
        }

        @Specialization(guards={"isString(self)", "!isString(other)", "!isNativeObject(other)"})
        static Object doSO(Object self, Object other, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_CONCAT_S_NOT_P_TO_S, "str", other, "str");
        }

        @Specialization(guards={"!isString(self)", "!isNativeObject(self)", "!isNativeObject(other)"})
        static Object doNoString(Object self, Object other, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___ADD__, "str", self);
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached StringCmpOpHelperNode stringCmpOpHelperNode) {
            return stringCmpOpHelperNode.execute(inliningTarget, self, other, r -> r >= 0);
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached StringCmpOpHelperNode stringCmpOpHelperNode) {
            return stringCmpOpHelperNode.execute(inliningTarget, self, other, r -> r > 0);
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached StringCmpOpHelperNode stringCmpOpHelperNode) {
            return stringCmpOpHelperNode.execute(inliningTarget, self, other, r -> r <= 0);
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached StringCmpOpHelperNode stringCmpOpHelperNode) {
            return stringCmpOpHelperNode.execute(inliningTarget, self, other, r -> r < 0);
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached StringEqOpHelperNode stringEqOpHelperNode) {
            return stringEqOpHelperNode.execute(inliningTarget, self, other, true);
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached StringEqOpHelperNode stringEqOpHelperNode) {
            return stringEqOpHelperNode.execute(inliningTarget, self, other, false);
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        public abstract boolean executeBool(Object var1, Object var2);

        @Specialization
        static boolean doit(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castStr, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode) {
            TruffleString selfStr = castStr.cast(inliningTarget, self, ErrorMessages.REQUIRES_STRING_AS_LEFT_OPERAND, other);
            TruffleString otherStr = castStr.cast(inliningTarget, other, ErrorMessages.REQUIRES_STRING_AS_LEFT_OPERAND, other);
            return indexOfStringNode.execute((AbstractTruffleString)selfStr, (AbstractTruffleString)otherStr, 0, codePointLengthNode.execute((AbstractTruffleString)selfStr, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class StringCmpOpHelperNode
    extends Node {
        StringCmpOpHelperNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3, IntPredicate var4);

        @Specialization
        static boolean doStrings(TruffleString self, TruffleString other, IntPredicate resultProcessor, @Cached.Shared @Cached(inline=false) TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return resultProcessor.test(StringUtils.compareStrings(self, other, compareIntsUTF32Node));
        }

        @Specialization
        static Object doGeneric(Node inliningTarget, Object self, Object other, IntPredicate resultProcessor, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached CastToTruffleStringNode castOtherNode, @Cached.Shared @Cached(inline=false) TruffleString.CompareIntsUTF32Node compareIntsUTF32Node, @Cached InlinedBranchProfile noStringBranch) {
            TruffleString otherStr;
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___EQ__, self);
            try {
                otherStr = castOtherNode.execute(inliningTarget, other);
            }
            catch (CannotCastException e) {
                noStringBranch.enter(inliningTarget);
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return StringCmpOpHelperNode.doStrings(selfStr, otherStr, resultProcessor, compareIntsUTF32Node);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class StringEqOpHelperNode
    extends Node {
        StringEqOpHelperNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3, boolean var4);

        @Specialization
        static boolean doStrings(TruffleString self, TruffleString other, boolean negate, @Cached.Shared @Cached(inline=false) TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)self, (AbstractTruffleString)other, PythonUtils.TS_ENCODING) != negate;
        }

        @Specialization
        static Object doGeneric(Node inliningTarget, Object self, Object other, boolean negate, @Cached StringNodes.CastToTruffleStringCheckedNode castSelfNode, @Cached CastToTruffleStringNode castOtherNode, @Cached.Shared @Cached(inline=false) TruffleString.EqualNode equalNode, @Cached InlinedBranchProfile noStringBranch) {
            TruffleString otherStr;
            TruffleString selfStr = castSelfNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___EQ__, self);
            try {
                otherStr = castOtherNode.execute(inliningTarget, other);
            }
            catch (CannotCastException e) {
                noStringBranch.enter(inliningTarget);
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return StringEqOpHelperNode.doStrings(selfStr, otherStr, negate, equalNode);
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetNewargsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PTuple doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast, @Cached PythonObjectFactory factory) {
            TruffleString selfStr = cast.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___GETNEWARGS__, self);
            PString copy = factory.createString(selfStr);
            return factory.createTuple(new Object[]{copy});
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castToStringNode, @Cached StringNodes.StringReprNode reprNode) {
            return reprNode.execute(castToStringNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___REPR__, self));
        }
    }

    @Builtin(name="format_map", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"self", "mapping"})
    @ArgumentClinic(name="self", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodNames.class})
    static abstract class FormatMapNode
    extends PythonBinaryClinicBuiltinNode {
        FormatMapNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.FormatMapNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        TruffleString format(VirtualFrame frame, TruffleString self, Object mapping, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached BuiltinFunctions.FormatNode format) {
            TemplateFormatter template = new TemplateFormatter(self);
            PythonLanguage language = PythonLanguage.get(this);
            PythonContext context = PythonContext.get(this);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                TruffleString truffleString = template.build(this, null, mapping, format);
                return truffleString;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }
    }

    @Builtin(name="format", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class StrFormatNode
    extends PythonBuiltinNode {
        StrFormatNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isString(self)"})
        static TruffleString format(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached BuiltinFunctions.FormatNode format, @Cached CastToTruffleStringNode castToStringNode) {
            TemplateFormatter template = new TemplateFormatter(castToStringNode.execute(inliningTarget, self));
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                TruffleString truffleString = template.build(inliningTarget, args, kwargs, format);
                return truffleString;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @Specialization(guards={"!isString(self)"})
        static TruffleString generic(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwargs, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, BuiltinNames.T_FORMAT, "str", self);
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        static TruffleString format(Object self, TruffleString formatString, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToJavaStringCheckedNode castToJavaStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            String str = castToJavaStringNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___STR__, self);
            return FormatNode.formatString(inliningTarget, FormatNode.getAndValidateSpec(inliningTarget, formatString, raiseNode), str);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString formatString(Node raisingNode, InternalFormat.Spec spec, String str) {
            TextFormatter formatter = new TextFormatter(spec, raisingNode);
            formatter.format(str);
            return formatter.pad().getResult();
        }

        private static InternalFormat.Spec getAndValidateSpec(Node inliningTarget, TruffleString formatString, PRaiseNode.Lazy raiseNode) {
            InternalFormat.Spec spec = InternalFormat.fromText(formatString, 's', '<', inliningTarget);
            if (InternalFormat.Spec.specified(spec.type) && spec.type != 's') {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNKNOWN_FORMAT_CODE, Character.valueOf(spec.type), "str");
            }
            if (InternalFormat.Spec.specified(spec.sign)) {
                if (spec.sign == ' ') {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SPACE_NOT_ALLOWED_IN_STRING_FORMAT_SPECIFIER);
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SIGN_NOT_ALLOWED_FOR_STRING_FMT);
            }
            if (spec.alternate) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ALTERNATE_NOT_ALLOWED_WITH_STRING_FMT);
            }
            if (InternalFormat.Spec.specified(spec.align) && spec.align == '=') {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EQUALS_ALIGNMENT_FLAG_NOT_ALLOWED_FOR_STRING_FMT);
            }
            return spec;
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        @Specialization
        static TruffleString doString(TruffleString self) {
            return self;
        }

        @Specialization(guards={"!isTruffleString(self)"})
        static TruffleString doGeneric(Object self, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castToTruffleStringNode) {
            return castToTruffleStringNode.cast(inliningTarget, self, ErrorMessages.REQUIRES_STR_OBJECT_BUT_RECEIVED_P, SpecialMethodNames.T___STR__, self);
        }
    }
}

