/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.mmap;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.mmap.MMapBuiltins;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary.Repeat(value={@ExportLibrary(value=PythonBufferAcquireLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public final class PMMap
extends PythonObject {
    public static final int ACCESS_DEFAULT = 0;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_COPY = 3;
    private final MMapRef ref;
    private long pos;
    private final int access;

    public PMMap(Object pythonClass, Shape instanceShape, PythonContext context, Object handle, int fd, long length, int access) {
        super(pythonClass, instanceShape);
        assert (handle != null);
        this.ref = new MMapRef(this, handle, context.getSharedFinalizer(), fd, length);
        this.access = access;
    }

    public Object getPosixSupportHandle() {
        return this.ref.getReference();
    }

    void close(PosixSupportLibrary lib, Object posix) {
        this.ref.close(lib, posix);
    }

    boolean isClosed() {
        return this.ref.isReleased();
    }

    @ExportMessage
    boolean isReadonly() {
        return !this.isWriteable();
    }

    public boolean isWriteable() {
        return this.access != 1;
    }

    public int getAccess() {
        return this.access;
    }

    public long getLength() {
        return this.ref.length;
    }

    public long getPos() {
        return this.pos;
    }

    public void setPos(long pos) {
        this.pos = pos;
    }

    public long getRemaining() {
        return this.pos < this.ref.length ? this.ref.length - this.pos : 0L;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength(@Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode castToIntNode) {
        return castToIntNode.execute(inliningTarget, this.ref.length);
    }

    @ExportMessage
    byte readByte(int byteOffset, @Bind(value="$node") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared(value="raiseNode") @Cached PConstructAndRaiseNode.Lazy raiseNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        try {
            return posixLib.mmapReadByte(PythonContext.get(raiseNode).getPosixSupport(), this.getPosixSupportHandle(), byteOffset);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw raiseNode.get(inliningTarget).raiseOSError(null, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING), null, null);
        }
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value, @Bind(value="$node") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached.Shared(value="raiseNode") @Cached PConstructAndRaiseNode.Lazy raiseNode, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        try {
            posixLib.mmapWriteByte(PythonContext.get(raiseNode).getPosixSupport(), this.getPosixSupportHandle(), byteOffset, value);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw raiseNode.get(inliningTarget).raiseOSError(null, e.getErrorCode(), fromJavaStringNode.execute(e.getMessage(), PythonUtils.TS_ENCODING), null, null);
        }
    }

    @ExportMessage
    Object acquire(int flags) {
        return this;
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    static class MMapRef
    extends AsyncHandler.SharedFinalizer.FinalizableReference {
        final int fd;
        private final long length;

        MMapRef(PMMap referent, Object handle, AsyncHandler.SharedFinalizer finalizer, int fd, long length) {
            super(referent, handle, finalizer);
            this.fd = fd;
            this.length = length;
        }

        @Override
        public AsyncHandler.AsyncAction release() {
            return new MMapBuiltins.ReleaseCallback(this);
        }

        void close(PosixSupportLibrary posixLib, Object posixSupport) {
            if (this.isReleased()) {
                return;
            }
            this.markReleased();
            Object handle = this.getReference();
            if (this.fd != -1) {
                try {
                    posixLib.close(posixSupport, this.fd);
                }
                catch (PosixSupportLibrary.PosixException posixException) {
                    // empty catch block
                }
            }
            try {
                posixLib.mmapUnmap(posixSupport, handle, this.length);
            }
            catch (PosixSupportLibrary.PosixException posixException) {
                // empty catch block
            }
        }
    }
}

