/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.mmap;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.mmap.MMapBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.mmap.MMapBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.builtins.objects.range.RangeNodes;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.LongIndexConverterNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMMap})
public final class MMapBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MMapBuiltinsFactory.getFactories();
    }

    private static PBytes createEmptyBytes(PythonObjectFactory factory) {
        if (CompilerDirectives.inInterpreter()) {
            return factory.createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
        }
        return factory.createBytes(new byte[0]);
    }

    private static byte[] readBytes(VirtualFrame frame, Node inliningTarget, PMMap self, PosixSupportLibrary posixLib, Object posixSupport, long pos, int len, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
        try {
            assert (len > 0);
            assert (pos + (long)len <= self.getLength());
            byte[] buffer = new byte[len];
            posixLib.mmapReadBytes(posixSupport, self.getPosixSupportHandle(), pos, buffer, buffer.length);
            return buffer;
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
        }
    }

    static class ReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final PMMap.MMapRef ref;

        ReleaseCallback(PMMap.MMapRef ref) {
            this.ref = ref;
        }

        @Override
        public void execute(PythonContext context) {
            if (this.ref.isReleased()) {
                return;
            }
            PythonLanguage language = context.getLanguage();
            RootCallTarget callTarget = language.createCachedCallTarget(ReleaserRootNode::new, (Object)ReleaserRootNode.class);
            callTarget.call(new Object[]{this.ref});
        }

        private static class ReleaserRootNode
        extends RootNode {
            @Node.Child
            private PosixSupportLibrary posixSupportLibrary = (PosixSupportLibrary)PosixSupportLibrary.getFactory().createDispatched(1);

            ReleaserRootNode(TruffleLanguage<?> language) {
                super(language);
            }

            public Object execute(VirtualFrame frame) {
                PMMap.MMapRef ref = (PMMap.MMapRef)frame.getArguments()[0];
                ref.close(this.posixSupportLibrary, PythonContext.get((Node)this).getPosixSupport());
                return null;
            }
        }
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1, parameterNames={"$self", "offset", "size"})
    @GenerateNodeFactory
    @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.LongIndex, defaultValue="0")
    static abstract class FlushNode
    extends PythonTernaryClinicBuiltinNode {
        FlushNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.FlushNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object flush(VirtualFrame frame, PMMap self, long offset, Object sizeObj, @Bind(value="this") Node inliningTarget, @Cached LongIndexConverterNode sizeConversion, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            long size = sizeObj == PNone.NO_VALUE ? self.getLength() : sizeConversion.executeLong(frame, sizeObj);
            if (size < 0L || offset < 0L || self.getLength() - offset < size) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.FLUSH_VALUES_OUT_OF_RANGE);
            }
            if (self.getAccess() == 1 || self.getAccess() == 3) {
                return PNone.NONE;
            }
            try {
                posixLib.mmapFlush(this.getPosixSupport(), self.getPosixSupportHandle(), offset, self.getLength());
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="find", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentClinic(name="sub", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class FindNode
    extends PythonQuaternaryClinicBuiltinNode {
        private static final int BUFFER_SIZE = 1024;

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.FindNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static long find(VirtualFrame frame, PMMap self, Object subBuffer, Object startIn, Object endIn, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="subBuffer") PythonBufferAccessLibrary bufferLib, @Cached LongIndexConverterNode startConverter, @Cached LongIndexConverterNode endConverter, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int bufferSize;
                long start = FindNode.normalizeIndex(frame, startConverter, startIn, self.getLength(), self.getPos());
                long end = FindNode.normalizeIndex(frame, endConverter, endIn, self.getLength(), self.getLength());
                byte[] sub = bufferLib.getInternalOrCopiedByteArray(subBuffer);
                int subLen = bufferLib.getBufferLength(subBuffer);
                int buffersIndex = bufferSize = Math.max(1024, subLen);
                byte[] firstBuffer = new byte[bufferSize];
                byte[] secondBuffer = new byte[bufferSize];
                FindNode.readBytes(frame, inliningTarget, self, posixLib, start, secondBuffer, constructAndRaiseNode, raiseNode);
                long selfIdx = start;
                while (selfIdx <= end - (long)subLen) {
                    if (buffersIndex + subLen > bufferSize * 2) {
                        byte[] tmp = firstBuffer;
                        firstBuffer = secondBuffer;
                        secondBuffer = tmp;
                        buffersIndex -= bufferSize;
                        long readIndex = selfIdx + (long)subLen - 1L;
                        FindNode.readBytes(frame, inliningTarget, self, posixLib, readIndex, secondBuffer, constructAndRaiseNode, raiseNode);
                    }
                    boolean found = true;
                    for (int subIdx = 0; subIdx < subLen; ++subIdx) {
                        int currentBuffersIdx = buffersIndex + subIdx;
                        byte value = currentBuffersIdx >= bufferSize ? secondBuffer[currentBuffersIdx % bufferSize] : firstBuffer[currentBuffersIdx];
                        if (sub[subIdx] == value) continue;
                        found = false;
                        break;
                    }
                    if (found) {
                        long l = selfIdx;
                        return l;
                    }
                    ++selfIdx;
                    ++buffersIndex;
                }
                long l = -1L;
                return l;
            }
            finally {
                bufferLib.release(subBuffer, frame, indirectCallData);
            }
        }

        private static void readBytes(VirtualFrame frame, Node inliningTarget, PMMap self, PosixSupportLibrary posixLib, long index, byte[] buffer, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PRaiseNode.Lazy raiseNode) {
            try {
                long remaining = self.getLength() - index;
                int toReadLen = remaining > (long)buffer.length ? buffer.length : (int)remaining;
                int nread = posixLib.mmapReadBytes(PosixSupport.get(inliningTarget), self.getPosixSupportHandle(), index, buffer, toReadLen);
                if (toReadLen != nread) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.MMAP_CHANGED_LENGTH);
                }
            }
            catch (PosixSupportLibrary.PosixException ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, ex);
            }
        }

        private static long normalizeIndex(VirtualFrame frame, LongIndexConverterNode converter, Object idxObj, long len, long defaultValue) {
            if (PGuards.isNoValue(idxObj)) {
                return defaultValue;
            }
            long idx = converter.executeLong(frame, idxObj);
            if (idx < 0L) {
                idx += len;
            }
            if (idx < 0L) {
                idx = 0L;
            } else if (idx > len) {
                idx = len;
            }
            return idx;
        }
    }

    @Builtin(name="seek", parameterNames={"$self", "dist", "how"})
    @ArgumentsClinic(value={@ArgumentClinic(name="dist", conversion=ArgumentClinic.ClinicConversion.LongIndex), @ArgumentClinic(name="how", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object seek(PMMap self, long dist, int how, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile errorProfile, @Cached PRaiseNode.Lazy raiseNode) {
            long where = switch (how) {
                case 0 -> dist;
                case 1 -> self.getPos() + dist;
                case 2 -> self.getLength() + dist;
                default -> {
                    errorProfile.enter(inliningTarget);
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNKNOWN_S_TYPE, "seek");
                }
            };
            if (where > self.getLength() || where < 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.SEEK_OUT_OF_RANGE);
            }
            self.setPos(where);
            return PNone.NONE;
        }
    }

    @Builtin(name="write", parameterNames={"$self", "data"})
    @ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBinaryClinicBuiltinNode {
        WriteNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MMapBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(limit="3")
        static int doIt(VirtualFrame frame, PMMap self, Object dataBuffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="dataBuffer") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                if (!self.isWriteable()) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.MMAP_CANNOT_MODIFY_READONLY_MEMORY);
                }
                byte[] dataBytes = bufferLib.getInternalOrCopiedByteArray(dataBuffer);
                int dataLen = bufferLib.getBufferLength(dataBuffer);
                if (self.getPos() > self.getLength() || self.getLength() - self.getPos() < (long)dataLen) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.DATA_OUT_OF_RANGE);
                }
                posixLib.mmapWriteBytes(PosixSupport.get(inliningTarget), self.getPosixSupportHandle(), self.getPos(), dataBytes, dataLen);
                self.setPos(self.getPos() + (long)dataLen);
                int n = dataLen;
                return n;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            finally {
                bufferLib.release(dataBuffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends PythonUnaryBuiltinNode {
        private static final int BUFFER_SIZE = 1024;

        ReadlineNode() {
        }

        @Specialization
        Object readline(VirtualFrame frame, PMMap self, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached SequenceStorageNodes.AppendNode appendNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            ByteSequenceStorage res = new ByteSequenceStorage(16);
            byte[] buffer = new byte[1024];
            block2: while (self.getPos() < self.getLength()) {
                int nread;
                try {
                    nread = posixLib.mmapReadBytes(this.getPosixSupport(), self.getPosixSupportHandle(), self.getPos(), buffer, (int)Math.min(self.getRemaining(), (long)buffer.length));
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                for (int i = 0; i < nread; ++i) {
                    byte b = buffer[i];
                    appendNode.execute(inliningTarget, res, b, BytesBuiltins.BytesLikeNoGeneralizationNode.SUPPLIER);
                    if (b != 10) continue;
                    self.setPos(self.getPos() + (long)i + 1L);
                    break block2;
                }
                self.setPos(self.getPos() + (long)nread);
            }
            return factory.createBytes(res);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ReadNode
    extends PythonBuiltinNode {
        ReadNode() {
        }

        @Specialization
        static PBytes read(VirtualFrame frame, PMMap self, Object n, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile noneProfile, @Cached InlinedConditionProfile emptyProfile, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedConditionProfile negativeProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            long nread;
            if (noneProfile.profile(inliningTarget, PGuards.isPNone(n))) {
                nread = self.getRemaining();
            } else {
                if (!indexCheckNode.execute(inliningTarget, n)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ARG_SHOULD_BE_INT_OR_NONE, n);
                }
                nread = asSizeNode.executeExact((Frame)frame, inliningTarget, n);
                if (negativeProfile.profile(inliningTarget, nread < 0L)) {
                    nread = self.getRemaining();
                } else if (nread > self.getRemaining()) {
                    nread = self.getRemaining();
                }
            }
            if (emptyProfile.profile(inliningTarget, nread == 0L)) {
                return MMapBuiltins.createEmptyBytes(factory);
            }
            try {
                byte[] buffer = MMapBuiltins.readBytes(frame, inliningTarget, self, posixLib, PosixSupport.get(inliningTarget), self.getPos(), PythonUtils.toIntExact(nread), constructAndRaiseNode);
                self.setPos(self.getPos() + (long)buffer.length);
                return factory.createBytes(buffer);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.TOO_MANY_REMAINING_BYTES_TO_BE_STORED);
            }
        }
    }

    @Builtin(name="read_byte", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ReadByteNode
    extends PythonUnaryBuiltinNode {
        ReadByteNode() {
        }

        @Specialization
        static int readByte(VirtualFrame frame, PMMap self, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (self.getPos() >= self.getLength()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.READ_BYTE_OUT_OF_RANGE);
            }
            try {
                byte res = posixSupportLib.mmapReadByte(PosixSupport.get(inliningTarget), self.getPosixSupportHandle(), self.getPos());
                self.setPos(self.getPos() + 1L);
                return res & 0xFF;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends PythonBuiltinNode {
        TellNode() {
        }

        @Specialization
        static long readline(PMMap self) {
            return self.getPos();
        }
    }

    @Builtin(name="resize", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ResizeNode
    extends PythonBuiltinNode {
        ResizeNode() {
        }

        @Specialization
        static long resize(PMMap self, Object n, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.RESIZING_NOT_AVAILABLE);
        }
    }

    @Builtin(name="size", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SizeNode
    extends PythonBuiltinNode {
        SizeNode() {
        }

        @Specialization
        static long size(PMMap self) {
            return self.getLength();
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization
        static boolean close(PMMap self) {
            return self.isClosed();
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        PNone close(PMMap self, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupportLib) {
            self.close(posixSupportLib, this.getPosixSupport());
            return PNone.NONE;
        }
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class ExitNode
    extends PythonBuiltinNode {
        protected static final TruffleString T_CLOSE = PythonUtils.tsLiteral("close");

        ExitNode() {
        }

        @Specialization
        static Object size(VirtualFrame frame, PMMap self, Object typ, Object val, Object tb, @Cached(value="create(T_CLOSE)") LookupAndCallUnaryNode callCloseNode) {
            return callCloseNode.executeObject(frame, self);
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class EnterNode
    extends PythonUnaryBuiltinNode {
        EnterNode() {
        }

        @Specialization
        static Object size(PMMap self) {
            return self;
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static long len(PMMap self) {
            return self.getLength();
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SetItemNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"!isPSlice(idxObj)"})
        static PNone doSingle(VirtualFrame frame, PMMap self, Object idxObj, Object val, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached PyLongAsLongNode asLongNode, @Cached(value="createCoerce()") CastToByteNode castToByteNode, @Cached.Exclusive @Cached InlinedConditionProfile outOfRangeProfile, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            long i = asLongNode.execute((Frame)frame, inliningTarget, idxObj);
            long len = self.getLength();
            long idx = i < 0L ? i + len : i;
            if (outOfRangeProfile.profile(inliningTarget, idx < 0L || idx >= len)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.MMAP_INDEX_OUT_OF_RANGE);
            }
            byte[] bytes = new byte[]{castToByteNode.execute(frame, val)};
            SetItemNode.writeBuffer(frame, inliningTarget, posixSupportLib, self, idx, bytes, 1, constructAndRaiseNode);
            return PNone.NONE;
        }

        @Specialization
        static PNone doSlice(VirtualFrame frame, PMMap self, PSlice idx, PBytesLike val, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached SequenceStorageNodes.ToByteArrayNode toByteArrayNode, @Cached.Exclusive @Cached InlinedConditionProfile invalidStepProfile, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached RangeNodes.LenOfRangeNode sliceLen, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                long len = self.getLength();
                PSlice.SliceInfo info = compute.execute((Frame)frame, sliceCast.execute(inliningTarget, idx), PInt.intValueExact(len));
                if (invalidStepProfile.profile(inliningTarget, info.step != 1)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.STEP_1_NOT_SUPPORTED);
                }
                byte[] bytes = toByteArrayNode.execute(inliningTarget, val.getSequenceStorage());
                SetItemNode.writeBuffer(frame, inliningTarget, posixSupportLib, self, info.start, bytes, sliceLen.len(inliningTarget, info), constructAndRaiseNode);
                return PNone.NONE;
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, e);
            }
        }

        private static void writeBuffer(VirtualFrame frame, Node inliningTarget, PosixSupportLibrary posixSupportLib, PMMap mmap, long idx, byte[] bytes, int len, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixSupportLib.mmapWriteBytes(PosixSupport.get(inliningTarget), mmap.getPosixSupportHandle(), idx, bytes, len);
            }
            catch (PosixSupportLibrary.PosixException ex) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, ex);
            }
        }

        @NeverDefault
        protected static CastToByteNode createCoerce() {
            return CastToByteNode.create(true);
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"!isPSlice(idxObj)"})
        static int doSingle(VirtualFrame frame, PMMap self, Object idxObj, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached PyLongAsLongNode asLongNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            long idx;
            long i = asLongNode.execute((Frame)frame, inliningTarget, idxObj);
            long len = self.getLength();
            long l = idx = i < 0L ? i + len : i;
            if (idx < 0L || idx >= len) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.MMAP_INDEX_OUT_OF_RANGE);
            }
            try {
                return posixSupportLib.mmapReadByte(PosixSupport.get(inliningTarget), self.getPosixSupportHandle(), idx) & 0xFF;
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Specialization
        static Object doSlice(VirtualFrame frame, PMMap self, PSlice idx, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixSupportLib, @Cached InlinedConditionProfile emptyProfile, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached RangeNodes.LenOfRangeNode sliceLenNode, @Cached.Exclusive @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PSlice.SliceInfo info = compute.execute((Frame)frame, sliceCast.execute(inliningTarget, idx), PInt.intValueExact(self.getLength()));
                int len = sliceLenNode.len(inliningTarget, info);
                if (emptyProfile.profile(inliningTarget, len == 0)) {
                    return MMapBuiltins.createEmptyBytes(factory);
                }
                byte[] result = MMapBuiltins.readBytes(frame, inliningTarget, self, posixSupportLib, PosixSupport.get(inliningTarget), info.start, len, constructAndRaiseNode);
                return factory.createBytes(result);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, e);
            }
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        ReprNode() {
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        NeNode() {
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        GeNode() {
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        GtNode() {
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        LeNode() {
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        LtNode() {
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        ContainsNode() {
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        MulNode() {
        }
    }

    @Builtin(name="__add__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        AddNode() {
        }
    }
}

