/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory;
import com.oracle.graal.python.builtins.objects.itertools.ChainBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.PChain;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsFactory;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyIterCheckNodeGen;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetIterNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=ChainBuiltins.class)
public final class ChainBuiltinsFactory {
    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(IterNodeFactory.getInstance(), NextNodeFactory.getInstance(), FromIterNodeFactory.getInstance(), ReduceNodeFactory.getInstance(), SetStateNodeFactory.getInstance(), ClassGetItemNodeFactory.getInstance());
    }

    @GeneratedBy(value=ChainBuiltins.IterNode.class)
    public static final class IterNodeFactory
    implements NodeFactory<ChainBuiltins.IterNode> {
        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        public Class<ChainBuiltins.IterNode> getNodeClass() {
            return ChainBuiltins.IterNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public ChainBuiltins.IterNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IterNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ChainBuiltins.IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ChainBuiltins.IterNode create() {
            return new IterNodeGen();
        }

        @GeneratedBy(value=ChainBuiltins.IterNode.class)
        public static final class IterNodeGen
        extends ChainBuiltins.IterNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 && arg0Value instanceof PChain) {
                    PChain arg0Value_ = (PChain)arg0Value;
                    return ChainBuiltins.IterNode.iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PChain) {
                    PChain arg0Value_ = (PChain)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return ChainBuiltins.IterNode.iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=ChainBuiltins.NextNode.class)
    public static final class NextNodeFactory
    implements NodeFactory<ChainBuiltins.NextNode> {
        private static final NextNodeFactory NEXT_NODE_FACTORY_INSTANCE = new NextNodeFactory();

        private NextNodeFactory() {
        }

        public Class<ChainBuiltins.NextNode> getNodeClass() {
            return ChainBuiltins.NextNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public ChainBuiltins.NextNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NextNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ChainBuiltins.NextNode> getInstance() {
            return NEXT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ChainBuiltins.NextNode create() {
            return new NextNodeGen();
        }

        @GeneratedBy(value=ChainBuiltins.NextNode.class)
        public static final class NextNodeGen
        extends ChainBuiltins.NextNode {
            private static final InlineSupport.StateField STATE_0_NextNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectGetIter INLINED_GET_ITER_ = PyObjectGetIterNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectGetIter.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NextNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field2_", Node.class)}));
            private static final BuiltinClassProfiles.IsBuiltinObjectProfile INLINED_IS_STOP_ITERATION_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinObjectProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NextNode_UPDATER.subUpdater(3, 22), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isStopIterationProfile__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"isStopIterationProfile__field2_", Node.class)}));
            private static final InlinedBranchProfile INLINED_NEXT_EXCEPTIO_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NextNode_UPDATER.subUpdater(25, 1)}));
            private static final InlinedLoopConditionProfile INLINED_LOOP_PROFILE_ = InlinedLoopConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedLoopConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{InlineSupport.LongField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"loopProfile__field0_"), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"loopProfile__field1_")}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NextNode_UPDATER.subUpdater(26, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field2_;
            @Node.Child
            private BuiltinFunctions.NextNode nextNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isStopIterationProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node isStopIterationProfile__field2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private long loopProfile__field0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int loopProfile__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PChain) {
                    PChain arg0Value_ = (PChain)arg0Value;
                    BuiltinFunctions.NextNode nextNode__ = this.nextNode_;
                    if (nextNode__ != null) {
                        NextNodeGen inliningTarget__ = this;
                        return ChainBuiltins.NextNode.next(frameValue, arg0Value_, inliningTarget__, INLINED_GET_ITER_, nextNode__, INLINED_IS_STOP_ITERATION_PROFILE_, INLINED_NEXT_EXCEPTIO_PROFILE_, INLINED_LOOP_PROFILE_, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                NextNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PChain) {
                    PChain arg0Value_ = (PChain)arg0Value;
                    inliningTarget__ = this;
                    BuiltinFunctions.NextNode nextNode__ = (BuiltinFunctions.NextNode)this.insert(BuiltinFunctionsFactory.NextNodeFactory.create());
                    Objects.requireNonNull(nextNode__, "Specialization 'next(VirtualFrame, PChain, Node, PyObjectGetIter, NextNode, IsBuiltinObjectProfile, InlinedBranchProfile, InlinedLoopConditionProfile, Lazy)' cache 'nextNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.nextNode_ = nextNode__;
                    this.state_0_ = state_0 |= 1;
                    return ChainBuiltins.NextNode.next(frameValue, arg0Value_, inliningTarget__, INLINED_GET_ITER_, nextNode__, INLINED_IS_STOP_ITERATION_PROFILE_, INLINED_NEXT_EXCEPTIO_PROFILE_, INLINED_LOOP_PROFILE_, INLINED_RAISE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=ChainBuiltins.FromIterNode.class)
    public static final class FromIterNodeFactory
    implements NodeFactory<ChainBuiltins.FromIterNode> {
        private static final FromIterNodeFactory FROM_ITER_NODE_FACTORY_INSTANCE = new FromIterNodeFactory();

        private FromIterNodeFactory() {
        }

        public Class<ChainBuiltins.FromIterNode> getNodeClass() {
            return ChainBuiltins.FromIterNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public ChainBuiltins.FromIterNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FromIterNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ChainBuiltins.FromIterNode> getInstance() {
            return FROM_ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ChainBuiltins.FromIterNode create() {
            return new FromIterNodeGen();
        }

        @GeneratedBy(value=ChainBuiltins.FromIterNode.class)
        public static final class FromIterNodeGen
        extends ChainBuiltins.FromIterNode {
            private static final InlineSupport.StateField STATE_0_FromIterNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectGetIter INLINED_GET_ITER_ = PyObjectGetIterNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectGetIter.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FromIterNode_UPDATER.subUpdater(1, 2), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getIter__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getIter__field2_;
            @Node.Child
            private PythonObjectFactory factory_;

            private FromIterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                PythonObjectFactory factory__;
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (factory__ = this.factory_) != null) {
                    FromIterNodeGen inliningTarget__ = this;
                    return ChainBuiltins.FromIterNode.fromIter(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_ITER_, factory__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                FromIterNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                PythonObjectFactory factory__ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                Objects.requireNonNull(factory__, "Specialization 'fromIter(VirtualFrame, Object, Object, Node, PyObjectGetIter, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                this.state_0_ = state_0 |= 1;
                return ChainBuiltins.FromIterNode.fromIter(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_ITER_, factory__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=ChainBuiltins.ReduceNode.class)
    public static final class ReduceNodeFactory
    implements NodeFactory<ChainBuiltins.ReduceNode> {
        private static final ReduceNodeFactory REDUCE_NODE_FACTORY_INSTANCE = new ReduceNodeFactory();

        private ReduceNodeFactory() {
        }

        public Class<ChainBuiltins.ReduceNode> getNodeClass() {
            return ChainBuiltins.ReduceNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public ChainBuiltins.ReduceNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ReduceNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ChainBuiltins.ReduceNode> getInstance() {
            return REDUCE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ChainBuiltins.ReduceNode create() {
            return new ReduceNodeGen();
        }

        @GeneratedBy(value=ChainBuiltins.ReduceNode.class)
        public static final class ReduceNodeGen
        extends ChainBuiltins.ReduceNode {
            private static final InlineSupport.StateField STATE_0_ReduceNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final GetClassNode INLINED_GET_CLASS_ = GetClassNodeGen.inline(InlineSupport.InlineTarget.create(GetClassNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReduceNode_UPDATER.subUpdater(1, 17), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getClass__field1_", Node.class)}));
            private static final InlinedConditionProfile INLINED_HAS_SOURCE_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReduceNode_UPDATER.subUpdater(18, 2)}));
            private static final InlinedConditionProfile INLINED_HAS_ACTIVE_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReduceNode_UPDATER.subUpdater(20, 2)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node getClass__field1_;
            @Node.Child
            private PythonObjectFactory factory_;

            private ReduceNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PChain) {
                    PChain arg0Value_ = (PChain)arg0Value;
                    PythonObjectFactory factory__ = this.factory_;
                    if (factory__ != null) {
                        ReduceNodeGen inliningTarget__ = this;
                        return ChainBuiltins.ReduceNode.reducePos(arg0Value_, inliningTarget__, INLINED_GET_CLASS_, INLINED_HAS_SOURCE_PROFILE_, INLINED_HAS_ACTIVE_PROFILE_, factory__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                ReduceNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PChain) {
                    PChain arg0Value_ = (PChain)arg0Value;
                    inliningTarget__ = this;
                    PythonObjectFactory factory__ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                    Objects.requireNonNull(factory__, "Specialization 'reducePos(PChain, Node, GetClassNode, InlinedConditionProfile, InlinedConditionProfile, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    this.state_0_ = state_0 |= 1;
                    return ChainBuiltins.ReduceNode.reducePos(arg0Value_, inliningTarget__, INLINED_GET_CLASS_, INLINED_HAS_SOURCE_PROFILE_, INLINED_HAS_ACTIVE_PROFILE_, factory__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=ChainBuiltins.SetStateNode.class)
    public static final class SetStateNodeFactory
    implements NodeFactory<ChainBuiltins.SetStateNode> {
        private static final SetStateNodeFactory SET_STATE_NODE_FACTORY_INSTANCE = new SetStateNodeFactory();

        private SetStateNodeFactory() {
        }

        public Class<ChainBuiltins.SetStateNode> getNodeClass() {
            return ChainBuiltins.SetStateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public ChainBuiltins.SetStateNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return SetStateNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ChainBuiltins.SetStateNode> getInstance() {
            return SET_STATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ChainBuiltins.SetStateNode create() {
            return new SetStateNodeGen();
        }

        @GeneratedBy(value=ChainBuiltins.SetStateNode.class)
        public static final class SetStateNodeGen
        extends ChainBuiltins.SetStateNode {
            private static final InlineSupport.StateField STATE_0_SetStateNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_LEN2_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SetStateNode_UPDATER.subUpdater(1, 1)}));
            private static final PyIterCheckNode INLINED_ITER_CHECK_NODE_ = PyIterCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyIterCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SetStateNode_UPDATER.subUpdater(2, 25), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"iterCheckNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"iterCheckNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"iterCheckNode__field3_", Node.class)}));
            private static final PRaiseNode.Lazy INLINED_RAISE_NODE_ = PRaiseNodeGen.LazyNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.Lazy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SetStateNode_UPDATER.subUpdater(27, 1), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"raiseNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private TupleBuiltins.LenNode lenNode_;
            @Node.Child
            private TupleBuiltins.GetItemNode getItemNode_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node iterCheckNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node iterCheckNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node iterCheckNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node raiseNode__field1_;

            private SetStateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && arg0Value instanceof PChain) {
                    TupleBuiltins.GetItemNode getItemNode__;
                    PChain arg0Value_ = (PChain)arg0Value;
                    TupleBuiltins.LenNode lenNode__ = this.lenNode_;
                    if (lenNode__ != null && (getItemNode__ = this.getItemNode_) != null) {
                        SetStateNodeGen inliningTarget__ = this;
                        return ChainBuiltins.SetStateNode.setState(frameValue, arg0Value_, arg1Value, inliningTarget__, lenNode__, getItemNode__, INLINED_LEN2_PROFILE_, INLINED_ITER_CHECK_NODE_, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                SetStateNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PChain) {
                    PChain arg0Value_ = (PChain)arg0Value;
                    inliningTarget__ = this;
                    TupleBuiltins.LenNode lenNode__ = (TupleBuiltins.LenNode)this.insert(TupleBuiltinsFactory.LenNodeFactory.create());
                    Objects.requireNonNull(lenNode__, "Specialization 'setState(VirtualFrame, PChain, Object, Node, LenNode, GetItemNode, InlinedBranchProfile, PyIterCheckNode, Lazy)' cache 'lenNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.lenNode_ = lenNode__;
                    TupleBuiltins.GetItemNode getItemNode__ = (TupleBuiltins.GetItemNode)this.insert(TupleBuiltinsFactory.GetItemNodeFactory.create());
                    Objects.requireNonNull(getItemNode__, "Specialization 'setState(VirtualFrame, PChain, Object, Node, LenNode, GetItemNode, InlinedBranchProfile, PyIterCheckNode, Lazy)' cache 'getItemNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.getItemNode_ = getItemNode__;
                    this.state_0_ = state_0 |= 1;
                    return ChainBuiltins.SetStateNode.setState(frameValue, arg0Value_, arg1Value, inliningTarget__, lenNode__, getItemNode__, INLINED_LEN2_PROFILE_, INLINED_ITER_CHECK_NODE_, INLINED_RAISE_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=ChainBuiltins.ClassGetItemNode.class)
    public static final class ClassGetItemNodeFactory
    implements NodeFactory<ChainBuiltins.ClassGetItemNode> {
        private static final ClassGetItemNodeFactory CLASS_GET_ITEM_NODE_FACTORY_INSTANCE = new ClassGetItemNodeFactory();

        private ClassGetItemNodeFactory() {
        }

        public Class<ChainBuiltins.ClassGetItemNode> getNodeClass() {
            return ChainBuiltins.ClassGetItemNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(new Class[0]));
        }

        public ChainBuiltins.ClassGetItemNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ClassGetItemNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ChainBuiltins.ClassGetItemNode> getInstance() {
            return CLASS_GET_ITEM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ChainBuiltins.ClassGetItemNode create() {
            return new ClassGetItemNodeGen();
        }

        @GeneratedBy(value=ChainBuiltins.ClassGetItemNode.class)
        public static final class ClassGetItemNodeGen
        extends ChainBuiltins.ClassGetItemNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PythonObjectFactory factory_;

            private ClassGetItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                PythonObjectFactory factory__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (factory__ = this.factory_) != null) {
                    return ChainBuiltins.ClassGetItemNode.classGetItem(arg0Value, arg1Value, factory__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                PythonObjectFactory factory__ = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
                Objects.requireNonNull(factory__, "Specialization 'classGetItem(Object, Object, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.factory_ = factory__;
                this.state_0_ = state_0 |= 1;
                return ChainBuiltins.ClassGetItemNode.classGetItem(arg0Value, arg1Value, factory__);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }
}

