/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;

public final class Signature {
    public static final Signature EMPTY = new Signature(-1, false, -1, false, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
    private final int varArgIndex;
    private final int positionalOnlyArgIndex;
    private final boolean isVarArgsMarker;
    private final boolean takesVarKeywordArgs;
    private final boolean checkEnclosingType;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] positionalParameterNames;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] keywordOnlyNames;
    private final TruffleString raiseErrorName;

    public Signature(boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames) {
        this(-1, takesVarKeywordArgs, takesVarArgs, varArgsMarker, parameterIds, keywordNames);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, varArgsMarker, parameterIds, keywordNames, false);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType) {
        this(positionOnlyArgIndex, takesVarKeywordArgs, takesVarArgs, varArgsMarker, parameterIds, keywordNames, checkEnclosingType, StringLiterals.T_EMPTY_STRING);
    }

    public Signature(int positionOnlyArgIndex, boolean takesVarKeywordArgs, int takesVarArgs, boolean varArgsMarker, TruffleString[] parameterIds, TruffleString[] keywordNames, boolean checkEnclosingType, TruffleString raiseErrorName) {
        this.positionalOnlyArgIndex = positionOnlyArgIndex;
        this.takesVarKeywordArgs = takesVarKeywordArgs;
        this.varArgIndex = takesVarArgs;
        this.isVarArgsMarker = varArgsMarker;
        this.positionalParameterNames = parameterIds != null ? parameterIds : PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
        this.keywordOnlyNames = keywordNames != null ? keywordNames : PythonUtils.EMPTY_TRUFFLESTRING_ARRAY;
        this.checkEnclosingType = checkEnclosingType;
        this.raiseErrorName = raiseErrorName;
    }

    public static Signature createVarArgsAndKwArgsOnly() {
        return new Signature(-1, true, 0, false, null, null);
    }

    public Signature createWithSelf() {
        TruffleString[] parameterIdsWithSelf = new TruffleString[this.getParameterIds().length + 1];
        parameterIdsWithSelf[0] = BuiltinNames.T_SELF;
        PythonUtils.arraycopy(this.getParameterIds(), 0, parameterIdsWithSelf, 1, parameterIdsWithSelf.length - 1);
        return new Signature(-1, this.takesVarKeywordArgs, this.varArgIndex, this.isVarArgsMarker, parameterIdsWithSelf, this.keywordOnlyNames);
    }

    public final int getNumOfRequiredKeywords() {
        return this.keywordOnlyNames.length;
    }

    public final int getMaxNumOfPositionalArgs() {
        return this.positionalParameterNames.length;
    }

    public final int getPositionalOnlyArgIndex() {
        return this.positionalOnlyArgIndex;
    }

    public final int getVarargsIdx() {
        return this.varArgIndex;
    }

    public final boolean takesVarArgs() {
        return this.varArgIndex != -1;
    }

    public final boolean isVarArgsMarker() {
        return this.isVarArgsMarker;
    }

    public final boolean takesVarKeywordArgs() {
        return this.takesVarKeywordArgs;
    }

    public final TruffleString[] getParameterIds() {
        return this.positionalParameterNames;
    }

    public final TruffleString[] getKeywordNames() {
        return this.keywordOnlyNames;
    }

    public final boolean takesKeywordArgs() {
        return this.keywordOnlyNames.length > 0 || this.takesVarKeywordArgs;
    }

    public final boolean takesRequiredKeywordArgs() {
        return this.keywordOnlyNames.length > 0;
    }

    public final boolean takesPositionalOnly() {
        return !this.takesVarArgs() && !this.takesVarKeywordArgs && !this.isVarArgsMarker && this.keywordOnlyNames.length == 0;
    }

    public final boolean takesNoArguments() {
        return this.positionalParameterNames.length == 0 && this.takesPositionalOnly();
    }

    public final boolean takesOneArgument() {
        return this.positionalParameterNames.length == 1 && this.takesPositionalOnly();
    }

    public final boolean checkEnclosingType() {
        return this.checkEnclosingType;
    }

    public final TruffleString getRaiseErrorName() {
        return this.raiseErrorName;
    }
}

