/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.frame;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.frame.FrameBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.frame.GetFrameLocalsNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFrame})
public final class FrameBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FrameBuiltinsFactory.getFactories();
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FrameClearNode
    extends PythonBuiltinNode {
        @Specialization
        Object clear(PFrame self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="f_back", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetBackrefNode
    extends PythonBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PFrame var2);

        @Specialization
        Object getBackref(VirtualFrame frame, PFrame self, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile noBackref, @Cached InlinedBranchProfile topRef, @Cached InlinedConditionProfile notMaterialized, @Cached ReadCallerFrameNode readCallerFrame) {
            PFrame cur = self;
            PFrame.Reference backref;
            while ((backref = cur.getBackref()) != PFrame.Reference.EMPTY) {
                PFrame callerFrame;
                if (backref == null) {
                    noBackref.enter(inliningTarget);
                    callerFrame = readCallerFrame.executeWith(cur.getRef(), ReadCallerFrameNode.FrameSelector.ALL_PYTHON_FRAMES, 0);
                    if (callerFrame == null) {
                        topRef.enter(inliningTarget);
                        cur.setBackref(PFrame.Reference.EMPTY);
                        return PNone.NONE;
                    }
                    backref = callerFrame.getRef();
                    cur.setBackref(backref);
                } else {
                    callerFrame = GetBackrefNode.materialize(frame, inliningTarget, readCallerFrame, backref, notMaterialized);
                }
                assert (callerFrame.getRef() == backref);
                RootNode rootNode = callerFrame.getLocation().getRootNode();
                if (rootNode != null && !rootNode.isInternal()) {
                    return callerFrame;
                }
                cur = backref.getPyFrame();
            }
            return PNone.NONE;
        }

        private static PFrame materialize(VirtualFrame frame, Node inliningTarget, ReadCallerFrameNode readCallerFrameNode, PFrame.Reference backref, InlinedConditionProfile notMaterialized) {
            if (notMaterialized.profile(inliningTarget, backref.getPyFrame() == null)) {
                PFrame caller;
                int i = 0;
                while ((caller = readCallerFrameNode.executeWith(frame, i)) != null) {
                    if (caller.getRef() == backref) {
                        assert (backref.getPyFrame() != null);
                        return caller;
                    }
                    ++i;
                }
                assert (false) : "could not find frame of backref on the stack";
            }
            return backref.getPyFrame();
        }

        @NeverDefault
        public static GetBackrefNode create() {
            return FrameBuiltinsFactory.GetBackrefNodeFactory.create(null);
        }
    }

    @Builtin(name="f_locals", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetLocalsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object getUpdating(VirtualFrame frame, PFrame self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile profile, @Cached MaterializeFrameNode materializeNode, @Cached GetFrameLocalsNode getFrameLocalsNode) {
            if (profile.profile(inliningTarget, frame != null && PArguments.getCurrentFrameInfo((Frame)frame) == self.getRef())) {
                PFrame pyFrame = materializeNode.execute(false, true, (Frame)frame);
                assert (pyFrame == self);
            }
            return getFrameLocalsNode.execute(inliningTarget, self);
        }
    }

    @Builtin(name="f_code", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCodeNode
    extends PythonBuiltinNode {
        public abstract PCode executeObject(VirtualFrame var1, PFrame var2);

        @Specialization
        static PCode get(PFrame self, @Cached PythonObjectFactory factory) {
            RootCallTarget ct = self.getTarget();
            assert (ct != null);
            return factory.createCode(ct);
        }

        @NeverDefault
        public static GetCodeNode create() {
            return FrameBuiltinsFactory.GetCodeNodeFactory.create(null);
        }
    }

    @Builtin(name="f_trace_lines", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isSetter=true, isGetter=true)
    @GenerateNodeFactory
    public static abstract class TraceLinesNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(v)"})
        static boolean doGet(PFrame self, PNone v) {
            return self.getTraceLine();
        }

        @Specialization(guards={"!isNoValue(v)"})
        static Object doSet(PFrame self, Object v, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raise, @Cached CastToJavaBooleanNode cast) {
            try {
                self.setTraceLine(cast.execute(inliningTarget, v));
            }
            catch (CannotCastException e) {
                throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTRIBUTE_VALUE_MUST_BE_BOOL);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="f_trace", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    public static abstract class GetTraceNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(v)"})
        static Object doGet(PFrame self, PNone v) {
            Object traceFun = self.getLocalTraceFun();
            return traceFun == null ? PNone.NONE : traceFun;
        }

        @Specialization(guards={"!isNoValue(v)", "!isDeleteMarker(v)"})
        static Object doSet(PFrame self, Object v) {
            self.setLocalTraceFun(v == PNone.NONE ? null : v);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(v)", "isDeleteMarker(v)"})
        static Object doDel(PFrame self, Object v) {
            self.setLocalTraceFun(null);
            return PNone.NONE;
        }
    }

    @Builtin(name="f_lasti", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetLastiNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int get(PFrame self) {
            return self.getLasti();
        }
    }

    @Builtin(name="f_lineno", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetLinenoNode
    extends PythonBuiltinNode {
        public abstract int executeInt(VirtualFrame var1, PFrame var2);

        @Specialization
        int get(VirtualFrame frame, PFrame self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isCurrentFrameProfile, @Cached MaterializeFrameNode materializeNode) {
            if (isCurrentFrameProfile.profile(inliningTarget, frame != null && PArguments.getCurrentFrameInfo((Frame)frame) == self.getRef())) {
                PFrame pyFrame = materializeNode.execute((Frame)frame, this, false, false);
                assert (pyFrame == self);
            }
            return self.getLine();
        }

        @NeverDefault
        public static GetLinenoNode create() {
            return FrameBuiltinsFactory.GetLinenoNodeFactory.create(null);
        }
    }

    @Builtin(name="f_builtins", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetBuiltinsNode
    extends PythonBuiltinNode {
        @Node.Child
        private ObjectBuiltins.DictNode dictNode = ObjectBuiltinsFactory.DictNodeGen.create();

        public abstract Object execute(VirtualFrame var1, PFrame var2);

        @Specialization
        Object get(VirtualFrame frame, PFrame self) {
            return this.dictNode.execute(frame, this.getContext().getBuiltins(), PNone.NO_VALUE);
        }

        @NeverDefault
        public static GetBuiltinsNode create() {
            return FrameBuiltinsFactory.GetBuiltinsNodeFactory.create(null);
        }
    }

    @Builtin(name="f_globals", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetGlobalsNode
    extends PythonBuiltinNode {
        @Node.Child
        private ObjectBuiltins.DictNode getDictNode;

        public abstract Object execute(VirtualFrame var1, PFrame var2);

        @Specialization
        Object get(VirtualFrame curFrame, PFrame self, @Cached PythonObjectFactory factory) {
            PythonObject globals = self.getGlobals();
            if (globals instanceof PythonModule) {
                if (this.getDictNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getDictNode = (ObjectBuiltins.DictNode)this.insert(ObjectBuiltinsFactory.DictNodeGen.create());
                }
                return this.getDictNode.execute(curFrame, globals, PNone.NO_VALUE);
            }
            return globals != null ? globals : factory.createDict();
        }

        @NeverDefault
        public static GetGlobalsNode create() {
            return FrameBuiltinsFactory.GetGlobalsNodeFactory.create(null);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, PFrame self, @Cached GetCodeNode getCodeNode, @Cached GetLinenoNode getLinenoNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            PCode code = getCodeNode.executeObject(frame, self);
            int lineno = getLinenoNode.executeInt(frame, self);
            return simpleTruffleStringFormatNode.format("<frame at 0x%s, file '%s', line %d, code %s>", PythonAbstractObject.objectHashCodeAsHexString(self), code.getFilename(), lineno, code.getName());
        }
    }
}

