/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.UnicodeDecodeErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.exception.UnicodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.UnicodeDecodeError})
public final class UnicodeDecodeErrorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnicodeDecodeErrorBuiltinsFactory.getFactories();
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyUnicodeDecodeErrorGetEncodingNode
    extends Node {
        public abstract TruffleString execute(Node var1, PBaseException var2);

        @Specialization
        static TruffleString doIt(Node inliningTarget, PBaseException exceptionObject, @Cached(inline=false) BaseExceptionAttrNode attrNode, @Cached StringNodes.CastToTruffleStringCheckedNode castToStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object obj = attrNode.get(exceptionObject, 0, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            if (obj == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_ATTRIBUTE_NOT_SET, "encoding");
            }
            return castToStringNode.cast(inliningTarget, obj, ErrorMessages.S_ATTRIBUTE_MUST_BE_UNICODE, "encoding");
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyUnicodeDecodeErrorGetEndNode
    extends Node {
        public abstract int execute(Node var1, PBaseException var2);

        @Specialization
        static int doIt(VirtualFrame frame, Node inliningTarget, PBaseException exceptionObject, @Cached PyUnicodeDecodeErrorGetObjectNode getObjectNode, @Cached(inline=false) BaseExceptionAttrNode attrNode, @Cached PyObjectSizeNode sizeNode) {
            Object obj = getObjectNode.execute(inliningTarget, exceptionObject);
            int size = sizeNode.execute((Frame)frame, inliningTarget, obj);
            int end = attrNode.getInt(exceptionObject, 3, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            if (end < 1) {
                end = 1;
            }
            if (end > size) {
                end = size;
            }
            return end;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyUnicodeDecodeErrorGetStartNode
    extends Node {
        public abstract int execute(Node var1, PBaseException var2);

        @Specialization
        static int doIt(VirtualFrame frame, Node inliningTarget, PBaseException exceptionObject, @Cached PyUnicodeDecodeErrorGetObjectNode getObjectNode, @Cached(inline=false) BaseExceptionAttrNode attrNode, @Cached PyObjectSizeNode sizeNode) {
            Object obj = getObjectNode.execute(inliningTarget, exceptionObject);
            int size = sizeNode.execute((Frame)frame, inliningTarget, obj);
            int start = attrNode.getInt(exceptionObject, 2, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            if (start < 0) {
                start = 0;
            }
            if (start >= size) {
                start = size - 1;
            }
            return start;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyUnicodeDecodeErrorGetObjectNode
    extends Node {
        public abstract Object execute(Node var1, PBaseException var2);

        @Specialization
        static Object doIt(VirtualFrame frame, Node inliningTarget, PBaseException exceptionObject, @Cached(inline=false) BaseExceptionAttrNode attrNode, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object obj = attrNode.get(exceptionObject, 1, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            if (obj == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_ATTRIBUTE_NOT_SET, "object");
            }
            if (!isSubtypeNode.execute(frame, getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PBytes)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.S_ATTRIBUTE_MUST_BE_BYTES, "object");
            }
            return obj;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class MakeDecodeExceptionNode
    extends Node {
        public abstract PBaseException execute(Node var1, PBaseException var2, TruffleString var3, Object var4, int var5, int var6, TruffleString var7);

        @Specialization(guards={"exceptionObject == null"})
        static PBaseException createNew(Node inliningTarget, PBaseException exceptionObject, TruffleString encoding, Object inputObject, int startPos, int endPos, TruffleString reason, @Cached(inline=false) CallNode callNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object obj = callNode.execute((Object)PythonErrorType.UnicodeDecodeError, encoding, inputObject, startPos, endPos, reason);
            if (obj instanceof PBaseException) {
                PBaseException exception = (PBaseException)obj;
                return exception;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_HAVE_RETURNED_EXCEPTION, new Object[]{PythonErrorType.UnicodeDecodeError, obj});
        }

        @Specialization(guards={"exceptionObject != null"})
        static PBaseException updateProvided(PBaseException exceptionObject, TruffleString encoding, Object inputObject, int startPos, int endPos, TruffleString reason, @Cached(inline=false) BaseExceptionAttrNode attrNode) {
            attrNode.set(exceptionObject, startPos, 2, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            attrNode.set(exceptionObject, endPos, 3, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            attrNode.set(exceptionObject, reason, 4, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            return exceptionObject;
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class UnicodeEncodeErrorStrNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        TruffleString str(VirtualFrame frame, PBaseException self, @Bind(value="this") Node inliningTarget, @Cached BaseExceptionAttrNode attrNode, @Cached SequenceStorageNodes.GetItemNode getitemNode, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            if (self.getExceptionAttributes() == null) {
                return StringLiterals.T_EMPTY_STRING;
            }
            PBytesLike object = (PBytesLike)attrNode.get(self, 1, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            int start = attrNode.getInt(self, 2, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            int end = attrNode.getInt(self, 3, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
            TruffleString encoding = strNode.execute((Frame)frame, inliningTarget, attrNode.get(self, 0, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY));
            TruffleString reason = strNode.execute((Frame)frame, inliningTarget, attrNode.get(self, 4, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY));
            if (start < object.getSequenceStorage().length() && end == start + 1) {
                int b = getitemNode.executeKnownInt(object.getSequenceStorage(), start);
                String bStr = PythonUtils.formatJString("%02x", b);
                return simpleTruffleStringFormatNode.format("'%s' codec can't decode byte 0x%s in position %d: %s", encoding, bStr, start, reason);
            }
            return simpleTruffleStringFormatNode.format("'%s' codec can't decode bytes in position %d-%d: %s", encoding, start, end - 1, reason);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class UnicodeDecodeErrorInitNode
    extends PythonBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PBaseException var2, Object[] var3);

        @Specialization
        static Object initNoArgs(VirtualFrame frame, PBaseException self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached UnicodeErrorBuiltins.GetArgAsBytesNode getArgAsBytesNode, @Cached CastToTruffleStringNode toStringNode, @Cached CastToJavaIntExactNode toJavaIntExactNode, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseInitNode, @Cached PRaiseNode.Lazy raiseNode) {
            baseInitNode.execute(self, args);
            self.setExceptionAttributes(new Object[]{UnicodeErrorBuiltins.getArgAsString(inliningTarget, args, 0, raiseNode, toStringNode), UnicodeErrorBuiltins.getArgAsBytes(frame, inliningTarget, args, 1, raiseNode, getArgAsBytesNode), UnicodeErrorBuiltins.getArgAsInt(inliningTarget, args, 2, raiseNode, toJavaIntExactNode), UnicodeErrorBuiltins.getArgAsInt(inliningTarget, args, 3, raiseNode, toJavaIntExactNode), UnicodeErrorBuiltins.getArgAsString(inliningTarget, args, 4, raiseNode, toStringNode)});
            return PNone.NONE;
        }
    }
}

