/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.jni;

import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyData;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIContext;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import sun.misc.Unsafe;

abstract class GraalHPyJNINodes {
    private GraalHPyJNINodes() {
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyJNIAsCharPointerNode
    extends GraalHPyNodes.HPyAsCharPointerNode {
        HPyJNIAsCharPointerNode() {
        }

        abstract long executeLong(GraalHPyContext var1, TruffleString var2, TruffleString.Encoding var3);

        @Specialization
        static long doGeneric(GraalHPyContext hpyContext, TruffleString string, TruffleString.Encoding encoding, @Bind(value="this") Node inliningTarget, @Cached InlinedExactClassProfile classProfile, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.AsNativeNode asNativeNode, @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode) {
            TruffleString tsEncoded = switchEncodingNode.execute((AbstractTruffleString)string, encoding);
            TruffleString tsNative = asNativeNode.execute(tsEncoded, GraalHPyJNIContext.TS_NATIVE_ALLOCATOR, encoding, false, true);
            Object profiledInteropPointer = classProfile.profile(inliningTarget, getInternalNativePointerNode.execute((AbstractTruffleString)tsNative, encoding));
            if (profiledInteropPointer instanceof NativePointer) {
                NativePointer nativePointer = (NativePointer)profiledInteropPointer;
                return nativePointer.asPointer();
            }
            return HPyJNIAsCharPointerNode.interopPointerToNative(profiledInteropPointer);
        }

        @CompilerDirectives.TruffleBoundary
        private static long interopPointerToNative(Object object) {
            return GraalHPyJNIContext.interopPointerToNative(object, InteropLibrary.getUncached((Object)object));
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyJNIFromCharPointerNode
    extends GraalHPyNodes.HPyFromCharPointerNode {
        HPyJNIFromCharPointerNode() {
        }

        @Specialization
        static TruffleString doLong(GraalHPyContext hpyContext, long charPtr, int n, TruffleString.Encoding encoding, boolean copy, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile lengthProfile, @Cached.Exclusive @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Exclusive @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            int length = lengthProfile.profile(inliningTarget, n < 0) ? HPyJNIFromCharPointerNode.strlen(charPtr) : n;
            return HPyJNIFromCharPointerNode.read(new NativePointer(charPtr), length, encoding, copy, fromNativePointerNode, switchEncodingNode);
        }

        @Specialization
        static TruffleString doNativePointer(GraalHPyContext hpyContext, NativePointer charPtr, int n, TruffleString.Encoding encoding, boolean copy, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile lengthProfile, @Cached.Exclusive @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Exclusive @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            int length = lengthProfile.profile(inliningTarget, n < 0) ? HPyJNIFromCharPointerNode.strlen(charPtr.asPointer()) : n;
            return HPyJNIFromCharPointerNode.read(charPtr, length, encoding, copy, fromNativePointerNode, switchEncodingNode);
        }

        @Specialization(replaces={"doLong", "doNativePointer"})
        static TruffleString doGeneric(GraalHPyContext hpyContext, Object charPtr, int n, TruffleString.Encoding encoding, boolean copy, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary lib, @Cached.Exclusive @Cached InlinedConditionProfile lengthProfile, @Cached.Exclusive @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Exclusive @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            long lcharPtr;
            Object interopPtr;
            if (charPtr instanceof Long) {
                Long ltmp = (Long)charPtr;
                interopPtr = new NativePointer(ltmp);
                lcharPtr = ltmp;
            } else if (charPtr instanceof NativePointer) {
                NativePointer nativeCharPtr = (NativePointer)charPtr;
                interopPtr = nativeCharPtr;
                lcharPtr = nativeCharPtr.asPointer();
            } else {
                try {
                    interopPtr = charPtr;
                    lcharPtr = lib.asPointer(charPtr);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            int length = lengthProfile.profile(inliningTarget, n < 0) ? HPyJNIFromCharPointerNode.strlen(lcharPtr) : n;
            return HPyJNIFromCharPointerNode.read(interopPtr, length, encoding, copy, fromNativePointerNode, switchEncodingNode);
        }

        private static TruffleString read(Object charPtr, int length, TruffleString.Encoding encoding, boolean copy, TruffleString.FromNativePointerNode fromNativePointerNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
            assert (length >= 0);
            TruffleString result = fromNativePointerNode.execute(charPtr, 0, length, encoding, copy);
            if (PythonUtils.TS_ENCODING != encoding) {
                return switchEncodingNode.execute((AbstractTruffleString)result, PythonUtils.TS_ENCODING);
            }
            return result;
        }

        static int strlen(long charPtr) {
            int length = 0;
            while (CArrayWrappers.UNSAFE.getByte(charPtr + (long)length) != 0) {
                ++length;
            }
            return length;
        }
    }

    static final class UnsafeWriteSizeTNode
    extends GraalHPyCAccess.WriteSizeTNode {
        static final UnsafeWriteSizeTNode UNCACHED = new UnsafeWriteSizeTNode();

        private UnsafeWriteSizeTNode() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object basePointer, long offset, long valuePointer) {
            UnsafeWriteSizeTNode.write(GraalHPyJNIContext.coerceToPointer(basePointer) + offset, valuePointer);
        }

        static void write(long address, long value) {
            CArrayWrappers.UNSAFE.putAddress(address, value);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeWritePointerNode
    extends GraalHPyCAccess.WritePointerNode {
        static final UnsafeWritePointerNode UNCACHED = new UnsafeWritePointerNode();

        private UnsafeWritePointerNode() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object basePointer, long offset, Object valuePointer) {
            CArrayWrappers.UNSAFE.putAddress(GraalHPyJNIContext.coerceToPointer(basePointer) + offset, GraalHPyJNIContext.coerceToPointer(valuePointer));
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeWriteHPyFieldNode
    extends GraalHPyCAccess.WriteHPyFieldNode {
        static final UnsafeWriteHPyFieldNode UNCACHED = new UnsafeWriteHPyFieldNode();

        private UnsafeWriteHPyFieldNode() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, PythonObject owner, Object pointer, long offset, Object value) {
            int newValue;
            long address = GraalHPyJNIContext.coerceToPointer(pointer) + offset;
            long loldValue = CArrayWrappers.UNSAFE.getAddress(address);
            if (!PInt.isIntRange(loldValue)) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            int oldValue = (int)loldValue;
            if ((value != GraalHPyHandle.NULL_HANDLE_DELEGATE || oldValue != 0) && oldValue != (newValue = GraalHPyData.setHPyField(owner, value, oldValue))) {
                CArrayWrappers.UNSAFE.putAddress(address, newValue);
            }
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeWriteHPyNode
    extends GraalHPyCAccess.WriteHPyNode {
        static final UnsafeWriteHPyNode UNCACHED = new UnsafeWriteHPyNode();

        private UnsafeWriteHPyNode() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object pointer, long offset, Object value) {
            long bits = ctx.pythonObjectAsBits(value);
            CArrayWrappers.UNSAFE.putAddress(GraalHPyJNIContext.coerceToPointer(pointer) + offset, bits);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeWriteGenericNode
    extends GraalHPyCAccess.WriteGenericNode {
        static final UnsafeWriteGenericNode UNCACHED = new UnsafeWriteGenericNode();

        private UnsafeWriteGenericNode() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType type, long value) {
            long addr = GraalHPyJNIContext.coerceToPointer(pointer) + offset;
            switch (switch (type) {
                case HPyContextSignatureType.Int8_t, HPyContextSignatureType.Uint8_t, HPyContextSignatureType.Bool -> 1;
                case HPyContextSignatureType.Int16_t, HPyContextSignatureType.Uint16_t -> 2;
                case HPyContextSignatureType.Int32_t, HPyContextSignatureType.Uint32_t -> 4;
                case HPyContextSignatureType.Int64_t, HPyContextSignatureType.Uint64_t -> 8;
                default -> ctx.getCTypeSize(type);
            }) {
                case 1: {
                    CArrayWrappers.UNSAFE.putByte(addr, (byte)value);
                    break;
                }
                case 2: {
                    CArrayWrappers.UNSAFE.putShort(addr, (short)value);
                    break;
                }
                case 4: {
                    CArrayWrappers.UNSAFE.putInt(addr, (int)value);
                    break;
                }
                case 8: {
                    CArrayWrappers.UNSAFE.putLong(addr, value);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType type, Object value) {
            long addr = GraalHPyJNIContext.coerceToPointer(pointer) + offset;
            block0 : switch (type) {
                case Int8_t: 
                case Uint8_t: 
                case Bool: {
                    CArrayWrappers.UNSAFE.putByte(addr, (Byte)value);
                    break;
                }
                case Int16_t: 
                case Uint16_t: {
                    CArrayWrappers.UNSAFE.putShort(addr, (Short)value);
                    break;
                }
                case Int32_t: 
                case Uint32_t: {
                    CArrayWrappers.UNSAFE.putInt(addr, (Integer)value);
                    break;
                }
                case Int64_t: 
                case Uint64_t: {
                    CArrayWrappers.UNSAFE.putLong(addr, (Long)value);
                    break;
                }
                case CFloat: {
                    CArrayWrappers.UNSAFE.putFloat(addr, ((Float)value).floatValue());
                    break;
                }
                case CDouble: {
                    CArrayWrappers.UNSAFE.putDouble(addr, (Double)value);
                    break;
                }
                case HPyContextPtr: 
                case VoidPtr: 
                case VoidPtrPtr: 
                case HPyPtr: 
                case ConstHPyPtr: 
                case Wchar_tPtr: 
                case ConstWchar_tPtr: 
                case CharPtr: 
                case ConstCharPtr: 
                case DataPtr: 
                case DataPtrPtr: 
                case Cpy_PyObjectPtr: 
                case HPyModuleDefPtr: 
                case HPyType_SpecPtr: 
                case HPyType_SpecParamPtr: 
                case HPyDefPtr: 
                case HPyFieldPtr: 
                case HPyGlobalPtr: 
                case HPyCapsule_DestructorPtr: 
                case PyType_SlotPtr: {
                    CArrayWrappers.UNSAFE.putAddress(addr, (Long)value);
                    break;
                }
                default: {
                    int size = ctx.getCTypeSize(type);
                    switch (size) {
                        case 1: {
                            CArrayWrappers.UNSAFE.putByte(addr, (Byte)value);
                            break block0;
                        }
                        case 2: {
                            CArrayWrappers.UNSAFE.putShort(addr, (Short)value);
                            break block0;
                        }
                        case 4: {
                            CArrayWrappers.UNSAFE.putInt(addr, (Integer)value);
                            break block0;
                        }
                        case 8: {
                            CArrayWrappers.UNSAFE.putLong(addr, (Long)value);
                            break block0;
                        }
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeWriteDoubleNode
    extends GraalHPyCAccess.WriteDoubleNode {
        static final UnsafeWriteDoubleNode UNCACHED = new UnsafeWriteDoubleNode();

        private UnsafeWriteDoubleNode() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object pointer, long offset, double value) {
            CArrayWrappers.UNSAFE.putDouble(GraalHPyJNIContext.coerceToPointer(pointer) + offset, value);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeWriteI64Node
    extends GraalHPyCAccess.WriteI64Node {
        static final UnsafeWriteI64Node UNCACHED = new UnsafeWriteI64Node();

        private UnsafeWriteI64Node() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object pointer, long offset, long value) {
            CArrayWrappers.UNSAFE.putLong(GraalHPyJNIContext.coerceToPointer(pointer) + offset, value);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeWriteI32Node
    extends GraalHPyCAccess.WriteI32Node {
        static final UnsafeWriteI32Node UNCACHED = new UnsafeWriteI32Node();

        private UnsafeWriteI32Node() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object pointer, long offset, int value) {
            CArrayWrappers.UNSAFE.putInt(GraalHPyJNIContext.coerceToPointer(pointer) + offset, value);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadGenericNode
    extends GraalHPyCAccess.ReadGenericNode {
        static final UnsafeReadGenericNode UNCACHED = new UnsafeReadGenericNode();

        private UnsafeReadGenericNode() {
        }

        @Override
        protected Object execute(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType type) {
            long addr = GraalHPyJNIContext.coerceToPointer(pointer) + offset;
            switch (type) {
                case Int8_t: 
                case Uint8_t: 
                case Bool: {
                    return CArrayWrappers.UNSAFE.getByte(addr);
                }
                case Int16_t: 
                case Uint16_t: {
                    return CArrayWrappers.UNSAFE.getShort(addr);
                }
                case Int32_t: 
                case Uint32_t: {
                    return CArrayWrappers.UNSAFE.getInt(addr);
                }
                case Int64_t: 
                case Uint64_t: {
                    return CArrayWrappers.UNSAFE.getLong(addr);
                }
                case CFloat: {
                    return Float.valueOf(CArrayWrappers.UNSAFE.getFloat(addr));
                }
                case CDouble: {
                    return CArrayWrappers.UNSAFE.getDouble(addr);
                }
                case HPyContextPtr: 
                case VoidPtr: 
                case VoidPtrPtr: 
                case HPyPtr: 
                case ConstHPyPtr: 
                case Wchar_tPtr: 
                case ConstWchar_tPtr: 
                case CharPtr: 
                case ConstCharPtr: 
                case DataPtr: 
                case DataPtrPtr: 
                case Cpy_PyObjectPtr: 
                case HPyModuleDefPtr: 
                case HPyType_SpecPtr: 
                case HPyType_SpecParamPtr: 
                case HPyDefPtr: 
                case HPyFieldPtr: 
                case HPyGlobalPtr: 
                case HPyCapsule_DestructorPtr: 
                case PyType_SlotPtr: {
                    return CArrayWrappers.UNSAFE.getAddress(addr);
                }
            }
            int size = ctx.getCTypeSize(type);
            switch (size) {
                case 1: {
                    return CArrayWrappers.UNSAFE.getByte(addr);
                }
                case 2: {
                    return CArrayWrappers.UNSAFE.getShort(addr);
                }
                case 4: {
                    return CArrayWrappers.UNSAFE.getInt(addr);
                }
                case 8: {
                    return CArrayWrappers.UNSAFE.getLong(addr);
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        protected int executeInt(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType type) {
            return (int)this.executeLong(ctx, pointer, offset, type);
        }

        @Override
        protected long executeLong(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType type) {
            long addr = GraalHPyJNIContext.coerceToPointer(pointer) + offset;
            switch (switch (type) {
                case HPyContextSignatureType.Int8_t, HPyContextSignatureType.Uint8_t, HPyContextSignatureType.Bool -> 1;
                case HPyContextSignatureType.Int16_t, HPyContextSignatureType.Uint16_t -> 2;
                case HPyContextSignatureType.Int32_t, HPyContextSignatureType.Uint32_t -> 4;
                case HPyContextSignatureType.Int64_t, HPyContextSignatureType.Uint64_t -> 8;
                default -> ctx.getCTypeSize(type);
            }) {
                case 1: {
                    return CArrayWrappers.UNSAFE.getByte(addr);
                }
                case 2: {
                    return CArrayWrappers.UNSAFE.getShort(addr);
                }
                case 4: {
                    return CArrayWrappers.UNSAFE.getInt(addr);
                }
                case 8: {
                    return CArrayWrappers.UNSAFE.getLong(addr);
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadPointerNode
    extends GraalHPyCAccess.ReadPointerNode {
        static final UnsafeReadPointerNode UNCACHED = new UnsafeReadPointerNode();

        private UnsafeReadPointerNode() {
        }

        @Override
        protected Object execute(GraalHPyContext ctx, Object pointer, long offset) {
            return CArrayWrappers.UNSAFE.getAddress(GraalHPyJNIContext.coerceToPointer(pointer) + offset);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadDoubleNode
    extends GraalHPyCAccess.ReadDoubleNode {
        static final UnsafeReadDoubleNode UNCACHED = new UnsafeReadDoubleNode();

        private UnsafeReadDoubleNode() {
        }

        @Override
        protected double execute(GraalHPyContext ctx, Object pointer, long offset) {
            return CArrayWrappers.UNSAFE.getDouble(GraalHPyJNIContext.coerceToPointer(pointer) + offset);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadFloatNode
    extends GraalHPyCAccess.ReadFloatNode {
        static final UnsafeReadFloatNode UNCACHED = new UnsafeReadFloatNode();

        private UnsafeReadFloatNode() {
        }

        @Override
        protected double execute(GraalHPyContext ctx, Object pointer, long offset) {
            return CArrayWrappers.UNSAFE.getFloat(GraalHPyJNIContext.coerceToPointer(pointer) + offset);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadI64Node
    extends GraalHPyCAccess.ReadI64Node {
        static final UnsafeReadI64Node UNCACHED = new UnsafeReadI64Node();

        private UnsafeReadI64Node() {
        }

        @Override
        protected long execute(GraalHPyContext ctx, Object pointer, long offset) {
            return CArrayWrappers.UNSAFE.getLong(GraalHPyJNIContext.coerceToPointer(pointer) + offset);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadI32Node
    extends GraalHPyCAccess.ReadI32Node {
        static final UnsafeReadI32Node UNCACHED = new UnsafeReadI32Node();

        private UnsafeReadI32Node() {
        }

        @Override
        protected int execute(GraalHPyContext ctx, Object pointer, long offset) {
            return CArrayWrappers.UNSAFE.getInt(GraalHPyJNIContext.coerceToPointer(pointer) + offset);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadHPyArrayNode
    extends GraalHPyCAccess.ReadHPyArrayNode {
        static final UnsafeReadHPyArrayNode UNCACHED = new UnsafeReadHPyArrayNode();

        private UnsafeReadHPyArrayNode() {
        }

        @Override
        protected Object[] execute(GraalHPyContext ctx, Object pointer, long offset, long n) {
            if (!PInt.isIntRange(n)) {
                throw CompilerDirectives.shouldNotReachHere((String)"cannot fit long into int");
            }
            long basePtr = GraalHPyJNIContext.coerceToPointer(pointer);
            Object[] result = new Object[(int)n];
            for (int i = 0; i < result.length; ++i) {
                result[i] = ctx.bitsAsPythonObject(CArrayWrappers.UNSAFE.getAddress(basePtr + ((long)i + offset) * (long)CArrayWrappers.UNSAFE.addressSize()));
            }
            return result;
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadHPyFieldNode
    extends GraalHPyCAccess.ReadHPyFieldNode {
        static final UnsafeReadHPyFieldNode UNCACHED = new UnsafeReadHPyFieldNode();

        private UnsafeReadHPyFieldNode() {
        }

        @Override
        protected Object execute(GraalHPyContext ctx, PythonObject owner, Object pointer, long offset, boolean close) {
            assert (ctx.getCTypeSize(HPyContextSignatureType.HPy) == CArrayWrappers.UNSAFE.addressSize());
            long bits = CArrayWrappers.UNSAFE.getAddress(GraalHPyJNIContext.coerceToPointer(pointer) + offset);
            if (!PInt.isIntRange(bits)) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            int idx = (int)bits;
            if (idx == 0) {
                return GraalHPyHandle.NULL_HANDLE_DELEGATE;
            }
            return GraalHPyData.getHPyField(owner, idx);
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadHPyNode
    extends GraalHPyCAccess.ReadHPyNode {
        static final UnsafeReadHPyNode UNCACHED = new UnsafeReadHPyNode();

        private UnsafeReadHPyNode() {
        }

        @Override
        protected Object execute(GraalHPyContext ctx, Object pointer, long offset, boolean close) {
            assert (ctx.getCTypeSize(HPyContextSignatureType.HPy) == CArrayWrappers.UNSAFE.addressSize());
            long bits = CArrayWrappers.UNSAFE.getAddress(GraalHPyJNIContext.coerceToPointer(pointer) + offset);
            Object result = ctx.bitsAsPythonObject(bits);
            if (close && GraalHPyBoxing.isBoxedHandle(bits)) {
                ctx.releaseHPyHandleForObject(GraalHPyBoxing.unboxHandle(bits));
            }
            return result;
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeReadI8ArrayNode
    extends GraalHPyCAccess.ReadI8ArrayNode {
        static final UnsafeReadI8ArrayNode UNCACHED = new UnsafeReadI8ArrayNode();

        private UnsafeReadI8ArrayNode() {
        }

        @Override
        protected byte[] execute(GraalHPyContext ctx, Object pointer, long offset, long n) {
            if (!PInt.isIntRange(n)) {
                throw CompilerDirectives.shouldNotReachHere((String)"cannot fit long into int");
            }
            byte[] result = new byte[(int)n];
            long ptr = GraalHPyJNIContext.coerceToPointer(pointer) + offset;
            CArrayWrappers.UNSAFE.copyMemory(null, ptr, result, Unsafe.ARRAY_BYTE_BASE_OFFSET, n);
            return result;
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeGetElementPtrNode
    extends GraalHPyCAccess.GetElementPtrNode {
        static final UnsafeGetElementPtrNode UNCACHED = new UnsafeGetElementPtrNode();

        private UnsafeGetElementPtrNode() {
        }

        @Override
        public Object execute(GraalHPyContext ctx, Object pointer, long offset) {
            return GraalHPyJNIContext.coerceToPointer(pointer) + offset;
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeBulkFreeHandleReferencesNode
    extends GraalHPyCAccess.BulkFreeHandleReferencesNode {
        private static final int BULK_CAPACITY = 1024;
        static final UnsafeBulkFreeHandleReferencesNode UNCACHED = new UnsafeBulkFreeHandleReferencesNode();

        private UnsafeBulkFreeHandleReferencesNode() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected void execute(GraalHPyContext ctx, GraalHPyContext.GraalHPyHandleReference[] references) {
            long[] nativeSpacePtrs = new long[1024];
            long[] destroyFuncPtrs = new long[1024];
            int i = 0;
            for (GraalHPyContext.GraalHPyHandleReference ref : references) {
                long destroyFunPtr = GraalHPyJNIContext.coerceToPointer(ref.getDestroyFunc());
                long nativeSpacePtr = GraalHPyJNIContext.coerceToPointer(ref.getNativeSpace());
                if (destroyFunPtr == 0L) {
                    CArrayWrappers.UNSAFE.freeMemory(nativeSpacePtr);
                    continue;
                }
                if (i >= 1024) {
                    GraalHPyJNIContext.bulkFreeNativeSpace(nativeSpacePtrs, destroyFuncPtrs, 1024);
                    i = 0;
                }
                destroyFuncPtrs[i] = destroyFunPtr;
                nativeSpacePtrs[i] = nativeSpacePtr;
                ++i;
            }
            if (i > 0) {
                GraalHPyJNIContext.bulkFreeNativeSpace(nativeSpacePtrs, destroyFuncPtrs, i);
            }
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeFreeNode
    extends GraalHPyCAccess.FreeNode {
        static final UnsafeFreeNode UNCACHED = new UnsafeFreeNode();

        private UnsafeFreeNode() {
        }

        @Override
        protected void execute(GraalHPyContext ctx, Object pointer) {
            CArrayWrappers.UNSAFE.freeMemory(GraalHPyJNIContext.coerceToPointer(pointer));
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeAllocateNode
    extends GraalHPyCAccess.AllocateNode {
        static final UnsafeAllocateNode UNCACHED = new UnsafeAllocateNode();

        private UnsafeAllocateNode() {
        }

        @Override
        protected Object execute(GraalHPyContext ctx, long size, boolean zero) {
            long result = CArrayWrappers.UNSAFE.allocateMemory(size);
            if (zero) {
                CArrayWrappers.UNSAFE.setMemory(result, size, (byte)0);
            }
            return result;
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    static final class UnsafeIsNullNode
    extends GraalHPyCAccess.IsNullNode {
        static final UnsafeIsNullNode UNCACHED = new UnsafeIsNullNode();

        private UnsafeIsNullNode() {
        }

        @Override
        protected boolean execute(GraalHPyContext ctx, Object pointer) {
            return GraalHPyJNIContext.coerceToPointer(pointer) == 0L;
        }

        public NodeCost getCost() {
            return NodeCost.POLYMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

