/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public abstract class GraalHPyDef {
    public static final HiddenKey TYPE_HPY_ITEMSIZE = new HiddenKey("hpy_itemsize");
    public static final HiddenKey TYPE_HPY_FLAGS = new HiddenKey("hpy_flags");
    public static final HiddenKey TYPE_HPY_BUILTIN_SHAPE = new HiddenKey("hpy_builtin_shape");
    public static final int HPY_DEF_KIND_SLOT = 1;
    public static final int HPY_DEF_KIND_METH = 2;
    public static final int HPY_DEF_KIND_MEMBER = 3;
    public static final int HPY_DEF_KIND_GETSET = 4;
    public static final int HPY_MEMBER_SHORT = 0;
    public static final int HPY_MEMBER_INT = 1;
    public static final int HPY_MEMBER_LONG = 2;
    public static final int HPY_MEMBER_FLOAT = 3;
    public static final int HPY_MEMBER_DOUBLE = 4;
    public static final int HPY_MEMBER_STRING = 5;
    public static final int HPY_MEMBER_OBJECT = 6;
    public static final int HPY_MEMBER_CHAR = 7;
    public static final int HPY_MEMBER_BYTE = 8;
    public static final int HPY_MEMBER_UBYTE = 9;
    public static final int HPY_MEMBER_USHORT = 10;
    public static final int HPY_MEMBER_UINT = 11;
    public static final int HPY_MEMBER_ULONG = 12;
    public static final int HPY_MEMBER_STRING_INPLACE = 13;
    public static final int HPY_MEMBER_BOOL = 14;
    public static final int HPY_MEMBER_OBJECT_EX = 16;
    public static final int HPY_MEMBER_LONGLONG = 17;
    public static final int HPY_MEMBER_ULONGLONG = 18;
    public static final int HPY_MEMBER_HPYSSIZET = 19;
    public static final int HPY_MEMBER_NONE = 20;
    public static final int HPyType_SPEC_PARAM_BASE = 1;
    public static final int HPyType_SPEC_PARAM_BASES_TUPLE = 2;
    public static final int HPyType_SPEC_PARAM_METACLASS = 3;
    public static final long _Py_TPFLAGS_HEAPTYPE = 512L;
    public static final long HPy_TPFLAGS_BASETYPE = 1024L;
    public static final long HPy_TPFLAGS_HAVE_GC = 16384L;
    public static final long HPy_TPFLAGS_DEFAULT = 512L;
    public static final int HPyType_BUILTIN_SHAPE_LEGACY = -1;
    public static final int HPyType_BUILTIN_SHAPE_OBJECT = 0;
    public static final int HPyType_BUILTIN_SHAPE_TYPE = 1;
    public static final int HPyType_BUILTIN_SHAPE_LONG = 2;
    public static final int HPyType_BUILTIN_SHAPE_FLOAT = 3;
    public static final int HPyType_BUILTIN_SHAPE_UNICODE = 4;
    public static final int HPyType_BUILTIN_SHAPE_TUPLE = 5;
    public static final int HPyType_BUILTIN_SHAPE_LIST = 6;

    public static boolean isValidBuiltinShape(int i) {
        return -1 <= i && i <= 6;
    }

    public static int getBuiltinShapeFromHiddenAttribute(Object object) {
        if (object instanceof PythonClass) {
            PythonClass pythonClass = (PythonClass)object;
            return pythonClass.getBuiltinShape();
        }
        if (object instanceof PythonAbstractNativeObject) {
            assert (TypeNodes.IsTypeNode.executeUncached(object));
            return -1;
        }
        return -2;
    }

    static PythonBuiltinClassType getBuiltinClassType(int builtinShape) {
        return switch (builtinShape) {
            case -1, 0 -> PythonBuiltinClassType.PythonObject;
            case 1 -> PythonBuiltinClassType.PythonClass;
            case 2 -> PythonBuiltinClassType.PInt;
            case 3 -> PythonBuiltinClassType.PFloat;
            case 4 -> PythonBuiltinClassType.PString;
            case 5 -> PythonBuiltinClassType.PTuple;
            case 6 -> PythonBuiltinClassType.PList;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid built-in shape");
        };
    }

    static final class HPySlot
    extends Enum<HPySlot> {
        public static final /* enum */ HPySlot HPY_BF_GETBUFFER = new HPySlot(1, HPySlotWrapper.GETBUFFER, TypeBuiltins.TYPE_GETBUFFER);
        public static final /* enum */ HPySlot HPY_BF_RELEASEBUFFER = new HPySlot(2, HPySlotWrapper.RELEASEBUFFER, TypeBuiltins.TYPE_RELEASEBUFFER);
        public static final /* enum */ HPySlot HPY_MP_ASS_SUBSCRRIPT = new HPySlot(3, HPySlotWrapper.OBJOBJARGPROC, SpecialMethodNames.T___SETITEM__, SpecialMethodNames.T___DELITEM__);
        public static final /* enum */ HPySlot HPY_MP_LENGTH = new HPySlot(4, HPySlotWrapper.LENFUNC, SpecialMethodNames.T___LEN__);
        public static final /* enum */ HPySlot HPY_MP_SUBSCRIPT = new HPySlot(5, HPySlotWrapper.BINARYFUNC, SpecialMethodNames.T___GETITEM__);
        public static final /* enum */ HPySlot HPY_NB_ABSOLUTE = new HPySlot(6, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___ABS__);
        public static final /* enum */ HPySlot HPY_NB_ADD = new HPySlot(7, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___ADD__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RADD__);
        public static final /* enum */ HPySlot HPY_NB_AND = new HPySlot(8, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___AND__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RAND__);
        public static final /* enum */ HPySlot HPY_NB_BOOL = new HPySlot(9, HPySlotWrapper.INQUIRYPRED, SpecialMethodNames.T___BOOL__);
        public static final /* enum */ HPySlot HPY_NB_DIVMOD = new HPySlot(10, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___DIVMOD__);
        public static final /* enum */ HPySlot HPY_NB_FLOAT = new HPySlot(11, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___FLOAT__);
        public static final /* enum */ HPySlot HPY_NB_FLOOR_DIVIDE = new HPySlot(12, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___FLOORDIV__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RFLOORDIV__);
        public static final /* enum */ HPySlot HPY_NB_INDEX = new HPySlot(13, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___INDEX__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_ADD = new HPySlot(14, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IADD__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_AND = new HPySlot(15, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IAND__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_FLOOR_DIVIDE = new HPySlot(16, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IFLOORDIV__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_LSHIFT = new HPySlot(17, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___ILSHIFT__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_MULTIPLY = new HPySlot(18, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IMUL__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_OR = new HPySlot(19, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IOR__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_POWER = new HPySlot(20, HPySlotWrapper.TERNARYFUNC, SpecialMethodNames.T___IPOW__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_REMAINDER = new HPySlot(21, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IMOD__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_RSHIFT = new HPySlot(22, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IRSHIFT__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_SUBTRACT = new HPySlot(23, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___ISUB__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_TRUE_DIVIDE = new HPySlot(24, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___ITRUEDIV__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_XOR = new HPySlot(25, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IXOR__);
        public static final /* enum */ HPySlot HPY_NB_INT = new HPySlot(26, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___INT__);
        public static final /* enum */ HPySlot HPY_NB_INVERT = new HPySlot(27, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___INVERT__);
        public static final /* enum */ HPySlot HPY_NB_LSHIFT = new HPySlot(28, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___LSHIFT__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RLSHIFT__);
        public static final /* enum */ HPySlot HPY_NB_MULTIPLY = new HPySlot(29, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___MUL__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RMUL__);
        public static final /* enum */ HPySlot HPY_NB_NEGATIVE = new HPySlot(30, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___NEG__);
        public static final /* enum */ HPySlot HPY_NB_OR = new HPySlot(31, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___OR__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___ROR__);
        public static final /* enum */ HPySlot HPY_NB_POSITIVE = new HPySlot(32, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___POS__);
        public static final /* enum */ HPySlot HPY_NB_POWER = new HPySlot(33, HPySlotWrapper.TERNARYFUNC, SpecialMethodNames.T___POW__);
        public static final /* enum */ HPySlot HPY_NB_REMAINDER = new HPySlot(34, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___MOD__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RMOD__);
        public static final /* enum */ HPySlot HPY_NB_RSHIFT = new HPySlot(35, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___RSHIFT__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RRSHIFT__);
        public static final /* enum */ HPySlot HPY_NB_SUBTRACT = new HPySlot(36, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___SUB__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RSUB__);
        public static final /* enum */ HPySlot HPY_NB_TRUE_DIVIDE = new HPySlot(37, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___TRUEDIV__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RTRUEDIV__);
        public static final /* enum */ HPySlot HPY_NB_XOR = new HPySlot(38, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___XOR__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RXOR__);
        public static final /* enum */ HPySlot HPY_SQ_ASS_ITEM = new HPySlot(39, HPySlotWrapper.SQ_SETITEM, SpecialMethodNames.T___SETITEM__, HPySlotWrapper.SQ_DELITEM, SpecialMethodNames.T___DELITEM__);
        public static final /* enum */ HPySlot HPY_SQ_CONCAT = new HPySlot(40, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___ADD__);
        public static final /* enum */ HPySlot HPY_SQ_CONTAINS = new HPySlot(41, HPySlotWrapper.OBJOBJPROC, SpecialMethodNames.T___CONTAINS__);
        public static final /* enum */ HPySlot HPY_SQ_INPLACE_CONCAT = new HPySlot(42, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IADD__);
        public static final /* enum */ HPySlot HPY_SQ_INPLACE_REPEAT = new HPySlot(43, HPySlotWrapper.INDEXARGFUNC, SpecialMethodNames.T___IMUL__);
        public static final /* enum */ HPySlot HPY_SQ_ITEM = new HPySlot(44, HPySlotWrapper.SQ_ITEM, SpecialMethodNames.T___GETITEM__);
        public static final /* enum */ HPySlot HPY_SQ_LENGTH = new HPySlot(45, HPySlotWrapper.LENFUNC, SpecialMethodNames.T___LEN__);
        public static final /* enum */ HPySlot HPY_SQ_REPEAT = new HPySlot(46, HPySlotWrapper.INDEXARGFUNC, SpecialMethodNames.T___MUL__, SpecialMethodNames.T___RMUL__);
        public static final /* enum */ HPySlot HPY_TP_CALL = new HPySlot(50, HPySlotWrapper.CALL, SpecialMethodNames.T___CALL__);
        public static final /* enum */ HPySlot HPY_TP_HASH = new HPySlot(59, HPySlotWrapper.HASHFUNC, SpecialMethodNames.T___HASH__);
        public static final /* enum */ HPySlot HPY_TP_INIT = new HPySlot(60, HPySlotWrapper.INIT, SpecialMethodNames.T___INIT__);
        public static final /* enum */ HPySlot HPY_TP_ITER = new HPySlot(62, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___ITER__);
        public static final /* enum */ HPySlot HPY_TP_NEW = new HPySlot(65, HPySlotWrapper.NULL, SpecialMethodNames.T___NEW__);
        public static final /* enum */ HPySlot HPY_TP_REPR = new HPySlot(66, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___REPR__);
        public static final /* enum */ HPySlot HPY_TP_RICHCOMPARE = new HPySlot(67, HPySlot.w(HPySlotWrapper.RICHCMP_LT, HPySlotWrapper.RICHCMP_LE, HPySlotWrapper.RICHCMP_EQ, HPySlotWrapper.RICHCMP_NE, HPySlotWrapper.RICHCMP_GT, HPySlotWrapper.RICHCMP_GE), HPySlot.k(SpecialMethodNames.T___LT__, SpecialMethodNames.T___LE__, SpecialMethodNames.T___EQ__, SpecialMethodNames.T___NE__, SpecialMethodNames.T___GT__, SpecialMethodNames.T___GE__));
        public static final /* enum */ HPySlot HPY_TP_STR = new HPySlot(70, HPySlotWrapper.UNARYFUNC, SpecialMethodNames.T___STR__);
        public static final /* enum */ HPySlot HPY_TP_TRAVERSE = new HPySlot(71, HPySlotWrapper.TRAVERSE, new TruffleString[0]);
        public static final /* enum */ HPySlot HPY_NB_MATRIX_MULTIPLY = new HPySlot(75, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___MATMUL__, HPySlotWrapper.BINARYFUNC_R, SpecialMethodNames.T___RMATMUL__);
        public static final /* enum */ HPySlot HPY_NB_INPLACE_MATRIX_MULTIPLY = new HPySlot(76, HPySlotWrapper.BINARYFUNC_L, SpecialMethodNames.T___IMATMUL__);
        public static final /* enum */ HPySlot HPY_TP_FINALIZE = new HPySlot(80, HPySlotWrapper.DESTRUCTOR, new TruffleString[0]);
        public static final /* enum */ HPySlot HPY_TP_DESTROY = new HPySlot(1000, HPySlotWrapper.DESTROYFUNC, new TruffleString[0]);
        public static final /* enum */ HPySlot HPY_MOD_CREATE = new HPySlot(2000, HPySlotWrapper.MOD_CREATE, new TruffleString[0]);
        public static final /* enum */ HPySlot HPY_MOD_EXEC = new HPySlot(2001, HPySlotWrapper.INQUIRYPRED, new TruffleString[0]);
        private final int value;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final Object[] attributeKeys;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final HPySlotWrapper[] signatures;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final HPySlot[] BY_VALUE;
        private static final /* synthetic */ HPySlot[] $VALUES;

        public static HPySlot[] values() {
            return (HPySlot[])$VALUES.clone();
        }

        public static HPySlot valueOf(String name) {
            return Enum.valueOf(HPySlot.class, name);
        }

        private HPySlot(int value, HPySlotWrapper signature, HiddenKey attributeKey) {
            this.value = value;
            this.attributeKeys = new Object[]{attributeKey};
            this.signatures = new HPySlotWrapper[]{signature};
        }

        private HPySlot(int value, HPySlotWrapper signature, TruffleString ... attributeKeys) {
            this.value = value;
            this.attributeKeys = attributeKeys;
            if (attributeKeys.length > 0) {
                this.signatures = new HPySlotWrapper[attributeKeys.length];
                Arrays.fill((Object[])this.signatures, (Object)signature);
            } else {
                this.signatures = new HPySlotWrapper[]{signature};
            }
        }

        private HPySlot(int value, HPySlotWrapper sig0, TruffleString key0, HPySlotWrapper sig1, TruffleString key1) {
            this.value = value;
            this.attributeKeys = new Object[]{key0, key1};
            this.signatures = new HPySlotWrapper[]{sig0, sig1};
        }

        private HPySlot(int value, HPySlotWrapper[] sigs, TruffleString ... keys) {
            this.value = value;
            this.attributeKeys = keys;
            this.signatures = sigs;
        }

        int getValue() {
            return this.value;
        }

        Object[] getAttributeKeys() {
            return this.attributeKeys;
        }

        HPySlotWrapper[] getSignatures() {
            return this.signatures;
        }

        static HPySlot fromValue(int value) {
            if (value >= 0 && value < BY_VALUE.length) {
                return BY_VALUE[value];
            }
            if (HPySlot.HPY_TP_DESTROY.value == value) {
                return HPY_TP_DESTROY;
            }
            if (HPySlot.HPY_MOD_CREATE.value == value) {
                return HPY_MOD_CREATE;
            }
            if (HPySlot.HPY_MOD_EXEC.value == value) {
                return HPY_MOD_EXEC;
            }
            return null;
        }

        private static HPySlotWrapper[] w(HPySlotWrapper ... wrappers) {
            return wrappers;
        }

        private static TruffleString[] k(TruffleString ... keys) {
            return keys;
        }

        private static /* synthetic */ HPySlot[] $values() {
            return new HPySlot[]{HPY_BF_GETBUFFER, HPY_BF_RELEASEBUFFER, HPY_MP_ASS_SUBSCRRIPT, HPY_MP_LENGTH, HPY_MP_SUBSCRIPT, HPY_NB_ABSOLUTE, HPY_NB_ADD, HPY_NB_AND, HPY_NB_BOOL, HPY_NB_DIVMOD, HPY_NB_FLOAT, HPY_NB_FLOOR_DIVIDE, HPY_NB_INDEX, HPY_NB_INPLACE_ADD, HPY_NB_INPLACE_AND, HPY_NB_INPLACE_FLOOR_DIVIDE, HPY_NB_INPLACE_LSHIFT, HPY_NB_INPLACE_MULTIPLY, HPY_NB_INPLACE_OR, HPY_NB_INPLACE_POWER, HPY_NB_INPLACE_REMAINDER, HPY_NB_INPLACE_RSHIFT, HPY_NB_INPLACE_SUBTRACT, HPY_NB_INPLACE_TRUE_DIVIDE, HPY_NB_INPLACE_XOR, HPY_NB_INT, HPY_NB_INVERT, HPY_NB_LSHIFT, HPY_NB_MULTIPLY, HPY_NB_NEGATIVE, HPY_NB_OR, HPY_NB_POSITIVE, HPY_NB_POWER, HPY_NB_REMAINDER, HPY_NB_RSHIFT, HPY_NB_SUBTRACT, HPY_NB_TRUE_DIVIDE, HPY_NB_XOR, HPY_SQ_ASS_ITEM, HPY_SQ_CONCAT, HPY_SQ_CONTAINS, HPY_SQ_INPLACE_CONCAT, HPY_SQ_INPLACE_REPEAT, HPY_SQ_ITEM, HPY_SQ_LENGTH, HPY_SQ_REPEAT, HPY_TP_CALL, HPY_TP_HASH, HPY_TP_INIT, HPY_TP_ITER, HPY_TP_NEW, HPY_TP_REPR, HPY_TP_RICHCOMPARE, HPY_TP_STR, HPY_TP_TRAVERSE, HPY_NB_MATRIX_MULTIPLY, HPY_NB_INPLACE_MATRIX_MULTIPLY, HPY_TP_FINALIZE, HPY_TP_DESTROY, HPY_MOD_CREATE, HPY_MOD_EXEC};
        }

        static {
            $VALUES = HPySlot.$values();
            BY_VALUE = new HPySlot[100];
            for (HPySlot entry : HPySlot.values()) {
                if (entry.value < 0 || entry.value >= BY_VALUE.length) continue;
                assert (BY_VALUE[entry.value] == null);
                HPySlot.BY_VALUE[entry.value] = entry;
            }
        }
    }

    static enum HPySlotWrapper {
        NULL(GraalHPyContext.LLVMType.HPyFunc_keywords),
        UNARYFUNC(GraalHPyContext.LLVMType.HPyFunc_unaryfunc),
        BINARYFUNC(GraalHPyContext.LLVMType.HPyFunc_binaryfunc),
        BINARYFUNC_L(GraalHPyContext.LLVMType.HPyFunc_binaryfunc),
        BINARYFUNC_R(GraalHPyContext.LLVMType.HPyFunc_binaryfunc),
        CALL(GraalHPyContext.LLVMType.HPyFunc_keywords),
        HASHFUNC(GraalHPyContext.LLVMType.HPyFunc_hashfunc),
        TERNARYFUNC(GraalHPyContext.LLVMType.HPyFunc_ternaryfunc),
        TERNARYFUNC_R(GraalHPyContext.LLVMType.HPyFunc_ternaryfunc),
        INQUIRYPRED(GraalHPyContext.LLVMType.HPyFunc_inquiry),
        DEL,
        INIT(GraalHPyContext.LLVMType.HPyFunc_initproc),
        LENFUNC(GraalHPyContext.LLVMType.HPyFunc_lenfunc),
        DELITEM,
        SQ_ITEM(GraalHPyContext.LLVMType.HPyFunc_ssizeargfunc),
        SQ_SETITEM(GraalHPyContext.LLVMType.HPyFunc_ssizeobjargproc),
        SQ_DELITEM(GraalHPyContext.LLVMType.HPyFunc_ssizeobjargproc),
        OBJOBJARGPROC(GraalHPyContext.LLVMType.HPyFunc_objobjargproc),
        OBJOBJPROC(GraalHPyContext.LLVMType.HPyFunc_objobjproc),
        INDEXARGFUNC(GraalHPyContext.LLVMType.HPyFunc_ssizeargfunc),
        SETATTR(GraalHPyContext.LLVMType.HPyFunc_setattrfunc),
        DELATTR(GraalHPyContext.LLVMType.HPyFunc_setattrfunc),
        RICHCMP_LT(GraalHPyContext.LLVMType.HPyFunc_richcmpfunc),
        RICHCMP_LE(GraalHPyContext.LLVMType.HPyFunc_richcmpfunc),
        RICHCMP_EQ(GraalHPyContext.LLVMType.HPyFunc_richcmpfunc),
        RICHCMP_NE(GraalHPyContext.LLVMType.HPyFunc_richcmpfunc),
        RICHCMP_GT(GraalHPyContext.LLVMType.HPyFunc_richcmpfunc),
        RICHCMP_GE(GraalHPyContext.LLVMType.HPyFunc_richcmpfunc),
        DESCR_GET(GraalHPyContext.LLVMType.HPyFunc_descrgetfunc),
        DESCR_SET(GraalHPyContext.LLVMType.HPyFunc_descrsetfunc),
        DESCR_DELETE(GraalHPyContext.LLVMType.HPyFunc_descrsetfunc),
        DESTROYFUNC(GraalHPyContext.LLVMType.HPyFunc_destroyfunc),
        TRAVERSE(GraalHPyContext.LLVMType.HPyFunc_traverseproc),
        DESTRUCTOR(GraalHPyContext.LLVMType.HPyFunc_destructor),
        GETBUFFER(GraalHPyContext.LLVMType.HPyFunc_getbufferproc),
        RELEASEBUFFER(GraalHPyContext.LLVMType.HPyFunc_releasebufferproc),
        MOD_CREATE(GraalHPyContext.LLVMType.HPyModule_create);

        private final GraalHPyContext.LLVMType llvmFunctionType;

        private HPySlotWrapper() {
            this.llvmFunctionType = null;
        }

        private HPySlotWrapper(GraalHPyContext.LLVMType llvmFunctionType) {
            this.llvmFunctionType = llvmFunctionType;
        }

        public GraalHPyContext.LLVMType getLLVMFunctionType() {
            return this.llvmFunctionType;
        }
    }

    static final class HPyFuncSignature
    extends Enum<HPyFuncSignature> {
        public static final /* enum */ HPyFuncSignature VARARGS = new HPyFuncSignature(1, GraalHPyContext.LLVMType.HPyFunc_varargs);
        public static final /* enum */ HPyFuncSignature KEYWORDS = new HPyFuncSignature(2, GraalHPyContext.LLVMType.HPyFunc_keywords);
        public static final /* enum */ HPyFuncSignature NOARGS = new HPyFuncSignature(3, GraalHPyContext.LLVMType.HPyFunc_noargs);
        public static final /* enum */ HPyFuncSignature O = new HPyFuncSignature(4, GraalHPyContext.LLVMType.HPyFunc_o);
        public static final /* enum */ HPyFuncSignature DESTROYFUNC = new HPyFuncSignature(5, GraalHPyContext.LLVMType.HPyFunc_destroyfunc);
        public static final /* enum */ HPyFuncSignature GETBUFFERPROC = new HPyFuncSignature(6, GraalHPyContext.LLVMType.HPyFunc_getbufferproc);
        public static final /* enum */ HPyFuncSignature RELEASEBUFFERPROC = new HPyFuncSignature(7, GraalHPyContext.LLVMType.HPyFunc_releasebufferproc);
        public static final /* enum */ HPyFuncSignature UNARYFUNC = new HPyFuncSignature(8, GraalHPyContext.LLVMType.HPyFunc_unaryfunc);
        public static final /* enum */ HPyFuncSignature BINARYFUNC = new HPyFuncSignature(9, GraalHPyContext.LLVMType.HPyFunc_binaryfunc);
        public static final /* enum */ HPyFuncSignature TERNARYFUNC = new HPyFuncSignature(10, GraalHPyContext.LLVMType.HPyFunc_ternaryfunc);
        public static final /* enum */ HPyFuncSignature INQUIRY = new HPyFuncSignature(11, GraalHPyContext.LLVMType.HPyFunc_inquiry);
        public static final /* enum */ HPyFuncSignature LENFUNC = new HPyFuncSignature(12, GraalHPyContext.LLVMType.HPyFunc_lenfunc);
        public static final /* enum */ HPyFuncSignature SSIZEARGFUNC = new HPyFuncSignature(13, GraalHPyContext.LLVMType.HPyFunc_ssizeargfunc);
        public static final /* enum */ HPyFuncSignature SSIZESSIZEARGFUNC = new HPyFuncSignature(14, GraalHPyContext.LLVMType.HPyFunc_ssizessizeargfunc);
        public static final /* enum */ HPyFuncSignature SSIZEOBJARGPROC = new HPyFuncSignature(15, GraalHPyContext.LLVMType.HPyFunc_ssizeobjargproc);
        public static final /* enum */ HPyFuncSignature SSIZESSIZEOBJARGPROC = new HPyFuncSignature(16, GraalHPyContext.LLVMType.HPyFunc_ssizessizeobjargproc);
        public static final /* enum */ HPyFuncSignature OBJOBJARGPROC = new HPyFuncSignature(17, GraalHPyContext.LLVMType.HPyFunc_objobjargproc);
        public static final /* enum */ HPyFuncSignature FREEFUNC = new HPyFuncSignature(18, GraalHPyContext.LLVMType.HPyFunc_freefunc);
        public static final /* enum */ HPyFuncSignature GETATTRFUNC = new HPyFuncSignature(19, GraalHPyContext.LLVMType.HPyFunc_getattrfunc);
        public static final /* enum */ HPyFuncSignature GETATTROFUNC = new HPyFuncSignature(20, GraalHPyContext.LLVMType.HPyFunc_getattrofunc);
        public static final /* enum */ HPyFuncSignature SETATTRFUNC = new HPyFuncSignature(21, GraalHPyContext.LLVMType.HPyFunc_setattrfunc);
        public static final /* enum */ HPyFuncSignature SETATTROFUNC = new HPyFuncSignature(22, GraalHPyContext.LLVMType.HPyFunc_setattrofunc);
        public static final /* enum */ HPyFuncSignature REPRFUNC = new HPyFuncSignature(23, GraalHPyContext.LLVMType.HPyFunc_reprfunc);
        public static final /* enum */ HPyFuncSignature HASHFUNC = new HPyFuncSignature(24, GraalHPyContext.LLVMType.HPyFunc_hashfunc);
        public static final /* enum */ HPyFuncSignature RICHCMPFUNC = new HPyFuncSignature(25, GraalHPyContext.LLVMType.HPyFunc_richcmpfunc);
        public static final /* enum */ HPyFuncSignature GETITERFUNC = new HPyFuncSignature(26, GraalHPyContext.LLVMType.HPyFunc_getiterfunc);
        public static final /* enum */ HPyFuncSignature ITERNEXTFUNC = new HPyFuncSignature(27, GraalHPyContext.LLVMType.HPyFunc_iternextfunc);
        public static final /* enum */ HPyFuncSignature DESCRGETFUNC = new HPyFuncSignature(28, GraalHPyContext.LLVMType.HPyFunc_descrgetfunc);
        public static final /* enum */ HPyFuncSignature DESCRSETFUNC = new HPyFuncSignature(29, GraalHPyContext.LLVMType.HPyFunc_descrsetfunc);
        public static final /* enum */ HPyFuncSignature INITPROC = new HPyFuncSignature(30, GraalHPyContext.LLVMType.HPyFunc_initproc);
        public static final /* enum */ HPyFuncSignature GETTER = new HPyFuncSignature(31, GraalHPyContext.LLVMType.HPyFunc_getter);
        public static final /* enum */ HPyFuncSignature SETTER = new HPyFuncSignature(32, GraalHPyContext.LLVMType.HPyFunc_setter);
        public static final /* enum */ HPyFuncSignature OBJOBJPROC = new HPyFuncSignature(33, GraalHPyContext.LLVMType.HPyFunc_objobjproc);
        private final int value;
        private final GraalHPyContext.LLVMType llvmFunctionType;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final HPyFuncSignature[] VALUES;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final HPyFuncSignature[] BY_VALUE;
        private static final /* synthetic */ HPyFuncSignature[] $VALUES;

        public static HPyFuncSignature[] values() {
            return (HPyFuncSignature[])$VALUES.clone();
        }

        public static HPyFuncSignature valueOf(String name) {
            return Enum.valueOf(HPyFuncSignature.class, name);
        }

        private HPyFuncSignature(int value, GraalHPyContext.LLVMType llvmFunctionType) {
            this.value = value;
            this.llvmFunctionType = llvmFunctionType;
        }

        public int getValue() {
            return this.value;
        }

        public GraalHPyContext.LLVMType getLLVMFunctionType() {
            return this.llvmFunctionType;
        }

        static HPyFuncSignature fromValue(int value) {
            return value >= 0 && value < BY_VALUE.length ? BY_VALUE[value] : null;
        }

        public static int getFlags(HPyFuncSignature sig) {
            switch (sig.ordinal()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 8;
                }
            }
            return 0;
        }

        static boolean isValid(int value) {
            return HPyFuncSignature.fromValue(value) != null;
        }

        private static /* synthetic */ HPyFuncSignature[] $values() {
            return new HPyFuncSignature[]{VARARGS, KEYWORDS, NOARGS, O, DESTROYFUNC, GETBUFFERPROC, RELEASEBUFFERPROC, UNARYFUNC, BINARYFUNC, TERNARYFUNC, INQUIRY, LENFUNC, SSIZEARGFUNC, SSIZESSIZEARGFUNC, SSIZEOBJARGPROC, SSIZESSIZEOBJARGPROC, OBJOBJARGPROC, FREEFUNC, GETATTRFUNC, GETATTROFUNC, SETATTRFUNC, SETATTROFUNC, REPRFUNC, HASHFUNC, RICHCMPFUNC, GETITERFUNC, ITERNEXTFUNC, DESCRGETFUNC, DESCRSETFUNC, INITPROC, GETTER, SETTER, OBJOBJPROC};
        }

        static {
            $VALUES = HPyFuncSignature.$values();
            VALUES = HPyFuncSignature.values();
            BY_VALUE = new HPyFuncSignature[40];
            for (HPyFuncSignature entry : VALUES) {
                assert (BY_VALUE[entry.value] == null);
                HPyFuncSignature.BY_VALUE[entry.value] = entry;
            }
        }
    }
}

