/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapperFactory;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public final class PySequenceArrayWrapper {
    @CompilerDirectives.TruffleBoundary
    public static Object ensureNativeSequence(PSequence sequence) {
        SequenceStorage sequenceStorage = sequence.getSequenceStorage();
        if (sequenceStorage instanceof NativeSequenceStorage) {
            NativeSequenceStorage nativeStorage = (NativeSequenceStorage)sequenceStorage;
            return nativeStorage.getPtr();
        }
        NativeSequenceStorage nativeStorage = ToNativeStorageNode.executeUncached(sequenceStorage, sequence instanceof PBytesLike);
        sequence.setSequenceStorage(nativeStorage);
        return nativeStorage.getPtr();
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class ToNativeStorageNode
    extends Node {
        public abstract NativeSequenceStorage execute(Node var1, SequenceStorage var2, boolean var3);

        public static NativeSequenceStorage executeUncached(SequenceStorage object, boolean isBytesLike) {
            return PySequenceArrayWrapperFactory.ToNativeStorageNodeGen.getUncached().execute(null, object, isBytesLike);
        }

        public static boolean isEmptySequenceStorage(SequenceStorage s) {
            return s instanceof EmptySequenceStorage;
        }

        @Specialization(guards={"!isNative(s)", "!isEmptySequenceStorage(s)"})
        static NativeSequenceStorage doManaged(Node inliningTarget, SequenceStorage s, boolean isBytesLike, @Cached InlinedConditionProfile isObjectArrayProfile, @Cached.Shared(value="storageToNativeNode") @Cached(inline=false) SequenceStorageNodes.StorageToNativeNode storageToNativeNode, @Cached SequenceStorageNodes.GetInternalArrayNode getInternalArrayNode) {
            Object array = getInternalArrayNode.execute(inliningTarget, s);
            if (isBytesLike) {
                assert (array instanceof byte[]);
            } else if (!isObjectArrayProfile.profile(inliningTarget, array instanceof Object[])) {
                array = ToNativeStorageNode.generalize(s);
            }
            return storageToNativeNode.execute(array, s.length());
        }

        @CompilerDirectives.TruffleBoundary
        private static Object generalize(SequenceStorage s) {
            return s.getInternalArray();
        }

        @Specialization
        static NativeSequenceStorage doNative(NativeSequenceStorage s, boolean isBytesLike) {
            return s;
        }

        @Specialization
        static NativeSequenceStorage doEmptyStorage(EmptySequenceStorage s, boolean isBytesLike, @Cached.Shared(value="storageToNativeNode") @Cached(inline=false) SequenceStorageNodes.StorageToNativeNode storageToNativeNode) {
            return storageToNativeNode.execute(PythonUtils.EMPTY_BYTE_ARRAY, 0);
        }

        protected static boolean isNative(SequenceStorage s) {
            return s instanceof NativeSequenceStorage;
        }
    }
}

