/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.PythonAbstractObjectFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class PyMethodDefWrapper
extends PythonNativeWrapper.PythonStructNativeWrapper {
    public PyMethodDefWrapper(PythonObject delegate) {
        super(delegate, true);
    }

    private static Object getMethFromBuiltinMethod(PBuiltinMethod object) {
        return PyMethodDefWrapper.getMethFromBuiltinFunction(object.getBuiltinFunction());
    }

    private static Object getMethFromBuiltinFunction(PBuiltinFunction object) {
        PKeyword[] kwDefaults = object.getKwDefaults();
        for (int i = 0; i < kwDefaults.length; ++i) {
            if (!ExternalFunctionNodes.KW_CALLABLE.equals((Object)kwDefaults[i].getName())) continue;
            return kwDefaults[i].getValue();
        }
        return PyMethodDefWrapper.createFunctionWrapper(object);
    }

    private static Object getMeth(PythonObject object) {
        if (object instanceof PBuiltinMethod) {
            return PyMethodDefWrapper.getMethFromBuiltinMethod((PBuiltinMethod)object);
        }
        if (object instanceof PBuiltinFunction) {
            return PyMethodDefWrapper.getMethFromBuiltinFunction((PBuiltinFunction)object);
        }
        return PyMethodDefWrapper.createFunctionWrapper(object);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object createFunctionWrapper(PythonObject object) {
        PyProcsWrapper wrapper;
        int flags = PyMethodDefWrapper.getFlags(object);
        if (CExtContext.isMethNoArgs(flags)) {
            wrapper = PyProcsWrapper.createUnaryFuncWrapper(object);
        } else if (CExtContext.isMethO(flags)) {
            wrapper = PyProcsWrapper.createBinaryFuncWrapper(object);
        } else if (CExtContext.isMethVarargsWithKeywords(flags)) {
            wrapper = PyProcsWrapper.createVarargKeywordWrapper(object);
        } else if (CExtContext.isMethVarargs(flags)) {
            wrapper = PyProcsWrapper.createVarargWrapper(object);
        } else {
            throw CompilerDirectives.shouldNotReachHere((String)("other signature " + Integer.toHexString(flags)));
        }
        if (wrapper.isReplacingWrapper()) {
            return wrapper.getReplacement(InteropLibrary.getUncached());
        }
        return wrapper;
    }

    private static int getFlags(PythonObject object) {
        if (object instanceof PBuiltinFunction) {
            return ((PBuiltinFunction)object).getFlags();
        }
        if (object instanceof PBuiltinMethod) {
            return ((PBuiltinMethod)object).getBuiltinFunction().getFlags();
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    private Object allocateReplacementObject() {
        PythonObject obj = (PythonObject)this.getDelegate();
        CStructAccess.AllocateNode allocNode = CStructAccessFactory.AllocateNodeGen.getUncached();
        CStructAccess.WritePointerNode writePointerNode = CStructAccessFactory.WritePointerNodeGen.getUncached();
        CStructAccess.WriteIntNode writeIntNode = CStructAccessFactory.WriteIntNodeGen.getUncached();
        PythonAbstractObject.PInteropGetAttributeNode getAttrNode = PythonAbstractObjectFactory.PInteropGetAttributeNodeGen.getUncached();
        CastToTruffleStringNode castToStringNode = CastToTruffleStringNode.getUncached();
        Object mem = allocNode.alloc(CStructs.PyMethodDef);
        Object nullValue = PythonContext.get(null).getNativeNull().getPtr();
        Object name = getAttrNode.execute(null, obj, SpecialAttributeNames.T___NAME__);
        if (PGuards.isPNone(name)) {
            name = nullValue;
        } else {
            try {
                name = new CArrayWrappers.CStringWrapper(castToStringNode.execute(null, name));
            }
            catch (CannotCastException cannotCastException) {
                // empty catch block
            }
        }
        writePointerNode.write(mem, CFields.PyMethodDef__ml_name, name);
        writePointerNode.write(mem, CFields.PyMethodDef__ml_meth, PyMethodDefWrapper.getMeth(obj));
        writeIntNode.write(mem, CFields.PyMethodDef__ml_flags, PyMethodDefWrapper.getFlags(obj));
        Object doc = getAttrNode.execute(null, obj, SpecialAttributeNames.T___DOC__);
        if (PGuards.isPNone(doc)) {
            doc = nullValue;
        } else {
            try {
                doc = new CArrayWrappers.CStringWrapper(castToStringNode.execute(null, doc));
            }
            catch (CannotCastException e) {
                doc = nullValue;
            }
        }
        writePointerNode.write(mem, CFields.PyMethodDef__ml_doc, doc);
        return mem;
    }

    @Override
    public Object getReplacement(InteropLibrary lib) {
        if (this.replacement == null) {
            this.replacement = this.registerReplacement(this.allocateReplacementObject(), lib);
        }
        return this.replacement;
    }

    @ExportMessage
    boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (!this.isNative()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedMessageException.create();
        }
        return this.getNativePointer();
    }

    @ExportMessage
    void toNative() {
        if (!this.isNative()) {
            this.getReplacement(InteropLibrary.getUncached());
            assert (this.isNative());
        }
    }
}

