/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.functools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.functools.FunctoolsModuleBuiltinsFactory;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(defineModule="_functools")
public final class FunctoolsModuleBuiltins
extends PythonBuiltins {
    protected static final HiddenKey KWD_MARK = new HiddenKey("kwd_mark");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FunctoolsModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"Create a cached callable that wraps another function.\n\nuser_function:      the function being cached\n\nmaxsize:  0         for no caching\n          None      for unlimited cache size\n          n         for a bounded cache\n\ntyped:    False     cache f(3) and f(3.0) as identical calls\n          True      cache f(3) and f(3.0) as distinct calls\n\ncache_info_type:    namedtuple class with the fields:\n                        hits misses currsize maxsize\n");
        this.addBuiltinConstant(KWD_MARK, (Object)core.factory().createPythonObject((Object)PythonBuiltinClassType.PythonObject));
    }

    @Builtin(name="cmp_to_key", minNumOfPositionalArgs=1, parameterNames={"mycmp"}, doc="Convert a cmp= function into a key= function.")
    @GenerateNodeFactory
    public static abstract class CmpToKeyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doConvert(Object myCmp, @Cached PythonObjectFactory factory) {
            return factory.createKeyWrapper(myCmp);
        }
    }

    @Builtin(name="reduce", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3, doc="reduce(function, sequence[, initial]) -> value\n\nApply a function of two arguments cumulatively to the items of a sequence,\nfrom left to right, so as to reduce the sequence to a single value.\nFor example, reduce(lambda x, y: x+y, [1, 2, 3, 4, 5]) calculates\n((((1+2)+3)+4)+5).  If initial is present, it is placed before the items\nof the sequence in the calculation, and serves as a default when the\nsequence is empty.")
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        Object doReduce(VirtualFrame frame, Object function, Object sequence, Object initialIn, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached CallNode callNode, @Cached InlinedConditionProfile initialNoValueProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile typeError, @Cached PRaiseNode.Lazy raiseNode) {
            Object seqIterator;
            Object initial;
            Object result = initial = initialNoValueProfile.profile(inliningTarget, PGuards.isNoValue(initialIn)) ? null : initialIn;
            try {
                seqIterator = getIter.execute((Frame)frame, inliningTarget, sequence);
            }
            catch (PException pe) {
                pe.expectTypeError(inliningTarget, typeError);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_ARG_N_MUST_SUPPORT_ITERATION, "reduce()", 2);
            }
            Object[] args = new Object[2];
            int count = 0;
            try {
                while (true) {
                    Object op2 = nextNode.execute((Frame)frame, seqIterator);
                    if (result == null) {
                        result = op2;
                    } else {
                        args[0] = result;
                        args[1] = op2;
                        result = callNode.execute((Frame)frame, function, args);
                    }
                    if (!CompilerDirectives.hasNextTier()) continue;
                    ++count;
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, stopIterProfile);
                LoopNode.reportLoopCount((Node)this, (int)(count >= 0 ? count : Integer.MAX_VALUE));
                if (result == null) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.REDUCE_EMPTY_SEQ);
                }
                return result;
            }
        }
    }
}

