/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCPointer})
public final class PyCPointerBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCPointerBuiltinsFactory.getFactories();
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class PointerGetItemNode
    extends PythonBinaryBuiltinNode {
        PointerGetItemNode() {
        }

        @Specialization
        static Object Pointer_item(CDataObject self, int index, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (self.b_ptr.isNull()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NULL_POINTER_ACCESS);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer object instances";
            Object proto = stgdict.proto;
            assert (proto != null);
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
            assert (itemdict != null) : "proto is the item type of the pointer, a ctypes type, so this cannot be NULL";
            int size = itemdict.size;
            int offset = index * itemdict.size;
            return pyCDataGetNode.execute(inliningTarget, proto, stgdict.getfunc, self, index, size, readPointerNode.execute(inliningTarget, self.b_ptr).withOffset(offset));
        }

        @Specialization(limit="1")
        static Object Pointer_subscriptSlice(VirtualFrame frame, CDataObject self, PSlice slice, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="self") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Exclusive @Cached PyNumberAsSizeNode asSizeNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int start;
            int step;
            if (slice.getStep() == PNone.NONE) {
                step = 1;
            } else {
                step = asSizeNode.executeExact((Frame)frame, inliningTarget, slice.getStep(), PythonErrorType.ValueError);
                if (step == 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
                }
            }
            if (slice.getStart() == PNone.NONE) {
                if (step < 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SLICE_START_IS_REQUIRED_FOR_STEP_0);
                }
                start = 0;
            } else {
                start = asSizeNode.executeExact((Frame)frame, inliningTarget, slice.getStart(), PythonErrorType.ValueError);
            }
            if (slice.getStop() == PNone.NONE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.SLICE_STOP_IS_REQUIRED);
            }
            int stop = asSizeNode.executeExact((Frame)frame, inliningTarget, slice.getStop(), PythonErrorType.ValueError);
            int len = step > 0 && start > stop || step < 0 && start < stop ? 0 : (step > 0 ? (stop - start - 1) / step + 1 : (stop - start + 1) / step + 1);
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            Object proto = stgdict.proto;
            assert (proto != null);
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
            assert (itemdict != null);
            if (itemdict.getfunc == FFIType.FieldDesc.c.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (len <= 0) {
                    return factory.createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
                }
                if (step == 1) {
                    return factory.createBytes(ptr, start, len);
                }
                byte[] dest = new byte[len];
                int cur = start;
                for (int i = 0; i < len; ++i) {
                    dest[i] = ptr[cur];
                    cur += step;
                }
                return factory.createBytes(dest);
            }
            if (itemdict.getfunc == FFIType.FieldDesc.u.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (len <= 0) {
                    return StringLiterals.T_EMPTY_STRING;
                }
                if (step == 1) {
                    return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(ptr, start, len, TruffleString.Encoding.UTF_8, true), PythonUtils.TS_ENCODING);
                }
                byte[] dest = new byte[len];
                int cur = start;
                for (int i = 0; i < len; ++i) {
                    dest[i] = ptr[cur];
                    cur += step;
                }
                return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(dest, TruffleString.Encoding.UTF_8), PythonUtils.TS_ENCODING);
            }
            Object[] np = new Object[len];
            int cur = start;
            for (int i = 0; i < len; ++i) {
                np[i] = PointerGetItemNode.Pointer_item(self, cur, inliningTarget, pyCDataGetNode, pyTypeStgDictNode, pyObjectStgDictNode, readPointerNode, raiseNode);
                cur += step;
            }
            return factory.createList(np);
        }

        @Specialization(guards={"!isPSlice(item)"})
        static Object Pointer_subscript(VirtualFrame frame, CDataObject self, Object item, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Exclusive @Cached PyNumberAsSizeNode asSizeNode, @Cached PyIndexCheckNode indexCheckNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (indexCheckNode.execute(inliningTarget, item)) {
                int i = asSizeNode.executeExact((Frame)frame, inliningTarget, item, PythonErrorType.IndexError);
                return PointerGetItemNode.Pointer_item(self, i, inliningTarget, pyCDataGetNode, pyTypeStgDictNode, pyObjectStgDictNode, readPointerNode, raiseNode);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.POINTER_INDICES_MUST_BE_INTEGER);
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class PointerSetItemNode
    extends PythonTernaryBuiltinNode {
        PointerSetItemNode() {
        }

        @Specialization
        static Object Pointer_ass_item(VirtualFrame frame, CDataObject self, int index, Object value, @Bind(value="this") Node inliningTarget, @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (value == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.POINTER_DOES_NOT_SUPPORT_ITEM_DELETION);
            }
            if (self.b_ptr.isNull()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NULL_POINTER_ACCESS);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            Object proto = stgdict.proto;
            assert (proto != null);
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
            assert (itemdict != null) : "Cannot be NULL because the itemtype of a pointer is always a ctypes type";
            int size = itemdict.size;
            int offset = index * itemdict.size;
            pyCDataSetNode.execute(frame, self, proto, stgdict.setfunc, value, index, size, readPointerNode.execute(inliningTarget, self.b_ptr).withOffset(offset));
            return PNone.NONE;
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class PointerBoolNode
    extends PythonUnaryBuiltinNode {
        protected PointerBoolNode() {
        }

        @Specialization
        boolean Pointer_bool(CDataObject self) {
            return !self.b_ptr.isNull();
        }
    }

    @Builtin(name="contents", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="the object this pointer points to (read-write)")
    @GenerateNodeFactory
    protected static abstract class PointerContentSNode
    extends PythonBinaryBuiltinNode {
        protected PointerContentSNode() {
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object get_contents(CDataObject self, PNone value, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached CtypesNodes.PyCDataFromBaseObjNode fromBaseObjNode, @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (self.b_ptr.isNull()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NULL_POINTER_ACCESS);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            return fromBaseObjNode.execute(inliningTarget, stgdict.proto, self, 0, readPointerNode.execute(inliningTarget, self.b_ptr));
        }

        @Specialization(guards={"!isNoValue(value)"})
        static Object set_contents(VirtualFrame frame, CDataObject self, Object value, @Bind(value="this") Node inliningTarget, @Cached PointerSetContentsNode setContentsNode) {
            setContentsNode.execute(frame, inliningTarget, self, value);
            return PNone.NONE;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class InitNode
    extends PythonBuiltinNode {
        protected InitNode() {
        }

        @Specialization
        static Object Pointer_init(VirtualFrame frame, CDataObject self, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached PointerSetContentsNode setContentsNode) {
            if (args.length > 0) {
                setContentsNode.execute(frame, inliningTarget, self, args[0]);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        static Object Pointer_new(Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.GenericPyCDataNewNode pyCDataNewNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            if (dict.proto == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCE_HAS_NO_TYPE);
            }
            return pyCDataNewNode.execute(inliningTarget, type, dict);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PointerSetContentsNode
    extends Node {
        PointerSetContentsNode() {
        }

        abstract void execute(VirtualFrame var1, Node var2, CDataObject var3, Object var4);

        @Specialization
        static void set(VirtualFrame frame, Node inliningTarget, CDataObject self, Object value, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached PRaiseNode.Lazy raiseNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached(inline=false) BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached CDataTypeBuiltins.KeepRefNode keepRefNode, @Cached PointerNodes.WritePointerNode writePointerNode, @Cached(inline=false) PythonObjectFactory factory) {
            boolean res;
            if (value == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.POINTER_DOES_NOT_SUPPORT_ITEM_DELETION);
            }
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for pointer instances";
            assert (stgdict.proto != null);
            if (!pyTypeCheck.isCDataObject(inliningTarget, value) && !(res = isInstanceNode.executeWith(frame, value, stgdict.proto))) {
                raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_N_INSTEAD_OF_P, stgdict.proto, value);
            }
            CDataObject dst = (CDataObject)value;
            writePointerNode.execute(inliningTarget, self.b_ptr, dst.b_ptr);
            keepRefNode.execute(frame, inliningTarget, self, 1, value);
            Object keep = CDataTypeBuiltins.GetKeepedObjects(dst, factory);
            keepRefNode.execute(frame, inliningTarget, self, 0, keep);
        }
    }
}

