/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecState;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteDecodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalDecoderBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteIncrementalDecoderObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStatefulDecoderContext;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MultibyteIncrementalDecoder})
public final class MultibyteIncrementalDecoderBuiltins
extends PythonBuiltins {
    public static final HiddenKey DECODER_OBJECT_ATTR = new HiddenKey("decoder_object");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultibyteStreamWriterBuiltinsFactory.getFactories();
    }

    @Builtin(name="reset", minNumOfPositionalArgs=1, parameterNames={"$self"}, doc="reset($self, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class ResetNode
    extends PythonUnaryBuiltinNode {
        ResetNode() {
        }

        @Specialization
        static Object reset(MultibyteIncrementalDecoderObject self) {
            self.codec.decreset(self.state);
            self.pendingsize = 0;
            return PNone.NONE;
        }
    }

    @Builtin(name="setstate", minNumOfPositionalArgs=2, parameterNames={"$self", "state"}, doc="setstate($self, state, /)\n--\n\n")
    @ArgumentClinic(name="state", conversion=ArgumentClinic.ClinicConversion.Tuple)
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryClinicBuiltinNode {
        SetStateNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteIncrementalDecoderBuiltinsClinicProviders.SetStateNodeClinicProviderGen.INSTANCE;
        }

        static Object setstate(VirtualFrame frame, MultibyteIncrementalDecoderObject self, PTuple state, @Bind(value="this") Node inliningTarget, @Cached ReadAttributeFromDynamicObjectNode readAttrNode, @Cached BytesNodes.ToBytesNode toBytesNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached PRaiseNode.Lazy raiseNode) {
            Object[] array = getArray.execute(inliningTarget, state.getSequenceStorage());
            Object buffer = array[0];
            Object statelong = array[1];
            byte[] bufferstr = toBytesNode.execute(frame, buffer);
            int buffersize = bufferstr.length;
            if (buffersize > 8) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.UnicodeError, ErrorMessages.PENDING_BUFFER_TOO_LARGE);
            }
            self.pendingsize = buffersize;
            PythonUtils.arraycopy(bufferstr, 0, self.pending, 0, self.pendingsize);
            Object s = readAttrNode.execute(statelong, DECODER_OBJECT_ATTR);
            if (s == PNone.NO_VALUE) {
                self.state = null;
            } else {
                assert (s instanceof MultibyteCodecState) : "Not MultibyteCodecState object!";
                self.state = (MultibyteCodecState)s;
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getstate", minNumOfPositionalArgs=1, parameterNames={"$self"}, doc="getstate($self, /)\n--\n\n")
    @GenerateNodeFactory
    static abstract class GetStateNode
    extends PythonUnaryBuiltinNode {
        GetStateNode() {
        }

        static Object getstate(MultibyteIncrementalDecoderObject self, @Cached WriteAttributeToDynamicObjectNode writeAttrNode, @Cached PythonObjectFactory factory) {
            PBytes buffer = factory.createBytes(Arrays.copyOf(self.pending, self.pendingsize));
            PInt statelong = factory.createInt(0);
            writeAttrNode.execute((Object)statelong, DECODER_OBJECT_ATTR, (Object)self.state);
            return factory.createTuple(new Object[]{buffer, statelong});
        }
    }

    @Builtin(name="decode", minNumOfPositionalArgs=1, parameterNames={"$self", "input", "final"}, doc="decode($self, /, input, final=False)\n--\n\n")
    @ArgumentsClinic(value={@ArgumentClinic(name="input", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="final", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class DecodeNode
    extends PythonTernaryClinicBuiltinNode {
        DecodeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteIncrementalDecoderBuiltinsClinicProviders.DecodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object decode(VirtualFrame frame, MultibyteIncrementalDecoderObject self, byte[] input, int end, @Bind(value="this") Node inliningTarget, @Cached MultibyteCodecUtil.DecodeErrorNode decodeErrorNode, @Cached PRaiseNode.Lazy raiseNode) {
            byte[] data = input;
            int size = input.length;
            int origpending = self.pendingsize;
            byte[] wdata = data;
            if (self.pendingsize != 0) {
                if (size > Integer.MAX_VALUE - self.pendingsize) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.MemoryError);
                }
                int wsize = size + self.pendingsize;
                wdata = new byte[wsize];
                PythonUtils.arraycopy(self.pending, 0, wdata, 0, self.pendingsize);
                PythonUtils.arraycopy(data, 0, wdata, self.pendingsize, size);
                self.pendingsize = 0;
            }
            MultibyteDecodeBuffer buf = new MultibyteDecodeBuffer(wdata);
            DecodeNode.decoderFeedBuffer(frame, self, buf, decodeErrorNode, inliningTarget);
            if (end != 0 && !buf.isFull()) {
                try {
                    decodeErrorNode.execute(frame, self.codec, buf, self.errors, -2);
                }
                catch (PException e) {
                    PythonUtils.arraycopy(wdata, 0, self.pending, 0, origpending);
                    self.pendingsize = origpending;
                    throw e;
                }
            }
            if (!buf.isFull()) {
                DecodeNode.decoderAppendPending(inliningTarget, self, buf, raiseNode);
            }
            return buf.toTString();
        }

        static int decoderAppendPending(Node inliningTarge, MultibyteStatefulDecoderContext ctx, MultibyteDecodeBuffer buf, PRaiseNode.Lazy raiseNode) {
            int npendings = buf.remaining();
            if (npendings + ctx.pendingsize > 8 || npendings > Integer.MAX_VALUE - ctx.pendingsize) {
                throw raiseNode.get(inliningTarge).raise(PythonErrorType.UnicodeError, ErrorMessages.PENDING_BUFFER_OVERFLOW);
            }
            buf.getRemaining(ctx.pending, ctx.pendingsize, npendings);
            ctx.pendingsize += npendings;
            return 0;
        }

        static int decoderFeedBuffer(VirtualFrame frame, MultibyteStatefulDecoderContext ctx, MultibyteDecodeBuffer buf, MultibyteCodecUtil.DecodeErrorNode decodeErrorNode, Node raisingNode) {
            int r;
            while (!buf.isFull() && (r = ctx.codec.decode(ctx.state, buf, raisingNode)) != 0 && r != -2) {
                decodeErrorNode.execute(frame, ctx.codec, buf, ctx.errors, r);
            }
            return 0;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone init(MultibyteIncrementalDecoderObject self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, parameterNames={"$cls", "errors"})
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBinaryBuiltinNode {
        private static final TruffleString CODEC = PythonUtils.tsLiteral("codec");

        protected NewNode() {
        }

        @Specialization
        static Object mbstreamreaderNew(VirtualFrame frame, Object type, Object err, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached PyObjectGetAttr getAttr, @Cached TruffleString.EqualNode isEqual, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString errors = null;
            if (err != PNone.NO_VALUE) {
                errors = castToStringNode.execute(inliningTarget, err);
            }
            MultibyteIncrementalDecoderObject self = factory.createMultibyteIncrementalDecoderObject(type);
            Object codec = getAttr.execute((Frame)frame, inliningTarget, type, CODEC);
            if (!(codec instanceof MultibyteCodecObject)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CODEC_IS_UNEXPECTED_TYPE);
            }
            self.codec = ((MultibyteCodecObject)codec).codec;
            self.pendingsize = 0;
            self.errors = MultibyteCodecUtil.internalErrorCallback(errors, isEqual);
            self.state = self.codec.decinit(self.errors);
            return self;
        }
    }
}

