/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public final class PythonCextTupleBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTuple_GetSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTuple_GetSlice() {
        }

        @Specialization
        static Object getSlice(PTuple tuple, Object iLow, Object iHigh, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="newSlice") @Cached PySliceNew sliceNode) {
            return PyTuple_GetSlice.doGetSlice(tuple.getSequenceStorage(), inliningTarget, iLow, iHigh, getItemNode, sliceNode);
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject tuple, Object iLow, Object iHigh, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="newSlice") @Cached PySliceNew sliceNode, @Cached TupleNodes.GetNativeTupleStorage asNativeStorage) {
            return PyTuple_GetSlice.doGetSlice(asNativeStorage.execute(tuple), inliningTarget, iLow, iHigh, getItemNode, sliceNode);
        }

        @Fallback
        Object fallback(Object tuple, Object iLow, Object iHigh) {
            throw this.raiseFallback(tuple, PythonBuiltinClassType.PTuple);
        }

        private static Object doGetSlice(SequenceStorage storage, Node inliningTarget, Object iLow, Object iHigh, SequenceStorageNodes.GetItemNode getItemNode, PySliceNew sliceNode) {
            return getItemNode.execute(null, storage, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTuple_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTuple_Size() {
        }

        @Specialization
        public static int size(Object tuple, @Bind(value="this") Node inliningTarget, @Cached PyTupleSizeNode pyTupleSizeNode) {
            return pyTupleSizeNode.execute(inliningTarget, tuple);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    public static abstract class PyTuple_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        public abstract Object execute(PTuple var1, long var2);

        @Specialization
        static Object doPTuple(PTuple tuple, long key, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="promote") @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached SequenceStorageNodes.ListGeneralizationNode generalizationNode, @Cached.Shared @Cached SequenceStorageNodes.SetItemScalarNode setItemNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            int index;
            SequenceStorage sequenceStorage = tuple.getSequenceStorage();
            Object result = getItemNode.execute(inliningTarget, sequenceStorage, index = PyTuple_GetItem.checkIndex(inliningTarget, key, sequenceStorage, raiseNode));
            Object promotedValue = promoteNode.execute(inliningTarget, result);
            if (promotedValue != null) {
                sequenceStorage = generalizationNode.execute(inliningTarget, sequenceStorage, promotedValue);
                tuple.setSequenceStorage(sequenceStorage);
                setItemNode.execute(inliningTarget, sequenceStorage, index, promotedValue);
                return promotedValue;
            }
            if (result == null) {
                return PyTuple_GetItem.getNativeNull(inliningTarget);
            }
            return result;
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject tuple, long key, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetNativeTupleStorage asNativeStorage, @Cached.Shared(value="promote") @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached.Shared @Cached SequenceStorageNodes.SetItemScalarNode setItemNode, @Cached.Shared @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            int index;
            NativeObjectSequenceStorage sequenceStorage = asNativeStorage.execute(tuple);
            Object result = getItemNode.execute(inliningTarget, sequenceStorage, index = PyTuple_GetItem.checkIndex(inliningTarget, key, sequenceStorage, raiseNode));
            Object promotedValue = promoteNode.execute(inliningTarget, result);
            if (promotedValue != null) {
                setItemNode.execute(inliningTarget, sequenceStorage, index, promotedValue);
                return promotedValue;
            }
            if (result == null) {
                return PyTuple_GetItem.getNativeNull(inliningTarget);
            }
            return result;
        }

        @Fallback
        Object fallback(Object tuple, Object pos) {
            throw this.raiseFallback(tuple, PythonBuiltinClassType.PTuple);
        }

        private static int checkIndex(Node inliningTarget, long key, SequenceStorage sequenceStorage, PRaiseNode.Lazy raiseNode) {
            if (key < 0L || key >= (long)sequenceStorage.length()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.TUPLE_OUT_OF_BOUNDS);
            }
            return (int)key;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObjectBorrowed}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyTuple_SET_ITEM
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyTuple_SET_ITEM() {
        }

        @Specialization
        static int doManaged(PTuple tuple, long index, Object element, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.ListGeneralizationNode generalizationNode, @Cached SequenceStorageNodes.InitializeItemScalarNode setItemNode, @Cached InlinedConditionProfile generalizedProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage sequenceStorage = tuple.getSequenceStorage();
            _PyTuple_SET_ITEM.checkBounds(inliningTarget, sequenceStorage, index, raiseNode);
            SequenceStorage newStorage = generalizationNode.execute(inliningTarget, sequenceStorage, element);
            setItemNode.execute(inliningTarget, newStorage, (int)index, element);
            if (generalizedProfile.profile(inliningTarget, tuple.getSequenceStorage() != newStorage)) {
                tuple.setSequenceStorage(newStorage);
            }
            return 0;
        }

        @Specialization
        static int doNative(PythonAbstractNativeObject tuple, long index, Object element, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetNativeTupleStorage asNativeStorage, @Cached SequenceStorageNodes.InitializeNativeItemScalarNode setItemNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            NativeObjectSequenceStorage sequenceStorage = asNativeStorage.execute(tuple);
            _PyTuple_SET_ITEM.checkBounds(inliningTarget, sequenceStorage, index, raiseNode);
            setItemNode.execute(sequenceStorage, (int)index, element);
            return 0;
        }

        @Fallback
        Object fallback(Object tuple, Object index, Object element) {
            throw this.raiseFallback(tuple, PythonBuiltinClassType.PTuple);
        }

        private static void checkBounds(Node inliningTarget, SequenceStorage sequenceStorage, long index, PRaiseNode.Lazy raiseNode) {
            if (index < 0L || index >= (long)sequenceStorage.length()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.TUPLE_OUT_OF_BOUNDS);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObjectTransfer}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTuple_SetItem
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTuple_SetItem() {
        }

        @Specialization
        static int doManaged(PTuple tuple, long index, Object element, @Bind(value="this") Node inliningTarget, @Cached(value="createSetItem()") SequenceStorageNodes.SetItemNode setItemNode, @Cached InlinedConditionProfile generalizedProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage sequenceStorage = tuple.getSequenceStorage();
            PyTuple_SetItem.checkBounds(inliningTarget, sequenceStorage, index, raiseNode);
            SequenceStorage newStorage = setItemNode.execute(null, sequenceStorage, (Object)((int)index), element);
            if (generalizedProfile.profile(inliningTarget, tuple.getSequenceStorage() != newStorage)) {
                tuple.setSequenceStorage(newStorage);
            }
            return 0;
        }

        @Specialization
        static int doNative(PythonAbstractNativeObject tuple, long index, Object element, @Bind(value="this") Node inliningTarget, @Cached TupleNodes.GetNativeTupleStorage asNativeStorage, @Cached SequenceStorageNodes.SetNativeItemScalarNode setItemNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            NativeObjectSequenceStorage sequenceStorage = asNativeStorage.execute(tuple);
            PyTuple_SetItem.checkBounds(inliningTarget, sequenceStorage, index, raiseNode);
            setItemNode.execute(sequenceStorage, (int)index, element);
            return 0;
        }

        @Fallback
        Object fallback(Object tuple, Object index, Object element) {
            throw this.raiseFallback(tuple, PythonBuiltinClassType.PTuple);
        }

        private static void checkBounds(Node inliningTarget, SequenceStorage sequenceStorage, long index, PRaiseNode.Lazy raiseNode) {
            if (index < 0L || index >= (long)sequenceStorage.length()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.TUPLE_OUT_OF_BOUNDS);
            }
        }

        @NeverDefault
        protected static SequenceStorageNodes.SetItemNode createSetItem() {
            return SequenceStorageNodes.SetItemNode.create(null, SequenceStorageNodes.ListGeneralizationNode::create);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTuple_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTuple_New() {
        }

        @Specialization
        static PTuple doGeneric(long size, @Cached PythonObjectFactory factory) {
            return factory.createTuple(new Object[(int)size]);
        }
    }
}

