/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;

public final class PythonCextPyStateBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleState_FindModule
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleState_FindModule() {
        }

        @Specialization
        Object doGeneric(long mIndex) {
            try {
                int i = PInt.intValueExact(mIndex);
                Object result = this.getCApiContext().getModuleByIndex(i);
                if (result == null) {
                    return this.getNativeNull();
                }
                return result;
            }
            catch (CannotCastException | OverflowException e) {
                return this.getNativeNull();
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyThreadState_GetDict
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyThreadState_GetDict() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PDict get(@Cached PythonObjectFactory factory) {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            PDict threadStateDict = threadState.getDict();
            if (threadStateDict == null) {
                threadStateDict = factory.createDict();
                threadState.setDict(threadStateDict);
            }
            return threadStateDict;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyThreadState, args={}, call=PythonCextBuiltins.CApiCallPath.Direct, inlined=true)
    static abstract class PyThreadState_Get
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyThreadState_Get() {
        }

        @Specialization
        Object get() {
            return PThreadState.getThreadState(this.getLanguage(), this.getContext());
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={}, acquiresGIL=false, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTruffleGILState_Release
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleGILState_Release() {
        }

        @Specialization
        static Object restore(@Cached GilNode gil) {
            gil.release(true);
            return PNone.NO_VALUE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={}, acquiresGIL=false, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTruffleGILState_Ensure
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleGILState_Ensure() {
        }

        @Specialization
        static Object save(@Cached GilNode gil) {
            boolean acquired = gil.acquire();
            return acquired ? 1 : 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={}, acquiresGIL=false, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyGILState_Check
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyGILState_Check() {
        }

        @Specialization
        Object check() {
            return PythonContext.get(this).ownsGil() ? 1 : 0;
        }
    }
}

