/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.PyDictSetDefault;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;

public final class PythonCextDictBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Merge
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyDict_Merge() {
        }

        @Specialization(guards={"override != 0"})
        static int merge(PDict a, Object b, int override, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupKeys, @Cached PyObjectLookupAttr lookupAttr, @Cached.Shared @Cached CallNode callNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (lookupKeys.execute(null, inliningTarget, b, SpecialMethodNames.T_KEYS) == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, b, SpecialMethodNames.T_KEYS);
            }
            Object updateCallable = lookupAttr.execute(null, inliningTarget, a, SpecialMethodNames.T_UPDATE);
            callNode.execute(updateCallable, b);
            return 0;
        }

        @Specialization(guards={"override == 0"})
        static int merge(PDict a, PDict b, int override, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetIterator getBIter, @Cached HashingStorageNodes.HashingStorageIteratorNext itBNext, @Cached HashingStorageNodes.HashingStorageIteratorKey itBKey, @Cached HashingStorageNodes.HashingStorageIteratorValue itBValue, @Cached HashingStorageNodes.HashingStorageIteratorKeyHash itBKeyHash, @Cached HashingStorageNodes.HashingStorageGetItemWithHash getAItem, @Cached HashingStorageNodes.HashingStorageSetItemWithHash setAItem, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile) {
            HashingStorage bStorage = b.getDictStorage();
            HashingStorageNodes.HashingStorageIterator bIt = getBIter.execute(inliningTarget, bStorage);
            HashingStorage aStorage = a.getDictStorage();
            while (loopProfile.profile(inliningTarget, itBNext.execute(inliningTarget, bStorage, bIt))) {
                long hash;
                Object key = itBKey.execute(inliningTarget, bStorage, bIt);
                if (getAItem.execute(null, inliningTarget, aStorage, key, hash = itBKeyHash.execute(inliningTarget, bStorage, bIt)) == null) continue;
                setAItem.execute(null, inliningTarget, aStorage, key, hash, itBValue.execute(inliningTarget, bStorage, bIt));
            }
            return 0;
        }

        @Specialization(guards={"override == 0", "!isDict(b)"})
        static int merge(PDict a, Object b, int override, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached.Shared @Cached CallNode callNode, @Cached ListNodes.ConstructListNode listNode, @Cached SequenceStorageNodes.GetItemNode getKeyNode, @Cached PyObjectGetItem getValueNode, @Cached HashingStorageNodes.HashingStorageGetItem getItemA, @Cached HashingStorageNodes.HashingStorageSetItem setItemA, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached InlinedBranchProfile noKeyProfile) {
            Object attr = getAttrNode.execute(null, inliningTarget, a, SpecialMethodNames.T_KEYS);
            PList keys = listNode.execute(null, callNode.execute(null, attr, new Object[0]));
            SequenceStorage keysStorage = keys.getSequenceStorage();
            HashingStorage aStorage = a.getDictStorage();
            int size = keysStorage.length();
            loopProfile.profileCounted(inliningTarget, (long)size);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < size)) {
                Object key = getKeyNode.execute(keysStorage, i);
                if (!getItemA.hasKey(null, inliningTarget, aStorage, key)) {
                    noKeyProfile.enter(inliningTarget);
                    Object value = getValueNode.execute(null, inliningTarget, b, key);
                    aStorage = setItemA.execute(null, inliningTarget, aStorage, key, value);
                }
                ++i;
            }
            a.setDictStorage(aStorage);
            return 0;
        }

        @Fallback
        int fallback(Object dict, Object b, Object override) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Values
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyDict_Values() {
        }

        @Specialization
        static Object values(PDict dict, @Cached ListNodes.ConstructListNode listNode, @Cached PythonObjectFactory factory) {
            return listNode.execute(null, factory.createDictValuesView(dict));
        }

        @Fallback
        PythonNativePointer fallback(Object dict) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Keys
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyDict_Keys() {
        }

        @Specialization
        static Object keys(PDict dict, @Cached ListNodes.ConstructListNode listNode, @Cached PythonObjectFactory factory) {
            return listNode.execute(null, factory.createDictKeysView(dict));
        }

        @Fallback
        PythonNativePointer fallback(Object dict) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Clear
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyDict_Clear() {
        }

        @Specialization
        static Object keys(PDict dict, @Cached DictBuiltins.ClearNode clearNode) {
            return clearNode.execute(null, dict);
        }

        @Fallback
        public PythonNativePointer fallback(Object dict) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Contains
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyDict_Contains() {
        }

        @Specialization
        static int contains(PDict dict, Object key, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return PInt.intValue(getItem.hasKey(null, inliningTarget, dict.getDictStorage(), key));
        }

        @Fallback
        public int fallback(Object dict, Object key) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Update
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyDict_Update() {
        }

        @Specialization
        static int update(PDict dict, Object other, @Cached DictNodes.UpdateNode updateNode) {
            updateNode.execute(null, dict, other);
            return 0;
        }

        @Fallback
        public int fallback(Object dict, Object other) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_DelItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyDict_DelItem() {
        }

        @Specialization
        static int delItem(PDict dict, Object key, @Cached DictBuiltins.DelItemNode delItemNode) {
            delItemNode.execute(null, dict, key);
            return 0;
        }

        @Fallback
        public int fallback(Object dict, Object key) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_SetDefault
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyDict_SetDefault() {
        }

        @Specialization
        static Object setItem(PDict dict, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached PyDictSetDefault setDefault) {
            return setDefault.execute(null, inliningTarget, dict, key, value);
        }

        @Fallback
        public Object fallback(Object dict, Object key, Object value) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Py_hash_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyDict_SetItem_KnownHash
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        _PyDict_SetItem_KnownHash() {
        }

        @Specialization
        static int setItem(PDict dict, Object key, Object value, Object givenHash, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached CastToJavaLongExactNode castToLong, @Cached HashingCollectionNodes.SetItemNode setItemNode, @Cached InlinedBranchProfile wrongHashProfile, @Cached PRaiseNode.Lazy raiseNode) {
            if (hashNode.execute(null, inliningTarget, key) != castToLong.execute(inliningTarget, givenHash)) {
                wrongHashProfile.enter(inliningTarget);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AssertionError, ErrorMessages.HASH_MISMATCH);
            }
            setItemNode.execute(null, inliningTarget, dict, key, value);
            return 0;
        }

        @Fallback
        int fallback(Object dict, Object key, Object value, Object givenHash) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_SetItem
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyDict_SetItem() {
        }

        @Specialization
        static int setItem(PDict dict, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.SetItemNode setItemNode) {
            setItemNode.execute(null, inliningTarget, dict, key, value);
            return 0;
        }

        @Fallback
        int fallback(Object dict, Object key, Object value) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_GetItemWithError
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyDict_GetItemWithError() {
        }

        @Specialization
        static Object getItem(PDict dict, Object key, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached HashingCollectionNodes.SetItemNode setItemNode, @Cached InlinedBranchProfile noResultProfile) {
            Object res = getItem.execute(null, inliningTarget, dict.getDictStorage(), key);
            if (res == null) {
                noResultProfile.enter(inliningTarget);
                return PyDict_GetItemWithError.getNativeNull(inliningTarget);
            }
            Object promotedValue = promoteNode.execute(inliningTarget, res);
            if (promotedValue != null) {
                setItemNode.execute(null, inliningTarget, dict, key, promotedValue);
                return promotedValue;
            }
            return res;
        }

        @Fallback
        PythonNativePointer fallback(Object dict, Object key) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    public static abstract class PyDict_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        @Specialization
        static Object getItem(PDict dict, Object key, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached HashingCollectionNodes.SetItemNode setItemNode, @Cached InlinedBranchProfile noResultProfile) {
            try {
                Object res = getItem.execute(null, inliningTarget, dict.getDictStorage(), key);
                if (res == null) {
                    noResultProfile.enter(inliningTarget);
                    return PyDict_GetItem.getNativeNull(inliningTarget);
                }
                Object promotedValue = promoteNode.execute(inliningTarget, res);
                if (promotedValue != null) {
                    setItemNode.execute(null, inliningTarget, dict, key, promotedValue);
                    return promotedValue;
                }
                return res;
            }
            catch (PException e) {
                return PyDict_GetItem.getNativeNull(inliningTarget);
            }
        }

        @Specialization(guards={"!isDict(obj)"})
        static Object getItem(Object obj, Object key, @Cached BuiltinConstructors.StrNode strNode, @Cached PRaiseNode raiseNode) {
            return raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_WAS_S_P, strNode.executeWith(null, obj), obj);
        }

        protected boolean isDict(Object obj) {
            return obj instanceof PDict;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Copy
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyDict_Copy() {
        }

        @Specialization
        static Object copy(PDict dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached PythonObjectFactory factory) {
            return factory.createDict(copyNode.execute(inliningTarget, dict.getDictStorage()));
        }

        @Fallback
        PythonNativePointer fallback(Object dict) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyDict_Size() {
        }

        @Specialization
        static int size(PDict dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, dict.getDictStorage());
        }

        @Fallback
        public int fallback(Object dict) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyDict_Pop
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyDict_Pop() {
        }

        @Specialization
        static Object pop(PDict dict, Object key, Object defaultValue, @Cached DictBuiltins.PopNode popNode) {
            return popNode.execute(null, dict, key, defaultValue);
        }

        @Fallback
        public PythonNativePointer fallback(Object dict, Object key, Object defaultValue) {
            throw this.raiseFallback(dict, PythonBuiltinClassType.PDict);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleDict_Next
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleDict_Next() {
        }

        @Specialization
        static Object run(PDict dict, long pos, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile needsRewriteProfile, @Cached InlinedBranchProfile economicMapProfile, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext itNext, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageIteratorValue itValue, @Cached HashingStorageNodes.HashingStorageIteratorKeyHash itKeyHash, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteKeyNode, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteValueNode, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached PythonObjectFactory factory) {
            HashingStorage storage;
            int len;
            if (pos == 0L && (len = lenNode.execute(inliningTarget, storage = dict.getDictStorage())) > 0) {
                boolean needsRewrite = false;
                if (storage instanceof EconomicMapStorage) {
                    economicMapProfile.enter(inliningTarget);
                    HashingStorageNodes.HashingStorageIterator it = getIterator.execute(inliningTarget, storage);
                    while (itNext.execute(inliningTarget, storage, it)) {
                        if (promoteKeyNode.execute(inliningTarget, itKey.execute(inliningTarget, storage, it)) == null && promoteValueNode.execute(inliningTarget, itValue.execute(inliningTarget, storage, it)) == null) continue;
                        needsRewrite = true;
                        break;
                    }
                } else {
                    needsRewrite = true;
                }
                if (needsRewrite) {
                    needsRewriteProfile.enter(inliningTarget);
                    EconomicMapStorage newStorage = EconomicMapStorage.create(len);
                    HashingStorageNodes.HashingStorageIterator it = getIterator.execute(inliningTarget, storage);
                    while (itNext.execute(inliningTarget, storage, it)) {
                        Object promotedValue;
                        Object key = itKey.execute(inliningTarget, storage, it);
                        Object value = itValue.execute(inliningTarget, storage, it);
                        Object promotedKey = promoteKeyNode.execute(inliningTarget, key);
                        if (promotedKey != null) {
                            key = promotedKey;
                        }
                        if ((promotedValue = promoteValueNode.execute(inliningTarget, value)) != null) {
                            value = promotedValue;
                        }
                        setItem.execute(null, inliningTarget, newStorage, key, value);
                    }
                    dict.setDictStorage(newStorage);
                }
            }
            storage = dict.getDictStorage();
            HashingStorageNodes.HashingStorageIterator it = getIterator.execute(inliningTarget, storage);
            it.setState((int)pos - 1);
            boolean hasNext = itNext.execute(inliningTarget, storage, it);
            if (!hasNext) {
                return PyTruffleDict_Next.getNativeNull(inliningTarget);
            }
            Object key = itKey.execute(inliningTarget, storage, it);
            Object value = itValue.execute(inliningTarget, storage, it);
            assert (promoteKeyNode.execute(inliningTarget, key) == null);
            assert (promoteValueNode.execute(inliningTarget, value) == null);
            long hash = itKeyHash.execute(inliningTarget, storage, it);
            int newPos = it.getState() + 1;
            return factory.createTuple(new Object[]{key, value, hash, newPos});
        }

        @Fallback
        Object run(Object dict, Object pos) {
            return this.getNativeNull();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyDict_New
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyDict_New() {
        }

        @Specialization
        static Object run(@Cached PythonObjectFactory factory) {
            return factory.createDict();
        }
    }
}

