/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public final class PythonCextBytesBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.CHAR_PTR, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyBytes_AsString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyBytes_AsString() {
        }

        @Specialization
        static Object doBytes(PBytes bytes) {
            return PySequenceArrayWrapper.ensureNativeSequence(bytes);
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject obj, @Bind(value="this") Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached CStructAccess.GetElementPtrNode getArray, @Cached PRaiseNode.Lazy raiseNode) {
            if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PBytes)) {
                return getArray.getElementPtr(obj.getPtr(), CFields.PyBytesObject__ob_sval);
            }
            return PyBytes_AsString.doError(obj, raiseNode.get(inliningTarget));
        }

        @Fallback
        static Object doError(Object obj, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_S_P_FOUND, "bytes", obj);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_Bytes_CheckEmbeddedNull
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_Bytes_CheckEmbeddedNull() {
        }

        @Specialization
        static int doBytes(Object bytes, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode) {
            SequenceStorage sequenceStorage = getBytesStorage.execute(inliningTarget, bytes);
            int len = sequenceStorage.length();
            try {
                for (int i = 0; i < len; ++i) {
                    if (getItemScalarNode.executeInt(inliningTarget, sequenceStorage, i) != 0) continue;
                    return -1;
                }
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"bytes object contains non-int value");
            }
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_ByteArray_EmptyWithCapacity
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_ByteArray_EmptyWithCapacity() {
        }

        @Specialization
        static PByteArray doInt(int size, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createByteArray(new byte[size]);
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PByteArray doLong(long size, @Cached.Shared @Cached PythonObjectFactory factory) throws OverflowException {
            return PyTruffle_ByteArray_EmptyWithCapacity.doInt(PInt.intValueExact(size), factory);
        }

        @Specialization(replaces={"doLong"})
        static PByteArray doLongOvf(long size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PyTruffle_ByteArray_EmptyWithCapacity.doInt(PInt.intValueExact(size), factory);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raiseNumberTooLarge(PythonBuiltinClassType.IndexError, size);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PByteArray doPInt(PInt size, @Cached.Shared @Cached PythonObjectFactory factory) throws OverflowException {
            return PyTruffle_ByteArray_EmptyWithCapacity.doInt(size.intValueExact(), factory);
        }

        @Specialization(replaces={"doPInt"})
        static PByteArray doPIntOvf(PInt size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PyTruffle_ByteArray_EmptyWithCapacity.doInt(size.intValueExact(), factory);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raiseNumberTooLarge(PythonBuiltinClassType.IndexError, size);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Long}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_Bytes_EmptyWithCapacity
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_Bytes_EmptyWithCapacity() {
        }

        @Specialization
        static PBytes doInt(int size, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createBytes(new byte[size]);
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PBytes doLong(long size, @Cached.Shared @Cached PythonObjectFactory factory) throws OverflowException {
            return PyTruffle_Bytes_EmptyWithCapacity.doInt(PInt.intValueExact(size), factory);
        }

        @Specialization(replaces={"doLong"})
        static PBytes doLongOvf(long size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PyTruffle_Bytes_EmptyWithCapacity.doInt(PInt.intValueExact(size), factory);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raiseNumberTooLarge(PythonBuiltinClassType.IndexError, size);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PBytes doPInt(PInt size, @Cached.Shared @Cached PythonObjectFactory factory) throws OverflowException {
            return PyTruffle_Bytes_EmptyWithCapacity.doInt(size.intValueExact(), factory);
        }

        @Specialization(replaces={"doPInt"})
        static PBytes doPIntOvf(PInt size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return PyTruffle_Bytes_EmptyWithCapacity.doInt(size.intValueExact(), factory);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raiseNumberTooLarge(PythonBuiltinClassType.IndexError, size);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltins(value={@PythonCextBuiltins.CApiBuiltin(name="PyByteArray_Resize", ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct), @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Ignored)})
    static abstract class _PyTruffleBytes_Resize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyTruffleBytes_Resize() {
        }

        @Specialization
        static int resize(PBytesLike self, long newSizeL, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached CastToByteNode castToByteNode) {
            SequenceStorage storage = self.getSequenceStorage();
            int newSize = asSizeNode.executeExact(null, inliningTarget, newSizeL);
            int len = storage.length();
            byte[] smaller = new byte[newSize];
            for (int i = 0; i < newSize && i < len; ++i) {
                smaller[i] = castToByteNode.execute(null, getItemNode.execute(storage, i));
            }
            self.setSequenceStorage(new ByteSequenceStorage(smaller));
            return 0;
        }

        @Fallback
        static int fallback(Object self, Object o, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXPECTED_S_NOT_P, "a bytes object", self);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtr, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    @ImportStatic(value={CApiGuards.class})
    static abstract class PyTruffleByteArray_FromStringAndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleByteArray_FromStringAndSize() {
        }

        @Specialization
        static Object doGeneric(PythonNativeWrapper object, long size, @Cached CApiTransitions.NativeToPythonNode asPythonObjectNode, @Cached.Exclusive @Cached BytesNodes.ToBytesNode getByteArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            byte[] ary = getByteArrayNode.execute(null, asPythonObjectNode.execute(object));
            if (size >= 0L && size < (long)ary.length) {
                return factory.createByteArray(Arrays.copyOf(ary, (int)size));
            }
            return factory.createByteArray(ary);
        }

        @Specialization(guards={"!isNativeWrapper(nativePointer)"})
        static Object doNativePointer(Object nativePointer, long size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return factory.createByteArray(getByteArrayNode.execute(inliningTarget, nativePointer, size));
            }
            catch (InteropException e) {
                return raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                return raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtr, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    @ImportStatic(value={CApiGuards.class})
    static abstract class PyTruffleBytes_FromStringAndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleBytes_FromStringAndSize() {
        }

        @Specialization
        static Object doGeneric(PythonNativeWrapper object, long size, @Cached CApiTransitions.NativeToPythonNode asPythonObjectNode, @Cached.Exclusive @Cached BytesNodes.ToBytesNode getByteArrayNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            byte[] ary = getByteArrayNode.execute(null, asPythonObjectNode.execute(object));
            if (size >= 0L && size < (long)ary.length) {
                return factory.createBytes(Arrays.copyOf(ary, (int)size));
            }
            return factory.createBytes(ary);
        }

        @Specialization(guards={"!isNativeWrapper(nativePointer)"})
        static Object doNativePointer(Object nativePointer, long size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return factory.createBytes(getByteArrayNode.execute(inliningTarget, nativePointer, size));
            }
            catch (InteropException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyBytes_FromObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyBytes_FromObject() {
        }

        @Specialization
        static Object fromObject(Object obj, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached BuiltinConstructors.BytesNode bytesNode, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (PGuards.isPBytes(obj)) {
                return obj;
            }
            Object klass = getClassNode.execute(inliningTarget, obj);
            if (isSubtypeNode.execute(klass, (Object)PythonBuiltinClassType.PBytes)) {
                return obj;
            }
            if (PyBytes_FromObject.isAcceptedSubtype(inliningTarget, obj, klass, isSubtypeNode, lookupAttrNode)) {
                return bytesNode.execute(null, (Object)PythonBuiltinClassType.PBytes, obj, PNone.NO_VALUE, PNone.NO_VALUE);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CONVERT_P_OBJ_TO_S, obj, "bytes");
        }

        private static boolean isAcceptedSubtype(Node inliningTarget, Object obj, Object klass, IsSubtypeNode isSubtypeNode, PyObjectLookupAttr lookupAttrNode) {
            return isSubtypeNode.execute(klass, (Object)PythonBuiltinClassType.PList) || isSubtypeNode.execute(klass, (Object)PythonBuiltinClassType.PTuple) || isSubtypeNode.execute(klass, (Object)PythonBuiltinClassType.PMemoryView) || !isSubtypeNode.execute(klass, (Object)PythonBuiltinClassType.PString) && lookupAttrNode.execute(null, inliningTarget, obj, SpecialMethodNames.T___ITER__) != PNone.NO_VALUE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleBytes_FromFormat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleBytes_FromFormat() {
        }

        @Specialization
        static Object fromFormat(TruffleString fmt, Object args, @Cached StringBuiltins.ModNode modeNode, @Cached StringBuiltins.EncodeNode encodeNode) {
            Object formated = modeNode.execute(null, fmt, args);
            return encodeNode.execute(null, formated, PNone.NONE, PNone.NONE);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyBytes_Join
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyBytes_Join() {
        }

        @Specialization
        static Object join(Object original, Object newPart, @Cached BytesBuiltins.JoinNode joinNode) {
            return joinNode.execute(null, original, newPart);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleBytes_Concat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleBytes_Concat() {
        }

        @Specialization
        static Object concat(Object original, Object newPart, @Cached BytesBuiltins.AddNode addNode) {
            return addNode.execute(null, original, newPart);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyBytes_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyBytes_Size() {
        }

        @Specialization
        static long doPBytes(PBytes obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute(null, inliningTarget, obj);
        }

        @Specialization
        static long doOther(PythonAbstractNativeObject obj, @Bind(value="this") Node inliningTarget, @Cached PyBytesCheckNode check, @Cached CStructAccess.ReadI64Node readI64Node) {
            if (check.execute(inliningTarget, obj)) {
                return readI64Node.readFromObj(obj, CFields.PyVarObject__ob_size);
            }
            return PyBytes_Size.fallback(obj, inliningTarget);
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        static long fallback(Object obj, @Bind(value="this") Node inliningTarget) {
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_BYTES_P_FOUND, obj);
        }
    }
}

