/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictFromGlobalsNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.formatting.ErrorMessageFormatter;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.IllegalFormatException;
import java.util.List;

@CoreFunctions(defineModule="_warnings")
public final class WarningsModuleBuiltins
extends PythonBuiltins {
    private static final HiddenKey FILTERS_VERSION = new HiddenKey("filters_version");
    private static final HiddenKey FILTERS = new HiddenKey("filters");
    private static final HiddenKey DEFAULTACTION = new HiddenKey("_defaultaction");
    private static final HiddenKey ONCEREGISTRY = new HiddenKey("_onceregistry");
    private static final TruffleString T___WARNINGREGISTRY__ = PythonUtils.tsLiteral("__warningregistry__");
    private static final String J_WARN = "warn";
    private static final String J_WARN_EXPLICIT = "warn_explicit";
    public static final TruffleString T_WARN = PythonUtils.tsLiteral("warn");
    public static final TruffleString T_WARN_EXPLICIT = PythonUtils.tsLiteral("warn_explicit");
    private static final TruffleString T_ERROR = PythonUtils.tsLiteral("error");
    private static final TruffleString T_ALWAYS = PythonUtils.tsLiteral("always");
    private static final TruffleString T_ONCE = PythonUtils.tsLiteral("once");
    private static final TruffleString T_IGNORE = PythonUtils.tsLiteral("ignore");
    private static final TruffleString T_MATCH = PythonUtils.tsLiteral("match");
    private static final TruffleString T_GET_SOURCE = PythonUtils.tsLiteral("get_source");
    private static final TruffleString T__SHOWWARNMSG = PythonUtils.tsLiteral("_showwarnmsg");
    private static final TruffleString T_ONCEREGISTRY = PythonUtils.tsLiteral("onceregistry");
    private static final TruffleString T_DEFAULTACTION = PythonUtils.tsLiteral("defaultaction");
    private static final TruffleString T_FILTERS = PythonUtils.tsLiteral("filters");
    private static final TruffleString T_WARNING_MESSAGE = PythonUtils.tsLiteral("WarningMessage");
    private static final TruffleString T_UNKNOWN_SOURCE = PythonUtils.tsLiteral("<unknown source>");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return WarningsModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"_warnings provides basic warning filtering support.\nIt is a helper module to speed up interpreter start-up.");
        this.addBuiltinConstant("_defaultaction", (Object)StringLiterals.T_DEFAULT);
        this.addBuiltinConstant(DEFAULTACTION, (Object)StringLiterals.T_DEFAULT);
        PDict onceregistry = core.factory().createDict();
        this.addBuiltinConstant("_onceregistry", (Object)onceregistry);
        this.addBuiltinConstant(ONCEREGISTRY, (Object)onceregistry);
        PList filters = WarningsModuleBuiltins.initFilters(core.factory());
        this.addBuiltinConstant("filters", (Object)filters);
        this.addBuiltinConstant(FILTERS, (Object)filters);
        this.addBuiltinConstant(FILTERS_VERSION, (Object)0L);
        super.initialize(core);
    }

    private static PTuple createFilter(PythonObjectSlowPathFactory factory, PythonBuiltinClassType cat, TruffleString id, Object mod) {
        return factory.createTuple(new Object[]{id, PNone.NONE, cat, mod, 0});
    }

    private static PList initFilters(PythonObjectSlowPathFactory factory) {
        return factory.createList(new Object[]{WarningsModuleBuiltins.createFilter(factory, PythonBuiltinClassType.DeprecationWarning, StringLiterals.T_DEFAULT, BuiltinNames.T___MAIN__), WarningsModuleBuiltins.createFilter(factory, PythonBuiltinClassType.DeprecationWarning, T_IGNORE, PNone.NONE), WarningsModuleBuiltins.createFilter(factory, PythonBuiltinClassType.PendingDeprecationWarning, T_IGNORE, PNone.NONE), WarningsModuleBuiltins.createFilter(factory, PythonBuiltinClassType.ImportWarning, T_IGNORE, PNone.NONE), WarningsModuleBuiltins.createFilter(factory, PythonBuiltinClassType.ResourceWarning, T_IGNORE, PNone.NONE)});
    }

    public static abstract class WarnNode
    extends Node {
        private static final WarnNode UNCACHED = new WarnNodeUncached();

        @NeverDefault
        public static WarnNode create() {
            return new WarnNodeCached();
        }

        public static WarnNode getUncached() {
            return UNCACHED;
        }

        public final void warnUnicode(Frame frame, Object category, TruffleString message, int stackLevel, Object source) {
            this.execute(frame, source, category == null ? PythonBuiltinClassType.RuntimeWarning : category, message, stackLevel, new Object[0]);
        }

        public final void warnFormat(Frame frame, Object category, TruffleString message, Object ... formatArgs) {
            this.warnFormat(frame, null, category, 1, message, formatArgs);
        }

        public final void warnFormat(Frame frame, Object source, Object category, int stackLevel, TruffleString message, Object ... formatArgs) {
            this.execute(frame, source, category == null ? PythonBuiltinClassType.RuntimeWarning : category, message, stackLevel, formatArgs);
        }

        public final void resourceWarning(Frame frame, Object source, int stackLevel, TruffleString message, Object ... formatArgs) {
            this.execute(frame, source, (Object)PythonBuiltinClassType.ResourceWarning, message, stackLevel, formatArgs);
        }

        public final void warnEx(Frame frame, Object category, TruffleString message, int stackLevel) {
            this.execute(frame, null, category == null ? PythonBuiltinClassType.RuntimeWarning : category, message, stackLevel, new Object[0]);
        }

        public final void warn(Frame frame, Object category, TruffleString message) {
            this.warnEx(frame, category, message, 1);
        }

        protected abstract void execute(Frame var1, Object var2, Object var3, TruffleString var4, int var5, Object ... var6);

        private static final class WarnNodeCached
        extends WarnNode {
            @CompilerDirectives.CompilationFinal
            BranchProfile noFrame = BranchProfile.create();
            @Node.Child
            WarningsModuleNode moduleFunctionsNode;
            @Node.Child
            TruffleString.FromJavaStringNode fromJavaStringNode;
            final IndirectCallData indirectCallData = IndirectCallData.createFor(this);

            private WarnNodeCached() {
            }

            @Override
            protected void execute(Frame frame, Object source, Object category, TruffleString format, int stackLevel, Object ... formatArgs) {
                if (frame == null) {
                    this.noFrame.enter();
                    UNCACHED.execute(null, source, category, format, stackLevel, formatArgs);
                    return;
                }
                assert (frame instanceof VirtualFrame);
                PythonModule _warnings = PythonContext.get(this).lookupBuiltinModule(BuiltinNames.T__WARNINGS);
                if (this.fromJavaStringNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.fromJavaStringNode = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                }
                TruffleString message = this.fromJavaStringNode.execute(WarnNodeCached.formatMessage(format, formatArgs), PythonUtils.TS_ENCODING);
                if (this.moduleFunctionsNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.moduleFunctionsNode = (WarningsModuleNode)this.insert(WarningsModuleNode.create());
                }
                this.moduleFunctionsNode.doWarn((VirtualFrame)frame, _warnings, message, category, stackLevel, source, this.indirectCallData);
            }

            @CompilerDirectives.TruffleBoundary
            private static String formatMessage(TruffleString format, Object ... formatArgs) {
                String message;
                try {
                    message = ErrorMessageFormatter.format(format, formatArgs);
                }
                catch (IllegalFormatException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)("error while formatting \"" + String.valueOf(format) + "\""), (Throwable)e);
                }
                return message;
            }
        }

        private static final class WarnNodeUncached
        extends WarnNode {
            private WarnNodeUncached() {
            }

            public boolean isAdoptable() {
                return false;
            }

            @Override
            protected void execute(Frame frame, Object source, Object category, TruffleString format, int stackLevel, Object ... formatArgs) {
                this.executeImpl(source, category, format, stackLevel, formatArgs);
            }

            @CompilerDirectives.TruffleBoundary
            private void executeImpl(Object source, Object category, TruffleString format, int stackLevel, Object ... formatArgs) {
                TruffleString message;
                PythonModule _warnings = PythonContext.get(this).lookupBuiltinModule(BuiltinNames.T__WARNINGS);
                Object warn = DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)_warnings, (Object)T_WARN, (Object)PNone.NONE);
                try {
                    message = TruffleString.fromJavaStringUncached((String)ErrorMessageFormatter.format(format, formatArgs), (TruffleString.Encoding)PythonUtils.TS_ENCODING);
                }
                catch (IllegalFormatException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)("error while formatting \"" + String.valueOf(format) + "\""), (Throwable)e);
                }
                CallNode.getUncached().execute(warn, message, category, stackLevel, source);
            }
        }
    }

    @Builtin(name="_filters_mutated", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class FiltersMutated
    extends PythonBuiltinNode {
        FiltersMutated() {
        }

        @Specialization(limit="1")
        static PNone mutate(PythonModule self, @CachedLibrary(value="self") DynamicObjectLibrary dylib) {
            long version = 0L;
            try {
                version = dylib.getLongOrDefault((DynamicObject)self, (Object)FILTERS_VERSION, (Object)0);
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            dylib.putLong((DynamicObject)self, (Object)FILTERS_VERSION, version + 1L);
            return PNone.NONE;
        }
    }

    @NodeInfo(shortName="warnings_warn_explicit")
    @Builtin(name="warn_explicit", minNumOfPositionalArgs=5, parameterNames={"$mod", "message", "category", "filename", "lineno", "module", "registry", "module_globals", "source"}, declaresExplicitSelf=true)
    @ReportPolymorphism
    @ArgumentClinic(name="lineno", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class WarnExplicitBuiltinNode
    extends PythonClinicBuiltinNode {
        WarnExplicitBuiltinNode() {
        }

        @Specialization
        static Object doWarn(VirtualFrame frame, PythonModule mod, Object message, Object category, Object flname, int lineno, Object module, Object registry, Object globals, Object source, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached CastToTruffleStringNode castStr, @Cached WarningsModuleNode moduleFunctionsNode, @Cached PRaiseNode.Lazy raiseNode) {
            PDict globalsDict;
            TruffleString filename;
            try {
                filename = castStr.execute(inliningTarget, flname);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "warn_explicit()", 3, "str", flname);
            }
            if (globals instanceof PNone) {
                globalsDict = null;
            } else if (globals instanceof PDict) {
                globalsDict = (PDict)globals;
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MOD_GLOBALS_MUST_BE_DICT, globals);
            }
            moduleFunctionsNode.warnExplicit(frame, mod, category, message, filename, lineno, module == PNone.NO_VALUE ? null : module, registry == PNone.NO_VALUE ? null : registry, globalsDict, source == PNone.NO_VALUE ? null : source, indirectCallData);
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return WarningsModuleBuiltinsClinicProviders.WarnExplicitBuiltinNodeClinicProviderGen.INSTANCE;
        }
    }

    @NodeInfo(shortName="warnings_warn_impl", description="implements warnings_warn_impl and the clinic wrapper")
    @Builtin(name="warn", minNumOfPositionalArgs=2, parameterNames={"$mod", "message", "category", "stacklevel", "source"}, declaresExplicitSelf=true, alwaysNeedsCallerFrame=true)
    @ReportPolymorphism
    @ArgumentsClinic(value={@ArgumentClinic(name="category", defaultValue="PNone.NONE"), @ArgumentClinic(name="stacklevel", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="1"), @ArgumentClinic(name="source", defaultValue="PNone.NONE")})
    @GenerateNodeFactory
    public static abstract class WarnBuiltinNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return WarningsModuleBuiltinsClinicProviders.WarnBuiltinNodeClinicProviderGen.INSTANCE;
        }

        public abstract Object execute(VirtualFrame var1, PythonModule var2, Object var3, Object var4, int var5, Object var6);

        @Specialization
        Object doWarn(VirtualFrame frame, PythonModule mod, Object message, Object category, int stacklevel, Object source, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached WarningsModuleNode moduleFunctionsNode) {
            moduleFunctionsNode.doWarn(frame, mod, message, moduleFunctionsNode.getCategory(frame, message, category), stacklevel, source, indirectCallData);
            return PNone.NONE;
        }

        @NeverDefault
        public static WarnBuiltinNode create() {
            return WarningsModuleBuiltinsFactory.WarnBuiltinNodeFactory.create(null);
        }
    }

    static final class WarningsModuleNode
    extends Node {
        @Node.Child
        DynamicObjectLibrary warningsModuleLib;
        @Node.Child
        CastToTruffleStringNode castStr;
        @Node.Child
        PRaiseNode raiseNode;
        @Node.Child
        PyObjectRichCompareBool.EqNode eqNode;
        @Node.Child
        GetClassNode getClassNode;
        @Node.Child
        PyNumberAsSizeNode asSizeNode;
        @Node.Child
        PyObjectIsTrueNode isTrueNode;
        @Node.Child
        PythonObjectFactory factory;
        @Node.Child
        BuiltinFunctions.IsSubClassNode isSubClassNode;
        @Node.Child
        GetOrCreateDictNode getDictNode;
        @Node.Child
        GetDictFromGlobalsNode getDictFromGlobalsNode;
        @Node.Child
        ReadCallerFrameNode readCallerNode;
        @Node.Child
        PyObjectLookupAttr lookupAttrNode;
        @Node.Child
        PyObjectCallMethodObjArgs callMethodNode;
        @Node.Child
        PyDictGetItem dictGetItemNode;
        @Node.Child
        PyObjectSetItem setItemNode;
        @Node.Child
        PyObjectStrAsObjectNode strNode;
        @Node.Child
        CallNode callNode;
        @Node.Child
        SequenceStorageNodes.GetItemScalarNode sequenceGetItemNode;
        @Node.Child
        TypeNodes.IsTypeNode isTypeNode;
        @Node.Child
        TruffleString.CodePointLengthNode codePointLengthNode;
        @Node.Child
        TruffleString.RegionEqualNode regionEqualNode;
        @Node.Child
        TruffleString.EqualNode equalNode;
        @Node.Child
        TruffleString.SubstringNode substringNode;

        WarningsModuleNode() {
        }

        @NeverDefault
        static WarningsModuleNode create() {
            return new WarningsModuleNode();
        }

        private static Object tryImport() {
            return AbstractImportNode.importModule(StringLiterals.T_WARNINGS);
        }

        private PythonLanguage getLanguage() {
            return PythonLanguage.get(this);
        }

        private PythonContext getContext() {
            return PythonContext.get(this);
        }

        private DynamicObjectLibrary getWarnLib() {
            if (this.warningsModuleLib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.warningsModuleLib = (DynamicObjectLibrary)this.insert((Node)((DynamicObjectLibrary)DynamicObjectLibrary.getFactory().createDispatched(1)));
            }
            return this.warningsModuleLib;
        }

        private PyObjectRichCompareBool.EqNode getEqNode() {
            if (this.eqNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.eqNode = (PyObjectRichCompareBool.EqNode)this.insert(PyObjectRichCompareBool.EqNode.create());
            }
            return this.eqNode;
        }

        private TypeNodes.IsTypeNode getIsTypeNode() {
            if (this.isTypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isTypeNode = (TypeNodes.IsTypeNode)this.insert(TypeNodes.IsTypeNode.create());
            }
            return this.isTypeNode;
        }

        private PyObjectLookupAttr getLookupAttrNode() {
            if (this.lookupAttrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupAttrNode = (PyObjectLookupAttr)this.insert(PyObjectLookupAttr.create());
            }
            return this.lookupAttrNode;
        }

        private PyObjectCallMethodObjArgs getCallMethodNode() {
            if (this.callMethodNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callMethodNode = (PyObjectCallMethodObjArgs)this.insert(PyObjectCallMethodObjArgs.create());
            }
            return this.callMethodNode;
        }

        private PyDictGetItem getDictGetItemNode() {
            if (this.dictGetItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.dictGetItemNode = (PyDictGetItem)this.insert(PyDictGetItem.create());
            }
            return this.dictGetItemNode;
        }

        private PyObjectSetItem getSetItemNode() {
            if (this.setItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setItemNode = (PyObjectSetItem)this.insert(PyObjectSetItem.create());
            }
            return this.setItemNode;
        }

        private PyObjectStrAsObjectNode getStrNode() {
            if (this.strNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.strNode = (PyObjectStrAsObjectNode)this.insert(PyObjectStrAsObjectNode.create());
            }
            return this.strNode;
        }

        private CallNode getCallNode() {
            if (this.callNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNode = (CallNode)this.insert(CallNode.create());
            }
            return this.callNode;
        }

        private SequenceStorageNodes.GetItemScalarNode getSequenceGetItemNode() {
            if (this.sequenceGetItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.sequenceGetItemNode = (SequenceStorageNodes.GetItemScalarNode)this.insert(SequenceStorageNodes.GetItemScalarNode.create());
            }
            return this.sequenceGetItemNode;
        }

        private Object getPythonClass(Object object) {
            if (this.getClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getClassNode.executeCached(object);
        }

        private PyNumberAsSizeNode getAsSizeNode() {
            if (this.asSizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asSizeNode = (PyNumberAsSizeNode)this.insert(PyNumberAsSizeNode.create());
            }
            return this.asSizeNode;
        }

        private PyObjectIsTrueNode getIsTrueNode() {
            if (this.isTrueNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isTrueNode = (PyObjectIsTrueNode)this.insert(PyObjectIsTrueNode.create());
            }
            return this.isTrueNode;
        }

        private CastToTruffleStringNode getCastStr() {
            if (this.castStr == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.castStr = (CastToTruffleStringNode)this.insert(CastToTruffleStringNode.create());
            }
            return this.castStr;
        }

        private TruffleString.CodePointLengthNode getCodePointLengthNode() {
            if (this.codePointLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.codePointLengthNode = (TruffleString.CodePointLengthNode)this.insert((Node)TruffleString.CodePointLengthNode.create());
            }
            return this.codePointLengthNode;
        }

        private TruffleString.RegionEqualNode getRegionEqualNode() {
            if (this.regionEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.regionEqualNode = (TruffleString.RegionEqualNode)this.insert((Node)TruffleString.RegionEqualNode.create());
            }
            return this.regionEqualNode;
        }

        private TruffleString.EqualNode getEqualNode() {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
            }
            return this.equalNode;
        }

        private TruffleString.SubstringNode getSubstringNode() {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.substringNode = (TruffleString.SubstringNode)this.insert((Node)TruffleString.SubstringNode.create());
            }
            return this.substringNode;
        }

        private PRaiseNode getRaise() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode;
        }

        private PythonObjectFactory getFactory() {
            if (this.factory == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.factory = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
            }
            return this.factory;
        }

        private BuiltinFunctions.IsSubClassNode getIsSubClass() {
            if (this.isSubClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.isSubClassNode = (BuiltinFunctions.IsSubClassNode)this.insert(BuiltinFunctions.IsSubClassNode.create());
            }
            return this.isSubClassNode;
        }

        private PDict getSysDict() {
            if (this.getDictNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.getDictNode = (GetOrCreateDictNode)this.insert(GetOrCreateDictNode.create());
            }
            return this.getDictNode.executeCached(this.getContext().lookupBuiltinModule(BuiltinNames.T_SYS));
        }

        private PDict getGlobalsDict(Object globals) {
            if (this.getDictFromGlobalsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.getDictFromGlobalsNode = (GetDictFromGlobalsNode)this.insert(GetDictFromGlobalsNode.create());
            }
            return this.getDictFromGlobalsNode.executeCached(globals);
        }

        private PFrame getCallerFrame(VirtualFrame frame, int stackLevel) {
            if (this.readCallerNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.readCallerNode = (ReadCallerFrameNode)this.insert(ReadCallerFrameNode.create());
            }
            return this.readCallerNode.executeWith(frame, stackLevel);
        }

        private static long getStateFiltersVersion(PythonModule warningsModule, DynamicObjectLibrary dylib) {
            try {
                return dylib.getLongOrDefault((DynamicObject)warningsModule, (Object)FILTERS_VERSION, (Object)0);
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        private Object getStateFilters(PythonModule warningsModule) {
            return this.getWarnLib().getOrDefault((DynamicObject)warningsModule, (Object)FILTERS, null);
        }

        private static Object getStateOnceRegistry(PythonModule warningsModule) {
            return DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)warningsModule, (Object)ONCEREGISTRY, null);
        }

        private Object getStateDefaultAction(PythonModule warningsModule) {
            return this.getWarnLib().getOrDefault((DynamicObject)warningsModule, (Object)DEFAULTACTION, null);
        }

        private boolean checkMatched(VirtualFrame frame, Object obj, Object arg) {
            if (obj == PNone.NONE) {
                return true;
            }
            try {
                TruffleString objStr = this.getCastStr().executeCached(obj);
                try {
                    return this.getEqualNode().execute((AbstractTruffleString)objStr, (AbstractTruffleString)this.getCastStr().executeCached(arg), PythonUtils.TS_ENCODING);
                }
                catch (CannotCastException e) {
                    throw this.getRaise().raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_COMPARE, obj, arg);
                }
            }
            catch (CannotCastException e) {
                Object result = this.getCallMethodNode().executeCached((Frame)frame, obj, T_MATCH, arg);
                return this.getIsTrueNode().executeCached((Frame)frame, result);
            }
        }

        private Object getWarningsAttr(VirtualFrame frame, TruffleString attr) {
            return WarningsModuleNode.getWarningsAttr(frame, attr, false, this.getLookupAttrNode(), this.getCallMethodNode(), this.getContext());
        }

        private static Object getWarningsAttr(PythonContext context, TruffleString attr, boolean tryImport) {
            return WarningsModuleNode.getWarningsAttr(null, attr, tryImport, PyObjectLookupAttr.getUncached(), PyObjectCallMethodObjArgs.getUncached(), context);
        }

        private static Object getWarningsAttr(VirtualFrame frame, TruffleString attr, boolean tryImport, PyObjectLookupAttr lookup, PyObjectCallMethodObjArgs callMethod, PythonContext context) {
            Object warningsModule;
            if (tryImport) {
                try {
                    warningsModule = WarningsModuleNode.tryImport();
                }
                catch (PException e) {
                    e.expect(null, PythonBuiltinClassType.ImportError, BuiltinClassProfiles.IsBuiltinObjectProfile.getUncached());
                    return null;
                }
            }
            PythonModule sys = context.lookupBuiltinModule(BuiltinNames.T_SYS);
            Object modules = lookup.executeCached((Frame)frame, sys, BuiltinNames.T_MODULES);
            try {
                warningsModule = callMethod.executeCached((Frame)frame, modules, SpecialMethodNames.T_GET, StringLiterals.T_WARNINGS, PNone.NONE);
            }
            catch (PException e) {
                return null;
            }
            if (warningsModule == PNone.NONE) {
                return null;
            }
            Object result = lookup.executeCached((Frame)frame, warningsModule, attr);
            if (result == PNone.NO_VALUE) {
                return null;
            }
            return result;
        }

        private static PDict getOnceRegistry(Node node, PythonContext context, PythonModule module) {
            Object registry = WarningsModuleNode.getWarningsAttr(context, T_ONCEREGISTRY, false);
            if (registry == null) {
                registry = WarningsModuleNode.getStateOnceRegistry(module);
            }
            if (!(registry instanceof PDict)) {
                throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.WARN_ONCE_REG_MUST_BE_DICT, registry);
            }
            return (PDict)registry;
        }

        private TruffleString getDefaultAction(VirtualFrame frame, PythonModule module) {
            Object defaultAction = this.getWarningsAttr(frame, T_DEFAULTACTION);
            if (defaultAction == null) {
                defaultAction = this.getStateDefaultAction(module);
            }
            try {
                return this.getCastStr().executeCached(defaultAction);
            }
            catch (CannotCastException e) {
                throw this.getRaise().raise(PythonBuiltinClassType.TypeError, ErrorMessages.WARN_DEF_ACTION_MUST_BE_STRING, defaultAction);
            }
        }

        private TruffleString getFilter(VirtualFrame frame, PythonModule _warnings, Object category, Object text, int lineno, Object module, Object[] item) {
            Object filters = this.getWarningsAttr(frame, T_FILTERS);
            if (filters != null) {
                this.getWarnLib().put((DynamicObject)_warnings, (Object)FILTERS, filters);
            } else {
                filters = this.getStateFilters(_warnings);
            }
            if (!(filters instanceof PList)) {
                throw this.getRaise().raise(PythonBuiltinClassType.ValueError, ErrorMessages.WARN_FILTERS_MUST_BE_LIST);
            }
            SequenceStorage filtersStorage = ((PList)filters).getSequenceStorage();
            SequenceStorageNodes.GetItemScalarNode sequenceGetItem = this.getSequenceGetItemNode();
            for (int i = 0; i < filtersStorage.length(); ++i) {
                TruffleString action;
                Object tmpItem = sequenceGetItem.executeCached(filtersStorage, i);
                if (!(tmpItem instanceof PTuple)) {
                    throw this.getRaise().raise(PythonBuiltinClassType.ValueError, ErrorMessages.WARN_FILTERS_IETM_ISNT_5TUPLE, i);
                }
                SequenceStorage tmpStorage = ((PTuple)tmpItem).getSequenceStorage();
                if (tmpStorage.length() != 5) {
                    throw this.getRaise().raise(PythonBuiltinClassType.ValueError, ErrorMessages.WARN_FILTERS_IETM_ISNT_5TUPLE, i);
                }
                Object actionObj = sequenceGetItem.executeCached(tmpStorage, 0);
                try {
                    action = this.getCastStr().executeCached(actionObj);
                }
                catch (CannotCastException e) {
                    throw this.getRaise().raise(PythonBuiltinClassType.TypeError, ErrorMessages.ACTION_MUST_BE_STRING, actionObj);
                }
                Object msg = sequenceGetItem.executeCached(tmpStorage, 1);
                Object cat = sequenceGetItem.executeCached(tmpStorage, 2);
                Object mod = sequenceGetItem.executeCached(tmpStorage, 3);
                Object lnObj = sequenceGetItem.executeCached(tmpStorage, 4);
                boolean goodMsg = this.checkMatched(frame, msg, text);
                boolean goodMod = this.checkMatched(frame, mod, module);
                boolean isSubclass = this.getIsSubClass().executeBoolean(frame, category, cat);
                int ln = this.getAsSizeNode().executeExactCached((Frame)frame, lnObj);
                if (!goodMsg || !isSubclass || !goodMod || ln != 0 && lineno != ln) continue;
                LoopNode.reportLoopCount((Node)this, (int)(i + 1));
                item[0] = tmpItem;
                return action;
            }
            TruffleString action = this.getDefaultAction(frame, _warnings);
            item[0] = PNone.NONE;
            return action;
        }

        private boolean alreadyWarnedShouldNotSet(VirtualFrame frame, PythonModule _warnings, PDict registry, Object key) {
            return WarningsModuleNode.alreadyWarned(frame, _warnings, registry, key, false, this.getEqNode(), this.getCallMethodNode(), this.getDictGetItemNode(), this.getSetItemNode(), this.getIsTrueNode(), this.getWarnLib());
        }

        private static boolean alreadyWarnedShouldSet(PythonModule _warnings, PDict registry, Object key) {
            return WarningsModuleNode.alreadyWarned(null, _warnings, registry, key, true, PyObjectRichCompareBool.EqNode.getUncached(), PyObjectCallMethodObjArgs.getUncached(), PyDictGetItem.getUncached(), PyObjectSetItem.getUncached(), PyObjectIsTrueNode.getUncached(), DynamicObjectLibrary.getUncached());
        }

        private static boolean alreadyWarned(VirtualFrame frame, PythonModule _warnings, PDict registry, Object key, boolean shouldSet, PyObjectRichCompareBool.EqNode eqNode, PyObjectCallMethodObjArgs callMethod, PyDictGetItem getItem, PyObjectSetItem setItem, PyObjectIsTrueNode isTrueNode, DynamicObjectLibrary warnLib) {
            Object versionObj = getItem.executeCached(frame, registry, StringLiterals.T_VERSION);
            long stateFiltersVersion = WarningsModuleNode.getStateFiltersVersion(_warnings, warnLib);
            if (versionObj == null || !eqNode.compareCached((Frame)frame, stateFiltersVersion, versionObj)) {
                callMethod.executeCached((Frame)frame, registry, SpecialMethodNames.T_CLEAR, new Object[0]);
                setItem.executeCached((Frame)frame, registry, StringLiterals.T_VERSION, stateFiltersVersion);
            } else {
                Object alreadyWarned = getItem.executeCached(frame, registry, key);
                if (alreadyWarned != null) {
                    return isTrueNode.executeCached((Frame)frame, alreadyWarned);
                }
            }
            if (shouldSet) {
                setItem.executeCached((Frame)frame, registry, key, true);
            }
            return false;
        }

        private TruffleString normalizeModule(TruffleString filename) {
            int extLen = 3;
            assert (3 == StringLiterals.T_PY_EXTENSION.codePointLengthUncached(PythonUtils.TS_ENCODING));
            if (filename.isEmpty()) {
                return StringLiterals.T_VALUE_UNKNOWN;
            }
            int length = this.getCodePointLengthNode().execute((AbstractTruffleString)filename, PythonUtils.TS_ENCODING);
            if (length >= 3 && this.getRegionEqualNode().execute((AbstractTruffleString)filename, length - 3, (AbstractTruffleString)StringLiterals.T_PY_EXTENSION, 0, 3, PythonUtils.TS_ENCODING)) {
                return this.getSubstringNode().execute((AbstractTruffleString)filename, 0, length - 3, PythonUtils.TS_ENCODING, false);
            }
            return filename;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean updateRegistry(PythonObjectSlowPathFactory factory, PythonModule _warnings, PDict registry, Object text, Object category, boolean addZero) {
            PTuple altKey = addZero ? factory.createTuple(new Object[]{text, category, 0}) : factory.createTuple(new Object[]{text, category});
            return WarningsModuleNode.alreadyWarnedShouldSet(_warnings, registry, altKey);
        }

        @CompilerDirectives.TruffleBoundary
        private static void showWarning(Object filename, int lineno, Object text, Object category, TruffleString sourceline) {
            Object name = category instanceof PythonBuiltinClassType ? ((PythonBuiltinClassType)((Object)category)).getName() : PyObjectLookupAttr.executeUncached(category, SpecialAttributeNames.T___NAME__);
            Object stderr = PythonContext.get(null).getStderr();
            PyObjectCallMethodObjArgs call = PyObjectCallMethodObjArgs.getUncached();
            PyObjectStrAsObjectNode str = PyObjectStrAsObjectNode.getUncached();
            call.execute(null, null, stderr, IONodes.T_WRITE, str.execute(null, filename));
            call.execute(null, null, stderr, IONodes.T_WRITE, StringLiterals.T_COLON);
            call.execute(null, null, stderr, IONodes.T_WRITE, TruffleString.fromLongUncached((long)lineno, (TruffleString.Encoding)PythonUtils.TS_ENCODING, (boolean)true));
            call.execute(null, null, stderr, IONodes.T_WRITE, StringLiterals.T_COLON);
            call.execute(null, null, stderr, IONodes.T_WRITE, str.execute(null, name));
            call.execute(null, null, stderr, IONodes.T_WRITE, StringLiterals.T_COLON);
            call.execute(null, null, stderr, IONodes.T_WRITE, StringLiterals.T_SPACE);
            call.execute(null, null, stderr, IONodes.T_WRITE, str.execute(null, text));
            call.execute(null, null, stderr, IONodes.T_WRITE, StringLiterals.T_NEWLINE);
            if (sourceline != null) {
                call.execute(null, null, stderr, IONodes.T_WRITE, sourceline);
                call.execute(null, null, stderr, IONodes.T_WRITE, StringLiterals.T_NEWLINE);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void callShowWarning(PythonContext context, Object category, Object text, Object message, TruffleString filename, int lineno, TruffleString sourceline, Object sourceIn) {
            Object source;
            PRaiseNode raise = PRaiseNode.getUncached();
            Object showFn = WarningsModuleNode.getWarningsAttr(context, T__SHOWWARNMSG, sourceIn != null);
            if (showFn == null) {
                WarningsModuleNode.showWarning(filename, lineno, text, category, sourceline);
                return;
            }
            if (!PyCallableCheckNode.executeUncached(showFn)) {
                throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.WARN_MUST_BE_SET_CALLABLE);
            }
            Object warnmsgCls = WarningsModuleNode.getWarningsAttr(context, T_WARNING_MESSAGE, false);
            if (warnmsgCls == null) {
                throw raise.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.UNABLE_GET_WARN_MSG);
            }
            Object object = source = sourceIn == null ? PNone.NONE : sourceIn;
            assert (message != null && category != null && filename != null && source != null);
            assert (message != PNone.NO_VALUE && category != PNone.NO_VALUE && source != PNone.NO_VALUE);
            Object msg = CallNode.getUncached().execute(warnmsgCls, message, category, filename, lineno, PNone.NONE, PNone.NONE, source);
            CallNode.getUncached().execute(showFn, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void warnExplicit(VirtualFrame frame, PythonModule warnings, Object categoryIn, Object messageIn, TruffleString filename, int lineno, Object moduleIn, Object registryObj, PDict globals, Object source, IndirectCallData indirectCallData) {
            Object text;
            PDict registry;
            Object module = moduleIn;
            Object category = categoryIn;
            Object message = messageIn;
            if (module == PNone.NONE) {
                return;
            }
            if (registryObj == null || registryObj == PNone.NONE) {
                registry = null;
            } else if (registryObj instanceof PDict) {
                registry = (PDict)registryObj;
            } else {
                throw this.getRaise().raise(PythonBuiltinClassType.TypeError, ErrorMessages.REGISTRY_MUST_BE_DICT);
            }
            if (module == null) {
                module = this.normalizeModule(filename);
            }
            if (this.getIsSubClass().executeBoolean(frame, this.getPythonClass(message), (Object)PythonBuiltinClassType.Warning)) {
                text = this.getStrNode().executeCached((Frame)frame, message);
                category = this.getPythonClass(message);
            } else {
                text = message;
                message = this.getCallNode().execute((Frame)frame, category, message);
            }
            PTuple key = this.getFactory().createTuple(new Object[]{text, category, lineno});
            if (registry != null && this.alreadyWarnedShouldNotSet(frame, warnings, registry, key)) {
                return;
            }
            Object[] item = new Object[1];
            TruffleString action = this.getFilter(frame, warnings, category, text, lineno, module, item);
            if (this.getEqualNode().execute((AbstractTruffleString)T_IGNORE, (AbstractTruffleString)action, PythonUtils.TS_ENCODING)) {
                return;
            }
            Object state = ExecutionContext.IndirectCallContext.enter(frame, this.getLanguage(), this.getContext(), indirectCallData);
            try {
                WarningsModuleNode.warnExplicitPart2(PythonContext.get(this), this, warnings, filename, lineno, registry, globals, source, category, message, text, key, item[0], action);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, this.getLanguage(), this.getContext(), state);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void warnExplicitPart2(PythonContext context, Node node, PythonModule warnings, TruffleString filename, int lineno, PDict registry, PDict globals, Object source, Object category, Object message, Object text, Object key, Object item, TruffleString action) {
            if (action.equalsUncached((AbstractTruffleString)T_ERROR, PythonUtils.TS_ENCODING)) {
                if (!PyExceptionInstanceCheckNode.executeUncached(message)) {
                    throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, PyObjectReprAsTruffleStringNode.executeUncached(message));
                }
                throw PRaiseNode.raiseExceptionObject(node, message);
            }
            if (!action.equalsUncached((AbstractTruffleString)T_ALWAYS, PythonUtils.TS_ENCODING)) {
                if (registry != null) {
                    PyObjectSetItem.executeUncached(registry, key, true);
                }
                boolean alreadyWarned = false;
                if (action.equalsUncached((AbstractTruffleString)T_ONCE, PythonUtils.TS_ENCODING)) {
                    if (registry == null) {
                        PDict currentRegistry = WarningsModuleNode.getOnceRegistry(node, context, warnings);
                        alreadyWarned = WarningsModuleNode.updateRegistry(context.factory(), warnings, currentRegistry, text, category, false);
                    } else {
                        alreadyWarned = WarningsModuleNode.updateRegistry(context.factory(), warnings, registry, text, category, false);
                    }
                } else if (action.equalsUncached((AbstractTruffleString)BuiltinNames.T_MODULE, PythonUtils.TS_ENCODING)) {
                    if (registry != null) {
                        alreadyWarned = WarningsModuleNode.updateRegistry(context.factory(), warnings, registry, text, category, false);
                    }
                } else if (!action.equalsUncached((AbstractTruffleString)StringLiterals.T_DEFAULT, PythonUtils.TS_ENCODING)) {
                    throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.RuntimeError, ErrorMessages.UNRECOGNIZED_ACTION_IN_WARNINGS, action, PyObjectReprAsTruffleStringNode.executeUncached(item));
                }
                if (alreadyWarned) {
                    return;
                }
            }
            TruffleString sourceline = null;
            if (globals != null) {
                sourceline = WarningsModuleNode.getSourceLine(node, globals, lineno);
            }
            WarningsModuleNode.callShowWarning(context, category, text, message, filename, lineno, sourceline, source);
        }

        private void setupContext(VirtualFrame frame, int stackLevel, TruffleString[] filename, int[] lineno, TruffleString[] module, Object[] registry) {
            Object moduleObj;
            PDict globals;
            PFrame f;
            PFrame pFrame = f = frame == null ? null : this.getCallerFrame(frame, stackLevel - 1);
            if (f == null || f.getGlobals() == null) {
                globals = this.getSysDict();
                filename[0] = BuiltinNames.T_SYS;
                lineno[0] = 1;
            } else {
                globals = this.getGlobalsDict(f.getGlobals());
                lineno[0] = f.getLine();
                RootCallTarget ct = f.getTarget();
                filename[0] = ct != null ? PCode.extractFileName(ct.getRootNode()) : T_UNKNOWN_SOURCE;
            }
            registry[0] = this.getDictGetItemNode().executeCached(frame, globals, T___WARNINGREGISTRY__);
            if (registry[0] == null) {
                registry[0] = this.getFactory().createDict();
                this.getSetItemNode().executeCached((Frame)frame, globals, T___WARNINGREGISTRY__, registry[0]);
            }
            if ((moduleObj = this.getDictGetItemNode().executeCached(frame, globals, SpecialAttributeNames.T___NAME__)) == null) {
                module[0] = null;
            } else {
                try {
                    module[0] = this.getCastStr().executeCached(moduleObj);
                }
                catch (CannotCastException e) {
                    module[0] = StringLiterals.T_STRING_SOURCE;
                }
            }
        }

        private Object getCategory(VirtualFrame frame, Object message, Object category) {
            Object messageType = this.getPythonClass(message);
            if (this.getIsSubClass().executeBoolean(frame, messageType, (Object)PythonBuiltinClassType.Warning)) {
                return messageType;
            }
            if (category == null || category == PNone.NONE) {
                return PythonBuiltinClassType.UserWarning;
            }
            if (!this.getIsTypeNode().executeCached(category) || !this.getIsSubClass().executeBoolean(frame, category, (Object)PythonBuiltinClassType.Warning)) {
                throw this.getRaise().raise(PythonBuiltinClassType.TypeError, ErrorMessages.CATEGORY_MUST_BE_WARN_SUBCLS, category);
            }
            return category;
        }

        private void doWarn(VirtualFrame frame, PythonModule warnings, Object message, Object category, int stackLevel, Object source, IndirectCallData indirectCallData) {
            TruffleString[] filename = new TruffleString[1];
            int[] lineno = new int[1];
            TruffleString[] module = new TruffleString[1];
            Object[] registry = new Object[1];
            this.setupContext(frame, stackLevel, filename, lineno, module, registry);
            this.warnExplicit(frame, warnings, category, message, filename[0], lineno[0], module[0], registry[0], null, source, indirectCallData);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString getSourceLine(Node node, PDict globals, int lineno) {
            String src;
            Object source;
            Object loader = PyDictGetItem.executeUncached(globals, SpecialAttributeNames.T___LOADER__);
            if (loader == null) {
                return null;
            }
            Object moduleName = PyDictGetItem.executeUncached(globals, SpecialAttributeNames.T___NAME__);
            if (moduleName == null) {
                return null;
            }
            try {
                source = PyObjectCallMethodObjArgs.executeUncached(loader, T_GET_SOURCE, moduleName);
            }
            catch (PException e) {
                return null;
            }
            if (source == PNone.NONE) {
                return null;
            }
            try {
                src = CastToJavaStringNode.getUncached().execute(source);
            }
            catch (CannotCastException e) {
                throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_S_NOT_P, "str", source);
            }
            String[] lines = src.split("\n");
            if (lines.length >= lineno) {
                return PythonUtils.toTruffleStringUncached(lines[lineno - 1]);
            }
            throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.IndexError, ErrorMessages.INDEX_OUT_OF_BOUNDS);
        }
    }
}

