/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterWithDefaultValueNode;
import com.oracle.graal.python.runtime.PosixConstants;

public class SocketModuleBuiltinsClinicProviders {

    public static final class InetAtoNNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final InetAtoNNodeClinicProviderGen INSTANCE = new InetAtoNNodeClinicProviderGen();

        private InetAtoNNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return TruffleStringConverterNode.create("inet_aton");
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class GetServByPortNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final GetServByPortNodeClinicProviderGen INSTANCE = new GetServByPortNodeClinicProviderGen();

        private GetServByPortNodeClinicProviderGen() {
            super(0, 1, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return JavaIntConversionNode.create(false);
                }
                case 1: {
                    return TruffleStringConverterWithDefaultValueNode.create("getservbyport", PNone.NO_VALUE, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class InetPtoNNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final InetPtoNNodeClinicProviderGen INSTANCE = new InetPtoNNodeClinicProviderGen();

        private InetPtoNNodeClinicProviderGen() {
            super(0, 1, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return JavaIntConversionNode.create(false);
                }
                case 1: {
                    return TruffleStringConverterNode.create("inet_pton");
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class GetServByNameNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final GetServByNameNodeClinicProviderGen INSTANCE = new GetServByNameNodeClinicProviderGen();

        private GetServByNameNodeClinicProviderGen() {
            super(0, 0, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return TruffleStringConverterNode.create("getservbyname");
                }
                case 1: {
                    return TruffleStringConverterWithDefaultValueNode.create("getservbyname", PNone.NO_VALUE, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class InetNtoPNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final InetNtoPNodeClinicProviderGen INSTANCE = new InetNtoPNodeClinicProviderGen();

        private InetNtoPNodeClinicProviderGen() {
            super(2, 3, 2, 2, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return JavaIntConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class GetAddrInfoNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final GetAddrInfoNodeClinicProviderGen INSTANCE = new GetAddrInfoNodeClinicProviderGen();

        private GetAddrInfoNodeClinicProviderGen() {
            super(3, 63, 3, 3, 60);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return JavaIntConversionNode.create(PosixConstants.AF_UNSPEC.value, false);
                }
                case 3: {
                    return JavaIntConversionNode.create(0, false);
                }
                case 4: {
                    return JavaIntConversionNode.create(0, false);
                }
                case 5: {
                    return JavaIntConversionNode.create(0, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class GetNameInfoNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final GetNameInfoNodeClinicProviderGen INSTANCE = new GetNameInfoNodeClinicProviderGen();

        private GetNameInfoNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return JavaIntConversionNode.create(false);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }
}

