/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.MathModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.MathModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.nodes.util.NarrowBigIntegerNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(defineModule="math")
public final class MathModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MathModuleBuiltinsFactory.getFactories();
    }

    public MathModuleBuiltins() {
        this.addBuiltinConstant("pi", (Object)Math.PI);
        this.addBuiltinConstant("e", (Object)Math.E);
        this.addBuiltinConstant("tau", (Object)(Math.PI * 2));
        this.addBuiltinConstant("inf", (Object)Double.POSITIVE_INFINITY);
        this.addBuiltinConstant("nan", (Object)Double.NaN);
    }

    @Builtin(name="dist", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"p", "q"})
    @GenerateNodeFactory
    public static abstract class DistNode
    extends PythonBuiltinNode {
        @Specialization
        static double doGeneric(VirtualFrame frame, Object p, Object q, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached TupleNodes.ConstructTupleNode tupleCtor, @Cached SequenceNodes.GetObjectArrayNode getObjectArray, @Cached InlinedLoopConditionProfile loopProfile1, @Cached InlinedLoopConditionProfile loopProfile2, @Cached InlinedConditionProfile infProfile, @Cached InlinedConditionProfile nanProfile, @Cached InlinedConditionProfile trivialProfile, @Cached PRaiseNode.Lazy raiseNode) {
            double x;
            Object[] qs;
            Object[] ps = getObjectArray.execute(inliningTarget, tupleCtor.execute(frame, p));
            int len = ps.length;
            if (len != (qs = getObjectArray.execute(inliningTarget, tupleCtor.execute(frame, q))).length) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BOTH_POINTS_MUST_HAVE_THE_SAME_NUMBER_OF_DIMENSIONS);
            }
            double[] diffs = new double[len];
            double max = 0.0;
            boolean foundNan = false;
            loopProfile1.profileCounted(inliningTarget, (long)len);
            int i = 0;
            while (loopProfile1.inject(inliningTarget, i < len)) {
                double a = asDoubleNode.execute(frame, inliningTarget, ps[i]);
                double b = asDoubleNode.execute(frame, inliningTarget, qs[i]);
                diffs[i] = x = Math.abs(a - b);
                foundNan |= Double.isNaN(x);
                if (x > max) {
                    max = x;
                }
                ++i;
            }
            if (infProfile.profile(inliningTarget, Double.isInfinite(max))) {
                return max;
            }
            if (nanProfile.profile(inliningTarget, foundNan)) {
                return Double.NaN;
            }
            if (trivialProfile.profile(inliningTarget, max == 0.0 || len <= 1)) {
                return max;
            }
            double csum = 1.0;
            double frac = 0.0;
            loopProfile2.profileCounted(inliningTarget, (long)len);
            int i2 = 0;
            while (loopProfile2.inject(inliningTarget, i2 < len)) {
                x = diffs[i2];
                x /= max;
                x *= x;
                double oldcsum = csum;
                frac += oldcsum - (csum += x) + x;
                ++i2;
            }
            return max * Math.sqrt(csum - 1.0 + frac);
        }
    }

    @Builtin(name="prod", minNumOfPositionalArgs=1, parameterNames={"iterable"}, keywordOnlyNames={"start"})
    @GenerateNodeFactory
    public static abstract class ProdNode
    extends PythonBuiltinNode {
        @Node.Child
        private LookupAndCallUnaryNode callNextNode = LookupAndCallUnaryNode.create(SpecialMethodSlot.Next);
        @Node.Child
        private BinaryOpNode mul = BinaryArithmetic.Mul.create();

        @Specialization
        public Object doGeneric(VirtualFrame frame, Object iterable, Object startIn, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached InlinedConditionProfile startIsNoValueProfile, @Cached PyObjectGetIter getIter) {
            Object start = startIsNoValueProfile.profile(inliningTarget, PGuards.isNoValue(startIn)) ? Integer.valueOf(1) : startIn;
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            Object value = start;
            while (true) {
                Object nextValue;
                try {
                    nextValue = this.callNextNode.executeObject(frame, iterator);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    return value;
                }
                value = this.mul.executeObject(frame, value, nextValue);
            }
        }
    }

    @Builtin(name="isqrt", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    public static abstract class IsqrtNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object isqrtLong(long x, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached NarrowBigIntegerNode makeInt, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            IsqrtNode.raiseIfNegative(inliningTarget, x < 0L, raiseNode);
            return makeInt.execute(inliningTarget, IsqrtNode.op(PInt.longToBigInteger(x)));
        }

        @Specialization
        static Object isqrtPInt(PInt x, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached NarrowBigIntegerNode makeInt, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            IsqrtNode.raiseIfNegative(inliningTarget, x.isNegative(), raiseNode);
            return makeInt.execute(inliningTarget, IsqrtNode.op(x.getValue()));
        }

        @Specialization(guards={"!isInteger(x)"})
        static Object doGeneral(VirtualFrame frame, Object x, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached IsqrtNode recursiveNode) {
            return recursiveNode.execute(frame, indexNode.execute((Frame)frame, inliningTarget, x));
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger op(BigInteger x) {
            if (x.equals(BigInteger.ZERO) || x.equals(BigInteger.ONE)) {
                return x;
            }
            BigInteger start = BigInteger.ONE;
            BigInteger end = x;
            BigInteger result = BigInteger.ZERO;
            BigInteger two = BigInteger.valueOf(2L);
            while (start.compareTo(end) <= 0) {
                BigInteger mid = start.add(end).divide(two);
                int cmp = mid.multiply(mid).compareTo(x);
                if (cmp == 0) {
                    return mid;
                }
                if (cmp < 0) {
                    start = mid.add(BigInteger.ONE);
                    result = mid;
                    continue;
                }
                end = mid.subtract(BigInteger.ONE);
            }
            return result;
        }

        private static void raiseIfNegative(Node inliningTarget, boolean condition, PRaiseNode.Lazy raiseNode) {
            if (condition) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE, "isqrt() argument");
            }
        }
    }

    @Builtin(name="lgamma", minNumOfPositionalArgs=1, doc="Natural logarithm of absolute value of Gamma function at x.")
    @GenerateNodeFactory
    public static abstract class LgammaNode
    extends GammaNode {
        private static final double LOGPI = 1.1447298858494002;

        @Override
        public double count(double x) {
            if (!Double.isFinite(x)) {
                if (Double.isNaN(x)) {
                    return x;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (x == Math.floor(x) && x <= 2.0) {
                this.checkMathDomainError(x <= 0.0);
                return 0.0;
            }
            double absx = Math.abs(x);
            if (absx < 1.0E-20) {
                return -Math.log(absx);
            }
            double r = Math.log(LgammaNode.lanczos_sum(absx)) - 6.02468004077673;
            r += (absx - 0.5) * (Math.log(absx + 6.02468004077673 - 0.5) - 1.0);
            if (x < 0.0) {
                r = 1.1447298858494002 - Math.log(Math.abs(LgammaNode.sinpi(absx))) - Math.log(absx) - r;
            }
            this.checkMathRangeError(Double.isInfinite(r));
            return r;
        }
    }

    @Builtin(name="gamma", minNumOfPositionalArgs=1, doc="Gamma function at x")
    @GenerateNodeFactory
    public static abstract class GammaNode
    extends MathDoubleUnaryBuiltinNode {
        private static final int NGAMMA_INTEGRAL = 23;
        private static final int LANCZOS_N = 13;
        protected static final double LANCZOS_G = 6.02468004077673;
        private static final double LANZOS_G_MINUS_HALF = 5.52468004077673;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        protected static final double[] LANCZOS_NUM_COEFFS = new double[]{2.353137688041076E10, 4.29198036426491E10, 3.571195923735567E10, 1.792103442603721E10, 6.039542586352028E9, 1.4397204073117216E9, 2.4887455786205417E8, 3.1426415585400194E7, 2876370.6289353725, 186056.26539522348, 8071.672002365816, 210.82427775157936, 2.5066282746310002};
        @CompilerDirectives.CompilationFinal(dimensions=1)
        protected static final double[] LANCZOS_DEN_COEFFS = new double[]{0.0, 3.99168E7, 1.2054384E8, 1.50917976E8, 1.05258076E8, 4.599573E7, 1.3339535E7, 2637558.0, 357423.0, 32670.0, 1925.0, 66.0, 1.0};
        @CompilerDirectives.CompilationFinal(dimensions=1)
        protected static final double[] GAMMA_INTEGRAL = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21};

        static double sinpi(double x) {
            double r = 0.0;
            assert (Double.isFinite(x));
            double y = Math.abs(x) % 2.0;
            int n = (int)Math.round(2.0 * y);
            assert (0 <= n && n <= 4);
            switch (n) {
                case 0: {
                    r = Math.sin(Math.PI * y);
                    break;
                }
                case 1: {
                    r = Math.cos(Math.PI * (y - 0.5));
                    break;
                }
                case 2: {
                    r = Math.sin(Math.PI * (1.0 - y));
                    break;
                }
                case 3: {
                    r = -Math.cos(Math.PI * (y - 1.5));
                    break;
                }
                case 4: {
                    r = Math.sin(Math.PI * (y - 2.0));
                    break;
                }
            }
            return Math.copySign(1.0, x) * r;
        }

        static double lanczos_sum(double x) {
            double num = 0.0;
            double den = 0.0;
            assert (x > 0.0);
            if (x < 5.0) {
                int i = 13;
                while (--i >= 0) {
                    num = num * x + LANCZOS_NUM_COEFFS[i];
                    den = den * x + LANCZOS_DEN_COEFFS[i];
                }
            } else {
                for (int i = 0; i < 13; ++i) {
                    num = num / x + LANCZOS_NUM_COEFFS[i];
                    den = den / x + LANCZOS_DEN_COEFFS[i];
                }
            }
            assert (den > 0.0) : "den cannot be zero, because LANCZOS_DEN_COEFFS are added";
            return num / den;
        }

        @Override
        public double count(double x) {
            double r;
            double z;
            double absx;
            if (!Double.isFinite(x)) {
                if (Double.isNaN(x) || x > 0.0) {
                    return x;
                }
                this.checkMathDomainError(false);
            }
            this.checkMathDomainError(x == 0.0);
            if (x == Math.floor(x)) {
                this.checkMathDomainError(x < 0.0);
                if (x <= 23.0) {
                    return GAMMA_INTEGRAL[(int)x - 1];
                }
            }
            if ((absx = Math.abs(x)) < 1.0E-20) {
                double r2 = 1.0 / x;
                this.checkMathRangeError(Double.isInfinite(r2));
                return r2;
            }
            if (absx > 200.0) {
                this.checkMathRangeError(x >= 0.0);
                return 0.0 / GammaNode.sinpi(x);
            }
            double y = absx + 5.52468004077673;
            if (absx > 5.52468004077673) {
                double q = y - absx;
                z = q - 5.52468004077673;
            } else {
                double q = y - 5.52468004077673;
                z = q - absx;
            }
            z = z * 6.02468004077673 / y;
            if (x < 0.0) {
                r = -Math.PI / GammaNode.sinpi(absx) / absx * Math.exp(y) / GammaNode.lanczos_sum(absx);
                r -= z * r;
                if (absx < 140.0) {
                    r /= Math.pow(y, absx - 0.5);
                } else {
                    double sqrtpow = Math.pow(y, absx / 2.0 - 0.25);
                    r /= sqrtpow;
                    r /= sqrtpow;
                }
            } else {
                r = GammaNode.lanczos_sum(absx) / Math.exp(y);
                r += z * r;
                if (absx < 140.0) {
                    r *= Math.pow(y, absx - 0.5);
                } else {
                    double sqrtpow = Math.pow(y, absx / 2.0 - 0.25);
                    r *= sqrtpow;
                    r *= sqrtpow;
                }
            }
            this.checkMathRangeError(Double.isInfinite(r));
            return r;
        }
    }

    @Builtin(name="erfc", minNumOfPositionalArgs=1, doc="Error function at x.")
    @GenerateNodeFactory
    public static abstract class ErfcNode
    extends ErfNode {
        @Override
        public double count(double x) {
            if (Double.isNaN(x)) {
                return x;
            }
            double absx = Math.abs(x);
            if (absx < 1.5) {
                return 1.0 - ErfcNode.m_erf_series(x);
            }
            double cf = ErfcNode.m_erfc_contfrac(absx);
            return x > 0.0 ? cf : 2.0 - cf;
        }
    }

    @Builtin(name="erf", minNumOfPositionalArgs=1, doc="Error function at x.")
    @GenerateNodeFactory
    public static abstract class ErfNode
    extends MathDoubleUnaryBuiltinNode {
        private static final double ERF_SERIES_CUTOFF = 1.5;
        private static final int ERF_SERIES_TERMS = 25;
        protected static final double ERFC_CONTFRAC_CUTOFF = 30.0;
        private static final int ERFC_CONTFRAC_TERMS = 50;
        private static final double SQRTPI = 1.772453850905516;

        static double m_erf_series(double x) {
            double x2 = x * x;
            double acc = 0.0;
            double fk = 25.5;
            for (int i = 0; i < 25; ++i) {
                acc = 2.0 + x2 * acc / fk;
                fk -= 1.0;
            }
            return acc * x * Math.exp(-x2) / 1.772453850905516;
        }

        static double m_erfc_contfrac(double x) {
            if (x >= 30.0) {
                return 0.0;
            }
            double x2 = x * x;
            double a = 0.0;
            double da = 0.5;
            double p = 1.0;
            double p_last = 0.0;
            double q = da + x2;
            double q_last = 1.0;
            for (int i = 0; i < 50; ++i) {
                double b = (da += 2.0) + x2;
                double temp = p;
                p = b * p - (a += da) * p_last;
                p_last = temp;
                temp = q;
                q = b * q - a * q_last;
                q_last = temp;
            }
            return p / q * x * Math.exp(-x2) / 1.772453850905516;
        }

        @Override
        public double count(double x) {
            if (Double.isNaN(x)) {
                return x;
            }
            double absx = Math.abs(x);
            if (absx < 1.5) {
                return ErfNode.m_erf_series(x);
            }
            double cf = ErfNode.m_erfc_contfrac(absx);
            return x > 0.0 ? 1.0 - cf : cf - 1.0;
        }
    }

    @Builtin(name="hypot", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, declaresExplicitSelf=true)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    public static abstract class HypotNode
    extends PythonVarargsBuiltinNode {
        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            return this.execute(frame, self, arguments, keywords);
        }

        @Specialization(guards={"arguments.length == 2"})
        public double hypot2(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyFloatAsDoubleNode xAsDouble, @Cached.Exclusive @Cached PyFloatAsDoubleNode yAsDouble) {
            if (keywords.length != 0) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "hypot()");
            }
            double x = xAsDouble.execute(frame, inliningTarget, arguments[0]);
            double y = yAsDouble.execute(frame, inliningTarget, arguments[1]);
            return Math.hypot(x, y);
        }

        @Specialization
        double hypotGeneric(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyFloatAsDoubleNode asDoubleNode) {
            if (keywords.length != 0) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "hypot()");
            }
            double max = 0.0;
            boolean foundNan = false;
            double[] coordinates = new double[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                double x = asDoubleNode.execute(frame, inliningTarget, arguments[i]);
                if (Double.isNaN(x = Math.abs(x))) {
                    foundNan = true;
                }
                if (x > max) {
                    max = x;
                }
                coordinates[i] = x;
            }
            if (Double.isInfinite(max)) {
                return max;
            }
            if (foundNan) {
                return Double.NaN;
            }
            if (max == 0.0 || arguments.length <= 1) {
                return max;
            }
            double csum = 1.0;
            double frac = 0.0;
            for (int i = 0; i < arguments.length; ++i) {
                double x = coordinates[i];
                x /= max;
                x *= x;
                double oldcsum = csum;
                frac += oldcsum - (csum += x) + x;
            }
            return max * Math.sqrt(csum - 1.0 + frac);
        }
    }

    @Builtin(name="radians", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class RadiansNode
    extends MathDoubleUnaryBuiltinNode {
        private static final double DEG_TO_RAD = Math.PI / 180;

        @Override
        public double count(double value) {
            return value * (Math.PI / 180);
        }
    }

    @Builtin(name="degrees", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DegreesNode
    extends MathDoubleUnaryBuiltinNode {
        private static final double RAD_TO_DEG = 57.29577951308232;

        @Override
        public double count(double value) {
            return value * 57.29577951308232;
        }
    }

    @Builtin(name="atan2", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"left", "right"})
    @ArgumentsClinic(value={@ArgumentClinic(name="left", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="right", conversion=ArgumentClinic.ClinicConversion.Double)})
    @GenerateNodeFactory
    public static abstract class Atan2Node
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        double atan2DD(double left, double right) {
            return Math.atan2(left, right);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.Atan2NodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="trunc", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class TruncNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object trunc(VirtualFrame frame, Object obj, @Bind(value="this") Node inliningTarget, @Cached(value="create(T___TRUNC__)") LookupAndCallUnaryNode callTrunc, @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callTrunc.executeObject(frame, obj);
            if (result == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_METHOD, obj, "__trunc__");
            }
            return result;
        }
    }

    @Builtin(name="pow", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"x", "y"})
    @ArgumentsClinic(value={@ArgumentClinic(name="x", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="y", conversion=ArgumentClinic.ClinicConversion.Double)})
    @GenerateNodeFactory
    public static abstract class PowNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static double pow(double left, double right, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            double result = 0.0;
            if (!Double.isFinite(left) || !Double.isFinite(right)) {
                if (Double.isNaN(left)) {
                    result = right == 0.0 ? 1.0 : left;
                } else if (Double.isNaN(right)) {
                    result = left == 1.0 ? 1.0 : right;
                } else if (Double.isInfinite(left)) {
                    boolean oddRight;
                    boolean bl = oddRight = Double.isFinite(right) && Math.abs(right) % 2.0 == 1.0;
                    result = right > 0.0 ? (oddRight ? left : Math.abs(left)) : (right == 0.0 ? 1.0 : (oddRight ? Math.copySign(0.0, left) : 0.0));
                } else if (Double.isInfinite(right)) {
                    if (Math.abs(left) == 1.0) {
                        result = 1.0;
                    } else if (right > 0.0 && Math.abs(left) > 1.0) {
                        result = right;
                    } else if (right < 0.0 && Math.abs(left) < 1.0) {
                        result = -right;
                        if (left == 0.0) {
                            throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                        }
                    } else {
                        result = 0.0;
                    }
                }
            } else {
                result = Math.pow(left, right);
                if (!Double.isFinite(result)) {
                    if (Double.isNaN(result)) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                    }
                    if (Double.isInfinite(result)) {
                        if (left == 0.0) {
                            throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                        }
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
                    }
                }
            }
            return result;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.PowNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="fabs", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"value"})
    @ArgumentClinic(name="value", conversion=ArgumentClinic.ClinicConversion.Double)
    @GenerateNodeFactory
    public static abstract class FabsNode
    extends PythonUnaryClinicBuiltinNode {
        @Specialization
        public double fabs(double value) {
            return Math.abs(value);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.FabsNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="log10", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Log10Node
    extends MathDoubleUnaryBuiltinNode {
        private static final double LOG10 = Math.log(10.0);

        private static int getDigitCount(BigInteger number) {
            double factor = Math.log(2.0) / Math.log(10.0);
            int digitCount = (int)(factor * (double)number.bitLength() + 1.0);
            if (BigInteger.TEN.pow(digitCount - 1).compareTo(number) > 0) {
                return digitCount - 1;
            }
            return digitCount;
        }

        @Override
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double doPI(PInt value) {
            BigInteger bValue = value.getValue();
            this.checkMathDomainError(bValue.compareTo(BigInteger.ZERO) <= 0);
            int digitCount = Log10Node.getDigitCount(bValue) - 1;
            if (bValue.compareTo(BigInteger.TEN.pow(digitCount)) == 0) {
                return digitCount;
            }
            return LogNode.logBigInteger(bValue) / LOG10;
        }

        @Override
        public double count(double value) {
            this.checkMathDomainError(value <= 0.0);
            return Math.log10(value);
        }
    }

    @Builtin(name="log2", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Log2Node
    extends MathDoubleUnaryBuiltinNode {
        private static final double LOG2 = Math.log(2.0);
        private static final BigInteger TWO = BigInteger.valueOf(2L);

        @Override
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double doPI(PInt value) {
            BigInteger bValue = value.getValue();
            this.checkMathDomainError(bValue.compareTo(BigInteger.ZERO) <= 0);
            int e = bValue.bitLength() - 1;
            if (bValue.compareTo(TWO.pow(e)) == 0) {
                return e;
            }
            return LogNode.logBigInteger(bValue) / LOG2;
        }

        @Override
        public double count(double value) {
            this.checkMathDomainError(value <= 0.0);
            double[] frexpR = FrexpNode.frexp(value);
            double m = frexpR[0];
            int e = (int)frexpR[1];
            if (value >= 1.0) {
                return Math.log(2.0 * m) / LOG2 + (double)(e - 1);
            }
            return Math.log(m) / LOG2 + (double)e;
        }
    }

    @Builtin(name="log1p", minNumOfPositionalArgs=1, doc="Return the natural logarithm of 1+x (base e).\n\nThe result is computed in a way which is accurate for x near zero.")
    @GenerateNodeFactory
    public static abstract class Log1pNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            if (value == 0.0 || value == Double.POSITIVE_INFINITY || Double.isNaN(value)) {
                return value;
            }
            double result = Math.log1p(value);
            this.checkMathDomainError(!Double.isFinite(result));
            return result;
        }
    }

    @Builtin(name="log", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    public static abstract class LogNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private LogNode recLogNode;
        private static final double LOG2 = Math.log(2.0);

        private double executeRecursiveLogNode(VirtualFrame frame, Object value, Object base) {
            if (this.recLogNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.recLogNode = (LogNode)this.insert(LogNode.create());
            }
            return this.recLogNode.executeObject(frame, value, base);
        }

        public abstract double executeObject(VirtualFrame var1, Object var2, Object var3);

        protected static double logBigInteger(BigInteger val) {
            int blex = val.bitLength() - 1022;
            BigInteger value = blex > 0 ? val.shiftRight(blex) : val;
            double res = Math.log(value.doubleValue());
            return blex > 0 ? res + (double)blex * LOG2 : res;
        }

        private static double countBase(double base, Node inliningTarget, InlinedConditionProfile divByZero, PRaiseNode.Lazy raiseNode) {
            double logBase = Math.log(base);
            if (divByZero.profile(inliningTarget, logBase == 0.0)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_BY_ZERO, "float");
            }
            return logBase;
        }

        private static double countBase(BigInteger base, Node inliningTarget, InlinedConditionProfile divByZero, PRaiseNode.Lazy raiseNode) {
            double logBase = LogNode.logBigInteger(base);
            if (divByZero.profile(inliningTarget, logBase == 0.0)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_BY_ZERO, "float");
            }
            return logBase;
        }

        @Specialization
        static double log(long value, PNone novalue, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return LogNode.logDN(value, novalue, inliningTarget, doNotFit, raiseNode);
        }

        @Specialization
        static double logDN(double value, PNone novalue, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            LogNode.raiseMathError(inliningTarget, doNotFit, value <= 0.0, raiseNode);
            return Math.log(value);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static double logPIN(PInt value, PNone novalue, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            BigInteger bValue = value.getValue();
            LogNode.raiseMathError(inliningTarget, doNotFit, bValue.compareTo(BigInteger.ZERO) < 0, raiseNode);
            return LogNode.logBigInteger(bValue);
        }

        @Specialization
        static double logLL(long value, long base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return LogNode.logDD(value, base, inliningTarget, doNotFit, divByZero, raiseNode);
        }

        @Specialization
        static double logDL(double value, long base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return LogNode.logDD(value, base, inliningTarget, doNotFit, divByZero, raiseNode);
        }

        @Specialization
        static double logLD(long value, double base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return LogNode.logDD(value, base, inliningTarget, doNotFit, divByZero, raiseNode);
        }

        @Specialization
        static double logDD(double value, double base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            LogNode.raiseMathError(inliningTarget, doNotFit, value < 0.0 || base <= 0.0, raiseNode);
            double logBase = LogNode.countBase(base, inliningTarget, divByZero, raiseNode);
            return Math.log(value) / logBase;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static double logDPI(double value, PInt base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            BigInteger bBase = base.getValue();
            LogNode.raiseMathError(inliningTarget, doNotFit, value < 0.0 || bBase.compareTo(BigInteger.ZERO) <= 0, raiseNode);
            double logBase = LogNode.countBase(bBase, inliningTarget, divByZero, raiseNode);
            return Math.log(value) / logBase;
        }

        @Specialization
        static double logPIL(PInt value, long base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return LogNode.logPID(value, base, inliningTarget, doNotFit, divByZero, raiseNode);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static double logPID(PInt value, double base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            BigInteger bValue = value.getValue();
            LogNode.raiseMathError(inliningTarget, doNotFit, bValue.compareTo(BigInteger.ZERO) < 0 || base <= 0.0, raiseNode);
            double logBase = LogNode.countBase(base, inliningTarget, divByZero, raiseNode);
            return LogNode.logBigInteger(bValue) / logBase;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static double logLPI(long value, PInt base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            BigInteger bBase = base.getValue();
            LogNode.raiseMathError(inliningTarget, doNotFit, value < 0L || bBase.compareTo(BigInteger.ZERO) <= 0, raiseNode);
            double logBase = LogNode.countBase(bBase, inliningTarget, divByZero, raiseNode);
            return Math.log(value) / logBase;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static double logPIPI(PInt value, PInt base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile doNotFit, @Cached.Shared @Cached InlinedConditionProfile divByZero, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            BigInteger bValue = value.getValue();
            BigInteger bBase = base.getValue();
            LogNode.raiseMathError(inliningTarget, doNotFit, bValue.compareTo(BigInteger.ZERO) < 0 || bBase.compareTo(BigInteger.ZERO) <= 0, raiseNode);
            double logBase = LogNode.countBase(bBase, inliningTarget, divByZero, raiseNode);
            return LogNode.logBigInteger(bValue) / logBase;
        }

        @Specialization(guards={"!isNumber(value)"})
        double logO(VirtualFrame frame, Object value, PNone novalue, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            return this.executeRecursiveLogNode(frame, asDoubleNode.execute(frame, inliningTarget, value), novalue);
        }

        @Specialization(guards={"!isNumber(value)", "!isNoValue(base)"})
        double logOO(VirtualFrame frame, Object value, Object base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            return this.executeRecursiveLogNode(frame, asDoubleNode.execute(frame, inliningTarget, value), asDoubleNode.execute(frame, inliningTarget, base));
        }

        @Specialization(guards={"!isNumber(base)"})
        double logLO(VirtualFrame frame, long value, Object base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            return this.executeRecursiveLogNode(frame, value, asDoubleNode.execute(frame, inliningTarget, base));
        }

        @Specialization(guards={"!isNumber(base)"})
        double logDO(VirtualFrame frame, double value, Object base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            return this.executeRecursiveLogNode(frame, value, asDoubleNode.execute(frame, inliningTarget, base));
        }

        @Specialization(guards={"!isNumber(base)"})
        double logPIO(VirtualFrame frame, PInt value, Object base, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            return this.executeRecursiveLogNode(frame, value, asDoubleNode.execute(frame, inliningTarget, base));
        }

        private static void raiseMathError(Node inliningTarget, InlinedConditionProfile doNotFit, boolean con, PRaiseNode.Lazy raiseNode) {
            if (doNotFit.profile(inliningTarget, con)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
            }
        }

        public static LogNode create() {
            return MathModuleBuiltinsFactory.LogNodeFactory.create();
        }
    }

    @Builtin(name="isinf", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    public static abstract class IsInfNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static boolean isinf(long value) {
            return false;
        }

        @Specialization
        public static boolean isinf(PInt value) {
            return false;
        }

        @Specialization
        public static boolean isinf(double value) {
            return Double.isInfinite(value);
        }

        @Specialization(guards={"!isNumber(value)"})
        public static boolean isinf(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return IsInfNode.isinf(asDoubleNode.execute(frame, inliningTarget, value));
        }
    }

    @Builtin(name="isfinite", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    public static abstract class IsFiniteNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public boolean isfinite(long value) {
            return true;
        }

        @Specialization
        public boolean isfinite(PInt value) {
            return true;
        }

        @Specialization
        public static boolean isfinite(double value) {
            return Double.isFinite(value);
        }

        @Specialization(guards={"!isNumber(value)"})
        public static boolean isinf(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return IsFiniteNode.isfinite(asDoubleNode.execute(frame, inliningTarget, value));
        }
    }

    @Builtin(name="asinh", minNumOfPositionalArgs=1, doc="Return the inverse hyperbolic sine of x.")
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    public static abstract class AsinhNode
    extends MathDoubleUnaryBuiltinNode {
        private static final double LN_2 = 0.6931471805599453;
        private static final double TWO_POW_P28 = 2.68435456E8;
        private static final double TWO_POW_M28 = 3.725290298461914E-9;

        @Override
        @CompilerDirectives.TruffleBoundary
        public double count(double value) {
            return AsinhNode.compute(value);
        }

        static double compute(double value) {
            double w;
            double absx = Math.abs(value);
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                return value + value;
            }
            if (absx < 3.725290298461914E-9) {
                return value;
            }
            if (absx > 2.68435456E8) {
                w = Math.log(absx) + 0.6931471805599453;
            } else if (absx > 2.0) {
                w = Math.log(2.0 * absx + 1.0 / (Math.sqrt(value * value + 1.0) + absx));
            } else {
                double t = value * value;
                w = Math.log1p(absx + t / (1.0 + Math.sqrt(1.0 + t)));
            }
            return Math.copySign(w, value);
        }

        public static AsinhNode create() {
            return MathModuleBuiltinsFactory.AsinhNodeFactory.create();
        }
    }

    @Builtin(name="atanh", minNumOfPositionalArgs=1, doc="Return the inverse hyperbolic tangent of x.")
    @GenerateNodeFactory
    public static abstract class AtanhNode
    extends MathDoubleUnaryBuiltinNode {
        private static final double TWO_POW_M28 = 3.725290298461914E-9;
        private final ConditionProfile closeToZeroProfile = ConditionProfile.create();
        private final ConditionProfile lessThanHalfProfile = ConditionProfile.create();

        @Override
        public double count(double value) {
            double t;
            double abs = Math.abs(value);
            this.checkMathDomainError(abs >= 1.0);
            if (this.closeToZeroProfile.profile(abs < 3.725290298461914E-9)) {
                return value;
            }
            if (this.lessThanHalfProfile.profile(abs < 0.5)) {
                t = abs + abs;
                t = 0.5 * Math.log1p(t + t * abs / (1.0 - abs));
            } else {
                t = 0.5 * Math.log1p((abs + abs) / (1.0 - abs));
            }
            return Math.copySign(t, value);
        }
    }

    @Builtin(name="atan", minNumOfPositionalArgs=1, doc="Return the arc tangent (measured in radians) of x.")
    @GenerateNodeFactory
    public static abstract class AtanNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            return Math.atan(value);
        }
    }

    @Builtin(name="tanh", minNumOfPositionalArgs=1, doc="Return the hyperbolic tangent of x.")
    @GenerateNodeFactory
    public static abstract class TanhNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            return Math.tanh(value);
        }
    }

    @Builtin(name="tan", minNumOfPositionalArgs=1, doc="Return the tangent of x (measured in radians).")
    @GenerateNodeFactory
    public static abstract class TanNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            return Math.tan(value);
        }
    }

    @Builtin(name="sinh", minNumOfPositionalArgs=1, doc="Return the hyperbolic sine of x.")
    @GenerateNodeFactory
    public static abstract class SinhNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            double result = Math.sinh(value);
            this.checkMathRangeError(Double.isInfinite(result) && Double.isFinite(value));
            return result;
        }
    }

    @Builtin(name="sin", minNumOfPositionalArgs=1, doc="Return the sine of x (measured in radians).")
    @GenerateNodeFactory
    public static abstract class SinNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            return Math.sin(value);
        }
    }

    @Builtin(name="cosh", minNumOfPositionalArgs=1, doc="Return the hyperbolic cosine of x.")
    @GenerateNodeFactory
    public static abstract class CoshNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            double result = Math.cosh(value);
            this.checkMathRangeError(Double.isInfinite(result) && Double.isFinite(value));
            return result;
        }
    }

    @Builtin(name="cos", minNumOfPositionalArgs=1, doc="Return the cosine of x (measured in radians).")
    @GenerateNodeFactory
    public static abstract class CosNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            return Math.cos(value);
        }
    }

    @Builtin(name="asin", minNumOfPositionalArgs=1, doc="Return the arc sine (measured in radians) of x.")
    @GenerateNodeFactory
    public static abstract class AsinNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            this.checkMathDomainError(value < -1.0 || value > 1.0);
            return Math.asin(value);
        }
    }

    @Builtin(name="acosh", minNumOfPositionalArgs=1, doc="Return the inverse hyperbolic cosine of x.")
    @GenerateNodeFactory
    public static abstract class AcoshNode
    extends MathDoubleUnaryBuiltinNode {
        private static final double TWO_POW_P28 = 2.68435456E8;
        private static final double LN_2 = 0.6931471805599453;
        private final ConditionProfile largeProfile = ConditionProfile.create();
        private final ConditionProfile smallProfile = ConditionProfile.create();

        @Override
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double doPI(PInt value) {
            BigInteger bValue = value.getValue();
            this.checkMathDomainError(bValue.compareTo(BigInteger.ONE) < 0);
            if (bValue.bitLength() >= 28) {
                return Math.log(bValue.doubleValue()) + 0.6931471805599453;
            }
            BigDecimal sqrt = SqrtNode.sqrtBigNumber(bValue.multiply(bValue).subtract(BigInteger.ONE));
            BigDecimal bd = new BigDecimal(bValue);
            return Math.log(bd.add(sqrt).doubleValue());
        }

        @Override
        public double count(double value) {
            this.checkMathDomainError(value < 1.0);
            if (this.largeProfile.profile(value >= 2.68435456E8)) {
                return Math.log(value) + 0.6931471805599453;
            }
            if (this.smallProfile.profile(value <= 2.0)) {
                double t = value - 1.0;
                return Math.log1p(t + Math.sqrt(2.0 * t + t * t));
            }
            return Math.log(value + Math.sqrt(value * value - 1.0));
        }
    }

    @Builtin(name="acos", minNumOfPositionalArgs=1, doc="Return the arc cosine (measured in radians) of x.")
    @GenerateNodeFactory
    public static abstract class AcosNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            this.checkMathDomainError(Double.isInfinite(value) || -1.0 > value || value > 1.0);
            return Math.acos(value);
        }
    }

    @Builtin(name="ulp", minNumOfPositionalArgs=1, parameterNames={"x"})
    @ArgumentClinic(name="x", conversion=ArgumentClinic.ClinicConversion.Double)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    public static abstract class UlpNode
    extends PythonUnaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.UlpNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static double ulp(double x) {
            if (Double.isNaN(x)) {
                return x;
            }
            if (Double.isInfinite(x = Math.abs(x))) {
                return x;
            }
            double x2 = Math.nextAfter(x, Double.POSITIVE_INFINITY);
            if (Double.isInfinite(x2)) {
                x2 = Math.nextAfter(x, Double.NEGATIVE_INFINITY);
                return x - x2;
            }
            return x2 - x;
        }
    }

    @Builtin(name="nextafter", minNumOfPositionalArgs=2, parameterNames={"start", "direction"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="direction", conversion=ArgumentClinic.ClinicConversion.Double)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    public static abstract class NextAfterNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.NextAfterNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static double nextAfter(double start, double direction) {
            return Math.nextAfter(start, direction);
        }
    }

    @Builtin(name="lcm", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class LcmNode
    extends PythonVarargsBuiltinNode {
        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            return this.execute(frame, self, arguments, keywords);
        }

        @Specialization(guards={"args.length > 1", "keywords.length == 0"})
        public static Object gcd(VirtualFrame frame, Object self, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached LoopConditionProfile profile, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached Gcd2Node gcdNode, @Cached IntBuiltins.FloorDivNode floorDivNode, @Cached IntBuiltins.MulNode mulNode, @Cached BinaryComparisonNode.EqNode eqNode, @Cached.Shared @Cached BuiltinFunctions.AbsNode absNode) {
            Object a = indexNode.execute((Frame)frame, inliningTarget, args[0]);
            profile.profileCounted((long)args.length);
            int i = 1;
            while (profile.inject(i < args.length)) {
                Object b = indexNode.execute((Frame)frame, inliningTarget, args[i]);
                if (!((Boolean)eqNode.executeObject(frame, a, 0)).booleanValue()) {
                    Object g = gcdNode.execute(frame, a, b);
                    Object f = floorDivNode.execute(frame, a, g);
                    Object m = mulNode.execute(frame, f, b);
                    a = absNode.execute(frame, m);
                }
                ++i;
            }
            return a;
        }

        @Specialization(guards={"args.length == 1", "keywords.length == 0"})
        public static Object gcdOne(VirtualFrame frame, Object self, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached BuiltinFunctions.AbsNode absNode) {
            return indexNode.execute((Frame)frame, inliningTarget, absNode.execute(frame, args[0]));
        }

        @Specialization(guards={"args.length == 0", "keywords.length == 0"})
        public static int gcdEmpty(Object self, Object[] args, PKeyword[] keywords) {
            return 1;
        }

        @Specialization(guards={"keywords.length != 0"})
        public int gcdKeywords(Object self, Object[] args, PKeyword[] keywords) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "gcd()");
        }
    }

    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    public static abstract class Gcd2Node
    extends Node {
        protected final boolean isRecursive;

        public Gcd2Node(boolean isRecursive) {
            this.isRecursive = isRecursive;
        }

        abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        private static long count(long a, long b) {
            if (b == 0L) {
                return a;
            }
            return Gcd2Node.count(b, a % b);
        }

        @Specialization
        static long gcd(long x, long y) {
            return Math.abs(Gcd2Node.count(x, y));
        }

        @Specialization
        static PInt gcd(long x, PInt y, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return factory.createInt(Gcd2Node.op(PInt.longToBigInteger(x), y.getValue()));
        }

        @Specialization
        static PInt gcd(PInt x, long y, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return factory.createInt(Gcd2Node.op(x.getValue(), PInt.longToBigInteger(y)));
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger op(BigInteger x, BigInteger y) {
            return x.gcd(y);
        }

        @Specialization
        PInt gcd(PInt x, PInt y, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return factory.createInt(Gcd2Node.op(x.getValue(), y.getValue()));
        }

        @Specialization
        static int gcd(double x, double y, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "float");
        }

        @Specialization
        static int gcd(long x, double y, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "float");
        }

        @Specialization
        static int gcd(double x, long y, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "float");
        }

        @Specialization
        static int gcd(double x, PInt y, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "float");
        }

        @Specialization(guards={"!isRecursive"})
        static int gcd(PInt x, double y, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "float");
        }

        @Specialization(guards={"!isRecursive", "!isNumber(x) || !isNumber(y)"})
        static Object gcd(VirtualFrame frame, Object x, Object y, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached(value="create(true)") Gcd2Node recursiveNode) {
            Object xValue = indexNode.execute((Frame)frame, inliningTarget, x);
            Object yValue = indexNode.execute((Frame)frame, inliningTarget, y);
            return recursiveNode.execute(frame, xValue, yValue);
        }

        @Specialization
        Object gcdNative(PythonAbstractNativeObject a, Object b) {
            CompilerDirectives.transferToInterpreter();
            throw PRaiseNode.raiseUncached((Node)this, PythonErrorType.SystemError, ErrorMessages.GCD_FOR_NATIVE_NOT_SUPPORTED);
        }

        @NeverDefault
        public static Gcd2Node create() {
            return MathModuleBuiltinsFactory.Gcd2NodeGen.create(false);
        }

        public static Gcd2Node create(boolean isRecursive) {
            return MathModuleBuiltinsFactory.Gcd2NodeGen.create(isRecursive);
        }
    }

    @Builtin(name="gcd", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class GcdNode
    extends PythonVarargsBuiltinNode {
        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            return this.execute(frame, self, arguments, keywords);
        }

        @Specialization(guards={"args.length > 1", "keywords.length == 0"})
        public static Object gcd(VirtualFrame frame, Object self, Object[] args, PKeyword[] keywords, @Cached Gcd2Node gdcNode, @Cached LoopConditionProfile profile) {
            Object res = args[0];
            profile.profileCounted((long)args.length);
            int i = 1;
            while (profile.inject(i < args.length)) {
                res = gdcNode.execute(frame, res, args[i]);
                ++i;
            }
            return res;
        }

        @Specialization(guards={"args.length == 1", "keywords.length == 0"})
        public static Object gcdOne(VirtualFrame frame, Object self, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached BuiltinFunctions.AbsNode absNode) {
            return indexNode.execute((Frame)frame, inliningTarget, absNode.execute(frame, args[0]));
        }

        @Specialization(guards={"args.length == 0", "keywords.length == 0"})
        public static int gcdEmpty(Object self, Object[] args, PKeyword[] keywords) {
            return 0;
        }

        @Specialization(guards={"keywords.length != 0"})
        public int gcdKeywords(Object self, Object[] args, PKeyword[] keywords) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "gcd()");
        }
    }

    @Builtin(name="fsum", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FsumNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static double doIt(VirtualFrame frame, Object iterable, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached(value="create(Next)") LookupAndCallUnaryNode callNextNode, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopProfile, @Cached PRaiseNode.Lazy raiseNode) {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iterable);
            return FsumNode.fsum(frame, iterator, callNextNode, asDoubleNode, inliningTarget, stopProfile, raiseNode);
        }

        private static double fsum(VirtualFrame frame, Object iterator, LookupAndCallUnaryNode next, PyFloatAsDoubleNode asDoubleNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile stopProfile, PRaiseNode.Lazy raiseNode) {
            double hi;
            double yr;
            double y;
            double x;
            double lo = 0.0;
            double inf_sum = 0.0;
            double special_sum = 0.0;
            int n = 0;
            int arayLength = 32;
            double[] p = new double[arayLength];
            while (true) {
                try {
                    x = asDoubleNode.execute(frame, inliningTarget, next.executeObject(frame, iterator));
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, stopProfile);
                    break;
                }
                double xsave = x;
                int i = 0;
                for (int j = 0; j < n; ++j) {
                    y = p[j];
                    if (Math.abs(x) < Math.abs(y)) {
                        double t = x;
                        x = y;
                        y = t;
                    }
                    if ((lo = y - (yr = (hi = x + y) - x)) != 0.0) {
                        p[i++] = lo;
                    }
                    x = hi;
                }
                n = i;
                if (x == 0.0) continue;
                if (!Double.isFinite(x)) {
                    if (Double.isFinite(xsave)) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.INTERMEDIATE_OVERFLOW_IN, "fsum");
                    }
                    if (Double.isInfinite(xsave)) {
                        inf_sum += xsave;
                    }
                    special_sum += xsave;
                    n = 0;
                    continue;
                }
                if (n >= arayLength) {
                    arayLength += arayLength;
                    p = Arrays.copyOf(p, arayLength);
                    continue;
                }
                p[n++] = x;
            }
            if (special_sum != 0.0) {
                if (Double.isNaN(inf_sum)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.NEG_INF_PLUS_INF_IN);
                }
                double sum = special_sum;
                return sum;
            }
            hi = 0.0;
            if (n > 0) {
                hi = p[--n];
                while (n > 0) {
                    x = hi;
                    y = p[--n];
                    assert (Math.abs(y) < Math.abs(x));
                    hi = x + y;
                    yr = hi - x;
                    lo = y - yr;
                    if (lo == 0.0) continue;
                }
                if (n > 0 && (lo < 0.0 && p[n - 1] < 0.0 || lo > 0.0 && p[n - 1] > 0.0) && FsumNode.compareAsBigDecimal(y = lo * 2.0, yr = (x = hi + y) - hi) == 0) {
                    hi = x;
                }
            }
            return hi;
        }

        @CompilerDirectives.TruffleBoundary
        private static int compareAsBigDecimal(double y, double yr) {
            return BigDecimal.valueOf(y).compareTo(BigDecimal.valueOf(yr));
        }
    }

    @Builtin(name="modf", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"x"})
    @ArgumentClinic(name="x", conversion=ArgumentClinic.ClinicConversion.Double)
    @GenerateNodeFactory
    public static abstract class ModfNode
    extends PythonUnaryClinicBuiltinNode {
        @Specialization
        static PTuple modfD(double value, @Cached PythonObjectFactory factory) {
            if (!Double.isFinite(value)) {
                if (Double.isInfinite(value)) {
                    return factory.createTuple(new Object[]{Math.copySign(0.0, value), value});
                }
                if (Double.isNaN(value)) {
                    return factory.createTuple(new Object[]{value, value});
                }
            }
            double fraction = value % 1.0;
            double integral = value - fraction;
            return factory.createTuple(new Object[]{fraction, integral});
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.ModfNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="ldexp", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"x", "i"})
    @ArgumentClinic(name="x", conversion=ArgumentClinic.ClinicConversion.Double)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class LdexpNode
    extends PythonBinaryClinicBuiltinNode {
        private static int makeInt(long x) {
            long result = x;
            if (x < Integer.MIN_VALUE) {
                result = Integer.MIN_VALUE;
            } else if (x > Integer.MAX_VALUE) {
                result = Integer.MAX_VALUE;
            }
            return (int)result;
        }

        private static double exceptInfinity(Node inliningTarget, double result, double arg, PRaiseNode.Lazy raiseNode) {
            if (Double.isInfinite(result) && !Double.isInfinite(arg)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
            return result;
        }

        @Specialization
        static double ldexp(double mantissa, long exp, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            return LdexpNode.exceptInfinity(inliningTarget, Math.scalb(mantissa, LdexpNode.makeInt(exp)), mantissa, raiseNode);
        }

        @Specialization(guards={"!isInteger(exp)"})
        static double ldexp(VirtualFrame frame, double mantissa, Object exp, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached PyNumberIndexNode indexNode, @Cached CastToJavaLongLossyNode cast, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, exp), (Object)PythonBuiltinClassType.PInt)) {
                long longExp = cast.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, exp));
                return LdexpNode.ldexp(mantissa, longExp, inliningTarget, raiseNode);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_INT_MESSAGE);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.LdexpNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isclose", minNumOfPositionalArgs=2, parameterNames={"a", "b"}, keywordOnlyNames={"rel_tol", "abs_tol"})
    @ArgumentsClinic(value={@ArgumentClinic(name="a", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="b", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="rel_tol", conversion=ArgumentClinic.ClinicConversion.Double, defaultValue="1e-09"), @ArgumentClinic(name="abs_tol", conversion=ArgumentClinic.ClinicConversion.Double, defaultValue="0.0")})
    @GenerateNodeFactory
    public static abstract class IsCloseNode
    extends PythonClinicBuiltinNode {
        @Specialization
        static boolean isCloseDouble(double a, double b, double rel_tol, double abs_tol, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (rel_tol < 0.0 || abs_tol < 0.0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.TOLERANCE_MUST_NON_NEGATIVE);
            }
            if (a == b) {
                return true;
            }
            if (Double.isInfinite(a) || Double.isInfinite(b)) {
                return false;
            }
            double diff = Math.abs(b - a);
            return diff <= Math.abs(rel_tol * b) || diff <= Math.abs(rel_tol * a) || diff <= abs_tol;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.IsCloseNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="isnan", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    public static abstract class IsNanNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static boolean isNan(long value) {
            return false;
        }

        @Specialization
        public static boolean isNan(PInt value) {
            return false;
        }

        @Specialization
        public static boolean isNan(double value) {
            return Double.isNaN(value);
        }

        @Specialization(guards={"!isNumber(value)"})
        public static boolean isinf(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return IsNanNode.isNan(asDoubleNode.execute(frame, inliningTarget, value));
        }
    }

    @Builtin(name="frexp", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"value"})
    @ArgumentClinic(name="value", conversion=ArgumentClinic.ClinicConversion.Double)
    @GenerateNodeFactory
    public static abstract class FrexpNode
    extends PythonUnaryClinicBuiltinNode {
        public static double[] frexp(double value) {
            boolean neg;
            double mantissa;
            int exponent;
            block7: {
                block6: {
                    exponent = 0;
                    mantissa = 0.0;
                    if (value == 0.0 || value == -0.0) {
                        return new double[]{mantissa, exponent};
                    }
                    if (Double.isNaN(value)) {
                        mantissa = Double.NaN;
                        exponent = -1;
                        return new double[]{mantissa, exponent};
                    }
                    if (Double.isInfinite(value)) {
                        mantissa = value;
                        exponent = -1;
                        return new double[]{mantissa, exponent};
                    }
                    neg = false;
                    mantissa = value;
                    if (mantissa < 0.0) {
                        mantissa = -mantissa;
                        neg = true;
                    }
                    if (!(mantissa >= 1.0)) break block6;
                    while (mantissa >= 1.0) {
                        ++exponent;
                        mantissa /= 2.0;
                    }
                    break block7;
                }
                if (!(mantissa < 0.5)) break block7;
                while (mantissa < 0.5) {
                    --exponent;
                    mantissa *= 2.0;
                }
            }
            return new double[]{neg ? -mantissa : mantissa, exponent};
        }

        @Specialization
        static PTuple frexpD(double value, @Cached PythonObjectFactory factory) {
            Object[] content = new Object[2];
            double[] primContent = FrexpNode.frexp(value);
            content[0] = primContent[0];
            content[1] = (int)primContent[1];
            return factory.createTuple(content);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.FrexpNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="remainder", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"x", "y"})
    @ArgumentsClinic(value={@ArgumentClinic(name="x", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="y", conversion=ArgumentClinic.ClinicConversion.Double)})
    @GenerateNodeFactory
    public static abstract class RemainderNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static double remainderDD(double x, double y, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (Double.isFinite(x) && Double.isFinite(y)) {
                double c;
                double absy;
                if (y == 0.0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                double absx = Math.abs(x);
                double m = absx % (absy = Math.abs(y));
                double r = m < (c = absy - m) ? m : (m > c ? -c : m - 2.0 * (0.5 * (absx - m) % absy));
                return Math.copySign(1.0, x) * r;
            }
            if (Double.isNaN(x)) {
                return x;
            }
            if (Double.isNaN(y)) {
                return y;
            }
            if (Double.isInfinite(x)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
            }
            return x;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.RemainderNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="fmod", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"left", "right"})
    @ArgumentsClinic(value={@ArgumentClinic(name="left", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="right", conversion=ArgumentClinic.ClinicConversion.Double)})
    @GenerateNodeFactory
    public static abstract class FmodNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static double fmodDD(double left, double right, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile infProfile, @Cached InlinedConditionProfile zeroProfile, @Cached PRaiseNode.Lazy raiseNode) {
            FmodNode.raiseMathDomainError(inliningTarget, Double.isInfinite(left), infProfile, raiseNode);
            FmodNode.raiseMathDomainError(inliningTarget, right == 0.0, zeroProfile, raiseNode);
            return left % right;
        }

        static void raiseMathDomainError(Node inliningTarget, boolean con, InlinedConditionProfile profile, PRaiseNode.Lazy raiseNode) {
            if (profile.profile(inliningTarget, con)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.FmodNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="floor", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FloorNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object floorDouble(double value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, Math.floor(value));
        }

        @Fallback
        static Object floor(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(value="create(T___FLOOR__)") LookupSpecialMethodNode lookupFloor, @Cached CallUnaryMethodNode callFloor, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Exclusive @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            Object method = lookupFloor.execute((Frame)frame, getClassNode.execute(inliningTarget, value), value);
            if (method != PNone.NO_VALUE) {
                return callFloor.executeObject((Frame)frame, method, value);
            }
            double doubleValue = asDoubleNode.execute(frame, inliningTarget, value);
            return pyLongFromDoubleNode.execute(inliningTarget, Math.floor(doubleValue));
        }
    }

    @Builtin(name="perm", minNumOfPositionalArgs=1, parameterNames={"n", "k"})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    public static abstract class PermNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private BigInteger calculatePerm(BigInteger n, BigInteger k) {
            if (n.signum() < 0) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE_INTEGER, "n");
            }
            if (k.signum() < 0) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE_INTEGER, "k");
            }
            if (n.compareTo(k) < 0) {
                return BigInteger.ZERO;
            }
            if (k.equals(BigInteger.ZERO)) {
                return BigInteger.ONE;
            }
            if (k.equals(BigInteger.ONE)) {
                return n;
            }
            BigInteger result = n;
            BigInteger factor = n;
            BigInteger i = BigInteger.ONE;
            while (i.compareTo(k) < 0) {
                factor = factor.subtract(BigInteger.ONE);
                result = result.multiply(factor);
                i = i.add(BigInteger.ONE);
            }
            return result;
        }

        @Specialization
        PInt perm(long n, long k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculatePerm(PInt.longToBigInteger(n), PInt.longToBigInteger(k)));
        }

        @Specialization
        PInt perm(long n, PInt k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculatePerm(PInt.longToBigInteger(n), k.getValue()));
        }

        @Specialization
        PInt perm(PInt n, long k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculatePerm(n.getValue(), PInt.longToBigInteger(k)));
        }

        @Specialization
        PInt perm(PInt n, PInt k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculatePerm(n.getValue(), k.getValue()));
        }

        @Specialization
        Object perm(VirtualFrame frame, Object n, PNone k, @Cached FactorialNode factorialNode) {
            return factorialNode.execute(frame, n);
        }

        @Specialization(guards={"!isPNone(k)"})
        static Object perm(VirtualFrame frame, Object n, Object k, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached PermNode recursiveNode) {
            Object nValue = indexNode.execute((Frame)frame, inliningTarget, n);
            Object kValue = indexNode.execute((Frame)frame, inliningTarget, k);
            return recursiveNode.execute(frame, nValue, kValue);
        }
    }

    @Builtin(name="comb", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    public static abstract class CombNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private BigInteger calculateComb(BigInteger n, BigInteger k) {
            if (n.signum() < 0) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE_INTEGER, "n");
            }
            if (k.signum() < 0) {
                throw PRaiseNode.raiseUncached(this, PythonErrorType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE_INTEGER, "k");
            }
            BigInteger factors = k.min(n.subtract(k));
            if (factors.signum() < 0) {
                return BigInteger.ZERO;
            }
            if (factors.signum() == 0) {
                return BigInteger.ONE;
            }
            BigInteger result = n;
            BigInteger factor = n;
            BigInteger i = BigInteger.ONE;
            while (i.compareTo(factors) < 0) {
                factor = factor.subtract(BigInteger.ONE);
                result = result.multiply(factor);
                i = i.add(BigInteger.ONE);
                result = result.divide(i);
            }
            return result;
        }

        @Specialization
        PInt comb(long n, long k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculateComb(PInt.longToBigInteger(n), PInt.longToBigInteger(k)));
        }

        @Specialization
        PInt comb(long n, PInt k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculateComb(PInt.longToBigInteger(n), k.getValue()));
        }

        @Specialization
        PInt comb(PInt n, long k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculateComb(n.getValue(), PInt.longToBigInteger(k)));
        }

        @Specialization
        PInt comb(PInt n, PInt k, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(this.calculateComb(n.getValue(), k.getValue()));
        }

        @Specialization
        static Object comb(VirtualFrame frame, Object n, Object k, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached CombNode recursiveNode) {
            Object nValue = indexNode.execute((Frame)frame, inliningTarget, n);
            Object kValue = indexNode.execute((Frame)frame, inliningTarget, k);
            return recursiveNode.execute(frame, nValue, kValue);
        }
    }

    @Builtin(name="factorial", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class FactorialNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        protected static final long[] SMALL_FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

        public abstract Object execute(VirtualFrame var1, long var2);

        @CompilerDirectives.TruffleBoundary
        private static BigInteger factorialPart(long start, long n) {
            if (n <= 16L) {
                BigInteger r = new BigInteger(String.valueOf(start));
                for (long i = start + 1L; i < start + n; ++i) {
                    r = r.multiply(BigInteger.valueOf(i));
                }
                return r;
            }
            long i = n / 2L;
            return FactorialNode.factorialPart(start, i).multiply(FactorialNode.factorialPart(start + i, n - i));
        }

        @Specialization(guards={"value < 0"})
        static long factorialNegativeInt(int value, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.FACTORIAL_NOT_DEFINED_FOR_NEGATIVE);
        }

        @Specialization(guards={"0 <= value", "value < SMALL_FACTORIALS.length"})
        static long factorialSmallInt(int value) {
            return SMALL_FACTORIALS[value];
        }

        @Specialization(guards={"value >= SMALL_FACTORIALS.length"})
        static PInt factorialInt(int value, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(FactorialNode.factorialPart(1L, value));
        }

        @Specialization(guards={"value < 0"})
        static long factorialNegativeLong(long value, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.FACTORIAL_NOT_DEFINED_FOR_NEGATIVE);
        }

        @Specialization(guards={"0 <= value", "value < SMALL_FACTORIALS.length"})
        static long factorialSmallLong(long value) {
            return SMALL_FACTORIALS[(int)value];
        }

        @Specialization(guards={"value >= SMALL_FACTORIALS.length"})
        static PInt factorialLong(long value, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(FactorialNode.factorialPart(1L, value));
        }

        @Fallback
        static Object factorialObject(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongAsLongAndOverflowNode convert, @Cached PyNumberAsSizeNode asSizeNode, @Cached FactorialNode recursiveNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return recursiveNode.execute(frame, convert.execute((Frame)frame, inliningTarget, value));
            }
            catch (OverflowException e) {
                if (asSizeNode.executeLossy((Frame)frame, inliningTarget, value) >= 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.FACTORIAL_ARGUMENT_SHOULD_NOT_EXCEED_D, Long.MAX_VALUE);
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.FACTORIAL_NOT_DEFINED_FOR_NEGATIVE);
            }
        }
    }

    @Builtin(name="copysign", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"magnitude", "sign"})
    @ArgumentsClinic(value={@ArgumentClinic(name="magnitude", conversion=ArgumentClinic.ClinicConversion.Double), @ArgumentClinic(name="sign", conversion=ArgumentClinic.ClinicConversion.Double)})
    @GenerateNodeFactory
    public static abstract class CopySignNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        public double copySign(double magnitude, double sign) {
            return Math.copySign(magnitude, sign);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MathModuleBuiltinsClinicProviders.CopySignNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="ceil", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CeilNode
    extends MathUnaryBuiltinNode {
        @Specialization
        static Object ceilDouble(double value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, Math.ceil(value));
        }

        @Fallback
        static Object ceil(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(value="create(T___CEIL__)") LookupSpecialMethodNode lookupCeil, @Cached CallUnaryMethodNode callCeil, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Exclusive @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            Object method = lookupCeil.execute((Frame)frame, getClassNode.execute(inliningTarget, value), value);
            if (method != PNone.NO_VALUE) {
                return callCeil.executeObject((Frame)frame, method, value);
            }
            double doubleValue = asDoubleNode.execute(frame, inliningTarget, value);
            return pyLongFromDoubleNode.execute(inliningTarget, Math.ceil(doubleValue));
        }
    }

    @Builtin(name="expm1", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class Expm1Node
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            double result = Math.expm1(value);
            this.checkMathRangeError(Double.isFinite(value) && Double.isInfinite(result));
            return result;
        }
    }

    @Builtin(name="exp", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ExpNode
    extends MathDoubleUnaryBuiltinNode {
        @Override
        public double count(double value) {
            double result = Math.exp(value);
            this.checkMathRangeError(Double.isFinite(value) && Double.isInfinite(result));
            return result;
        }
    }

    @Builtin(name="sqrt", minNumOfPositionalArgs=1, doc="Return the square root of x.")
    @GenerateNodeFactory
    public static abstract class SqrtNode
    extends MathDoubleUnaryBuiltinNode {
        protected static BigDecimal sqrtBigNumber(BigInteger value) {
            BigDecimal number = new BigDecimal(value);
            BigDecimal result = BigDecimal.ZERO;
            BigDecimal guess = BigDecimal.ONE;
            BigDecimal BigDecimalTWO = new BigDecimal(2);
            BigDecimal flipA = result;
            BigDecimal flipB = result;
            boolean first = true;
            while (result.compareTo(guess) != 0) {
                if (!first) {
                    guess = result;
                } else {
                    first = false;
                }
                result = number.divide(guess, MathContext.DECIMAL128).add(guess).divide(BigDecimalTWO, MathContext.DECIMAL128);
                if (result.equals(flipB)) {
                    return flipA;
                }
                flipB = flipA;
                flipA = result;
            }
            return result;
        }

        @Override
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double doPI(PInt value) {
            value.doubleValueWithOverflow(this);
            BigInteger bValue = value.getValue();
            this.checkMathDomainError(bValue.compareTo(BigInteger.ZERO) < 0);
            return SqrtNode.sqrtBigNumber(bValue).doubleValue();
        }

        @Override
        public double count(double value) {
            this.checkMathDomainError(value < 0.0);
            return Math.sqrt(value);
        }
    }

    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    public static abstract class MathDoubleUnaryBuiltinNode
    extends MathUnaryBuiltinNode {
        public abstract double executeObject(VirtualFrame var1, Object var2);

        public double count(double value) {
            throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.COUNT_FUNC_MATH);
        }

        @Specialization
        public double doL(long value) {
            return this.op(value);
        }

        @Specialization
        public double doD(double value) {
            return this.op(value);
        }

        @Specialization
        public double doPI(PInt value) {
            return this.op(value.doubleValueWithOverflow(this));
        }

        @Specialization(guards={"!isNumber(value)"})
        public double doGeneral(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return this.op(asDoubleNode.execute(frame, inliningTarget, value));
        }

        private double op(double arg) {
            double res = this.count(arg);
            this.checkMathDomainError(Double.isNaN(res) && !Double.isNaN(arg));
            return res;
        }
    }

    public static abstract class MathUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        private PRaiseNode raiseNode;

        final PException raise(PythonBuiltinClassType type, TruffleString string) {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = this.isAdoptable() ? (PRaiseNode)this.insert(PRaiseNode.create()) : PRaiseNode.getUncached();
            }
            return this.raiseNode.raise(type, string);
        }

        final void checkMathRangeError(boolean con) {
            if (con) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
        }

        final void checkMathDomainError(boolean con) {
            if (con) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
            }
        }
    }
}

