// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.memoryview;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes.ReleaseBufferNode;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodesFactory.ReleaseBufferNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

@GeneratedBy(PMemoryView.class)
@SuppressWarnings("javadoc")
final class PMemoryViewGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    static  {
        LibraryExport.register(PMemoryView.class, new PythonBufferAcquireLibraryExports(), new PythonBufferAccessLibraryExports());
    }

    private PMemoryViewGen() {
    }

    @GeneratedBy(PMemoryView.class)
    private static final class PythonBufferAcquireLibraryExports extends LibraryExport<PythonBufferAcquireLibrary> {

        private PythonBufferAcquireLibraryExports() {
            super(PythonBufferAcquireLibrary.class, PMemoryView.class, false, false, 0);
        }

        @Override
        protected PythonBufferAcquireLibrary createUncached(Object receiver) {
            assert receiver instanceof PMemoryView;
            PythonBufferAcquireLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected PythonBufferAcquireLibrary createCached(Object receiver) {
            assert receiver instanceof PMemoryView;
            return new Cached();
        }

        @GeneratedBy(PMemoryView.class)
        private static final class Cached extends PythonBufferAcquireLibrary {

            private static final StateField STATE_0_AcquireNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#acquire(PMemoryView, int, Node, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_AcquireNode__UPDATER.subUpdater(0, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: InlinedCache
             *        Specialization: {@link PMemoryView#acquire}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#acquire(PMemoryView, int, Node, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @Override
            public boolean hasBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).hasBuffer();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#acquire(PMemoryView, int, Node, Lazy)}
             *     Activation probability: 1.00000
             *     With/without class size: 28/5 bytes
             * </pre>
             */
            @Override
            public Object acquire(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                {
                    Node inliningTarget__ = (this);
                    return arg0Value.acquire(arg1Value, inliningTarget__, INLINED_RAISE_NODE_);
                }
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
        @GeneratedBy(PMemoryView.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAcquireLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .hasBuffer();
            }

            @TruffleBoundary
            @Override
            public Object acquire(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.acquire(arg1Value, (this), (Lazy.getUncached()));
            }

        }
    }
    @GeneratedBy(PMemoryView.class)
    private static final class PythonBufferAccessLibraryExports extends LibraryExport<PythonBufferAccessLibrary> {

        private PythonBufferAccessLibraryExports() {
            super(PythonBufferAccessLibrary.class, PMemoryView.class, false, false, 0);
        }

        @Override
        protected PythonBufferAccessLibrary createUncached(Object receiver) {
            assert receiver instanceof PMemoryView;
            PythonBufferAccessLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected PythonBufferAccessLibrary createCached(Object receiver) {
            assert receiver instanceof PMemoryView;
            return new Cached();
        }

        @GeneratedBy(PMemoryView.class)
        private static final class Cached extends PythonBufferAccessLibrary {

            private static final StateField RELEASE__RELEASE_NODE__RELEASE_STATE_0_UPDATER = StateField.create(ReleaseNode_ReleaseData.lookup_(), "release_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
             *   Parameter: {@link ReleaseBufferNode} releaseNode
             *   Inline method: {@link ReleaseBufferNodeGen#inline}</pre>
             */
            private static final ReleaseBufferNode INLINED_RELEASE_NODE__RELEASE_RELEASE_NODE_ = ReleaseBufferNodeGen.inline(InlineTarget.create(ReleaseBufferNode.class, RELEASE__RELEASE_NODE__RELEASE_STATE_0_UPDATER.subUpdater(0, 3), ReferenceField.create(ReleaseNode_ReleaseData.lookup_(), "releaseNode__release_releaseNode__field1_", Node.class), ReferenceField.create(ReleaseNode_ReleaseData.lookup_(), "releaseNode__release_releaseNode__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
             *   1: SpecializationActive {@link PMemoryView#hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *   2: SpecializationActive {@link PMemoryView#getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *   3: SpecializationActive {@link PMemoryView#readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *   4: SpecializationActive {@link PMemoryView#writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *   5: SpecializationActive {@link PMemoryView#readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)}
             *   6: SpecializationActive {@link PMemoryView#readByte(PMemoryView, int, PythonBufferAccessLibrary)}
             *   7: SpecializationActive {@link PMemoryView#writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)}
             *   8: SpecializationActive {@link PMemoryView#readShort(PMemoryView, int, PythonBufferAccessLibrary)}
             *   9: SpecializationActive {@link PMemoryView#writeShort(PMemoryView, int, short, PythonBufferAccessLibrary)}
             *   10: SpecializationActive {@link PMemoryView#readInt(PMemoryView, int, PythonBufferAccessLibrary)}
             *   11: SpecializationActive {@link PMemoryView#writeInt(PMemoryView, int, int, PythonBufferAccessLibrary)}
             *   12: SpecializationActive {@link PMemoryView#readLong(PMemoryView, int, PythonBufferAccessLibrary)}
             *   13: SpecializationActive {@link PMemoryView#writeLong(PMemoryView, int, long, PythonBufferAccessLibrary)}
             *   14: SpecializationActive {@link PMemoryView#readFloat(PMemoryView, int, PythonBufferAccessLibrary)}
             *   15: SpecializationActive {@link PMemoryView#writeFloat(PMemoryView, int, float, PythonBufferAccessLibrary)}
             *   16: SpecializationActive {@link PMemoryView#readDouble(PMemoryView, int, PythonBufferAccessLibrary)}
             *   17: SpecializationActive {@link PMemoryView#writeDouble(PMemoryView, int, double, PythonBufferAccessLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link PMemoryView#hasInternalByteArray}
             *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
             */
            @Child private PythonBufferAccessLibrary bufferLib;
            @Child private ReleaseNode_ReleaseData releaseNode__release_cache;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @Override
            public int getItemSize(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).getItemSize();
            }

            @Override
            public TruffleString getFormatString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).getFormatString();
            }

            @Override
            protected boolean isBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).isBuffer();
            }

            @Override
            public int getBufferLength(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).getBufferLength();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
             *     Activation probability: 0.05556
             *     With/without class size: 5/13 bytes
             * </pre>
             */
            @Override
            public void release(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[PMemoryView.release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)] */) {
                    ReleaseNode_ReleaseData s0_ = this.releaseNode__release_cache;
                    if (s0_ != null) {
                        {
                            Node inliningTarget__ = (s0_);
                            arg0Value.release(inliningTarget__, s0_.raiseNode_, INLINED_RELEASE_NODE__RELEASE_RELEASE_NODE_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                releaseNode_AndSpecialize(arg0Value);
                return;
            }

            private void releaseNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    ReleaseNode_ReleaseData s0_ = this.insert(new ReleaseNode_ReleaseData());
                    inliningTarget__ = (s0_);
                    PRaiseNode raiseNode__ = s0_.insert((PRaiseNode.create()));
                    Objects.requireNonNull(raiseNode__, "Specialization 'release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)' cache 'raiseNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s0_.raiseNode_ = raiseNode__;
                    VarHandle.storeStoreFence();
                    this.releaseNode__release_cache = s0_;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[PMemoryView.release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)] */;
                    this.state_0_ = state_0;
                    arg0Value.release(inliningTarget__, raiseNode__, INLINED_RELEASE_NODE__RELEASE_RELEASE_NODE_);
                    return;
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            @Override
            public boolean isReadonly(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                return (((PMemoryView) receiver)).isReadonly();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[PMemoryView.hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.hasInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private boolean hasInternalByteArrayNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[PMemoryView.hasInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.hasInternalByteArray(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[PMemoryView.getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.getInternalByteArray(bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getInternalByteArrayNode_AndSpecialize(arg0Value);
            }

            private byte[] getInternalByteArrayNode_AndSpecialize(PMemoryView arg0Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[PMemoryView.getInternalByteArray(PMemoryView, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.getInternalByteArray(bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void readIntoByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[PMemoryView.readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.readIntoByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                readIntoByteArrayNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                return;
            }

            private void readIntoByteArrayNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[PMemoryView.readIntoByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.readIntoByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeFromByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[PMemoryView.writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeFromByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeFromByteArrayNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                return;
            }

            private void writeFromByteArrayNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[PMemoryView.writeFromByteArray(PMemoryView, int, byte[], int, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeFromByteArray(arg1Value, arg2Value, arg3Value, arg4Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void readIntoBuffer(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, PythonBufferAccessLibrary arg5Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[PMemoryView.readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.readIntoBuffer(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                readIntoBufferNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                return;
            }

            private void readIntoBufferNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, PythonBufferAccessLibrary arg5Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[PMemoryView.readIntoBuffer(PMemoryView, int, Object, int, int, PythonBufferAccessLibrary, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.readIntoBuffer(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readByte(PMemoryView, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[PMemoryView.readByte(PMemoryView, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readByte(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readByteNode_AndSpecialize(arg0Value, arg1Value);
            }

            private byte readByteNode_AndSpecialize(PMemoryView arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readByte(PMemoryView, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[PMemoryView.readByte(PMemoryView, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readByte(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeByte(Object arg0Value_, int arg1Value, byte arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[PMemoryView.writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeByte(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeByteNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeByteNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, byte arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[PMemoryView.writeByte(PMemoryView, int, byte, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeByte(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readShort(PMemoryView, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short readShort(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[PMemoryView.readShort(PMemoryView, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readShort(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readShortNode_AndSpecialize(arg0Value, arg1Value);
            }

            private short readShortNode_AndSpecialize(PMemoryView arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readShort(PMemoryView, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[PMemoryView.readShort(PMemoryView, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readShort(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeShort(PMemoryView, int, short, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeShort(Object arg0Value_, int arg1Value, short arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[PMemoryView.writeShort(PMemoryView, int, short, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeShort(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeShortNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeShortNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, short arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeShort(PMemoryView, int, short, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[PMemoryView.writeShort(PMemoryView, int, short, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeShort(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readInt(PMemoryView, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int readInt(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[PMemoryView.readInt(PMemoryView, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readInt(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readIntNode_AndSpecialize(arg0Value, arg1Value);
            }

            private int readIntNode_AndSpecialize(PMemoryView arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readInt(PMemoryView, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[PMemoryView.readInt(PMemoryView, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readInt(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeInt(PMemoryView, int, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeInt(Object arg0Value_, int arg1Value, int arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[PMemoryView.writeInt(PMemoryView, int, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeInt(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeIntNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeIntNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, int arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeInt(PMemoryView, int, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[PMemoryView.writeInt(PMemoryView, int, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeInt(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readLong(PMemoryView, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long readLong(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[PMemoryView.readLong(PMemoryView, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readLong(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readLongNode_AndSpecialize(arg0Value, arg1Value);
            }

            private long readLongNode_AndSpecialize(PMemoryView arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readLong(PMemoryView, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[PMemoryView.readLong(PMemoryView, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readLong(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeLong(PMemoryView, int, long, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeLong(Object arg0Value_, int arg1Value, long arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[PMemoryView.writeLong(PMemoryView, int, long, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeLong(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeLongNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeLongNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, long arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeLong(PMemoryView, int, long, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[PMemoryView.writeLong(PMemoryView, int, long, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeLong(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readFloat(PMemoryView, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float readFloat(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[PMemoryView.readFloat(PMemoryView, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readFloat(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readFloatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private float readFloatNode_AndSpecialize(PMemoryView arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readFloat(PMemoryView, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[PMemoryView.readFloat(PMemoryView, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readFloat(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeFloat(PMemoryView, int, float, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeFloat(Object arg0Value_, int arg1Value, float arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[PMemoryView.writeFloat(PMemoryView, int, float, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeFloat(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeFloatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeFloatNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, float arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeFloat(PMemoryView, int, float, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[PMemoryView.writeFloat(PMemoryView, int, float, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeFloat(arg1Value, arg2Value, bufferLib_);
                return;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#readDouble(PMemoryView, int, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double readDouble(Object arg0Value_, int arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000) != 0 /* is SpecializationActive[PMemoryView.readDouble(PMemoryView, int, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            return arg0Value.readDouble(arg1Value, bufferLib_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readDoubleNode_AndSpecialize(arg0Value, arg1Value);
            }

            private double readDoubleNode_AndSpecialize(PMemoryView arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'readDouble(PMemoryView, int, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0x10000 /* add SpecializationActive[PMemoryView.readDouble(PMemoryView, int, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readDouble(arg1Value, bufferLib_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link PMemoryView#writeDouble(PMemoryView, int, double, PythonBufferAccessLibrary)}
             *     Activation probability: 0.05556
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeDouble(Object arg0Value_, int arg1Value, double arg2Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted(this);
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000) != 0 /* is SpecializationActive[PMemoryView.writeDouble(PMemoryView, int, double, PythonBufferAccessLibrary)] */) {
                    {
                        PythonBufferAccessLibrary bufferLib_ = this.bufferLib;
                        if (bufferLib_ != null) {
                            arg0Value.writeDouble(arg1Value, arg2Value, bufferLib_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeDoubleNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeDoubleNode_AndSpecialize(PMemoryView arg0Value, int arg1Value, double arg2Value) {
                int state_0 = this.state_0_;
                PythonBufferAccessLibrary bufferLib_;
                PythonBufferAccessLibrary bufferLib__shared = this.bufferLib;
                if (bufferLib__shared != null) {
                    bufferLib_ = bufferLib__shared;
                } else {
                    bufferLib_ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    if (bufferLib_ == null) {
                        throw new IllegalStateException("Specialization 'writeDouble(PMemoryView, int, double, PythonBufferAccessLibrary)' contains a shared cache with name 'bufferLib' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.bufferLib == null) {
                    VarHandle.storeStoreFence();
                    this.bufferLib = bufferLib_;
                }
                state_0 = state_0 | 0x20000 /* add SpecializationActive[PMemoryView.writeDouble(PMemoryView, int, double, PythonBufferAccessLibrary)] */;
                this.state_0_ = state_0;
                arg0Value.writeDouble(arg1Value, arg2Value, bufferLib_);
                return;
            }

            @GeneratedBy(PMemoryView.class)
            @DenyReplace
            private static final class ReleaseNode_ReleaseData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-2: InlinedCache
                 *        Specialization: {@link PMemoryView#release}
                 *        Parameter: {@link ReleaseBufferNode} releaseNode
                 *        Inline method: {@link ReleaseBufferNodeGen#inline}
                 * </pre>
                 */
                @CompilationFinal @UnsafeAccessedField private int release_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
                 *   Parameter: {@link PRaiseNode} raiseNode</pre>
                 */
                @Child PRaiseNode raiseNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
                 *   Parameter: {@link ReleaseBufferNode} releaseNode
                 *   Inline method: {@link ReleaseBufferNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node releaseNode__release_releaseNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PMemoryView#release(PMemoryView, Node, PRaiseNode, ReleaseBufferNode)}
                 *   Parameter: {@link ReleaseBufferNode} releaseNode
                 *   Inline method: {@link ReleaseBufferNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node releaseNode__release_releaseNode__field2_;

                ReleaseNode_ReleaseData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
        @GeneratedBy(PMemoryView.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAccessLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PMemoryView) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PMemoryView;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public int getItemSize(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .getItemSize();
            }

            @TruffleBoundary
            @Override
            public TruffleString getFormatString(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .getFormatString();
            }

            @TruffleBoundary
            @Override
            protected boolean isBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .isBuffer();
            }

            @TruffleBoundary
            @Override
            public int getBufferLength(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .getBufferLength();
            }

            @TruffleBoundary
            @Override
            public void release(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.release((this), (PRaiseNode.getUncached()), (ReleaseBufferNodeGen.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isReadonly(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PMemoryView) receiver) .isReadonly();
            }

            @TruffleBoundary
            @Override
            public boolean hasInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.hasInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte[] getInternalByteArray(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.getInternalByteArray((PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void readIntoByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.readIntoByteArray(arg1Value, arg2Value, arg3Value, arg4Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void writeFromByteArray(Object arg0Value_, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeFromByteArray(arg1Value, arg2Value, arg3Value, arg4Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public void readIntoBuffer(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, PythonBufferAccessLibrary arg5Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.readIntoBuffer(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public byte readByte(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readByte(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeByte(Object arg0Value_, int arg1Value, byte arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeByte(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public short readShort(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readShort(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeShort(Object arg0Value_, int arg1Value, short arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeShort(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public int readInt(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readInt(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeInt(Object arg0Value_, int arg1Value, int arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeInt(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public long readLong(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readLong(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeLong(Object arg0Value_, int arg1Value, long arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeLong(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public float readFloat(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readFloat(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeFloat(Object arg0Value_, int arg1Value, float arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeFloat(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public double readDouble(Object arg0Value_, int arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                return arg0Value.readDouble(arg1Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeDouble(Object arg0Value_, int arg1Value, double arg2Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PMemoryView arg0Value = ((PMemoryView) arg0Value_);
                arg0Value.writeDouble(arg1Value, arg2Value, (PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached()));
                return;
            }

        }
    }
}
