// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.buffer;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary.Assertions;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PythonBufferAcquireLibrary.class)
final class PythonBufferAcquireLibraryGen extends LibraryFactory<PythonBufferAcquireLibrary> {

    private static final Class<PythonBufferAcquireLibrary> LIBRARY_CLASS = PythonBufferAcquireLibraryGen.lazyLibraryClass();
    private static final Message HAS_BUFFER = new MessageImpl("hasBuffer", 0, false, boolean.class, Object.class);
    private static final Message ACQUIRE = new MessageImpl("acquire", 1, false, Object.class, Object.class, int.class);
    private static final PythonBufferAcquireLibraryGen INSTANCE = new PythonBufferAcquireLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(PythonBufferAcquireLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(PythonBufferAcquireLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private PythonBufferAcquireLibraryGen() {
        super(PythonBufferAcquireLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(PythonBufferAcquireLibraryGen.HAS_BUFFER, PythonBufferAcquireLibraryGen.ACQUIRE)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return PythonBufferAcquireLibrary.class;
    }

    @Override
    protected Lookup getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    protected PythonBufferAcquireLibrary createAssertions(PythonBufferAcquireLibrary delegate) {
        return new Assertions(delegate);
    }

    @Override
    protected PythonBufferAcquireLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected PythonBufferAcquireLibrary createDelegate(PythonBufferAcquireLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        PythonBufferAcquireLibrary lib = (PythonBufferAcquireLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                return lib.hasBuffer(receiver);
            case 1 :
                return lib.acquire(receiver, (int) args[offset]);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected PythonBufferAcquireLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected PythonBufferAcquireLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<PythonBufferAcquireLibrary> lazyLibraryClass() {
        try {
            return (Class<PythonBufferAcquireLibrary>) Class.forName("com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary", false, PythonBufferAcquireLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private static final class Default extends LibraryExport<PythonBufferAcquireLibrary> {

        private Default() {
            super(PythonBufferAcquireLibrary.class, Object.class, false, false, 0);
        }

        @Override
        protected PythonBufferAcquireLibrary createUncached(Object receiver) {
            PythonBufferAcquireLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected PythonBufferAcquireLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(PythonBufferAcquireLibrary.class)
        private static final class Cached extends PythonBufferAcquireLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean hasBuffer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasBuffer((dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object acquire(Object receiver, int flags) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.acquire((dynamicDispatch_.cast(receiver)), flags);
            }

        }
        @GeneratedBy(PythonBufferAcquireLibrary.class)
        @DenyReplace
        private static final class Uncached extends PythonBufferAcquireLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasBuffer(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasBuffer(receiver);
            }

            @TruffleBoundary
            @Override
            public Object acquire(Object receiver, int flags) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return super.acquire(receiver, flags);
            }

        }
    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(PythonBufferAcquireLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private static final class Proxy extends PythonBufferAcquireLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean hasBuffer(Object receiver_) {
            try {
                return (boolean) lib.send(receiver_, PythonBufferAcquireLibraryGen.HAS_BUFFER);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object acquire(Object receiver_, int flags) {
            try {
                return lib.send(receiver_, PythonBufferAcquireLibraryGen.ACQUIRE, flags);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private static final class Delegate extends PythonBufferAcquireLibrary {

        @Child private PythonBufferAcquireLibrary delegateLibrary;

        Delegate(PythonBufferAcquireLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean hasBuffer(Object receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).hasBuffer(delegate);
            } else {
                return this.delegateLibrary.hasBuffer(receiver_);
            }
        }

        @Override
        public Object acquire(Object receiver_, int flags) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).acquire(delegate, flags);
            } else {
                return this.delegateLibrary.acquire(receiver_, flags);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private static final class CachedToUncachedDispatch extends PythonBufferAcquireLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean hasBuffer(Object receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).hasBuffer(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object acquire(Object receiver_, int flags) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).acquire(receiver_, flags);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends PythonBufferAcquireLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public boolean hasBuffer(Object receiver_) {
            return INSTANCE.getUncached(receiver_).hasBuffer(receiver_);
        }

        @TruffleBoundary
        @Override
        public Object acquire(Object receiver_, int flags) {
            return INSTANCE.getUncached(receiver_).acquire(receiver_, flags);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(PythonBufferAcquireLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(PythonBufferAcquireLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(PythonBufferAcquireLibrary.class)
    private abstract static class CachedDispatch extends PythonBufferAcquireLibrary {

        @Child PythonBufferAcquireLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(PythonBufferAcquireLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public boolean hasBuffer(Object receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAcquireLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.hasBuffer(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object acquire(Object receiver_, int flags) {
            do {
                CachedDispatch current = this;
                do {
                    PythonBufferAcquireLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.acquire(receiver_, flags);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(Object receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                PythonBufferAcquireLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        PythonBufferAcquireLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
