// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.AcquireNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.CountNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.EnterLockNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.ExitLockNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.GetHandleNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.GetKindNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.GetMaxValue;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.GetNameNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.GetValueNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.IsMineNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.IsZeroNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.RebuildNode;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltins.ReleaseLockNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(GraalPySemLockBuiltins.class)
@SuppressWarnings("javadoc")
public final class GraalPySemLockBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(CountNodeFactory.getInstance(), IsMineNodeFactory.getInstance(), IsZeroNodeFactory.getInstance(), GetValueNodeFactory.getInstance(), GetHandleNodeFactory.getInstance(), GetNameNodeFactory.getInstance(), GetMaxValueFactory.getInstance(), GetKindNodeFactory.getInstance(), AcquireNodeFactory.getInstance(), EnterLockNodeFactory.getInstance(), RebuildNodeFactory.getInstance(), ReleaseLockNodeFactory.getInstance(), ExitLockNodeFactory.getInstance());
    }

    @GeneratedBy(CountNode.class)
    static final class CountNodeFactory implements NodeFactory<CountNode> {

        private static final CountNodeFactory COUNT_NODE_FACTORY_INSTANCE = new CountNodeFactory();

        private CountNodeFactory() {
        }

        @Override
        public Class<CountNode> getNodeClass() {
            return CountNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public CountNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<CountNode> getInstance() {
            return COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CountNode create() {
            return new CountNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CountNode#getCount}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(CountNode.class)
        @SuppressWarnings("javadoc")
        static final class CountNodeGen extends CountNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CountNode#getCount}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private CountNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.CountNode.getCount(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return CountNode.getCount(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private int executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.CountNode.getCount(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return CountNode.getCount(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(IsMineNode.class)
    static final class IsMineNodeFactory implements NodeFactory<IsMineNode> {

        private static final IsMineNodeFactory IS_MINE_NODE_FACTORY_INSTANCE = new IsMineNodeFactory();

        private IsMineNodeFactory() {
        }

        @Override
        public Class<IsMineNode> getNodeClass() {
            return IsMineNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public IsMineNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<IsMineNode> getInstance() {
            return IS_MINE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IsMineNode create() {
            return new IsMineNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IsMineNode#isMine}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(IsMineNode.class)
        @SuppressWarnings("javadoc")
        static final class IsMineNodeGen extends IsMineNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsMineNode#isMine}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private IsMineNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.IsMineNode.isMine(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return IsMineNode.isMine(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.IsMineNode.isMine(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return IsMineNode.isMine(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(IsZeroNode.class)
    static final class IsZeroNodeFactory implements NodeFactory<IsZeroNode> {

        private static final IsZeroNodeFactory IS_ZERO_NODE_FACTORY_INSTANCE = new IsZeroNodeFactory();

        private IsZeroNodeFactory() {
        }

        @Override
        public Class<IsZeroNode> getNodeClass() {
            return IsZeroNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public IsZeroNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<IsZeroNode> getInstance() {
            return IS_ZERO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IsZeroNode create() {
            return new IsZeroNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IsZeroNode#isZero}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(IsZeroNode.class)
        @SuppressWarnings("javadoc")
        static final class IsZeroNodeGen extends IsZeroNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsZeroNode#isZero}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private IsZeroNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.IsZeroNode.isZero(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return IsZeroNode.isZero(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.IsZeroNode.isZero(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return IsZeroNode.isZero(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetValueNode.class)
    static final class GetValueNodeFactory implements NodeFactory<GetValueNode> {

        private static final GetValueNodeFactory GET_VALUE_NODE_FACTORY_INSTANCE = new GetValueNodeFactory();

        private GetValueNodeFactory() {
        }

        @Override
        public Class<GetValueNode> getNodeClass() {
            return GetValueNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetValueNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetValueNode> getInstance() {
            return GET_VALUE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetValueNode create() {
            return new GetValueNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetValueNode#getValue}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetValueNode.class)
        @SuppressWarnings("javadoc")
        static final class GetValueNodeGen extends GetValueNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetValueNode#getValue}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetValueNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.GetValueNode.getValue(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return GetValueNode.getValue(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private int executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.GetValueNode.getValue(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return GetValueNode.getValue(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetHandleNode.class)
    static final class GetHandleNodeFactory implements NodeFactory<GetHandleNode> {

        private static final GetHandleNodeFactory GET_HANDLE_NODE_FACTORY_INSTANCE = new GetHandleNodeFactory();

        private GetHandleNodeFactory() {
        }

        @Override
        public Class<GetHandleNode> getNodeClass() {
            return GetHandleNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetHandleNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetHandleNode> getInstance() {
            return GET_HANDLE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetHandleNode create() {
            return new GetHandleNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetHandleNode#getHandle}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetHandleNode.class)
        @SuppressWarnings("javadoc")
        static final class GetHandleNodeGen extends GetHandleNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetHandleNode#getHandle}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetHandleNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.GetHandleNode.getHandle(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return GetHandleNode.getHandle(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private int executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.GetHandleNode.getHandle(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return GetHandleNode.getHandle(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetNameNode.class)
    static final class GetNameNodeFactory implements NodeFactory<GetNameNode> {

        private static final GetNameNodeFactory GET_NAME_NODE_FACTORY_INSTANCE = new GetNameNodeFactory();

        private GetNameNodeFactory() {
        }

        @Override
        public Class<GetNameNode> getNodeClass() {
            return GetNameNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetNameNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetNameNode> getInstance() {
            return GET_NAME_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetNameNode create() {
            return new GetNameNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetNameNode#getName}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetNameNode.class)
        @SuppressWarnings("javadoc")
        static final class GetNameNodeGen extends GetNameNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetNameNode#getName}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetNameNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.GetNameNode.getName(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return GetNameNode.getName(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.GetNameNode.getName(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return GetNameNode.getName(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetMaxValue.class)
    static final class GetMaxValueFactory implements NodeFactory<GetMaxValue> {

        private static final GetMaxValueFactory GET_MAX_VALUE_FACTORY_INSTANCE = new GetMaxValueFactory();

        private GetMaxValueFactory() {
        }

        @Override
        public Class<GetMaxValue> getNodeClass() {
            return GetMaxValue.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetMaxValue createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetMaxValue> getInstance() {
            return GET_MAX_VALUE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetMaxValue create() {
            return new GetMaxValueNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetMaxValue#getMax}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetMaxValue.class)
        @SuppressWarnings("javadoc")
        static final class GetMaxValueNodeGen extends GetMaxValue {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetMaxValue#getMax}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetMaxValueNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.GetMaxValue.getMax(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return GetMaxValue.getMax(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.GetMaxValue.getMax(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return GetMaxValue.getMax(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetKindNode.class)
    static final class GetKindNodeFactory implements NodeFactory<GetKindNode> {

        private static final GetKindNodeFactory GET_KIND_NODE_FACTORY_INSTANCE = new GetKindNodeFactory();

        private GetKindNodeFactory() {
        }

        @Override
        public Class<GetKindNode> getNodeClass() {
            return GetKindNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetKindNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetKindNode> getInstance() {
            return GET_KIND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetKindNode create() {
            return new GetKindNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetKindNode#getKind}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetKindNode.class)
        @SuppressWarnings("javadoc")
        static final class GetKindNodeGen extends GetKindNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetKindNode#getKind}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetKindNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.GetKindNode.getKind(PGraalPySemLock)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    return GetKindNode.getKind(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private int executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.GetKindNode.getKind(PGraalPySemLock)] */;
                    this.state_0_ = state_0;
                    return GetKindNode.getKind(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(AcquireNode.class)
    static final class AcquireNodeFactory implements NodeFactory<AcquireNode> {

        private static final AcquireNodeFactory ACQUIRE_NODE_FACTORY_INSTANCE = new AcquireNodeFactory();

        private AcquireNodeFactory() {
        }

        @Override
        public Class<AcquireNode> getNodeClass() {
            return AcquireNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public AcquireNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<AcquireNode> getInstance() {
            return ACQUIRE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AcquireNode create() {
            return new AcquireNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AcquireNode#fast}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link AcquireNode#slow}
         *     Activation probability: 0.35000
         *     With/without class size: 15/13 bytes
         * </pre>
         */
        @GeneratedBy(AcquireNode.class)
        @SuppressWarnings("javadoc")
        static final class AcquireNodeGen extends AcquireNode {

            private static final StateField STATE_0_AcquireNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link AcquireNode#slow}
             *   Parameter: {@link PyFloatAsDoubleNode} asDoubleNode
             *   Inline method: {@link PyFloatAsDoubleNodeGen#inline}</pre>
             */
            private static final PyFloatAsDoubleNode INLINED_SLOW_AS_DOUBLE_NODE_ = PyFloatAsDoubleNodeGen.inline(InlineTarget.create(PyFloatAsDoubleNode.class, STATE_0_AcquireNode_UPDATER.subUpdater(2, 7), ReferenceField.create(MethodHandles.lookup(), "slow_asDoubleNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "slow_asDoubleNode__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AcquireNode#fast}
             *   1: SpecializationActive {@link AcquireNode#slow}
             *   2-8: InlinedCache
             *        Specialization: {@link AcquireNode#slow}
             *        Parameter: {@link PyFloatAsDoubleNode} asDoubleNode
             *        Inline method: {@link PyFloatAsDoubleNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AcquireNode#slow}
             *   Parameter: {@link PyFloatAsDoubleNode} asDoubleNode
             *   Inline method: {@link PyFloatAsDoubleNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node slow_asDoubleNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AcquireNode#slow}
             *   Parameter: {@link PyFloatAsDoubleNode} asDoubleNode
             *   Inline method: {@link PyFloatAsDoubleNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node slow_asDoubleNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link AcquireNode#slow}
             *   Parameter: {@link GilNode} gil</pre>
             */
            @Child private GilNode slow_gil_;

            private AcquireNodeGen() {
            }

            @Override
            protected Object execute1(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[GraalPySemLockBuiltins.AcquireNode.fast(PGraalPySemLock, boolean, Object)] || SpecializationActive[GraalPySemLockBuiltins.AcquireNode.slow(VirtualFrame, PGraalPySemLock, boolean, Object, Node, PyFloatAsDoubleNode, GilNode)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (boolean) arg1Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[GraalPySemLockBuiltins.AcquireNode.fast(PGraalPySemLock, boolean, Object)] */) {
                            if ((AcquireNode.isFast(arg0Value_))) {
                                return AcquireNode.fast(arg0Value_, arg1Value_, arg2Value);
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[GraalPySemLockBuiltins.AcquireNode.slow(VirtualFrame, PGraalPySemLock, boolean, Object, Node, PyFloatAsDoubleNode, GilNode)] */) {
                            {
                                GilNode gil__ = this.slow_gil_;
                                if (gil__ != null) {
                                    if ((!(AcquireNode.isFast(arg0Value_)))) {
                                        Node inliningTarget__ = (this);
                                        return AcquireNode.slow(frameValue, arg0Value_, arg1Value_, arg2Value, inliningTarget__, INLINED_SLOW_AS_DOUBLE_NODE_, gil__);
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[GraalPySemLockBuiltins.AcquireNode.fast(PGraalPySemLock, boolean, Object)] || SpecializationActive[GraalPySemLockBuiltins.AcquireNode.slow(VirtualFrame, PGraalPySemLock, boolean, Object, Node, PyFloatAsDoubleNode, GilNode)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (boolean) arg1Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[GraalPySemLockBuiltins.AcquireNode.fast(PGraalPySemLock, boolean, Object)] */) {
                            if ((AcquireNode.isFast(arg0Value_))) {
                                return AcquireNode.fast(arg0Value_, arg1Value_, arg2Value);
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[GraalPySemLockBuiltins.AcquireNode.slow(VirtualFrame, PGraalPySemLock, boolean, Object, Node, PyFloatAsDoubleNode, GilNode)] */) {
                            {
                                GilNode gil__ = this.slow_gil_;
                                if (gil__ != null) {
                                    if ((!(AcquireNode.isFast(arg0Value_)))) {
                                        Node inliningTarget__ = (this);
                                        return AcquireNode.slow(frameValue, arg0Value_, arg1Value_, arg2Value, inliningTarget__, INLINED_SLOW_AS_DOUBLE_NODE_, gil__);
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (boolean) arg1Value;
                        if ((AcquireNode.isFast(arg0Value_))) {
                            state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.AcquireNode.fast(PGraalPySemLock, boolean, Object)] */;
                            this.state_0_ = state_0;
                            return AcquireNode.fast(arg0Value_, arg1Value_, arg2Value);
                        }
                        {
                            Node inliningTarget__ = null;
                            if ((!(AcquireNode.isFast(arg0Value_)))) {
                                inliningTarget__ = (this);
                                GilNode gil__ = this.insert((GilNode.create()));
                                Objects.requireNonNull(gil__, "Specialization 'slow(VirtualFrame, PGraalPySemLock, boolean, Object, Node, PyFloatAsDoubleNode, GilNode)' cache 'gil' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                VarHandle.storeStoreFence();
                                this.slow_gil_ = gil__;
                                state_0 = state_0 | 0b10 /* add SpecializationActive[GraalPySemLockBuiltins.AcquireNode.slow(VirtualFrame, PGraalPySemLock, boolean, Object, Node, PyFloatAsDoubleNode, GilNode)] */;
                                this.state_0_ = state_0;
                                return AcquireNode.slow(frameValue, arg0Value_, arg1Value_, arg2Value, inliningTarget__, INLINED_SLOW_AS_DOUBLE_NODE_, gil__);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(EnterLockNode.class)
    static final class EnterLockNodeFactory implements NodeFactory<EnterLockNode> {

        private static final EnterLockNodeFactory ENTER_LOCK_NODE_FACTORY_INSTANCE = new EnterLockNodeFactory();

        private EnterLockNodeFactory() {
        }

        @Override
        public Class<EnterLockNode> getNodeClass() {
            return EnterLockNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public EnterLockNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<EnterLockNode> getInstance() {
            return ENTER_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EnterLockNode create() {
            return new EnterLockNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link EnterLockNode#doEnter}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(EnterLockNode.class)
        @SuppressWarnings("javadoc")
        static final class EnterLockNodeGen extends EnterLockNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link EnterLockNode#doEnter}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link EnterLockNode#doEnter}
             *   Parameter: {@link AcquireNode} acquireNode</pre>
             */
            @Child private AcquireNode acquireNode_;

            private EnterLockNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.EnterLockNode.doEnter(VirtualFrame, PGraalPySemLock, Object, Object, AcquireNode)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    {
                        AcquireNode acquireNode__ = this.acquireNode_;
                        if (acquireNode__ != null) {
                            return EnterLockNode.doEnter(frameValue, arg0Value_, arg1Value, arg2Value, acquireNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @Override
            protected Object execute1(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.EnterLockNode.doEnter(VirtualFrame, PGraalPySemLock, Object, Object, AcquireNode)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    {
                        AcquireNode acquireNode__ = this.acquireNode_;
                        if (acquireNode__ != null) {
                            return EnterLockNode.doEnter(frameValue, arg0Value_, arg1Value, arg2Value, acquireNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    AcquireNode acquireNode__ = this.insert((AcquireNodeFactory.create()));
                    Objects.requireNonNull(acquireNode__, "Specialization 'doEnter(VirtualFrame, PGraalPySemLock, Object, Object, AcquireNode)' cache 'acquireNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.acquireNode_ = acquireNode__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.EnterLockNode.doEnter(VirtualFrame, PGraalPySemLock, Object, Object, AcquireNode)] */;
                    this.state_0_ = state_0;
                    return EnterLockNode.doEnter(frameValue, arg0Value_, arg1Value, arg2Value, acquireNode__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(RebuildNode.class)
    static final class RebuildNodeFactory implements NodeFactory<RebuildNode> {

        private static final RebuildNodeFactory REBUILD_NODE_FACTORY_INSTANCE = new RebuildNodeFactory();

        private RebuildNodeFactory() {
        }

        @Override
        public Class<RebuildNode> getNodeClass() {
            return RebuildNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public RebuildNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RebuildNode> getInstance() {
            return REBUILD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RebuildNode create(ReadArgumentNode[] arguments) {
            return new RebuildNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RebuildNode#doEnter}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(RebuildNode.class)
        @SuppressWarnings("javadoc")
        static final class RebuildNodeGen extends RebuildNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RebuildNode#doEnter}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link RebuildNode#doEnter}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;

            private RebuildNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.RebuildNode.doEnter(Object, int, Object, TruffleString, Node, PythonObjectFactory)] */ && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (int) arguments1Value_;
                    if (arguments3Value_ instanceof TruffleString) {
                        TruffleString arguments3Value__ = (TruffleString) arguments3Value_;
                        {
                            PythonObjectFactory factory__ = this.factory_;
                            if (factory__ != null) {
                                Node inliningTarget__ = (this);
                                return RebuildNode.doEnter(arguments0Value_, arguments1Value__, arguments2Value_, arguments3Value__, inliningTarget__, factory__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (int) arguments1Value;
                        if (arguments3Value instanceof TruffleString) {
                            TruffleString arguments3Value_ = (TruffleString) arguments3Value;
                            inliningTarget__ = (this);
                            PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                            Objects.requireNonNull(factory__, "Specialization 'doEnter(Object, int, Object, TruffleString, Node, PythonObjectFactory)' cache 'factory' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            VarHandle.storeStoreFence();
                            this.factory_ = factory__;
                            state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.RebuildNode.doEnter(Object, int, Object, TruffleString, Node, PythonObjectFactory)] */;
                            this.state_0_ = state_0;
                            return RebuildNode.doEnter(arguments0Value, arguments1Value_, arguments2Value, arguments3Value_, inliningTarget__, factory__);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ReleaseLockNode.class)
    static final class ReleaseLockNodeFactory implements NodeFactory<ReleaseLockNode> {

        private static final ReleaseLockNodeFactory RELEASE_LOCK_NODE_FACTORY_INSTANCE = new ReleaseLockNodeFactory();

        private ReleaseLockNodeFactory() {
        }

        @Override
        public Class<ReleaseLockNode> getNodeClass() {
            return ReleaseLockNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ReleaseLockNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReleaseLockNode> getInstance() {
            return RELEASE_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReleaseLockNode create() {
            return new ReleaseLockNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReleaseLockNode#doRelease}
         *     Activation probability: 1.00000
         *     With/without class size: 28/5 bytes
         * </pre>
         */
        @GeneratedBy(ReleaseLockNode.class)
        @SuppressWarnings("javadoc")
        static final class ReleaseLockNodeGen extends ReleaseLockNode {

            private static final StateField STATE_0_ReleaseLockNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReleaseLockNode#doRelease}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_ReleaseLockNode_UPDATER.subUpdater(1, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReleaseLockNode#doRelease}
             *   1: InlinedCache
             *        Specialization: {@link ReleaseLockNode#doRelease}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReleaseLockNode#doRelease}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            private ReleaseLockNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[GraalPySemLockBuiltins.ReleaseLockNode.doRelease(PGraalPySemLock, Node, Lazy)] */ && arg0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                    {
                        Node inliningTarget__ = (this);
                        return ReleaseLockNode.doRelease(arg0Value_, inliningTarget__, INLINED_RAISE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PGraalPySemLock) {
                        PGraalPySemLock arg0Value_ = (PGraalPySemLock) arg0Value;
                        inliningTarget__ = (this);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.ReleaseLockNode.doRelease(PGraalPySemLock, Node, Lazy)] */;
                        this.state_0_ = state_0;
                        return ReleaseLockNode.doRelease(arg0Value_, inliningTarget__, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ExitLockNode.class)
    static final class ExitLockNodeFactory implements NodeFactory<ExitLockNode> {

        private static final ExitLockNodeFactory EXIT_LOCK_NODE_FACTORY_INSTANCE = new ExitLockNodeFactory();

        private ExitLockNodeFactory() {
        }

        @Override
        public Class<ExitLockNode> getNodeClass() {
            return ExitLockNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public ExitLockNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ExitLockNode> getInstance() {
            return EXIT_LOCK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ExitLockNode create(ReadArgumentNode[] arguments) {
            return new ExitLockNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ExitLockNode#exit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ExitLockNode.class)
        @SuppressWarnings("javadoc")
        static final class ExitLockNodeGen extends ExitLockNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            @Child private ReadArgumentNode arguments2_;
            @Child private ReadArgumentNode arguments3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ExitLockNode#exit}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ExitLockNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[GraalPySemLockBuiltins.ExitLockNode.exit(PGraalPySemLock, Object, Object, Object)] */ && arguments0Value_ instanceof PGraalPySemLock) {
                    PGraalPySemLock arguments0Value__ = (PGraalPySemLock) arguments0Value_;
                    return ExitLockNode.exit(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PGraalPySemLock) {
                    PGraalPySemLock arguments0Value_ = (PGraalPySemLock) arguments0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[GraalPySemLockBuiltins.ExitLockNode.exit(PGraalPySemLock, Object, Object, Object)] */;
                    this.state_0_ = state_0;
                    return ExitLockNode.exit(arguments0Value_, arguments1Value, arguments2Value, arguments3Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
