/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.graal.python.runtime.sequence.storage.TypedSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.nio.ByteBuffer;
import java.util.Arrays;

@ExportLibrary(value=PythonBufferAccessLibrary.class)
public final class ByteSequenceStorage
extends TypedSequenceStorage {
    private byte[] values;

    public ByteSequenceStorage(byte[] elements) {
        this(elements, elements.length);
    }

    public ByteSequenceStorage(byte[] elements, int length) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = length;
    }

    public ByteSequenceStorage(int capacity) {
        this.values = new byte[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    @Override
    protected void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    @Override
    protected void increaseCapacityExact(int newCapacity) {
        this.values = new byte[newCapacity];
        this.capacity = this.values.length;
    }

    @Override
    public SequenceStorage copy() {
        return new ByteSequenceStorage(PythonUtils.arrayCopyOf(this.values, this.length));
    }

    @Override
    public SequenceStorage createEmpty(int newCapacity) {
        return new ByteSequenceStorage(newCapacity);
    }

    @Override
    public Object[] getInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    @ExportMessage.Ignore
    public byte[] getInternalByteArray() {
        if (this.length != this.values.length) {
            assert (this.length < this.values.length);
            return Arrays.copyOf(this.values, this.length);
        }
        return this.values;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true, transferToInterpreterOnException=false)
    public ByteBuffer getBufferView() {
        ByteBuffer view = ByteBuffer.wrap(this.values);
        view.limit(this.values.length);
        return view;
    }

    @Override
    public Object getItemNormalized(int idx) {
        return this.getIntItemNormalized(idx);
    }

    public final byte getByteItemNormalized(int idx) {
        return this.values[idx];
    }

    public int getIntItemNormalized(int idx) {
        return this.values[idx] & 0xFF;
    }

    @Override
    public void setItemNormalized(int idx, Object value) throws SequenceStoreException {
        if (value instanceof Byte) {
            this.setByteItemNormalized(idx, (Byte)value);
        } else if (value instanceof Integer) {
            if ((Integer)value < 0 || (Integer)value >= 256) {
                throw PRaiseNode.raiseUncached(null, PythonErrorType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
            }
            this.setByteItemNormalized(idx, ((Integer)value).byteValue());
        } else {
            throw PRaiseNode.raiseUncached(null, PythonErrorType.TypeError, ErrorMessages.INTEGER_REQUIRED);
        }
    }

    public void setByteItemNormalized(int idx, byte value) {
        this.values[idx] = value;
    }

    @Override
    public void insertItem(int idx, Object value) throws SequenceStoreException {
        if (value instanceof Byte) {
            this.insertByteItem(idx, (Byte)value);
        } else if (value instanceof Integer) {
            this.insertByteItem(idx, ((Integer)value).byteValue());
        } else {
            throw new SequenceStoreException(value);
        }
    }

    public void insertByteItem(int idx, byte value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        ++this.length;
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
        this.values[idxTo] = this.values[idxFrom];
    }

    @Override
    public ByteSequenceStorage getSliceInBound(int start, int stop, int step, int sliceLength) {
        byte[] newArray = new byte[sliceLength];
        if (step == 1) {
            PythonUtils.arraycopy(this.values, start, newArray, 0, sliceLength);
            return new ByteSequenceStorage(newArray);
        }
        int i = start;
        for (int j = 0; j < sliceLength; ++j) {
            newArray[j] = this.values[i];
            i += step;
        }
        return new ByteSequenceStorage(newArray);
    }

    public int indexOfByte(byte value) {
        for (int i = 0; i < this.length; ++i) {
            if (this.values[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int indexOfInt(int value) {
        for (int i = 0; i < this.length; ++i) {
            if ((this.values[i] & 0xFF) != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                byte temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    @Override
    public Object getIndicativeValue() {
        return 0;
    }

    @Override
    public boolean equals(SequenceStorage other) {
        if (other.length() != this.length() || !(other instanceof ByteSequenceStorage)) {
            return false;
        }
        byte[] otherArray = ((ByteSequenceStorage)other).getInternalByteArray();
        for (int i = 0; i < this.length(); ++i) {
            if (this.values[i] == otherArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return this.getInternalArray();
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (byte[])arrayObject;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Byte;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    int getBufferLength() {
        return this.length;
    }

    @ExportMessage
    boolean hasInternalByteArray() {
        return true;
    }

    @ExportMessage(name="getInternalByteArray")
    byte[] getInternalByteArrayMessage() {
        return this.values;
    }

    @ExportMessage
    byte readByte(int byteOffset) {
        return this.values[byteOffset];
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value) {
        this.values[byteOffset] = value;
    }

    @ExportMessage
    short readShort(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getShort(this.values, byteOffset);
    }

    @ExportMessage
    void writeShort(int byteOffset, short value) {
        PythonUtils.ARRAY_ACCESSOR.putShort(this.values, byteOffset, value);
    }

    @ExportMessage
    int readInt(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getInt(this.values, byteOffset);
    }

    @ExportMessage
    void writeInt(int byteOffset, int value) {
        PythonUtils.ARRAY_ACCESSOR.putInt(this.values, byteOffset, value);
    }

    @ExportMessage
    long readLong(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getLong(this.values, byteOffset);
    }

    @ExportMessage
    void writeLong(int byteOffset, long value) {
        PythonUtils.ARRAY_ACCESSOR.putLong(this.values, byteOffset, value);
    }

    @ExportMessage
    float readFloat(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getFloat(this.values, byteOffset);
    }

    @ExportMessage
    void writeFloat(int byteOffset, float value) {
        PythonUtils.ARRAY_ACCESSOR.putFloat(this.values, byteOffset, value);
    }

    @ExportMessage
    double readDouble(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getDouble(this.values, byteOffset);
    }

    @ExportMessage
    void writeDouble(int byteOffset, double value) {
        PythonUtils.ARRAY_ACCESSOR.putDouble(this.values, byteOffset, value);
    }
}

