/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.util.NarrowBigIntegerNodeGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.math.BigInteger;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class NarrowBigIntegerNode
extends PNodeWithContext {
    public abstract Object execute(Node var1, BigInteger var2);

    public static Object executeUncached(BigInteger x) {
        return NarrowBigIntegerNodeGen.getUncached().execute(null, x);
    }

    @Specialization(guards={"x.signum() == 0"})
    static Object narrowBigInteger0(BigInteger x) {
        return 0;
    }

    @Specialization(guards={"x.signum() != 0"})
    static Object narrowBigInteger(Node inliningTarget, BigInteger x, @Cached InlinedConditionProfile fitsIntProfile, @Cached InlinedConditionProfile fitsLongProfile, @Cached(inline=false) PythonObjectFactory factory) {
        if (fitsIntProfile.profile(inliningTarget, PInt.fitsIn(x, PInt.MIN_INT, PInt.MAX_INT))) {
            return PInt.intValue(x);
        }
        if (fitsLongProfile.profile(inliningTarget, PInt.fitsIn(x, PInt.MIN_LONG, PInt.MAX_LONG))) {
            return PInt.longValue(x);
        }
        return factory.createInt(x);
    }
}

