/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallNbNumbersBinaryNodeFactory;
import com.oracle.graal.python.nodes.call.special.LookupAndCallNonReversibleBinaryNodeGen;
import com.oracle.graal.python.nodes.call.special.LookupAndCallReversibleBinaryNodeGen;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
public abstract class LookupAndCallBinaryNode
extends Node {
    protected final Supplier<NotImplementedHandler> handlerFactory;
    protected final boolean ignoreDescriptorException;
    @Node.Child
    private CallBinaryMethodNode dispatchNode;
    @Node.Child
    private NotImplementedHandler handler;

    LookupAndCallBinaryNode(Supplier<NotImplementedHandler> handlerFactory, boolean ignoreDescriptorException) {
        this.handlerFactory = handlerFactory;
        this.ignoreDescriptorException = ignoreDescriptorException;
    }

    public abstract Object executeObject(VirtualFrame var1, Object var2, Object var3);

    @NeverDefault
    public static LookupAndCallBinaryNode create(TruffleString name) {
        assert (SpecialMethodSlot.findSpecialSlotUncached(name) == null) : name;
        return LookupAndCallNonReversibleBinaryNodeGen.create(name, null, false);
    }

    @NeverDefault
    public static LookupAndCallBinaryNode create(SpecialMethodSlot slot) {
        return LookupAndCallNonReversibleBinaryNodeGen.create(slot, null, false);
    }

    @NeverDefault
    public static LookupAndCallBinaryNode create(SpecialMethodSlot slot, Supplier<NotImplementedHandler> handlerFactory) {
        return LookupAndCallNonReversibleBinaryNodeGen.create(slot, handlerFactory, false);
    }

    @NeverDefault
    public static LookupAndCallBinaryNode createReversible(SpecialMethodSlot slot, SpecialMethodSlot rslot, Supplier<NotImplementedHandler> handlerFactory) {
        return LookupAndCallReversibleBinaryNodeGen.create(slot, rslot, handlerFactory, false, false);
    }

    @NeverDefault
    public static LookupAndCallBinaryNode createPyNumberAdd(Supplier<NotImplementedHandler> handlerFactory) {
        return LookupAndCallNbNumbersBinaryNodeFactory.PyNumberAddNodeGen.create(handlerFactory);
    }

    @NeverDefault
    public static LookupAndCallBinaryNode createPyNumberMultiply(Supplier<NotImplementedHandler> handlerFactory) {
        return LookupAndCallNbNumbersBinaryNodeFactory.PyNumberMultiplyNodeGen.create(handlerFactory);
    }

    @NeverDefault
    public static LookupAndCallBinaryNode createBinaryOp(SpecialMethodSlot slot, SpecialMethodSlot rslot, Supplier<NotImplementedHandler> handlerFactory) {
        return LookupAndCallNbNumbersBinaryNodeFactory.BinaryOpNodeGen.create(slot, rslot, handlerFactory);
    }

    @NeverDefault
    public static LookupAndCallBinaryNode create(SpecialMethodSlot slot, SpecialMethodSlot rslot, boolean alwaysCheckReverse, boolean ignoreDescriptorException) {
        return LookupAndCallReversibleBinaryNodeGen.create(slot, rslot, null, alwaysCheckReverse, ignoreDescriptorException);
    }

    protected static Object getMethod(Object receiver, TruffleString methodName) {
        return LookupSpecialMethodNode.Dynamic.executeUncached(null, GetClassNode.executeUncached(receiver), methodName, receiver);
    }

    public abstract TruffleString getName();

    public abstract TruffleString getRname();

    protected final CallBinaryMethodNode ensureDispatch() {
        if (this.dispatchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.dispatchNode = (CallBinaryMethodNode)this.insert(CallBinaryMethodNode.create());
        }
        return this.dispatchNode;
    }

    protected final Object runErrorHandler(VirtualFrame frame, Object left, Object right) {
        if (this.handler == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.handler = (NotImplementedHandler)this.insert((NotImplementedHandler)((Object)this.handlerFactory.get()));
        }
        return this.handler.execute(frame, left, right);
    }

    public static abstract class NotImplementedHandler
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, Object var2, Object var3);
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class GetEnclosingType
    extends Node {
        protected GetEnclosingType() {
        }

        public abstract Object execute(Node var1, Object var2);

        @Specialization
        static Object doDescrs(BuiltinMethodDescriptor descriptor) {
            return descriptor.getEnclosingType();
        }

        @Specialization
        static Object doBuiltinFun(PBuiltinFunction fun) {
            return fun.getEnclosingType();
        }

        @Specialization
        static Object doBuiltinMethod(PBuiltinMethod a) {
            return GetEnclosingType.doBuiltinFun(a.getBuiltinFunction());
        }

        @Fallback
        static Object doOthers(Object callable) {
            return null;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class AreSameCallables
    extends Node {
        protected AreSameCallables() {
        }

        public abstract boolean execute(Node var1, Object var2, Object var3);

        @Specialization(guards={"a == b"})
        static boolean areIdenticalFastPath(Object a, Object b) {
            return true;
        }

        @Specialization(guards={"isNone(a) || isNone(b)"})
        static boolean noneFastPath(Object a, Object b) {
            return a == b;
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doDescrs(BuiltinMethodDescriptor a, BuiltinMethodDescriptor b) {
            return a == b;
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doDescrFun1(BuiltinMethodDescriptor a, PBuiltinFunction b) {
            return a.isDescriptorOf(b);
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doDescrFun2(PBuiltinFunction a, BuiltinMethodDescriptor b) {
            return b.isDescriptorOf(a);
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doDescrMeth1(BuiltinMethodDescriptor a, PBuiltinMethod b) {
            return AreSameCallables.doDescrFun1(a, b.getBuiltinFunction());
        }

        @Specialization(replaces={"areIdenticalFastPath"})
        static boolean doDescrMeth2(PBuiltinMethod a, BuiltinMethodDescriptor b) {
            return AreSameCallables.doDescrFun2(a.getBuiltinFunction(), b);
        }

        @Fallback
        static boolean doGenericRuntimeObjects(Object a, Object b) {
            return a == b;
        }
    }
}

