/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.common.CExtAsPythonObjectNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyMemberAccessNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

public class GraalHPyMemberAccessNodes {
    static GraalHPyNativeSymbol getReadAccessorName(int type) {
        switch (type) {
            case 0: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_S;
            }
            case 1: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_I;
            }
            case 2: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_L;
            }
            case 3: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_F;
            }
            case 4: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_D;
            }
            case 5: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_STRING;
            }
            case 6: 
            case 16: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_HPYFIELD;
            }
            case 7: 
            case 8: 
            case 14: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_C;
            }
            case 9: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_UC;
            }
            case 10: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_US;
            }
            case 11: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_UI;
            }
            case 12: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_UL;
            }
            case 13: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_STRING_IN_PLACE;
            }
            case 17: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_LL;
            }
            case 18: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_ULL;
            }
            case 19: {
                return GraalHPyNativeSymbol.GRAAL_HPY_READ_HPY_SSIZE_T;
            }
            case 20: {
                return null;
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
    }

    static CExtAsPythonObjectNode getReadConverterNode(int type) {
        return switch (type) {
            case 0, 1, 2, 3, 4, 6, 8, 9, 10, 13, 16, 19, 20 -> null;
            case 5 -> CExtCommonNodesFactory.StringAsPythonStringNodeGen.create();
            case 14 -> CExtCommonNodesFactory.NativePrimitiveAsPythonBooleanNodeGen.create();
            case 7 -> CExtCommonNodesFactory.NativePrimitiveAsPythonCharNodeGen.create();
            case 11, 12, 17, 18 -> CExtCommonNodesFactory.NativeUnsignedPrimitiveAsPythonObjectNodeGen.create();
            default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
        };
    }

    static GraalHPyNativeSymbol getWriteAccessorName(int type) {
        return switch (type) {
            case 0 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_S;
            case 1 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I;
            case 2 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_L;
            case 3 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_F;
            case 4 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_D;
            case 5, 13, 20 -> null;
            case 6, 16 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_HPYFIELD;
            case 7, 8, 14 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_C;
            case 9 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UC;
            case 10 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_US;
            case 11 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UI;
            case 12 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UL;
            case 17 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_LL;
            case 18 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_ULL;
            case 19 -> GraalHPyNativeSymbol.GRAAL_HPY_WRITE_HPY_SSIZE_T;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
        };
    }

    static CExtToNativeNode getWriteConverterNode(int type) {
        return switch (type) {
            case 7 -> CExtCommonNodesFactory.AsNativeCharNodeGen.create();
            case 14 -> CExtCommonNodesFactory.AsNativeBooleanNodeGen.create();
            case 0, 1, 8 -> CExtCommonNodesFactory.AsFixedNativePrimitiveNodeGen.create(4, true);
            case 2, 19 -> CExtCommonNodesFactory.AsFixedNativePrimitiveNodeGen.create(8, true);
            case 3, 4 -> CExtCommonNodesFactory.AsNativeDoubleNodeGen.create();
            case 9, 10, 11 -> CExtCommonNodesFactory.AsFixedNativePrimitiveNodeGen.create(4, false);
            case 12, 17, 18 -> CExtCommonNodesFactory.AsFixedNativePrimitiveNodeGen.create(8, false);
            case 5, 6, 13, 16, 20 -> null;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
        };
    }

    static boolean isReadOnlyType(int type) {
        return type == 5 || type == 13;
    }

    @Builtin(name="hpy_write_member", minNumOfPositionalArgs=2, parameterNames={"$self", "value"})
    protected static abstract class HPyWriteMemberNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin builtin = HPyWriteMemberNode.class.getAnnotation(Builtin.class);
        @Node.Child
        private GraalHPyNodes.PCallHPyFunction callHPyFunctionNode;
        @Node.Child
        private CExtToNativeNode toNativeNode;
        @Node.Child
        private GraalHPyNodes.HPyGetNativeSpacePointerNode readNativeSpaceNode;
        @Node.Child
        private InteropLibrary resultLib;
        @Node.Child
        private GraalHPyNodes.HPyFieldStoreNode hpyFieldStoreNode;
        private final int type;
        private final int offset;

        protected HPyWriteMemberNode(int type, int offset) {
            this.type = type;
            this.offset = offset;
            this.toNativeNode = GraalHPyMemberAccessNodes.getWriteConverterNode(type);
            if (type == 6 || type == 16) {
                this.hpyFieldStoreNode = GraalHPyNodesFactory.HPyFieldStoreNodeGen.create();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        Object doGeneric(VirtualFrame frame, Object self, Object value) {
            Object nativeValue;
            Object newValue;
            PythonContext context = this.getContext();
            GraalHPyContext hPyContext = context.getHPyContext();
            Object nativeSpacePtr = this.ensureReadNativeSpaceNode().execute(self);
            if (nativeSpacePtr == PNone.NO_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.ATTEMPTING_WRITE_OFFSET_D, this.offset, self);
            }
            if (value == DescriptorDeleteMarker.INSTANCE) {
                if (this.type == 16) {
                    Object oldValue;
                    if (this.resultLib == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.resultLib = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(2)));
                    }
                    if (this.resultLib.isNull(oldValue = this.ensureCallHPyFunctionNode().call(hPyContext, GraalHPyMemberAccessNodes.getReadAccessorName(this.type), nativeSpacePtr, this.offset))) {
                        throw this.raise(PythonBuiltinClassType.AttributeError);
                    }
                } else if (this.type != 6) {
                    throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_T_DELETE_NUMERIC_CHAR_ATTRIBUTE);
                }
                newValue = PNone.NO_VALUE;
            } else {
                newValue = value;
            }
            GraalHPyNativeSymbol accessor = GraalHPyMemberAccessNodes.getWriteAccessorName(this.type);
            if (accessor == null) return PNone.NONE;
            if (this.hpyFieldStoreNode != null) {
                assert (this.type == 6 || this.type == 16);
                if (!(self instanceof PythonObject)) throw CompilerDirectives.shouldNotReachHere((String)"Cannot have HPyField on non-Python object");
                PythonObject pythonObject = (PythonObject)self;
                Object oldValue = this.ensureCallHPyFunctionNode().call(hPyContext, GraalHPyMemberAccessNodes.getReadAccessorName(this.type), nativeSpacePtr, this.offset);
                int fieldIdx = this.hpyFieldStoreNode.execute(this, pythonObject, oldValue, newValue);
                nativeValue = GraalHPyHandle.createField(newValue, fieldIdx);
            } else if (this.toNativeNode != null) {
                Object savedState = ExecutionContext.IndirectCallContext.enter(frame, this.getLanguage(), context, this);
                try {
                    nativeValue = this.toNativeNode.execute(newValue);
                }
                finally {
                    ExecutionContext.IndirectCallContext.exit(frame, this.getLanguage(), context, savedState);
                }
            } else {
                nativeValue = newValue;
            }
            this.ensureCallHPyFunctionNode().call(hPyContext, accessor, nativeSpacePtr, this.offset, nativeValue);
            return PNone.NONE;
        }

        private GraalHPyNodes.PCallHPyFunction ensureCallHPyFunctionNode() {
            if (this.callHPyFunctionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callHPyFunctionNode = (GraalHPyNodes.PCallHPyFunction)this.insert(GraalHPyNodesFactory.PCallHPyFunctionNodeGen.create());
            }
            return this.callHPyFunctionNode;
        }

        private GraalHPyNodes.HPyGetNativeSpacePointerNode ensureReadNativeSpaceNode() {
            if (this.readNativeSpaceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNativeSpaceNode = (GraalHPyNodes.HPyGetNativeSpacePointerNode)this.insert(GraalHPyNodesFactory.HPyGetNativeSpacePointerNodeGen.create());
            }
            return this.readNativeSpaceNode;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName, int type, int offset) {
            GraalHPyNativeSymbol accessor = GraalHPyMemberAccessNodes.getWriteAccessorName(type);
            if (accessor == null) {
                if (GraalHPyMemberAccessNodes.isReadOnlyType(type)) {
                    return HPyReadOnlyMemberNode.createBuiltinFunction(language, propertyName);
                }
                return HPyBadMemberDescrNode.createBuiltinFunction(language, propertyName);
            }
            RootCallTarget callTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<HPyWriteMemberNode>(GraalHPyMemberAccessNodesFactory.HPyWriteMemberNodeGen.create(type, offset)), true), HPyWriteMemberNode.class, builtin.name(), type, offset);
            int flags = PBuiltinFunction.getFlags(builtin, callTarget);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, callTarget);
        }
    }

    @Builtin(name="hpy_bad_member_descr", minNumOfPositionalArgs=2, parameterNames={"$self", "value"})
    protected static abstract class HPyBadMemberDescrNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin builtin = HPyBadMemberDescrNode.class.getAnnotation(Builtin.class);

        protected HPyBadMemberDescrNode() {
        }

        @Specialization
        Object doGeneric(Object self, Object value) {
            if (value == DescriptorDeleteMarker.INSTANCE) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_T_DELETE_NUMERIC_CHAR_ATTRIBUTE);
            }
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_MEMBER_DESCR_TYPE_FOR_P, self);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName) {
            RootCallTarget builtinCt = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<HPyBadMemberDescrNode>(GraalHPyMemberAccessNodesFactory.HPyBadMemberDescrNodeGen.create()), true), HPyBadMemberDescrNode.class, builtin);
            int flags = PBuiltinFunction.getFlags(builtin, builtinCt);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, builtinCt);
        }
    }

    @Builtin(name="hpy_member_write_read_only", minNumOfPositionalArgs=1, parameterNames={"$self", "value"})
    protected static abstract class HPyReadOnlyMemberNode
    extends PythonBinaryBuiltinNode {
        private static final Builtin builtin = HPyReadOnlyMemberNode.class.getAnnotation(Builtin.class);
        private final TruffleString propertyName;

        protected HPyReadOnlyMemberNode(TruffleString propertyName) {
            this.propertyName = propertyName;
        }

        @Specialization
        Object doGeneric(Object self, Object value) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTRIBUTE_S_OF_P_OBJECTS_IS_NOT_WRITABLE, this.propertyName, self);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName) {
            RootCallTarget builtinCt = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<HPyReadOnlyMemberNode>(GraalHPyMemberAccessNodesFactory.HPyReadOnlyMemberNodeGen.create(propertyName)), true), GraalHPyMemberAccessNodes.class, builtin.name());
            int flags = PBuiltinFunction.getFlags(builtin, builtinCt);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, builtinCt);
        }
    }

    @Builtin(name="hpy_member_read", minNumOfPositionalArgs=1, parameterNames={"$self"})
    protected static abstract class HPyReadMemberNode
    extends PythonUnaryBuiltinNode {
        private static final Builtin builtin = HPyReadMemberNode.class.getAnnotation(Builtin.class);
        @Node.Child
        private GraalHPyNodes.PCallHPyFunction callHPyFunctionNode;
        @Node.Child
        private CExtAsPythonObjectNode asPythonObjectNode;
        @Node.Child
        private PForeignToPTypeNode fromForeign;
        @Node.Child
        private GraalHPyNodes.HPyGetNativeSpacePointerNode readNativeSpaceNode;
        @Node.Child
        private GraalHPyNodes.HPyFieldLoadNode hPyFieldLoadNode;
        private final GraalHPyNativeSymbol accessor;
        private final int type;
        private final int offset;

        protected HPyReadMemberNode(GraalHPyNativeSymbol accessor, int offset, int type, CExtAsPythonObjectNode asPythonObjectNode) {
            this.accessor = accessor;
            this.offset = offset;
            this.type = type;
            if (type == 6 || type == 16) {
                this.hPyFieldLoadNode = GraalHPyNodesFactory.HPyFieldLoadNodeGen.create();
            }
            this.asPythonObjectNode = asPythonObjectNode;
            if (asPythonObjectNode == null) {
                this.fromForeign = PForeignToPTypeNode.create();
            }
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, Object self) {
            GraalHPyContext hPyContext = this.getContext().getHPyContext();
            Object nativeSpacePtr = this.ensureReadNativeSpaceNode().execute(self);
            if (nativeSpacePtr == PNone.NO_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.ATTEMPTING_READ_FROM_OFFSET_D, this.offset, self);
            }
            Object nativeResult = PNone.NONE;
            if (this.accessor != null) {
                nativeResult = this.ensureCallHPyFunctionNode().call(hPyContext, this.accessor, nativeSpacePtr, this.offset);
                if (this.hPyFieldLoadNode != null) {
                    assert (this.type == 6 || this.type == 16);
                    if (self instanceof PythonObject) {
                        PythonObject pythonObject = (PythonObject)self;
                        Object loadedFieldValue = this.hPyFieldLoadNode.execute(this, pythonObject, nativeResult);
                        if (loadedFieldValue == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
                            if (this.type == 6) {
                                return PNone.NONE;
                            }
                            throw this.raise(PythonBuiltinClassType.AttributeError);
                        }
                        return loadedFieldValue;
                    }
                    throw CompilerDirectives.shouldNotReachHere((String)"Cannot have HPyField on non-Python object");
                }
                if (this.asPythonObjectNode != null) {
                    return this.asPythonObjectNode.execute(nativeResult);
                }
            }
            return this.fromForeign.executeConvert(nativeResult);
        }

        private GraalHPyNodes.PCallHPyFunction ensureCallHPyFunctionNode() {
            if (this.callHPyFunctionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callHPyFunctionNode = (GraalHPyNodes.PCallHPyFunction)this.insert(GraalHPyNodesFactory.PCallHPyFunctionNodeGen.create());
            }
            return this.callHPyFunctionNode;
        }

        private GraalHPyNodes.HPyGetNativeSpacePointerNode ensureReadNativeSpaceNode() {
            if (this.readNativeSpaceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readNativeSpaceNode = (GraalHPyNodes.HPyGetNativeSpacePointerNode)this.insert(GraalHPyNodesFactory.HPyGetNativeSpacePointerNodeGen.create());
            }
            return this.readNativeSpaceNode;
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createBuiltinFunction(PythonLanguage language, TruffleString propertyName, int type, int offset) {
            GraalHPyNativeSymbol accessor = GraalHPyMemberAccessNodes.getReadAccessorName(type);
            CExtAsPythonObjectNode asPythonObjectNode = GraalHPyMemberAccessNodes.getReadConverterNode(type);
            RootCallTarget callTarget = language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)new HPyMemberNodeFactory<HPyReadMemberNode>(GraalHPyMemberAccessNodesFactory.HPyReadMemberNodeGen.create(accessor, offset, type, asPythonObjectNode)), true), HPyReadMemberNode.class, builtin.name(), type, offset);
            int flags = PBuiltinFunction.getFlags(builtin, callTarget);
            return PythonObjectFactory.getUncached().createBuiltinFunction(propertyName, null, 0, flags, callTarget);
        }
    }

    public static class HPyMemberNodeFactory<T extends PythonBuiltinBaseNode>
    implements NodeFactory<T> {
        private final T node;

        public HPyMemberNodeFactory(T node) {
            this.node = node;
        }

        public T createNode(Object ... arguments) {
            return (T)((PythonBuiltinBaseNode)NodeUtil.cloneNode(this.node));
        }

        public Class<T> getNodeClass() {
            return HPyMemberNodeFactory.determineNodeClass(this.node);
        }

        private static <T> Class<T> determineNodeClass(T node) {
            CompilerAsserts.neverPartOfCompilation();
            Class nodeClass = node.getClass();
            GeneratedBy genBy = nodeClass.getAnnotation(GeneratedBy.class);
            if (genBy != null) {
                nodeClass = genBy.value();
                assert (nodeClass.isAssignableFrom(node.getClass()));
            }
            return nodeClass;
        }

        public List<List<Class<?>>> getNodeSignatures() {
            throw new IllegalAccessError();
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            throw new IllegalAccessError();
        }
    }
}

