/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIContext;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.nio.file.LinkOption;
import org.graalvm.shadowed.com.ibm.icu.impl.Punycode;
import org.graalvm.shadowed.com.ibm.icu.text.StringPrepParseException;

public abstract class CExtContext {
    private static TruffleLogger LOGGER;
    protected static final String J_HPY_INIT = "HPyInit_";
    protected static final String J_HPY_MAJOR_VER_FUN = "get_required_hpy_major_version_";
    protected static final String J_HPY_MINOR_VER_FUN = "get_required_hpy_minor_version_";
    private static final TruffleString T_PY_INIT;
    private static final TruffleString T_PY_INIT_U;
    public static final int METH_VARARGS = 1;
    public static final int METH_KEYWORDS = 2;
    public static final int METH_NOARGS = 4;
    public static final int METH_O = 8;
    public static final int METH_CLASS = 16;
    public static final int METH_STATIC = 32;
    public static final int METH_FASTCALL = 128;
    public static final int METH_METHOD = 512;
    private static final int CALL_CONVENTION_MASK = 655;
    private final PythonContext context;
    private final Object llvmLibrary;
    private DynamicObject symbolCache;
    protected final boolean useNativeBackend;

    private static TruffleLogger getLogger() {
        if (LOGGER == null) {
            LOGGER = CApiContext.getLogger(CExtContext.class);
        }
        return LOGGER;
    }

    public CExtContext(PythonContext context, Object llvmLibrary, boolean useNativeBackend) {
        this.context = context;
        this.llvmLibrary = llvmLibrary;
        this.useNativeBackend = useNativeBackend;
    }

    public final PythonContext getContext() {
        return this.context;
    }

    public final Object getLLVMLibrary() {
        return this.llvmLibrary;
    }

    public static boolean isMethVarargs(int flags) {
        return (flags & 0x28F) == 1;
    }

    public static boolean isMethVarargsWithKeywords(int flags) {
        return (flags & 0x28F) == 3;
    }

    public static boolean isMethNoArgs(int flags) {
        return (flags & 0x28F) == 4;
    }

    public static boolean isMethO(int flags) {
        return (flags & 0x28F) == 8;
    }

    public static boolean isMethFastcall(int flags) {
        return (flags & 0x28F) == 128;
    }

    public static boolean isMethFastcallWithKeywords(int flags) {
        return (flags & 0x28F) == 130;
    }

    public static boolean isMethMethod(int flags) {
        return (flags & 0x28F) == 642;
    }

    public static boolean isMethStatic(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isClassOrStaticMethod(int flags) {
        return flags > 0 && (flags & 0x30) != 0;
    }

    public final DynamicObject getSymbolCache() {
        if (this.symbolCache == null) {
            this.symbolCache = this.initializeSymbolCache();
        }
        return this.symbolCache;
    }

    protected abstract Store initializeSymbolCache();

    @CompilerDirectives.TruffleBoundary
    protected static TruffleString getBaseName(TruffleString name) {
        int len = TruffleString.CodePointLengthNode.getUncached().execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING);
        if (len == 1) {
            return name.equalsUncached((AbstractTruffleString)StringLiterals.T_DOT, PythonUtils.TS_ENCODING) ? StringLiterals.T_EMPTY_STRING : name;
        }
        int idx = name.lastIndexOfStringUncached((AbstractTruffleString)StringLiterals.T_DOT, len, 0, PythonUtils.TS_ENCODING);
        if (idx < 0) {
            return name;
        }
        if (idx == len - 1) {
            return StringLiterals.T_EMPTY_STRING;
        }
        return name.substringUncached(idx + 1, len - idx - 1, PythonUtils.TS_ENCODING, true);
    }

    private static String dlopenFlagsToString(int flags) {
        Object str = "RTLD_NOW";
        if ((flags & PosixConstants.RTLD_LAZY.value) != 0) {
            str = "RTLD_LAZY";
        }
        if ((flags & PosixConstants.RTLD_GLOBAL.value) != 0) {
            str = (String)str + "|RTLD_GLOBAL";
        }
        return str;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object loadCExtModule(Node location, PythonContext context, ModuleSpec spec, CExtCommonNodes.CheckFunctionResultNode checkFunctionResultNode) throws IOException, LoadCExtException.ApiInitException, LoadCExtException.ImportException {
        InteropLibrary interopLib;
        Object library;
        CApiContext cApiContext = CApiContext.ensureCapiWasLoaded(location, context, spec.name, spec.path);
        if (cApiContext.useNativeBackend) {
            GraalHPyJNIContext.loadJNIBackend();
            TruffleFile realPath = context.getPublicTruffleFileRelaxed(spec.path, context.getSoAbi()).getCanonicalFile(new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            CExtContext.getLogger().config(String.format("loading module %s (real path: %s) as native", spec.path, realPath));
            Object loadExpr = String.format("load(%s) \"%s\"", CExtContext.dlopenFlagsToString(context.getDlopenFlags()), realPath);
            if (((Boolean)PythonOptions.UsePanama.getValue(context.getEnv().getOptions())).booleanValue()) {
                loadExpr = "with panama " + (String)loadExpr;
            }
            try {
                Source librarySource = Source.newBuilder((String)"nfi", (CharSequence)loadExpr, (String)("load " + spec.name)).build();
                library = context.getEnv().parseInternal(librarySource, new String[0]).call(new Object[0]);
                interopLib = InteropLibrary.getUncached((Object)library);
            }
            catch (PException e) {
                throw e;
            }
            catch (AbstractTruffleException e) {
                throw new LoadCExtException.ImportException(CExtContext.wrapJavaException(e, location), spec.name, spec.path, ErrorMessages.CANNOT_LOAD_M, new Object[]{spec.path, e});
            }
        }
        library = CExtContext.loadLLVMLibrary(location, context, spec.name, spec.path);
        interopLib = InteropLibrary.getUncached((Object)library);
        try {
            if (interopLib.getLanguage(library).toString().startsWith("class com.oracle.truffle.nfi")) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, ErrorMessages.NO_BITCODE_FOUND, spec.path);
            }
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
        try {
            return cApiContext.initCApiModule(location, library, spec.getInitFunctionName(), spec, interopLib, checkFunctionResultNode);
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw new LoadCExtException.ImportException(CExtContext.wrapJavaException(e, location), spec.name, spec.path, ErrorMessages.CANNOT_INITIALIZE_WITH, spec.path, spec.getEncodedName(), "");
        }
    }

    public static Object loadLLVMLibrary(Node location, PythonContext context, TruffleString name, TruffleString path) throws LoadCExtException.ImportException, IOException {
        TruffleLanguage.Env env = context.getEnv();
        try {
            TruffleString extSuffix = context.getSoAbi();
            TruffleFile realPath = context.getPublicTruffleFileRelaxed(path, extSuffix).getCanonicalFile(new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            CallTarget callTarget = env.parseInternal(Source.newBuilder((String)"llvm", (TruffleFile)realPath).build(), new String[0]);
            return callTarget.call(new Object[0]);
        }
        catch (SecurityException e) {
            throw new LoadCExtException.ImportException(CExtContext.wrapJavaException(e, location), name, path, ErrorMessages.CANNOT_LOAD_M, path, e);
        }
        catch (RuntimeException e) {
            throw CExtContext.reportImportError(e, name, path);
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected static PException reportImportError(RuntimeException e, TruffleString name, TruffleString path) throws LoadCExtException.ImportException {
        StringBuilder sb = new StringBuilder();
        Object pythonCause = null;
        PException pcause = null;
        if (e instanceof PException) {
            Object excObj;
            pythonCause = excObj = ((PException)((Object)e)).getEscapedException();
            pcause = (PException)((Object)e);
            sb.append(LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode.getUncached().executeObject(excObj, SpecialMethodNames.T___REPR__));
        } else {
            sb.append(e.getMessage());
        }
        Throwable cause = e;
        while ((cause = cause.getCause()) != null) {
            if (e instanceof PException) {
                Object pythonException = ((PException)((Object)e)).getEscapedException();
                if (pythonCause != null) {
                    ExceptionNodes.SetCauseNode.executeUncached(pythonCause, pythonException);
                }
                pythonCause = pythonException;
                pcause = (PException)((Object)e);
            }
            if (cause.getMessage() == null) continue;
            sb.append(", ");
            sb.append(cause.getMessage());
        }
        Object[] args = new Object[]{path, sb.toString()};
        if (pythonCause != null) {
            throw new LoadCExtException.ImportException(pcause, name, path, ErrorMessages.CANNOT_LOAD, args);
        }
        throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.CANNOT_LOAD, args);
    }

    @CompilerDirectives.TruffleBoundary
    public static PException wrapJavaException(Throwable e, Node raisingNode) {
        TruffleString message = PythonUtils.toTruffleStringUncached(e.getMessage());
        PBaseException excObject = PythonObjectFactory.getUncached().createBaseException((Object)PythonBuiltinClassType.SystemError, message != null ? message : PythonUtils.toTruffleStringUncached(e.toString()), PythonUtils.EMPTY_OBJECT_ARRAY);
        return ExceptionUtils.wrapJavaException(e, raisingNode, excObject);
    }

    static {
        T_PY_INIT = PythonUtils.tsLiteral("PyInit_");
        T_PY_INIT_U = PythonUtils.tsLiteral("PyInitU_");
    }

    public static final class Store
    extends DynamicObject {
        public Store(Shape shape) {
            super(shape);
        }
    }

    @CompilerDirectives.ValueType
    public static final class ModuleSpec {
        public final TruffleString name;
        public final TruffleString path;
        public final Object originalModuleSpec;
        private TruffleString encodedName;
        private boolean ascii;

        public ModuleSpec(TruffleString name, TruffleString path, Object originalModuleSpec) {
            this.name = name;
            this.path = path;
            this.originalModuleSpec = originalModuleSpec;
        }

        @CompilerDirectives.TruffleBoundary
        TruffleString getEncodedName() {
            if (this.encodedName != null) {
                return this.encodedName;
            }
            TruffleString basename = CExtContext.getBaseName(this.name);
            boolean canEncode = ModuleSpec.canEncode(basename);
            if (canEncode) {
                this.ascii = true;
            } else {
                this.ascii = false;
                try {
                    basename = TruffleString.fromJavaStringUncached((String)Punycode.encode((CharSequence)basename.toJavaStringUncached(), null).toString(), (TruffleString.Encoding)PythonUtils.TS_ENCODING);
                }
                catch (StringPrepParseException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            this.encodedName = StringNodes.StringReplaceNode.getUncached().execute(basename, StringLiterals.T_DASH, StringLiterals.T_UNDERSCORE, -1);
            return this.encodedName;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean canEncode(TruffleString basename) {
            return TruffleString.GetCodeRangeNode.getUncached().execute((AbstractTruffleString)basename, PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII;
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleString getInitFunctionName() {
            TruffleString s = this.getEncodedName();
            return StringUtils.cat(this.ascii ? T_PY_INIT : T_PY_INIT_U, s);
        }
    }
}

