/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.logging.Level;

public abstract class PyTruffleObjectFree {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PyTruffleObjectFree.class);

    @GenerateUncached
    public static abstract class ReleaseHandleNode
    extends Node {
        public abstract void execute(PythonNativeWrapper var1);

        @Specialization
        static void doNativeWrapper(PythonNativeWrapper nativeWrapper, @Cached CExtNodes.PCallCapiFunction callReleaseHandleNode) {
            if (nativeWrapper.isNative()) {
                long nativePointer = nativeWrapper.getNativePointer();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(() -> PythonUtils.formatJString("Releasing handle: %x (object: %s)", nativePointer, nativeWrapper));
                }
                if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(nativePointer)) {
                    CApiTransitions.HandleReleaser.release(nativePointer);
                } else {
                    CApiTransitions.nativeLookupRemove(PythonContext.get((Node)callReleaseHandleNode).nativeContext, nativePointer);
                    callReleaseHandleNode.call(NativeCAPISymbol.FUN_PY_TRUFFLE_FREE, nativePointer);
                }
            }
        }
    }

    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    public static abstract class FreeNode
    extends Node {
        public abstract int execute(Object var1);

        @Specialization(guards={"!isCArrayWrapper(nativeWrapper)"})
        static int doNativeWrapper(PythonNativeWrapper nativeWrapper, @Cached CExtNodes.ClearNativeWrapperNode clearNativeWrapperNode, @Cached CExtNodes.PCallCapiFunction callReleaseHandleNode) {
            Object delegate = nativeWrapper.getDelegate();
            clearNativeWrapperNode.execute(delegate, nativeWrapper);
            ReleaseHandleNode.doNativeWrapper(nativeWrapper, callReleaseHandleNode);
            return 1;
        }

        @Specialization
        static int arrayWrapper(CArrayWrappers.CArrayWrapper object) {
            return 1;
        }

        @Specialization(guards={"!isNativeWrapper(object)"})
        static int doOther(Object object) {
            return 0;
        }

        protected static boolean isCArrayWrapper(Object obj) {
            return obj instanceof CArrayWrappers.CArrayWrapper;
        }
    }
}

