/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.asyncio.AsyncGeneratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.asyncio.PAsyncGen;
import com.oracle.graal.python.builtins.objects.generator.GeneratorBuiltins;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PAsyncGenerator})
public final class AsyncGeneratorBuiltins
extends PythonBuiltins {
    private static void callHooks(VirtualFrame frame, PAsyncGen self, PythonContext.PythonThreadState state, CallUnaryMethodNode invokeFirstIter) {
        Object firstIter = state.getAsyncgenFirstIter();
        if (firstIter == null) {
            return;
        }
        if (self.isHookCalled()) {
            return;
        }
        self.setHookCalled(true);
        invokeFirstIter.executeObject((Frame)frame, firstIter, self);
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AsyncGeneratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="aclose", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AClose
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object aClose(VirtualFrame frame, PAsyncGen self, @Cached CallUnaryMethodNode callFirstIter) {
            AsyncGeneratorBuiltins.callHooks(frame, self, this.getContext().getThreadState(this.getLanguage()), callFirstIter);
            return this.factory().createAsyncGeneratorAThrow(self, null, PNone.NO_VALUE, PNone.NO_VALUE);
        }
    }

    @Builtin(name="__anext__", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ANext
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object aNext(VirtualFrame frame, PAsyncGen self, @Cached CallUnaryMethodNode callFirstIter) {
            AsyncGeneratorBuiltins.callHooks(frame, self, this.getContext().getThreadState(this.getLanguage()), callFirstIter);
            return this.factory().createAsyncGeneratorASend(self, PNone.NONE);
        }
    }

    @Builtin(name="__aiter__", declaresExplicitSelf=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AIter
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object aIter(PAsyncGen self) {
            return self;
        }
    }

    @Builtin(name="athrow", declaresExplicitSelf=true, minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    public static abstract class AThrow
    extends PythonBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PAsyncGen var2, Object var3, Object var4, Object var5);

        @Specialization
        public Object athrow(VirtualFrame frame, PAsyncGen self, Object arg1, Object arg2, Object arg3, @Cached CallUnaryMethodNode callFirstIter) {
            AsyncGeneratorBuiltins.callHooks(frame, self, this.getContext().getThreadState(this.getLanguage()), callFirstIter);
            return this.factory().createAsyncGeneratorAThrow(self, arg1, arg2, arg3);
        }
    }

    @Builtin(name="asend", declaresExplicitSelf=true, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ASend
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object aSend(VirtualFrame frame, PAsyncGen self, Object sent, @Cached CallUnaryMethodNode callFirstIter) {
            AsyncGeneratorBuiltins.callHooks(frame, self, this.getContext().getThreadState(this.getLanguage()), callFirstIter);
            return this.factory().createAsyncGeneratorASend(self, sent);
        }
    }

    @Builtin(name="ag_running", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsRunning
    extends PythonUnaryBuiltinNode {
        @Specialization
        public boolean isRunning(PAsyncGen self) {
            return self.isRunning();
        }
    }

    @Builtin(name="ag_frame", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetFrame
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getFrame(VirtualFrame frame, PAsyncGen self, @Cached GeneratorBuiltins.GetFrameNode getFrame) {
            return getFrame.execute(frame, self);
        }
    }

    @Builtin(name="ag_await", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetAwait
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getAwait(PAsyncGen self) {
            Object yieldFrom = self.getYieldFrom();
            return yieldFrom != null ? yieldFrom : PNone.NONE;
        }
    }

    @Builtin(name="ag_code", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetCode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getCode(PAsyncGen self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasCodeProfile) {
            return self.getOrCreateCode(inliningTarget, hasCodeProfile, this.factory());
        }
    }
}

