/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZLibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZlibCompressBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.zlib.ZlibCompressBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.zlib.ZlibNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ZlibCompress})
public final class ZlibCompressBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZlibCompressBuiltinsFactory.getFactories();
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1, parameterNames={"$self", "mode"})
    @ImportStatic(value={ZLibModuleBuiltins.class})
    @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.Z_FINISH", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends PythonBinaryClinicBuiltinNode {
        FlushNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZlibCompressBuiltinsClinicProviders.FlushNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"mode == Z_NO_FLUSH"})
        PBytes empty(ZLibCompObject self, int mode) {
            return this.factory().createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"mode != Z_NO_FLUSH", "self.isInitialized()"})
        PBytes doit(ZLibCompObject.NativeZlibCompObject self, int mode, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction compressObjFlush, @Cached ZlibNodes.GetNativeBufferNode getBuffer, @Cached NativeLibrary.InvokeNativeFunction getIsInitialised, @Cached ZlibNodes.NativeDeallocation processDeallocation, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                PythonContext ctxt = PythonContext.get(this);
                NFIZlibSupport zlibSupport = ctxt.getNFIZlibSupport();
                Object lastInput = self.lastInput == null ? ctxt.getEnv().asGuestValue((Object)PythonUtils.EMPTY_BYTE_ARRAY) : self.lastInput;
                int err = zlibSupport.compressObjFlush(self.getZst(), lastInput, 16384L, mode, compressObjFlush);
                if (err != 0) {
                    errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
                }
                byte[] resultArray = getBuffer.getOutputBuffer(inliningTarget, self.getZst(), ctxt);
                if (zlibSupport.getIsInitialised(self.getZst(), getIsInitialised) == 0) {
                    processDeallocation.execute(inliningTarget, self, ctxt, this.factory(), true);
                }
                return this.factory().createBytes(resultArray);
            }
        }

        @Specialization(guards={"mode != Z_NO_FLUSH", "self.isInitialized()"})
        PBytes doit(ZLibCompObject.JavaZlibCompObject self, int mode) {
            return ZlibNodes.JavaCompressNode.execute(self, mode, this.factory());
        }

        @Specialization(guards={"!self.isInitialized()"})
        PNone error(ZLibCompObject self, int mode) {
            throw this.raise(PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, -2, "while compressing data", "inconsistent stream state");
        }
    }

    @Builtin(name="__deepcopy__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DeepCopyNode
    extends PythonBinaryBuiltinNode {
        DeepCopyNode() {
        }

        @Specialization
        Object doit(ZLibCompObject self, Object memo, @Bind(value="this") Node inliningTarget, @Cached BaseCopyNode copyNode) {
            return copyNode.execute(inliningTarget, self, PythonContext.get(this), this.factory());
        }
    }

    @Builtin(name="__copy__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class UndescoreCopyNode
    extends CopyNode {
        UndescoreCopyNode() {
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        CopyNode() {
        }

        @Specialization
        Object doit(ZLibCompObject self, @Bind(value="this") Node inliningTarget, @Cached BaseCopyNode copyNode) {
            return copyNode.execute(inliningTarget, self, PythonContext.get(this), this.factory());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class BaseCopyNode
    extends PNodeWithContext {
        BaseCopyNode() {
        }

        public abstract Object execute(Node var1, ZLibCompObject var2, PythonContext var3, PythonObjectFactory var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()"})
        static Object doNative(Node inliningTarget, ZLibCompObject.NativeZlibCompObject self, PythonContext ctxt, PythonObjectFactory factory, @Cached(inline=false) NativeLibrary.InvokeNativeFunction createCompObject, @Cached(inline=false) NativeLibrary.InvokeNativeFunction compressObjCopy, @Cached(inline=false) NativeLibrary.InvokeNativeFunction deallocateStream, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                NFIZlibSupport zlibSupport = ctxt.getNFIZlibSupport();
                Object zstNewCopy = zlibSupport.createCompObject(createCompObject);
                int err = zlibSupport.compressObjCopy(self.getZst(), zstNewCopy, compressObjCopy);
                if (err != 0) {
                    zlibSupport.deallocateStream(zstNewCopy, deallocateStream);
                    errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
                }
                return factory.createNativeZLibCompObject((Object)PythonBuiltinClassType.ZlibCompress, zstNewCopy, zlibSupport);
            }
        }

        @Specialization(guards={"self.isInitialized()", "self.canCopy()"})
        static Object doJava(ZLibCompObject.JavaZlibCompObject self, PythonContext ctxt, PythonObjectFactory factory) {
            return self.copyCompressObj(factory);
        }

        @Specialization(guards={"self.isInitialized()", "!self.canCopy()"})
        static PNone error(ZLibCompObject.JavaZlibCompObject self, PythonContext ctxt, PythonObjectFactory factory, @Cached.Shared @Cached(inline=false) PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("JDK based zlib doesn't support copying"));
        }

        @Specialization(guards={"!self.isInitialized()"})
        static PNone error(ZLibCompObject self, PythonContext ctxt, PythonObjectFactory factory, @Cached.Shared @Cached(inline=false) PRaiseNode raise) {
            throw raise.raise(PythonErrorType.ValueError, ErrorMessages.INCONSISTENT_STREAM_STATE);
        }
    }

    @Builtin(name="compress", minNumOfPositionalArgs=2, parameterNames={"$self", ""})
    @GenerateNodeFactory
    static abstract class CompressNode
    extends PythonBinaryBuiltinNode {
        CompressNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()"})
        PBytes doNativeBytes(ZLibCompObject.NativeZlibCompObject self, PBytesLike data, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode toBytes, @Cached.Exclusive @Cached ZlibNodes.ZlibNativeCompressObj compressObj) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                byte[] bytes = toBytes.execute(inliningTarget, data.getSequenceStorage());
                int len = data.getSequenceStorage().length();
                return this.factory().createBytes(compressObj.execute(inliningTarget, self, PythonContext.get(this), bytes, len));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()", "!isBytes(data)"})
        PBytes doNativeObject(VirtualFrame frame, ZLibCompObject.NativeZlibCompObject self, Object data, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BytesNodes.ToBytesNode toBytes, @Cached.Exclusive @Cached ZlibNodes.ZlibNativeCompressObj compressObj) {
            ZLibCompObject.NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                byte[] bytes = toBytes.execute(frame, data);
                int len = bytes.length;
                return this.factory().createBytes(compressObj.execute(inliningTarget, self, PythonContext.get(this), bytes, len));
            }
        }

        @Specialization(guards={"self.isInitialized()"})
        PBytes doit(VirtualFrame frame, ZLibCompObject.JavaZlibCompObject self, Object data, @Cached.Exclusive @Cached BytesNodes.ToBytesNode toBytes) {
            byte[] bytes = toBytes.execute(frame, data);
            self.setDeflaterInput(bytes);
            return ZlibNodes.JavaCompressNode.execute(self, 0, this.factory());
        }

        @Specialization(guards={"!self.isInitialized()"})
        PBytes error(ZLibCompObject self, Object data) {
            throw this.raise(PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, -2, "while compressing data", "inconsistent stream state");
        }
    }
}

