/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public abstract class ZLibCompObject
extends PythonBuiltinObject {
    protected volatile boolean isInitialized = true;
    private boolean eof = false;
    private PBytes unusedData = null;
    private PBytes unconsumedTail = null;

    public ZLibCompObject(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isEof() {
        return this.eof;
    }

    public void setEof(boolean eof) {
        this.eof = eof;
    }

    public PBytes getUnusedData() {
        return this.unusedData;
    }

    public void setUnusedData(PBytes unusedData) {
        this.unusedData = unusedData;
    }

    public PBytes getUnconsumedTail() {
        return this.unconsumedTail;
    }

    public void setUnconsumedTail(PBytes unconsumedTail) {
        this.unconsumedTail = unconsumedTail;
    }

    public static NativeZlibCompObject createNative(Object cls, Shape instanceShape, Object zst, NFIZlibSupport zlibSupport) {
        return new NativeZlibCompObject(cls, instanceShape, zst, zlibSupport);
    }

    public static ZLibCompObject createJava(Object cls, Shape instanceShape, Object stream, int level, int wbits, int strategy, byte[] zdict) {
        return new JavaZlibCompObject(cls, instanceShape, stream, level, wbits, strategy, zdict);
    }

    public static ZLibCompObject createJava(Object cls, Shape instanceShape, Object stream, int wbits, byte[] zdict) {
        return new JavaZlibCompObject(cls, instanceShape, stream, wbits, zdict);
    }

    protected static class NativeZlibCompObject
    extends ZLibCompObject {
        private NFIZlibSupport.Pointer pointer;
        Object lastInput;

        public NativeZlibCompObject(Object cls, Shape instanceShape, Object zst, NFIZlibSupport zlibSupport) {
            super(cls, instanceShape);
            this.pointer = new NFIZlibSupport.Pointer((Object)this, zst, zlibSupport);
            this.lastInput = null;
        }

        public Object getZst() {
            assert (this.pointer != null);
            return this.pointer.getReference();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        public void markReleased() {
            if (this.isInitialized) {
                NativeZlibCompObject nativeZlibCompObject = this;
                synchronized (nativeZlibCompObject) {
                    this.isInitialized = false;
                    this.pointer.markReleased();
                    this.pointer = null;
                }
            }
        }
    }

    protected static class JavaZlibCompObject
    extends ZLibCompObject {
        final Object stream;
        final byte[] zdict;
        final int level;
        final int wbits;
        final int strategy;
        private byte[] inputData;
        private boolean canCopy;
        private boolean readHeader;
        public static final int GZIP_MAGIC = 35615;
        private static final int FHCRC = 2;
        private static final int FEXTRA = 4;
        private static final int FNAME = 8;
        private static final int FCOMMENT = 16;

        public JavaZlibCompObject(Object cls, Shape instanceShape, Object stream, int level, int wbits, int strategy, byte[] zdict) {
            super(cls, instanceShape);
            this.stream = stream;
            this.zdict = zdict;
            this.level = level;
            this.wbits = wbits;
            this.strategy = strategy;
            this.inputData = null;
            this.canCopy = true;
            this.readHeader = wbits >= 25 && wbits <= 31;
        }

        public JavaZlibCompObject(Object cls, Shape instanceShape, Object stream, int wbits, byte[] zdict) {
            this(cls, instanceShape, stream, 0, wbits, 0, zdict);
        }

        public void setUninitialized() {
            this.isInitialized = false;
        }

        public byte[] getZdict() {
            return this.zdict;
        }

        public boolean canCopy() {
            return this.canCopy;
        }

        @CompilerDirectives.TruffleBoundary
        public void setDeflaterInput(byte[] data) {
            assert (this.stream instanceof Deflater);
            this.canCopy = this.inputData == null;
            this.inputData = data;
            ((Deflater)this.stream).setInput(data);
        }

        @CompilerDirectives.TruffleBoundary
        public void setInflaterInput(byte[] data, Node node) {
            assert (this.stream instanceof Inflater);
            byte[] bytes = data;
            if (this.readHeader) {
                this.readHeader = false;
                int h = JavaZlibCompObject.gzipHeader(data, node);
                bytes = PythonUtils.arrayCopyOfRange(bytes, h, data.length);
            }
            this.canCopy = this.inputData == null;
            this.inputData = bytes;
            ((Inflater)this.stream).setInput(bytes);
        }

        @CompilerDirectives.TruffleBoundary
        public ZLibCompObject copyCompressObj(PythonObjectFactory factory) {
            assert (this.canCopy);
            Deflater deflater = new Deflater(this.level, this.wbits < 0 || this.wbits > 24);
            deflater.setStrategy(this.strategy);
            if (this.zdict.length > 0) {
                deflater.setDictionary(this.zdict);
            }
            ZLibCompObject obj = factory.createJavaZLibCompObject((Object)PythonBuiltinClassType.ZlibCompress, deflater, this.level, this.wbits, this.strategy, this.zdict);
            if (this.inputData != null) {
                ((JavaZlibCompObject)obj).setDeflaterInput(this.inputData);
                deflater.deflate(new byte[this.inputData.length]);
            }
            return obj;
        }

        @CompilerDirectives.TruffleBoundary
        public ZLibCompObject copyDecompressObj(PythonObjectFactory factory, Node node) {
            assert (this.canCopy);
            boolean isRAW = this.wbits < 0;
            Inflater inflater = new Inflater(isRAW || this.wbits > 24);
            if (isRAW && this.zdict.length > 0) {
                inflater.setDictionary(this.zdict);
            }
            ZLibCompObject obj = factory.createJavaZLibCompObject((Object)PythonBuiltinClassType.ZlibDecompress, inflater, this.wbits, this.zdict);
            if (this.inputData != null) {
                try {
                    ((JavaZlibCompObject)obj).setInflaterInput(this.inputData, node);
                    inflater.setInput(this.inputData);
                    int n = inflater.inflate(new byte[16384]);
                    if (!isRAW && n == 0 && inflater.needsDictionary() && this.zdict.length > 0) {
                        inflater.setDictionary(this.zdict);
                        inflater.inflate(new byte[16384]);
                    }
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
            obj.setUnconsumedTail(this.getUnconsumedTail());
            obj.setUnusedData(this.getUnusedData());
            return obj;
        }

        private static int getValue(byte b, CRC32 crc) {
            int v = BytesUtils.mask(b);
            crc.update(v);
            return v;
        }

        private static int readShort(byte[] bytes, int off, CRC32 crc) {
            return JavaZlibCompObject.getValue(bytes[off + 1], crc) << 8 | JavaZlibCompObject.getValue(bytes[off], crc);
        }

        @CompilerDirectives.TruffleBoundary
        private static int gzipHeader(byte[] bytes, Node node) {
            int idx = 0;
            CRC32 crc = new CRC32();
            if (JavaZlibCompObject.readShort(bytes, idx, crc) != 35615) {
                throw PRaiseNode.raiseUncached(node, PythonErrorType.ZLibError, ErrorMessages.NOT_IN_GZIP_FORMAT);
            }
            idx += 2;
            if (JavaZlibCompObject.getValue(bytes[idx++], crc) != 8) {
                throw PRaiseNode.raiseUncached(node, PythonErrorType.ZLibError, ErrorMessages.UNSUPPORTED_COMPRESSION_METHOD);
            }
            int flg = JavaZlibCompObject.getValue(bytes[idx++], crc);
            idx += 6;
            int n = 10;
            if ((flg & 4) == 4) {
                int m = JavaZlibCompObject.getValue(bytes[idx++], crc);
                idx += m;
                n += m + 2;
            }
            if ((flg & 8) == 8) {
                do {
                    ++n;
                } while (JavaZlibCompObject.getValue(bytes[idx++], crc) != 0);
            }
            if ((flg & 0x10) == 16) {
                do {
                    ++n;
                } while (JavaZlibCompObject.getValue(bytes[idx++], crc) != 0);
            }
            crc.reset();
            if ((flg & 2) == 2) {
                int v = (int)crc.getValue() & 0xFFFF;
                if (JavaZlibCompObject.readShort(bytes, idx, crc) != v) {
                    throw PRaiseNode.raiseUncached(node, PythonErrorType.ZLibError, ErrorMessages.CORRUPT_GZIP_HEADER);
                }
                idx += 2;
                n += 2;
            }
            crc.reset();
            return idx;
        }
    }
}

