/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.GraalPythonModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltinRegistry;
import com.oracle.graal.python.builtins.modules.cext.PythonCextTypeBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtParseArgumentsNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.memoryview.NativeBufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PNodeWithRaiseAndIndirectCall;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.frame.GetCurrentFrameRef;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;

public final class PythonCextBuiltins {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PythonCextBuiltins.class);
    private static final int TRACE_MEM = 1;
    private static final int LOG_INFO = 2;
    private static final int LOG_CONFIG = 4;
    private static final int LOG_FINE = 8;
    private static final int LOG_FINER = 16;
    private static final int LOG_FINEST = 32;

    public static PException checkThrowableBeforeNative(Throwable t, String where1, Object where2) {
        if (t instanceof PException) {
            PException pe = (PException)((Object)t);
            throw pe;
        }
        if (t instanceof ThreadDeath) {
            ThreadDeath td = (ThreadDeath)t;
            throw td;
        }
        if (t instanceof StackOverflowError) {
            StackOverflowError soe = (StackOverflowError)t;
            CompilerDirectives.transferToInterpreter();
            PythonContext context = PythonContext.get(null);
            context.reacquireGilAfterStackOverflow();
            PBaseException newException = context.factory().createBaseException((Object)PythonBuiltinClassType.RecursionError, ErrorMessages.MAXIMUM_RECURSION_DEPTH_EXCEEDED, PythonUtils.EMPTY_OBJECT_ARRAY);
            PException pe = ExceptionUtils.wrapJavaException(soe, null, newException);
            throw pe;
        }
        if (t instanceof OutOfMemoryError) {
            OutOfMemoryError oome = (OutOfMemoryError)t;
            PBaseException newException = PythonContext.get(null).factory().createBaseException((Object)PythonBuiltinClassType.MemoryError);
            throw ExceptionUtils.wrapJavaException(oome, null, newException);
        }
        CompilerDirectives.transferToInterpreter();
        PNodeWithContext.printStack();
        PrintStream out = new PrintStream(PythonContext.get(null).getEnv().err());
        out.println("while executing " + where1 + " " + where2);
        out.println("should not throw exceptions apart from PException");
        t.printStackTrace(out);
        out.flush();
        throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, ErrorMessages.INTERNAL_EXCEPTION_OCCURED);
    }

    @CApiBuiltin(ret=ArgDescriptor.CHAR_PTR, args={ArgDescriptor.PyObject}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_GetMMapData
    extends CApiUnaryBuiltinNode {
        PyTruffle_GetMMapData() {
        }

        @Specialization
        Object get(PMMap object, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib) {
            try {
                return posixLib.mmapGetPointer(this.getPosixSupport(), object.getPosixSupportHandle());
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                return new PMMapWrapper(object);
            }
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class PMMapWrapper
    implements TruffleObject {
        private final PMMap delegate;

        public PMMapWrapper(PMMap delegate) {
            this.delegate = delegate;
        }

        @ExportMessage
        boolean hasBufferElements() {
            return true;
        }

        @ExportMessage
        long getBufferSize() {
            return this.delegate.getLength();
        }

        private final void checkIndex(long idx) throws InvalidBufferOffsetException {
            long len = this.delegate.getLength();
            if (idx < 0L || idx >= len) {
                throw InvalidBufferOffsetException.create((long)idx, (long)len);
            }
        }

        @ExportMessage
        byte readBufferByte(long idx, @Bind(value="$node") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixSupportLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) throws InvalidBufferOffsetException {
            this.checkIndex(idx);
            try {
                return posixSupportLib.mmapReadByte(PythonContext.get((Node)posixSupportLib).getPosixSupport(), this.delegate.getPosixSupportHandle(), idx);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(null, e.getErrorCode(), e.getMessageAsTruffleString(), null, null);
            }
        }

        @ExportMessage
        short readBufferShort(ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        int readBufferInt(ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        long readBufferLong(ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        float readBufferFloat(ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        double readBufferDouble(ByteOrder order, long byteOffset) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_SetTypeStore
    extends CApiBinaryBuiltinNode {
        PyTruffle_SetTypeStore() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object set(TruffleString tsName, Object pointer, @Cached TruffleString.EqualNode eqNode) {
            try {
                LOGGER.fine(() -> "initializing built-in class " + tsName + " at " + PythonUtils.formatPointer(pointer));
                Python3Core core = this.getCore();
                PythonManagedClass clazz = null;
                String name = tsName.toJavaStringUncached();
                int index = name.indexOf(46);
                if (index == -1) {
                    for (PythonBuiltinClassType type : PythonBuiltinClassType.VALUES) {
                        if (!eqNode.execute((AbstractTruffleString)type.getName(), (AbstractTruffleString)tsName, PythonUtils.TS_ENCODING)) continue;
                        clazz = core.lookupType(type);
                        break;
                    }
                } else {
                    Object attribute;
                    String module = name.substring(0, index);
                    name = name.substring(index + 1);
                    Object moduleObject = core.lookupBuiltinModule(PythonUtils.toTruffleStringUncached(module));
                    if (moduleObject == null) {
                        moduleObject = AbstractImportNode.importModule(PythonUtils.toTruffleStringUncached(module));
                    }
                    if ((attribute = PyObjectGetAttr.getUncached().execute(null, moduleObject, PythonUtils.toTruffleStringUncached(name))) != PNone.NO_VALUE) {
                        clazz = (PythonManagedClass)attribute;
                    }
                }
                if (clazz == null) {
                    throw CompilerDirectives.shouldNotReachHere((String)("cannot find class " + name));
                }
                PythonClassNativeWrapper.wrapNative(clazz, TypeNodes.GetNameNode.executeUncached(clazz), pointer);
                return PNone.NO_VALUE;
            }
            catch (PException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.Pointer}, call=CApiCallPath.Direct)
    static abstract class PyTruffle_ToNative
    extends CApiUnaryBuiltinNode {
        PyTruffle_ToNative() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int doIt(Object object) {
            if (!((Boolean)PythonOptions.EnableDebuggingBuiltins.getValue(this.getContext().getEnv().getOptions())).booleanValue()) {
                String message = "PyTruffle_ToNative is not enabled - enable with --python.EnableDebuggingBuiltins\n";
                try {
                    this.getContext().getEnv().out().write(message.getBytes());
                }
                catch (IOException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                return 1;
            }
            if (!this.getContext().getOption(PythonOptions.NativeModules).booleanValue()) {
                LanguageInfo llvmInfo;
                TruffleLanguage.Env env = this.getContext().getEnv();
                Toolchain toolchain = (Toolchain)env.lookup(llvmInfo = (LanguageInfo)env.getInternalLanguages().get("llvm"), Toolchain.class);
                if ("native".equals(toolchain.getIdentifier())) {
                    InteropLibrary.getUncached().toNative(object);
                }
            } else {
                InteropLibrary.getUncached().toNative(object);
            }
            return 0;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.Pointer}, call=CApiCallPath.Direct)
    static abstract class PyTruffle_Debug
    extends CApiUnaryBuiltinNode {
        PyTruffle_Debug() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doIt(Object arg, @Cached GraalPythonModuleBuiltins.DebugNode debugNode) {
            debugNode.execute(new Object[]{arg});
            return 0;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={}, call=CApiCallPath.Direct)
    static abstract class PyTruffle_DebugTrace
    extends CApiNullaryBuiltinNode {
        PyTruffle_DebugTrace() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object trace() {
            final PrintStream out = new PrintStream(this.getContext().getEnv().out());
            if (this.getContext().getOption(PythonOptions.EnableDebuggingBuiltins).booleanValue()) {
                out.println("\n\nJava Stacktrace:");
                new RuntimeException().printStackTrace(out);
                out.println("\n\nTruffle Stacktrace:");
                PyTruffle_DebugTrace.printStack();
                out.println("\n\nFrames:");
                Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Void>(){

                    public Void visitFrame(FrameInstance frame) {
                        out.println("  ===========================");
                        out.println("  call: " + frame.getCallNode());
                        out.println("  target: " + frame.getCallTarget());
                        Frame f = frame.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                        out.println("  args: " + Arrays.asList(f.getArguments()));
                        return null;
                    }
                });
            } else {
                out.println("\n\nDEBUG TRACE (enable details via --python.EnableDebuggingBuiltins)");
            }
            return PNone.NO_VALUE;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.Int, ArgDescriptor.ConstCharPtrAsTruffleString}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_LogString
    extends CApiBinaryBuiltinNode {
        PyTruffle_LogString() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object log(int level, TruffleString message) {
            String msg = message.toJavaStringUncached();
            switch (level) {
                case 2: {
                    LOGGER.info(msg);
                    break;
                }
                case 4: {
                    LOGGER.config(msg);
                    break;
                }
                case 8: {
                    LOGGER.fine(msg);
                    break;
                }
                case 16: {
                    LOGGER.finer(msg);
                    break;
                }
                case 32: {
                    LOGGER.finest(msg);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)("unknown log level: " + level));
                }
            }
            return PNone.NO_VALUE;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_Native_Options
    extends CApiNullaryBuiltinNode {
        PyTruffle_Native_Options() {
        }

        @Specialization
        int getNativeOptions() {
            int options = 0;
            if (this.getContext().getOption(PythonOptions.TraceNativeMemory).booleanValue()) {
                options |= 1;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                options |= 2;
            }
            if (LOGGER.isLoggable(Level.CONFIG)) {
                options |= 4;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                options |= 8;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                options |= 0x10;
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                options |= 0x20;
            }
            return options;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.Pointer}, call=CApiCallPath.Direct)
    static abstract class PyObject_GC_Track
    extends PyTruffleGcTracingNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyObject_GC_Track.class);

        PyObject_GC_Track() {
        }

        @Override
        protected void trace(PythonContext context, Object ptr, PFrame.Reference ref, TruffleString className) {
            LOGGER.finer(() -> PythonUtils.formatJString("Tracking container object at %s", CApiContext.asHex(ptr)));
            context.getCApiContext().trackObject(ptr, ref, className);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.Pointer}, call=CApiCallPath.Direct)
    static abstract class PyObject_GC_UnTrack
    extends PyTruffleGcTracingNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyObject_GC_UnTrack.class);

        PyObject_GC_UnTrack() {
        }

        @Override
        protected void trace(PythonContext context, Object ptr, PFrame.Reference ref, TruffleString className) {
            LOGGER.finer(() -> PythonUtils.formatJString("Untracking container object at %s", CApiContext.asHex(ptr)));
            context.getCApiContext().untrackObject(ptr, ref, className);
        }
    }

    static abstract class PyTruffleGcTracingNode
    extends CApiUnaryBuiltinNode {
        PyTruffleGcTracingNode() {
        }

        @Specialization(guards={"!traceCalls(getContext())", "traceMem(getContext())"})
        Object doNativeWrapper(Object ptr, @Cached.Shared(value="lib") @CachedLibrary(limit="3") InteropLibrary lib) {
            this.trace(this.getContext(), CApiContext.asPointer(ptr, lib), null, null);
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"traceCalls(getContext())", "traceMem(getContext())"})
        Object doNativeWrapperTraceCall(Object ptr, @Bind(value="this") Node inliningTarget, @Cached GetCurrentFrameRef getCurrentFrameRef, @Cached.Shared(value="lib") @CachedLibrary(limit="3") InteropLibrary lib) {
            PFrame.Reference ref = getCurrentFrameRef.execute(null, inliningTarget);
            this.trace(this.getContext(), CApiContext.asPointer(ptr, lib), ref, null);
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"!traceMem(getContext())"})
        static Object doNothing(Object ptr) {
            return PNone.NO_VALUE;
        }

        @NonIdempotent
        static boolean traceMem(PythonContext context) {
            return context.getOption(PythonOptions.TraceNativeMemory);
        }

        @NonIdempotent
        static boolean traceCalls(PythonContext context) {
            return context.getOption(PythonOptions.TraceNativeMemoryCalls);
        }

        protected void trace(PythonContext context, Object ptr, PFrame.Reference ref, TruffleString className) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("should not reach");
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=CApiCallPath.Direct)
    static abstract class _PyTraceMalloc_NewReference
    extends CApiUnaryBuiltinNode {
        _PyTraceMalloc_NewReference() {
        }

        @Specialization
        static int doCachedDomainIdx(Object pointerObject) {
            return 0;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.UNSIGNED_INT, ArgDescriptor.UINTPTR_T}, call=CApiCallPath.Direct)
    @ImportStatic(value={CApiGuards.class})
    static abstract class PyTraceMalloc_Untrack
    extends CApiBinaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyTraceMalloc_Untrack.class);

        PyTraceMalloc_Untrack() {
        }

        @Specialization(guards={"isSingleContext()", "domain == cachedDomain"}, limit="3")
        int doCachedDomainIdx(int domain, Object pointerObject, @Cached(value="domain") long cachedDomain, @Cached(value="lookupDomain(domain)") int cachedDomainIdx, @CachedLibrary(value="pointerObject") InteropLibrary lib) {
            CApiContext cApiContext = this.getCApiContext();
            Object key = CApiContext.asPointer(pointerObject, lib);
            long trackedMemorySize = cApiContext.getTraceMallocDomain(cachedDomainIdx).untrack(key);
            cApiContext.reduceMemoryPressure(trackedMemorySize);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(() -> PythonUtils.formatJString("Untracking memory (size: %d): %s", trackedMemorySize, CApiContext.asHex(key)));
            }
            return 0;
        }

        @Specialization(replaces={"doCachedDomainIdx"})
        int doGeneric(int domain, Object pointerObject, @CachedLibrary(limit="3") InteropLibrary lib) {
            return this.doCachedDomainIdx(domain, pointerObject, domain, this.lookupDomain(domain), lib);
        }

        int lookupDomain(int domain) {
            return this.getCApiContext().findOrCreateTraceMallocDomain(domain);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.UNSIGNED_INT, ArgDescriptor.UINTPTR_T, ArgDescriptor.SIZE_T}, call=CApiCallPath.Direct)
    @ImportStatic(value={CApiGuards.class})
    static abstract class PyTraceMalloc_Track
    extends CApiTernaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyTraceMalloc_Track.class);

        PyTraceMalloc_Track() {
        }

        @Specialization(guards={"isSingleContext()", "domain == cachedDomain"}, limit="3")
        int doCachedDomainIdx(int domain, Object pointerObject, long size, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @CachedLibrary(value="pointerObject") InteropLibrary lib, @Cached(value="domain") long cachedDomain, @Cached(value="lookupDomain(domain)") int cachedDomainIdx) {
            if (!lib.isNull(pointerObject)) {
                CApiContext cApiContext = this.getCApiContext();
                Object key = CApiContext.asPointer(pointerObject, lib);
                cApiContext.getTraceMallocDomain(cachedDomainIdx).track(key, size);
                cApiContext.increaseMemoryPressure(null, inliningTarget, getThreadStateNode, this, size);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(() -> PythonUtils.formatJString("Tracking memory (size: %d): %s", size, CApiContext.asHex(key)));
                }
            }
            return 0;
        }

        @Specialization(replaces={"doCachedDomainIdx"}, limit="3")
        int doGeneric(int domain, Object pointerObject, long size, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="pointerObject") InteropLibrary lib, @Cached PythonContext.GetThreadStateNode getThreadStateNode) {
            return this.doCachedDomainIdx(domain, pointerObject, size, inliningTarget, getThreadStateNode, lib, domain, this.lookupDomain(domain));
        }

        int lookupDomain(int domain) {
            return this.getCApiContext().findOrCreateTraceMallocDomain(domain);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.Pointer}, call=CApiCallPath.Ignored)
    @ImportStatic(value={CApiGuards.class})
    static abstract class PyTruffle_Object_Free
    extends CApiUnaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyTruffle_Object_Free.class);

        PyTruffle_Object_Free() {
        }

        @Specialization(guards={"!isCArrayWrapper(nativeWrapper)"})
        static PNone doNativeWrapper(PythonNativeWrapper nativeWrapper, @Cached CExtNodes.ClearNativeWrapperNode clearNativeWrapperNode, @Cached CExtNodes.PCallCapiFunction callReleaseHandleNode) {
            Object delegate = nativeWrapper.getDelegate();
            clearNativeWrapperNode.execute(delegate, nativeWrapper);
            PyTruffle_Object_Free.doNativeWrapper(nativeWrapper, callReleaseHandleNode);
            return PNone.NO_VALUE;
        }

        @Specialization
        static PNone arrayWrapper(CArrayWrappers.CArrayWrapper object) {
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"!isNativeWrapper(object)"})
        static PNone doOther(Object object) {
            throw CompilerDirectives.shouldNotReachHere((String)"Attempted to free a managed object");
        }

        protected static boolean isCArrayWrapper(Object obj) {
            return obj instanceof CArrayWrappers.CArrayWrapper;
        }

        static void doNativeWrapper(PythonNativeWrapper nativeWrapper, @Cached CExtNodes.PCallCapiFunction callReleaseHandleNode) {
            if (nativeWrapper.isNative()) {
                long nativePointer = nativeWrapper.getNativePointer();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(() -> PythonUtils.formatJString("Releasing handle: %x (object: %s)", nativePointer, nativeWrapper));
                }
                if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(nativePointer)) {
                    CApiTransitions.HandleReleaser.release(nativePointer);
                } else {
                    callReleaseHandleNode.call(NativeCAPISymbol.FUN_PY_TRUFFLE_FREE, nativePointer);
                }
            }
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.SIZE_T}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_TriggerGC
    extends CApiUnaryBuiltinNode {
        PyTruffle_TriggerGC() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object trigger(long delay) {
            LOGGER.fine("full GC due to native memory");
            PythonUtils.forceFullGC();
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
            CApiTransitions.pollReferenceQueue();
            PythonContext.triggerAsyncActions(this);
            return PNone.NO_VALUE;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.SIZE_T, args={}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_GetInitialNativeMemory
    extends CApiNullaryBuiltinNode {
        PyTruffle_GetInitialNativeMemory() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long get() {
            return (Long)PythonOptions.InitialNativeMemory.getValue(this.getContext().getEnv().getOptions());
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.SIZE_T, args={}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_GetMaxNativeMemory
    extends CApiNullaryBuiltinNode {
        PyTruffle_GetMaxNativeMemory() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long get() {
            return (Long)PythonOptions.MaxNativeMemory.getValue(this.getContext().getEnv().getOptions());
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Pointer}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_Arg_ParseTupleAndKeywords
    extends CApi5BuiltinNode {
        PyTruffle_Arg_ParseTupleAndKeywords() {
        }

        @Specialization
        static int doConvert(Object argv, Object nativeKwds, TruffleString formatString, Object nativeKwdnames, Object varargs, @Cached CExtParseArgumentsNode.SplitFormatStringNode splitFormatStringNode, @CachedLibrary(limit="2") InteropLibrary kwdnamesRefLib, @Cached ConditionProfile kwdsProfile, @Cached ConditionProfile kwdnamesProfile, @Cached CExtParseArgumentsNode.ParseTupleAndKeywordsNode parseTupleAndKeywordsNode) {
            TruffleString[] split;
            try {
                split = splitFormatStringNode.execute(formatString);
                assert (split.length == 2);
            }
            catch (CannotCastException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
            TruffleString format = split[0];
            TruffleString functionName = split[1];
            Object kwds = kwdsProfile.profile(PGuards.isNoValue(nativeKwds)) ? null : nativeKwds;
            Object kwdnames = kwdnamesProfile.profile(kwdnamesRefLib.isNull(nativeKwdnames)) ? null : nativeKwdnames;
            return parseTupleAndKeywordsNode.execute(functionName, argv, kwds, format, kwdnames, varargs);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Pointer}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_Arg_ParseArrayAndKeywords
    extends CApi6BuiltinNode {
        PyTruffle_Arg_ParseArrayAndKeywords() {
        }

        @Specialization
        static int doConvert(Object args, long argCount, Object nativeKwds, TruffleString formatString, Object nativeKwdnames, Object varargs, @Cached CExtParseArgumentsNode.SplitFormatStringNode splitFormatStringNode, @CachedLibrary(limit="2") InteropLibrary kwdnamesRefLib, @Cached CStructAccess.ReadObjectNode readNode, @Cached PythonObjectFactory factory, @Cached ConditionProfile kwdsProfile, @Cached ConditionProfile kwdnamesProfile, @Cached CExtParseArgumentsNode.ParseTupleAndKeywordsNode parseTupleAndKeywordsNode) {
            TruffleString[] split;
            try {
                split = splitFormatStringNode.execute(formatString);
                assert (split.length == 2);
            }
            catch (CannotCastException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
            TruffleString format = split[0];
            TruffleString functionName = split[1];
            Object kwds = kwdsProfile.profile(PGuards.isNoValue(nativeKwds)) ? null : nativeKwds;
            Object kwdnames = kwdnamesProfile.profile(kwdnamesRefLib.isNull(nativeKwdnames)) ? null : nativeKwdnames;
            PTuple argv = factory.createTuple(readNode.readPyObjectArray(args, (int)argCount));
            return parseTupleAndKeywordsNode.execute(functionName, argv, kwds, format, kwdnames, varargs);
        }
    }

    @ReportPolymorphism
    static abstract class CastKwargsNode
    extends PNodeWithContext {
        CastKwargsNode() {
        }

        public abstract PKeyword[] execute(Object var1);

        @Specialization(guards={"isNoValue(kwargs)"})
        static PKeyword[] doNoKeywords(Object kwargs) {
            return PKeyword.EMPTY_KEYWORDS;
        }

        @Specialization(guards={"!isNoValue(kwargs)"})
        static PKeyword[] doKeywords(Object kwargs, @Bind(value="this") Node inliningTarget, @Cached ExpandKeywordStarargsNode expandKwargsNode) {
            return expandKwargsNode.execute(inliningTarget, kwargs);
        }
    }

    @ReportPolymorphism
    static abstract class CastArgsNode
    extends PNodeWithContext {
        CastArgsNode() {
        }

        public abstract Object[] execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"isNoValue(args)"})
        static Object[] doNull(PNone args) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }

        @Specialization(guards={"!isNoValue(args)"})
        static Object[] doNotNull(VirtualFrame frame, Object args, @Cached ExecutePositionalStarargsNode expandArgsNode) {
            return expandArgsNode.executeWith((Frame)frame, args);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.Pointer}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_Register_NULL
    extends CApiUnaryBuiltinNode {
        PyTruffle_Register_NULL() {
        }

        @Specialization
        Object doIt(Object object) {
            PythonNativePointer nn = this.getContext().getNativeNull();
            nn.setPtr(object);
            return PNone.NO_VALUE;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Pointer, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int, ArgDescriptor.Py_ssize_t, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Pointer}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_MemoryViewFromBuffer
    extends CApi11BuiltinNode {
        PyTruffle_MemoryViewFromBuffer() {
        }

        @Specialization
        Object wrap(Object bufferStructPointer, Object ownerObj, long lenObj, Object readonlyObj, Object itemsizeObj, TruffleString format, Object ndimObj, Object bufPointer, Object shapePointer, Object stridesPointer, Object suboffsetsPointer, @Bind(value="this") Node inliningTarget, @Cached ConditionProfile zeroDimProfile, @Cached CStructAccess.ReadI64Node readShapeNode, @Cached CStructAccess.ReadI64Node readStridesNode, @Cached CStructAccess.ReadI64Node readSuboffsetsNode, @Cached MemoryViewNodes.InitFlagsNode initFlagsNode, @CachedLibrary(limit="1") InteropLibrary lib, @Cached CastToJavaIntExactNode castToIntNode, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode atIndexNode) {
            int ndim = castToIntNode.execute(inliningTarget, ndimObj);
            int itemsize = castToIntNode.execute(inliningTarget, itemsizeObj);
            int len = castToIntNode.execute(inliningTarget, lenObj);
            boolean readonly = castToIntNode.execute(inliningTarget, readonlyObj) != 0;
            Object owner = ownerObj instanceof PythonNativePointer ? null : ownerObj;
            int[] shape = null;
            int[] strides = null;
            int[] suboffsets = null;
            if (zeroDimProfile.profile(ndim > 0)) {
                if (!lib.isNull(shapePointer)) {
                    shape = readShapeNode.readLongAsIntArray(shapePointer, ndim);
                } else {
                    assert (ndim == 1);
                    shape = new int[]{len / itemsize};
                }
                strides = !lib.isNull(stridesPointer) ? readStridesNode.readLongAsIntArray(stridesPointer, ndim) : PMemoryView.initStridesFromShape(ndim, itemsize, shape);
                if (!lib.isNull(suboffsetsPointer)) {
                    suboffsets = readSuboffsetsNode.readLongAsIntArray(suboffsetsPointer, ndim);
                }
            }
            NativeByteSequenceStorage buffer = NativeByteSequenceStorage.create(bufPointer, len, len, false);
            int flags = initFlagsNode.execute(inliningTarget, ndim, itemsize, shape, strides, suboffsets);
            NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromType bufferLifecycleManager = null;
            if (!lib.isNull(bufferStructPointer)) {
                bufferLifecycleManager = new NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromType(bufferStructPointer);
            }
            return this.factory().createMemoryView(this.getContext(), bufferLifecycleManager, buffer, owner, len, readonly, itemsize, BufferFormat.forMemoryView(format, lengthNode, atIndexNode), format, ndim, bufPointer, 0, shape, strides, suboffsets, flags);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.PyFrameObjectTransfer, args={ArgDescriptor.PyThreadState, ArgDescriptor.PyCodeObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=CApiCallPath.Direct)
    static abstract class PyFrame_New
    extends CApiQuaternaryBuiltinNode {
        PyFrame_New() {
        }

        @Specialization
        Object newFrame(Object threadState, PCode code, PythonObject globals, Object locals) {
            Object frameLocals = locals == null || PGuards.isPNone(locals) ? this.factory().createDict() : locals;
            return this.factory().createPFrame(threadState, code, globals, frameLocals);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyTypeObject}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_AddInheritedSlots
    extends CApiUnaryBuiltinNode {
        private static final int INDEX_GETSETS = 0;
        private static final int INDEX_MEMBERS = 1;

        PyTruffle_AddInheritedSlots() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object addInheritedSlots(PythonAbstractNativeObject pythonClass, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CStructAccess.ReadObjectNode readNativeDict, @Cached CStructAccess.ReadPointerNode readPointer, @Cached CStructAccess.ReadI32Node readI32, @Cached CStructAccess.ReadI64Node readI64, @Cached CExtNodes.FromCharPointerNode fromCharPointer, @Cached PythonCextTypeBuiltins.PyTruffleType_AddGetSet addGetSet, @Cached PythonCextTypeBuiltins.PyTruffleType_AddMember addMember, @Cached TypeNodes.GetMroStorageNode getMroStorageNode) {
            TruffleString name;
            Object namePtr;
            int i;
            Object[] getsets = PyTruffle_AddInheritedSlots.collect(getMroStorageNode.execute(inliningTarget, pythonClass), 0);
            Object[] members = PyTruffle_AddInheritedSlots.collect(getMroStorageNode.execute(inliningTarget, pythonClass), 1);
            PDict dict = (PDict)readNativeDict.readFromObj(pythonClass, CFields.PyTypeObject__tp_dict);
            for (Object getset : getsets) {
                if (PGuards.isNullOrZero(getset, lib)) continue;
                i = 0;
                while (!PGuards.isNullOrZero(namePtr = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__name), lib)) {
                    name = fromCharPointer.execute(namePtr);
                    Object getter = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__get);
                    Object setter = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__set);
                    Object docPtr = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__doc);
                    PNone doc = PGuards.isNullOrZero(docPtr, lib) ? PNone.NO_VALUE : fromCharPointer.execute(docPtr);
                    Object closure = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__closure);
                    addGetSet.execute(pythonClass, dict, name, getter, setter, doc, closure);
                    ++i;
                }
            }
            for (Object member : members) {
                if (PGuards.isNullOrZero(member, lib)) continue;
                i = 0;
                while (!PGuards.isNullOrZero(namePtr = readPointer.readStructArrayElement(member, i, CFields.PyMemberDef__name), lib)) {
                    name = fromCharPointer.execute(namePtr);
                    int type = readI32.readStructArrayElement(member, i, CFields.PyMemberDef__type);
                    long offset = readI64.readStructArrayElement(member, i, CFields.PyMemberDef__offset);
                    int flags = readI32.readStructArrayElement(member, i, CFields.PyMemberDef__flags);
                    Object docPtr = readPointer.readStructArrayElement(member, i, CFields.PyMemberDef__doc);
                    PNone doc = PGuards.isNullOrZero(docPtr, lib) ? PNone.NO_VALUE : fromCharPointer.execute(docPtr);
                    boolean canSet = (flags & CConstants.READONLY.intValue()) == 0;
                    addMember.execute(pythonClass, dict, name, type, offset, canSet ? 1 : 0, doc);
                    ++i;
                }
            }
            return PNone.NO_VALUE;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] collect(MroSequenceStorage mro, int idx) {
            ArrayList<Object> l = new ArrayList<Object>();
            int mroLength = mro.length();
            for (int i = 0; i < mroLength; ++i) {
                PythonAbstractClass kls = mro.getItemNormalized(i);
                Object value = ReadAttributeFromObjectNode.getUncachedForceType().execute(kls, PyTruffle_Set_Native_Slots.NATIVE_SLOTS);
                if (value == PNone.NO_VALUE) continue;
                Object[] tuple = (Object[])value;
                assert (tuple.length == 2);
                l.add(tuple[idx]);
            }
            return l.toArray();
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyTypeObject, ArgDescriptor.Pointer, ArgDescriptor.Pointer}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_Set_Native_Slots
    extends CApiTernaryBuiltinNode {
        static final HiddenKey NATIVE_SLOTS = new HiddenKey("__native_slots__");

        PyTruffle_Set_Native_Slots() {
        }

        @Specialization
        static int doPythonClass(PythonClass pythonClass, Object nativeGetSets, Object nativeMembers, @Cached WriteAttributeToObjectNode writeAttrNode) {
            writeAttrNode.execute((Object)pythonClass, NATIVE_SLOTS, (Object)new Object[]{nativeGetSets, nativeMembers});
            return 0;
        }
    }

    static abstract class PyObjectSetAttrNode
    extends PNodeWithContext {
        PyObjectSetAttrNode() {
        }

        abstract Object execute(Object var1, TruffleString var2, Object var3);

        @Specialization
        static Object doBuiltinClass(PythonBuiltinClass object, TruffleString key, Object value, @Cached.Exclusive @Cached(value="createForceType()") WriteAttributeToObjectNode writeAttrNode) {
            writeAttrNode.execute((Object)object, key, value);
            return PNone.NONE;
        }

        @Specialization
        static Object doNativeClass(PythonNativeClass object, TruffleString key, Object value, @Cached.Exclusive @Cached(value="createForceType()") WriteAttributeToObjectNode writeAttrNode) {
            writeAttrNode.execute((Object)object, key, value);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPythonBuiltinClass(object)"})
        static Object doObject(PythonObject object, TruffleString key, Object value, @Cached.Exclusive @Cached WriteAttributeToDynamicObjectNode writeAttrToDynamicObjectNode) {
            writeAttrToDynamicObjectNode.execute((Object)object.getStorage(), key, value);
            return PNone.NONE;
        }
    }

    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    static abstract class CreateFunctionNode
    extends PNodeWithContext {
        CreateFunctionNode() {
        }

        abstract Object execute(TruffleString var1, Object var2, Object var3, Object var4, Object var5, PythonObjectFactory var6);

        @Specialization(guards={"!isNoValue(type)", "isNoValue(wrapper)"})
        static Object doPythonCallableWithoutWrapper(TruffleString name, PythonNativeWrapper callable, PNone wrapper, Object type, Object flags, PythonObjectFactory factory) {
            return callable.getDelegate();
        }

        @Specialization(guards={"!isNoValue(type)"})
        @CompilerDirectives.TruffleBoundary
        Object doPythonCallable(TruffleString name, PythonNativeWrapper callable, int signature, Object type, int flags, PythonObjectFactory factory) {
            Object managedCallable = callable.getDelegate();
            PBuiltinFunction function = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, managedCallable, type, flags, signature, this.getLanguage(), factory, false);
            return function != null ? function : managedCallable;
        }

        @Specialization(guards={"!isNativeWrapper(callable)"})
        @CompilerDirectives.TruffleBoundary
        Object doNativeCallableWithWrapper(TruffleString name, Object callable, int signature, Object type, int flags, PythonObjectFactory factory, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
            boolean doArgAndResultConversion;
            Object resolvedCallable = CreateFunctionNode.resolveClosurePointer(this.getContext(), callable, lib);
            if (resolvedCallable != null) {
                doArgAndResultConversion = false;
            } else {
                doArgAndResultConversion = true;
                resolvedCallable = callable;
            }
            PBuiltinFunction function = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, resolvedCallable, type, flags, signature, this.getLanguage(), factory, doArgAndResultConversion);
            return function != null ? function : resolvedCallable;
        }

        @Specialization(guards={"isNoValue(wrapper)", "!isNativeWrapper(callable)"})
        @CompilerDirectives.TruffleBoundary
        PBuiltinFunction doNativeCallableWithoutWrapper(TruffleString name, Object callable, Object type, PNone wrapper, Object flags, PythonObjectFactory factory, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
            PBuiltinFunction managedCallable = CreateFunctionNode.resolveClosurePointer(this.getContext(), callable, lib);
            if (managedCallable != null) {
                return managedCallable;
            }
            return ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, callable, type, 0, ExternalFunctionNodes.PExternalFunctionWrapper.DIRECT, this.getLanguage(), factory, true);
        }

        private static PBuiltinFunction resolveClosurePointer(PythonContext context, Object callable, InteropLibrary lib) {
            if (lib.isPointer(callable)) {
                long pointer;
                try {
                    pointer = lib.asPointer(callable);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                Object delegate = context.getCApiContext().getClosureDelegate(pointer);
                if (delegate instanceof PBuiltinFunction) {
                    PBuiltinFunction function = (PBuiltinFunction)delegate;
                    LOGGER.fine(() -> PythonUtils.formatJString("forwarding %d 0x%x to %s", pointer, pointer, function));
                    return function;
                }
            }
            return null;
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.PyTypeObject, args={ArgDescriptor.ConstCharPtrAsTruffleString}, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_Type
    extends CApiUnaryBuiltinNode {
        private static final TruffleString[] LOOKUP_MODULES = new TruffleString[]{BuiltinNames.T__WEAKREF, BuiltinNames.T_BUILTINS};

        PyTruffle_Type() {
        }

        @Specialization
        Object doI(TruffleString typeName, @Cached TruffleString.EqualNode eqNode) {
            Python3Core core = this.getCore();
            for (PythonBuiltinClassType pythonBuiltinClassType : PythonBuiltinClassType.VALUES) {
                if (!eqNode.execute((AbstractTruffleString)pythonBuiltinClassType.getName(), (AbstractTruffleString)typeName, PythonUtils.TS_ENCODING)) continue;
                return core.lookupType(pythonBuiltinClassType);
            }
            for (PythonBuiltinClassType pythonBuiltinClassType : LOOKUP_MODULES) {
                Object attribute = core.lookupBuiltinModule((TruffleString)pythonBuiltinClassType).getAttribute(typeName);
                if (attribute == PNone.NO_VALUE) continue;
                return attribute;
            }
            throw this.raise(PythonErrorType.KeyError, ErrorMessages.APOSTROPHE_S, typeName);
        }
    }

    @CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, call=CApiCallPath.Ignored)
    static abstract class PyTruffle_FileSystemDefaultEncoding
    extends CApiNullaryBuiltinNode {
        PyTruffle_FileSystemDefaultEncoding() {
        }

        @Specialization
        static TruffleString encoding() {
            return SysModuleBuiltins.GetFileSystemEncodingNode.getFileSystemEncoding();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=CApiBuiltins.class)
    public static @interface CApiBuiltin {
        public String name() default "";

        public ArgDescriptor ret();

        public ArgDescriptor[] args() default {};

        public boolean inlined() default false;

        public boolean acquiresGIL() default true;

        public CApiCallPath call();

        public String comment() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CApiBuiltins {
        public CApiBuiltin[] value();
    }

    public static enum CApiCallPath {
        Direct,
        CImpl,
        NotImplemented,
        Ignored;

    }

    static final class UncachedExecuteCApiBuiltinNode
    extends ExecuteCApiBuiltinNode {
        static final UncachedExecuteCApiBuiltinNode INSTANCE = new UncachedExecuteCApiBuiltinNode();

        UncachedExecuteCApiBuiltinNode() {
        }

        public boolean isAdoptable() {
            return false;
        }

        @Override
        Object execute(CApiBuiltinExecutable self, Object[] arguments) {
            return IndirectCallNode.getUncached().call(self.getCallTarget(), arguments);
        }
    }

    static final class CachedExecuteCApiBuiltinNode
    extends ExecuteCApiBuiltinNode {
        private final CApiBuiltinExecutable cachedSelf;
        @Node.Child
        private CExtToNativeNode retNode;
        @Node.Children
        private final CExtToJavaNode[] argNodes;
        @Node.Child
        private CApiBuiltinNode builtinNode;
        @Node.Child
        private CExtNodes.TransformExceptionToNativeNode transformExceptionToNativeNode;

        CachedExecuteCApiBuiltinNode(CApiBuiltinExecutable cachedSelf) {
            assert (cachedSelf.ret.createCheckResultNode() == null) : "primitive result check types are only intended for ExternalFunctionInvokeNode";
            this.cachedSelf = cachedSelf;
            this.retNode = cachedSelf.createRetNode();
            this.argNodes = cachedSelf.createArgNodes();
            this.builtinNode = cachedSelf.createBuiltinNode();
        }

        @Override
        Object execute(CApiBuiltinExecutable self, Object[] arguments) {
            CApiTiming.enter();
            try {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(() -> "CAPI-" + self.name + " " + Arrays.toString(arguments));
                }
                assert (this.cachedSelf == self);
                assert (arguments.length == this.argNodes.length);
                Object[] argCast = new Object[this.argNodes.length];
                this.castArguments(arguments, argCast);
                Object result = this.builtinNode.execute(argCast);
                if (this.retNode != null) {
                    result = this.retNode.execute(result);
                }
                assert (!(result instanceof PythonNativePointer));
                CApiTransitions.maybeGCALot();
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "CApiBuiltin", self.name);
                }
                catch (PException e) {
                    if (this.transformExceptionToNativeNode == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.transformExceptionToNativeNode = (CExtNodes.TransformExceptionToNativeNode)this.insert(CExtNodesFactory.TransformExceptionToNativeNodeGen.create());
                    }
                    this.transformExceptionToNativeNode.execute(e);
                    if (this.cachedSelf.getRetDescriptor().isIntType()) {
                        Integer n = -1;
                        return n;
                    }
                    if (this.cachedSelf.getRetDescriptor().isPyObjectOrPointer()) {
                        Object object = PythonContext.get(this).getNativeNull().getPtr();
                        return object;
                    }
                    if (this.cachedSelf.getRetDescriptor().isFloatType()) {
                        Double d = -1.0;
                        return d;
                    }
                    if (this.cachedSelf.getRetDescriptor().isVoid()) {
                        PNone pNone = PNone.NO_VALUE;
                        return pNone;
                    }
                    CompilerDirectives.transferToInterpreter();
                    throw CompilerDirectives.shouldNotReachHere((String)("return type while handling PException: " + this.cachedSelf.getRetDescriptor() + " in " + self.name));
                }
            }
            finally {
                CApiTiming.exit(self.timing);
            }
        }

        @ExplodeLoop
        private void castArguments(Object[] arguments, Object[] argCast) {
            for (int i = 0; i < this.argNodes.length; ++i) {
                argCast[i] = this.argNodes[i] == null ? arguments[i] : this.argNodes[i].execute(arguments[i]);
            }
        }
    }

    @GenerateUncached
    static abstract class ExecuteCApiBuiltinNode
    extends Node {
        ExecuteCApiBuiltinNode() {
        }

        abstract Object execute(CApiBuiltinExecutable var1, Object[] var2);

        public static ExecuteCApiBuiltinNode create(CApiBuiltinExecutable self) {
            try {
                return new CachedExecuteCApiBuiltinNode(self);
            }
            catch (Throwable t) {
                PNodeWithContext.printStack();
                LOGGER.logp(Level.SEVERE, "ExecuteCApiBuiltinNode", "create", "while creating CApiBuiltin " + self.name, t);
                throw t;
            }
        }

        public static ExecuteCApiBuiltinNode getUncached(CApiBuiltinExecutable self) {
            return UncachedExecuteCApiBuiltinNode.INSTANCE;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class CApiBuiltinExecutable
    implements TruffleObject {
        private final CApiTiming timing;
        private final ArgDescriptor ret;
        private final ArgDescriptor[] args;
        @CompilerDirectives.CompilationFinal
        private CallTarget callTarget;
        private final CApiCallPath call;
        private final String name;
        private final int id;

        public CApiBuiltinExecutable(String name, CApiCallPath call, ArgDescriptor ret, ArgDescriptor[] args, int id) {
            this.timing = CApiTiming.create(false, name);
            this.name = name;
            this.call = call;
            this.ret = ret;
            this.args = args;
            this.id = id;
        }

        CallTarget getCallTarget() {
            if (this.callTarget == null) {
                CompilerDirectives.transferToInterpreter();
                CompilerDirectives.shouldNotReachHere((String)"call target slow path not implemented");
            }
            return this.callTarget;
        }

        @ExportMessage
        public boolean isExecutable() {
            return true;
        }

        public CApiCallPath call() {
            return this.call;
        }

        public String name() {
            return this.name;
        }

        CExtToNativeNode createRetNode() {
            return this.ret.createPythonToNativeNode();
        }

        ArgDescriptor getRetDescriptor() {
            return this.ret;
        }

        CExtToJavaNode[] createArgNodes() {
            return ArgDescriptor.createNativeToPython(this.args);
        }

        public CApiBuiltinNode createBuiltinNode() {
            CApiBuiltinNode node = PythonCextBuiltinRegistry.createBuiltinNode(this.id);
            node.ret = this.ret;
            return node;
        }

        public CApiBuiltinNode getUncachedNode() {
            throw CompilerDirectives.shouldNotReachHere((String)("not supported - uncached for " + this.name));
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isPointer() {
            long pointer = PythonContext.get(null).getCApiContext().getClosurePointer(this);
            return pointer != -1L;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long asPointer() throws UnsupportedMessageException {
            long pointer = PythonContext.get(null).getCApiContext().getClosurePointer(this);
            if (pointer == -1L) {
                throw UnsupportedMessageException.create();
            }
            return pointer;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void toNative() {
            PythonContext context = PythonContext.get(null);
            long pointer = context.getCApiContext().getClosurePointer(this);
            if (pointer == -1L) {
                if (context.signatureContainer == null) {
                    context.signatureContainer = new SignatureContainerRootNode().getCallTarget();
                }
                try {
                    SignatureContainerRootNode container = (SignatureContainerRootNode)context.signatureContainer.getRootNode();
                    boolean panama = (Boolean)PythonOptions.UsePanama.getValue(PythonContext.get(null).getEnv().getOptions());
                    StringBuilder signature = new StringBuilder(panama ? "with panama (" : "(");
                    for (int i = 0; i < this.args.length; ++i) {
                        signature.append(i == 0 ? "" : ",");
                        signature.append(this.args[i].getNFISignature());
                    }
                    signature.append("):").append(this.ret.getNFISignature());
                    Object nfiSignature = PythonContext.get(null).getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)signature.toString(), (String)"exec").build(), new String[0]).call(new Object[0]);
                    Object closure = container.getLibrary(this.name).createClosure(nfiSignature, (Object)this);
                    InteropLibrary.getUncached().toNative(closure);
                    try {
                        pointer = InteropLibrary.getUncached().asPointer(closure);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                    context.getCApiContext().setClosurePointer(closure, null, this, pointer);
                    LOGGER.finer(CApiBuiltinExecutable.class.getSimpleName() + " toNative: " + this.id + " / " + this.name() + " -> " + pointer);
                }
                catch (Throwable t) {
                    t.printStackTrace(new PrintStream(PythonContext.get(null).getEnv().err()));
                    throw t;
                }
            }
        }

        public String toString() {
            return "CApiBuiltin(" + this.name + " / " + this.id + ")";
        }

        private static final class SignatureContainerRootNode
        extends RootNode {
            final HashMap<String, SignatureLibrary> libs = new HashMap();

            protected SignatureContainerRootNode() {
                super(null);
            }

            public Object execute(VirtualFrame frame) {
                throw CompilerDirectives.shouldNotReachHere((String)"not meant to be executed");
            }

            public SignatureLibrary getLibrary(String name) {
                return this.libs.computeIfAbsent(name, n -> {
                    SignatureLibrary lib = (SignatureLibrary)SignatureLibrary.getFactory().createDispatched(3);
                    this.insert((Node)lib);
                    return lib;
                });
            }
        }

        @ExportMessage
        static final class Execute {
            Execute() {
            }

            @Specialization(guards={"self == cachedSelf"})
            public static Object doExecute(CApiBuiltinExecutable self, Object[] arguments, @Cached(value="self") CApiBuiltinExecutable cachedSelf, @Cached(parameters={"cachedSelf"}) ExecuteCApiBuiltinNode call) {
                try {
                    return call.execute(cachedSelf, arguments);
                }
                catch (ThreadDeath t) {
                    CompilerDirectives.transferToInterpreter();
                    throw t;
                }
                catch (Throwable t) {
                    CompilerDirectives.transferToInterpreter();
                    t.printStackTrace();
                    throw CompilerDirectives.shouldNotReachHere((Throwable)t);
                }
            }

            @Specialization
            public static Object doFallback(CApiBuiltinExecutable self, Object[] arguments) {
                CompilerDirectives.transferToInterpreter();
                throw CompilerDirectives.shouldNotReachHere((String)("shouldn't hit generic case of " + Execute.class.getName()));
            }
        }
    }

    public static abstract class CApi16BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11, Object var12, Object var13, Object var14, Object var15, Object var16);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15]);
        }
    }

    public static abstract class CApi15BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11, Object var12, Object var13, Object var14, Object var15);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14]);
        }
    }

    public static abstract class CApi11BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10]);
        }
    }

    public static abstract class CApi10BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
        }
    }

    public static abstract class CApi9BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
        }
    }

    public static abstract class CApi8BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
        }
    }

    public static abstract class CApi7BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        }
    }

    public static abstract class CApi6BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5]);
        }
    }

    public static abstract class CApi5BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4]);
        }
    }

    public static abstract class CApiQuaternaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3]);
        }
    }

    public static abstract class CApiTernaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2]);
        }
    }

    public static abstract class CApiBinaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1]);
        }
    }

    public static abstract class CApiUnaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0]);
        }
    }

    public static abstract class CApiNullaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute();

        @Override
        public final Object execute(Object[] args) {
            return this.execute();
        }
    }

    public static abstract class CApiBuiltinNode
    extends PNodeWithRaiseAndIndirectCall {
        @Node.Child
        private PythonObjectFactory objectFactory;
        @CompilerDirectives.CompilationFinal
        private ArgDescriptor ret;

        public abstract Object execute(Object[] var1);

        protected final PythonNativePointer getNativeNull() {
            return this.getContext().getNativeNull();
        }

        protected final Object getNULL() {
            return this.getContext().getNativeNull().getPtr();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected static ByteBuffer wrap(byte[] data) {
            return ByteBuffer.wrap(data);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected static ByteBuffer wrap(byte[] data, int offset, int length) {
            return ByteBuffer.wrap(data, offset, length);
        }

        protected final PythonObjectFactory factory() {
            if (this.objectFactory == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.objectFactory = this.isAdoptable() ? (PythonObjectFactory)this.insert(PythonObjectFactory.create()) : this.getCore().factory();
            }
            return this.objectFactory;
        }

        public final Python3Core getCore() {
            return this.getContext();
        }

        protected final CApiContext getCApiContext() {
            return this.getContext().getCApiContext();
        }

        protected final PException badInternalCall(String argName) {
            CompilerDirectives.transferToInterpreter();
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.S_S_BAD_ARG_TO_INTERNAL_FUNC, this.getName(), argName);
        }

        private String getName() {
            Class<?> c = this.getClass();
            while (c.getSimpleName().endsWith("NodeGen")) {
                c = c.getSuperclass();
            }
            String name = c.getSimpleName();
            return name;
        }

        @CompilerDirectives.TruffleBoundary
        protected PException raiseFallback(Object obj, PythonBuiltinClassType type) {
            if (obj == PNone.NO_VALUE) {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_S, this.getName());
            }
            if (IsSubtypeNode.getUncached().execute(GetClassNode.executeUncached(obj), (Object)type)) {
                throw this.raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.NATIVE_S_SUBTYPES_NOT_IMPLEMENTED, type.getName());
            }
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXPECTED_S_NOT_P, type.getName(), obj);
        }

        @CompilerDirectives.TruffleBoundary
        protected PException raiseFallback(Object obj, PythonBuiltinClassType type1, PythonBuiltinClassType type2) {
            if (obj == PNone.NO_VALUE) {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_S, this.getName());
            }
            Object objType = GetClassNode.executeUncached(obj);
            if (IsSubtypeNode.getUncached().execute(objType, (Object)type1) || IsSubtypeNode.getUncached().execute(objType, (Object)type2)) {
                throw this.raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.NATIVE_S_SUBTYPES_NOT_IMPLEMENTED, type1.getName());
            }
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXPECTED_S_NOT_P, type1.getName(), obj);
        }

        protected final ArgDescriptor getRetDescriptor() {
            return this.ret;
        }

        protected final int castToInt(long elementSize) {
            if (elementSize == (long)((int)elementSize)) {
                return (int)elementSize;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.INDEX_OUT_OF_RANGE);
        }

        protected void checkNonNullArg(Object obj) {
            if (obj == PNone.NO_VALUE) {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.NULL_ARG_INTERNAL);
            }
        }

        protected void checkNonNullArg(Object obj1, Object obj2) {
            if (obj1 == PNone.NO_VALUE || obj2 == PNone.NO_VALUE) {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.NULL_ARG_INTERNAL);
            }
        }
    }

    @GenerateUncached
    public static abstract class PromoteBorrowedValue
    extends Node {
        public abstract Object execute(Object var1);

        @Specialization
        public static PString doString(TruffleString str, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createString(str);
        }

        @Specialization
        static PythonBuiltinObject doInteger(int i, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(i);
        }

        @Specialization
        static PythonBuiltinObject doLong(long i, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(i);
        }

        @Specialization(guards={"!isNaN(d)"})
        static PythonBuiltinObject doDouble(double d, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFloat(d);
        }

        static boolean isNaN(double d) {
            return Double.isNaN(d);
        }

        @Fallback
        static PythonBuiltinObject doOther(Object value) {
            return null;
        }
    }
}

