/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNodeGen;
import com.oracle.graal.python.nodes.util.CastToJavaIntNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class CastToJavaIntLossyNode
extends CastToJavaIntNode {
    public static int executeUncached(Object x) {
        return CastToJavaIntLossyNodeGen.getUncached().execute(null, x);
    }

    @Specialization
    protected static int toInt(long x) {
        int i = (int)x;
        return x == (long)i ? i : (x > 0L ? Integer.MAX_VALUE : Integer.MIN_VALUE);
    }

    @Specialization(rewriteOn={OverflowException.class})
    protected static int toIntPInt(PInt x) throws OverflowException {
        return x.intValueExact();
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(replaces={"toIntPInt"})
    protected static int toIntOverflow(PInt x) {
        if (x.compareTo(PInt.MAX_INT) > 0) {
            return Integer.MAX_VALUE;
        }
        if (x.compareTo(PInt.MIN_INT) < 0) {
            return Integer.MIN_VALUE;
        }
        return x.intValue();
    }
}

