/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode.instrumentation;

import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.bytecode.instrumentation.InstrumentedBytecodeStatement;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;

public final class InstrumentationSupport
extends Node {
    final CodeUnit code;
    @Node.Children
    InstrumentedBytecodeStatement[] statements;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public Node[] bciToHelperNode;
    final int startLine;

    public InstrumentationSupport(PBytecodeRootNode rootNode) {
        assert (rootNode.getSource() != null && rootNode.getSource().hasCharacters());
        this.code = rootNode.getCodeUnit();
        int minLine = this.code.startLine;
        int maxLine = this.code.endLine;
        for (int bci2 = 0; bci2 < this.code.code.length; ++bci2) {
            minLine = Math.min(minLine, this.code.bciToLine(bci2));
            maxLine = Math.max(maxLine, this.code.bciToLine(bci2));
        }
        this.startLine = minLine;
        this.statements = new InstrumentedBytecodeStatement[maxLine - minLine + 1];
        this.bciToHelperNode = new Node[this.code.code.length];
        boolean[] loadedBreakpoint = new boolean[1];
        this.code.iterateBytecode((bci, op, oparg, followingArgs) -> {
            boolean setBreakpoint = false;
            if ((op == OpCodes.LOAD_NAME || op == OpCodes.LOAD_GLOBAL) && BuiltinNames.T_BREAKPOINT.equals((Object)this.code.names[oparg])) {
                loadedBreakpoint[0] = true;
            } else {
                if (op == OpCodes.CALL_FUNCTION && loadedBreakpoint[0]) {
                    setBreakpoint = true;
                }
                loadedBreakpoint[0] = false;
            }
            int line = this.code.bciToLine(bci);
            if (line >= 0) {
                InstrumentedBytecodeStatement statement = this.getStatement(line);
                if (statement == null) {
                    statement = InstrumentedBytecodeStatement.create();
                    try {
                        statement.setSourceSection(rootNode.getSource().createSection(line));
                    }
                    catch (IllegalArgumentException e) {
                        statement.setSourceSection(rootNode.getSource().createUnavailableSection());
                    }
                    this.setStatement(line, statement);
                }
                statement.coversBci(bci, op.length());
                if (setBreakpoint) {
                    statement.setContainsBreakpoint();
                }
            }
        });
    }

    private InstrumentedBytecodeStatement getStatement(int line) {
        return this.statements[this.getStatementIndex(line)];
    }

    private void setStatement(int line, InstrumentedBytecodeStatement statement) {
        this.statements[this.getStatementIndex((int)line)] = statement;
    }

    private int getStatementIndex(int line) {
        return line - this.startLine;
    }

    private InstrumentableNode.WrapperNode getWrapperAtLine(int line) {
        InstrumentedBytecodeStatement node;
        if (line >= 0 && (node = this.getStatement(line)) instanceof InstrumentableNode.WrapperNode) {
            return (InstrumentableNode.WrapperNode)node;
        }
        return null;
    }

    public void notifyStatement(VirtualFrame frame, int prevLine, int nextLine) {
        if (nextLine != prevLine) {
            if (prevLine >= 0) {
                this.notifyStatementExit(frame, prevLine);
            }
            this.notifyStatementEnter(frame, nextLine);
        }
    }

    public void notifyStatementEnter(VirtualFrame frame, int line) {
        CompilerAsserts.partialEvaluationConstant((int)line);
        InstrumentableNode.WrapperNode wrapper = this.getWrapperAtLine(line);
        if (wrapper != null) {
            try {
                wrapper.getProbeNode().onEnter(frame);
            }
            catch (Throwable t) {
                InstrumentationSupport.handleException(frame, wrapper, t, false);
                throw t;
            }
        }
    }

    public void notifyStatementExit(VirtualFrame frame, int line) {
        CompilerAsserts.partialEvaluationConstant((int)line);
        InstrumentableNode.WrapperNode wrapper = this.getWrapperAtLine(line);
        if (wrapper != null) {
            try {
                wrapper.getProbeNode().onReturnValue(frame, null);
            }
            catch (Throwable t) {
                InstrumentationSupport.handleException(frame, wrapper, t, true);
                throw t;
            }
        }
    }

    private static void handleException(VirtualFrame frame, InstrumentableNode.WrapperNode wrapper, Throwable t, boolean isReturnCalled) {
        Object result = wrapper.getProbeNode().onReturnExceptionalOrUnwind(frame, t, isReturnCalled);
        if (result == ProbeNode.UNWIND_ACTION_REENTER) {
            throw CompilerDirectives.shouldNotReachHere((String)"Unwind not supported on statement level");
        }
        if (result != null) {
            throw CompilerDirectives.shouldNotReachHere((String)"Cannot replace a return of a statement");
        }
    }

    public void notifyException(VirtualFrame frame, int line, Throwable exception) {
        CompilerAsserts.partialEvaluationConstant((int)line);
        InstrumentableNode.WrapperNode wrapper = this.getWrapperAtLine(line);
        if (wrapper != null) {
            InstrumentationSupport.handleException(frame, wrapper, exception, false);
        }
    }

    public void insertHelperNode(Node node, int bci) {
        int line = this.code.bciToLine(bci);
        this.getStatement(line).insertHelperNode(node, bci);
        this.bciToHelperNode[bci] = node;
    }
}

