/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.attributes.ObjectAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class, PythonOptions.class})
@GenerateUncached
@GenerateInline(value=false)
public abstract class ReadAttributeFromDynamicObjectNode
extends ObjectAttributeNode {
    @NeverDefault
    public static ReadAttributeFromDynamicObjectNode create() {
        return ReadAttributeFromDynamicObjectNodeGen.create();
    }

    public static ReadAttributeFromDynamicObjectNode getUncached() {
        return ReadAttributeFromDynamicObjectNodeGen.getUncached();
    }

    public abstract Object execute(Object var1, Object var2);

    public abstract Object execute(Object var1, TruffleString var2);

    public abstract Object execute(Object var1, HiddenKey var2);

    protected static Object getAttribute(DynamicObject object, TruffleString key) {
        return DynamicObjectLibrary.getUncached().getOrDefault(object, (Object)key, (Object)PNone.NO_VALUE);
    }

    @Idempotent
    protected static boolean isLongLivedObject(DynamicObject object) {
        return object instanceof PythonModule || object instanceof PythonManagedClass;
    }

    @Idempotent
    protected static boolean isPrimitive(Object value) {
        return value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof Double;
    }

    @NonIdempotent
    protected static boolean locationIsAssumedFinal(Location loc) {
        return loc != null && loc.isAssumedFinal();
    }

    @Specialization(limit="1", guards={"isSingleContext()", "dynamicObject == cachedObject", "isLongLivedObject(cachedObject)", "key == cachedKey", "dynamicObject.getShape() == cachedShape", "locationIsAssumedFinal(loc)", "!isPrimitive(value)"}, assumptions={"cachedShape.getValidAssumption()", "loc.getFinalAssumption()"})
    protected static Object readFinalAttr(DynamicObject dynamicObject, TruffleString key, @Cached(value="key") TruffleString cachedKey, @Cached(value="dynamicObject", weak=true) DynamicObject cachedObject, @Cached(value="dynamicObject.getShape()") Shape cachedShape, @Cached(value="getLocationOrNull(cachedShape.getProperty(cachedKey))") Location loc, @Cached(value="dynamicObject.getShape().getPropertyAssumption(key)") Assumption propertyAssumption, @Cached(value="getAttribute(dynamicObject, key)", weak=true) Object value) {
        return value;
    }

    @Specialization(limit="1", guards={"isSingleContext()", "dynamicObject == cachedObject", "isLongLivedObject(cachedObject)", "key == cachedKey", "dynamicObject.getShape() == cachedShape", "locationIsAssumedFinal(loc)", "isPrimitive(value)"}, assumptions={"cachedShape.getValidAssumption()", "loc.getFinalAssumption()"})
    protected static Object readFinalPrimitiveAttr(DynamicObject dynamicObject, TruffleString key, @Cached(value="key") TruffleString cachedKey, @Cached(value="dynamicObject", weak=true) DynamicObject cachedObject, @Cached(value="dynamicObject.getShape()") Shape cachedShape, @Cached(value="getLocationOrNull(cachedShape.getProperty(cachedKey))") Location loc, @Cached(value="dynamicObject.getShape().getPropertyAssumption(key)") Assumption propertyAssumption, @Cached(value="getAttribute(dynamicObject, key)") Object value) {
        return value;
    }

    @Specialization(limit="getAttributeAccessInlineCacheMaxDepth()", replaces={"readFinalAttr", "readFinalPrimitiveAttr"})
    protected static Object readDirect(DynamicObject dynamicObject, TruffleString key, @CachedLibrary(value="dynamicObject") DynamicObjectLibrary dylib) {
        return dylib.getOrDefault(dynamicObject, (Object)key, (Object)PNone.NO_VALUE);
    }

    @Specialization(guards={"isHiddenKey(key)"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    protected static Object readDirectHidden(DynamicObject dynamicObject, Object key, @CachedLibrary(value="dynamicObject") DynamicObjectLibrary dylib) {
        return dylib.getOrDefault(dynamicObject, key, (Object)PNone.NO_VALUE);
    }

    @Specialization(guards={"!isHiddenKey(key)"}, replaces={"readDirect", "readFinalAttr"}, limit="getAttributeAccessInlineCacheMaxDepth()")
    protected static Object read(DynamicObject dynamicObject, Object key, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castNode, @CachedLibrary(value="dynamicObject") DynamicObjectLibrary dylib) {
        return dylib.getOrDefault(dynamicObject, (Object)ReadAttributeFromDynamicObjectNode.attrKey(inliningTarget, key, castNode), (Object)PNone.NO_VALUE);
    }
}

