/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public class PNodeWithRaise
extends PNodeWithContext {
    @Node.Child
    private PRaiseNode raiseNode;

    protected final PRaiseNode getRaiseNode() {
        if (this.raiseNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.raiseNode = this.isAdoptable() ? (PRaiseNode)this.insert(PRaiseNode.create()) : PRaiseNode.getUncached();
        }
        return this.raiseNode;
    }

    public PException raise(PythonBuiltinClassType type, TruffleString string) {
        return this.getRaiseNode().raise(type, string);
    }

    public PException raise(PythonBuiltinClassType exceptionType) {
        return this.getRaiseNode().raise(exceptionType);
    }

    public final PException raise(PythonBuiltinClassType type, PBaseException cause, TruffleString format, Object ... arguments) {
        return this.getRaiseNode().raiseWithCause(type, cause, format, arguments);
    }

    public final PException raise(PythonBuiltinClassType type, PException cause, TruffleString format, Object ... arguments) {
        return this.getRaiseNode().raiseWithCause(type, cause.getEscapedException(), format, arguments);
    }

    public final PException raise(PythonBuiltinClassType type, TruffleString format, Object ... arguments) {
        return this.getRaiseNode().raise(type, format, arguments);
    }

    public final PException raise(PythonBuiltinClassType type, Object[] arguments) {
        return this.getRaiseNode().raise(type, arguments);
    }

    public final PException raise(PythonBuiltinClassType type, Exception e) {
        return this.getRaiseNode().raise(type, e);
    }

    public final PException raiseBadInternalCall() {
        return this.getRaiseNode().raiseBadInternalCall();
    }

    public final PException raiseOverflow() {
        return this.getRaiseNode().raiseNumberTooLarge(PythonErrorType.OverflowError, 0);
    }

    public final PException raiseStopIteration() {
        return this.getRaiseNode().raiseStopIteration();
    }

    public final PException raiseStopIteration(Object value) {
        return this.getRaiseNode().raiseStopIteration(value);
    }

    public final PException raiseSystemExit(Object code) {
        return this.getRaiseNode().raiseSystemExit(code);
    }
}

