/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.lib.PyFloatCheckNode;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.lib.PyObjectTypeCheckNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=PyFloatCheckNode.class)
public final class PyFloatCheckNodeGen {
    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static PyFloatCheckNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static PyFloatCheckNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=PyFloatCheckNode.class)
    @DenyReplace
    private static final class Uncached
    extends PyFloatCheckNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof Double) {
                Double arg1Value_ = (Double)arg1Value;
                return PyFloatCheckNode.doDouble(arg1Value_);
            }
            if (arg1Value instanceof PFloat) {
                PFloat arg1Value_ = (PFloat)arg1Value;
                return PyFloatCheckNode.doPFloat(arg1Value_);
            }
            if (arg1Value instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                return PyFloatCheckNode.doNative(arg1Value_, PyObjectTypeCheckNodeGen.getUncached());
            }
            return PyFloatCheckNode.doOther(arg1Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=PyFloatCheckNode.class)
    @DenyReplace
    private static final class Inlined
    extends PyFloatCheckNode {
        private final InlineSupport.StateField state_0_;
        private final InlineSupport.ReferenceField<PyObjectTypeCheck> native_check_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(PyFloatCheckNode.class));
            this.state_0_ = target.getState(0, 4);
            this.native_check_ = target.getReference(1, PyObjectTypeCheck.class);
        }

        private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value) {
            if ((state_0 & 1) == 0 && arg1Value instanceof Double) {
                return false;
            }
            if ((state_0 & 2) == 0 && arg1Value instanceof PFloat) {
                return false;
            }
            return (state_0 & 4) != 0 || !(arg1Value instanceof PythonAbstractNativeObject);
        }

        @Override
        public boolean execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arg1Value instanceof Double) {
                    Double arg1Value_ = (Double)arg1Value;
                    return PyFloatCheckNode.doDouble(arg1Value_);
                }
                if ((state_0 & 2) != 0 && arg1Value instanceof PFloat) {
                    PFloat arg1Value_ = (PFloat)arg1Value;
                    return PyFloatCheckNode.doPFloat(arg1Value_);
                }
                if ((state_0 & 4) != 0 && arg1Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                    PyObjectTypeCheck check__ = (PyObjectTypeCheck)((Object)this.native_check_.get(arg0Value));
                    if (check__ != null) {
                        return PyFloatCheckNode.doNative(arg1Value_, check__);
                    }
                }
                if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                    return PyFloatCheckNode.doOther(arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Double) {
                Double arg1Value_ = (Double)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 1);
                return PyFloatCheckNode.doDouble(arg1Value_);
            }
            if (arg1Value instanceof PFloat) {
                PFloat arg1Value_ = (PFloat)arg1Value;
                this.state_0_.set(arg0Value, state_0 |= 2);
                return PyFloatCheckNode.doPFloat(arg1Value_);
            }
            if (arg1Value instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                PyObjectTypeCheck check__ = (PyObjectTypeCheck)arg0Value.insert((Node)PyObjectTypeCheckNodeGen.create());
                Objects.requireNonNull(check__, "Specialization 'doNative(PythonAbstractNativeObject, PyObjectTypeCheck)' cache 'check' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.native_check_.set(arg0Value, (Object)check__);
                this.state_0_.set(arg0Value, state_0 |= 4);
                return PyFloatCheckNode.doNative(arg1Value_, check__);
            }
            this.state_0_.set(arg0Value, state_0 |= 8);
            return PyFloatCheckNode.doOther(arg1Value);
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

